<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

require_once __DIR__ . '/../../../vendor/autoload.php';

// [START ces_v1beta_generated_EvaluationService_GenerateEvaluation_sync]
use Google\ApiCore\ApiException;
use Google\ApiCore\OperationResponse;
use Google\Cloud\Ces\V1beta\Client\EvaluationServiceClient;
use Google\Cloud\Ces\V1beta\Evaluation;
use Google\Cloud\Ces\V1beta\GenerateEvaluationRequest;
use Google\Rpc\Status;

/**
 * Creates a golden evaluation from a conversation.
 *
 * @param string $formattedConversation The conversation to create the golden evaluation for.
 *                                      Format:
 *                                      `projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}`
 *                                      Please see {@see EvaluationServiceClient::conversationName()} for help formatting this field.
 */
function generate_evaluation_sample(string $formattedConversation): void
{
    // Create a client.
    $evaluationServiceClient = new EvaluationServiceClient();

    // Prepare the request message.
    $request = (new GenerateEvaluationRequest())
        ->setConversation($formattedConversation);

    // Call the API and handle any network failures.
    try {
        /** @var OperationResponse $response */
        $response = $evaluationServiceClient->generateEvaluation($request);
        $response->pollUntilComplete();

        if ($response->operationSucceeded()) {
            /** @var Evaluation $result */
            $result = $response->getResult();
            printf('Operation successful with response data: %s' . PHP_EOL, $result->serializeToJsonString());
        } else {
            /** @var Status $error */
            $error = $response->getError();
            printf('Operation failed with error data: %s' . PHP_EOL, $error->serializeToJsonString());
        }
    } catch (ApiException $ex) {
        printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
    }
}

/**
 * Helper to execute the sample.
 *
 * This sample has been automatically generated and should be regarded as a code
 * template only. It will require modifications to work:
 *  - It may require correct/in-range values for request initialization.
 *  - It may require specifying regional endpoints when creating the service client,
 *    please see the apiEndpoint client configuration option for more details.
 */
function callSample(): void
{
    $formattedConversation = EvaluationServiceClient::conversationName(
        '[PROJECT]',
        '[LOCATION]',
        '[APP]',
        '[CONVERSATION]'
    );

    generate_evaluation_sample($formattedConversation);
}
// [END ces_v1beta_generated_EvaluationService_GenerateEvaluation_sync]
