<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

require_once __DIR__ . '/../../../vendor/autoload.php';

// [START ces_v1beta_generated_EvaluationService_TestPersonaVoice_sync]
use Google\ApiCore\ApiException;
use Google\Cloud\Ces\V1beta\Client\EvaluationServiceClient;
use Google\Cloud\Ces\V1beta\TestPersonaVoiceRequest;
use Google\Cloud\Ces\V1beta\TestPersonaVoiceResponse;

/**
 * Tests the voice of a persona. Also accepts a default persona.
 *
 * @param string $formattedApp the resource name of the app to test the persona voice for.
 *                             Format:
 *                             `projects/{project}/locations/{location}/apps/{app}`
 *                             Please see {@see EvaluationServiceClient::appName()} for help formatting this field.
 * @param string $personaId    The persona ID to test the voice for. Also accepts "default".
 * @param string $text         The text to test the voice for.
 */
function test_persona_voice_sample(string $formattedApp, string $personaId, string $text): void
{
    // Create a client.
    $evaluationServiceClient = new EvaluationServiceClient();

    // Prepare the request message.
    $request = (new TestPersonaVoiceRequest())
        ->setApp($formattedApp)
        ->setPersonaId($personaId)
        ->setText($text);

    // Call the API and handle any network failures.
    try {
        /** @var TestPersonaVoiceResponse $response */
        $response = $evaluationServiceClient->testPersonaVoice($request);
        printf('Response data: %s' . PHP_EOL, $response->serializeToJsonString());
    } catch (ApiException $ex) {
        printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
    }
}

/**
 * Helper to execute the sample.
 *
 * This sample has been automatically generated and should be regarded as a code
 * template only. It will require modifications to work:
 *  - It may require correct/in-range values for request initialization.
 *  - It may require specifying regional endpoints when creating the service client,
 *    please see the apiEndpoint client configuration option for more details.
 */
function callSample(): void
{
    $formattedApp = EvaluationServiceClient::appName('[PROJECT]', '[LOCATION]', '[APP]');
    $personaId = '[PERSONA_ID]';
    $text = '[TEXT]';

    test_persona_voice_sample($formattedApp, $personaId, $text);
}
// [END ces_v1beta_generated_EvaluationService_TestPersonaVoice_sync]
