<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

require_once __DIR__ . '/../../../vendor/autoload.php';

// [START ces_v1beta_generated_SessionService_BidiRunSession_sync]
use Google\ApiCore\ApiException;
use Google\ApiCore\BidiStream;
use Google\Cloud\Ces\V1beta\BidiSessionClientMessage;
use Google\Cloud\Ces\V1beta\BidiSessionServerMessage;
use Google\Cloud\Ces\V1beta\Client\SessionServiceClient;

/**
 * Establishes a bidirectional streaming connection with the CES agent. The
 * agent will process continuous client inputs across multiple modalities
 * (e.g., text, audio) and generates real-time multimodal output streams.
 *
 * For an audio session, the client is expected to stream audio data
 * continuously to the agent, even when the end user is silent. A chunk size
 * of **40-120 milliseconds** is recommended, balancing network efficiency and
 * low latency for real-time processing.
 *
 * This sample has been automatically generated and should be regarded as a code
 * template only. It will require modifications to work:
 *  - It may require correct/in-range values for request initialization.
 *  - It may require specifying regional endpoints when creating the service client,
 *    please see the apiEndpoint client configuration option for more details.
 */
function bidi_run_session_sample(): void
{
    // Create a client.
    $sessionServiceClient = new SessionServiceClient();

    // Prepare the request message.
    $request = new BidiSessionClientMessage();

    // Call the API and handle any network failures.
    try {
        /** @var BidiStream $stream */
        $stream = $sessionServiceClient->bidiRunSession();
        $stream->writeAll([$request,]);

        /** @var BidiSessionServerMessage $element */
        foreach ($stream->closeWriteAndReadAll() as $element) {
            printf('Element data: %s' . PHP_EOL, $element->serializeToJsonString());
        }
    } catch (ApiException $ex) {
        printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
    }
}
// [END ces_v1beta_generated_SessionService_BidiRunSession_sync]
