<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/ces/v1beta/agent_service.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Ces\V1beta\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Ces\V1beta\Agent;
use Google\Cloud\Ces\V1beta\App;
use Google\Cloud\Ces\V1beta\AppVersion;
use Google\Cloud\Ces\V1beta\BatchDeleteConversationsRequest;
use Google\Cloud\Ces\V1beta\BatchDeleteConversationsResponse;
use Google\Cloud\Ces\V1beta\Changelog;
use Google\Cloud\Ces\V1beta\Conversation;
use Google\Cloud\Ces\V1beta\CreateAgentRequest;
use Google\Cloud\Ces\V1beta\CreateAppRequest;
use Google\Cloud\Ces\V1beta\CreateAppVersionRequest;
use Google\Cloud\Ces\V1beta\CreateDeploymentRequest;
use Google\Cloud\Ces\V1beta\CreateExampleRequest;
use Google\Cloud\Ces\V1beta\CreateGuardrailRequest;
use Google\Cloud\Ces\V1beta\CreateToolRequest;
use Google\Cloud\Ces\V1beta\CreateToolsetRequest;
use Google\Cloud\Ces\V1beta\DeleteAgentRequest;
use Google\Cloud\Ces\V1beta\DeleteAppRequest;
use Google\Cloud\Ces\V1beta\DeleteAppVersionRequest;
use Google\Cloud\Ces\V1beta\DeleteConversationRequest;
use Google\Cloud\Ces\V1beta\DeleteDeploymentRequest;
use Google\Cloud\Ces\V1beta\DeleteExampleRequest;
use Google\Cloud\Ces\V1beta\DeleteGuardrailRequest;
use Google\Cloud\Ces\V1beta\DeleteToolRequest;
use Google\Cloud\Ces\V1beta\DeleteToolsetRequest;
use Google\Cloud\Ces\V1beta\Deployment;
use Google\Cloud\Ces\V1beta\Example;
use Google\Cloud\Ces\V1beta\ExportAppRequest;
use Google\Cloud\Ces\V1beta\ExportAppResponse;
use Google\Cloud\Ces\V1beta\GetAgentRequest;
use Google\Cloud\Ces\V1beta\GetAppRequest;
use Google\Cloud\Ces\V1beta\GetAppVersionRequest;
use Google\Cloud\Ces\V1beta\GetChangelogRequest;
use Google\Cloud\Ces\V1beta\GetConversationRequest;
use Google\Cloud\Ces\V1beta\GetDeploymentRequest;
use Google\Cloud\Ces\V1beta\GetExampleRequest;
use Google\Cloud\Ces\V1beta\GetGuardrailRequest;
use Google\Cloud\Ces\V1beta\GetToolRequest;
use Google\Cloud\Ces\V1beta\GetToolsetRequest;
use Google\Cloud\Ces\V1beta\Guardrail;
use Google\Cloud\Ces\V1beta\ImportAppRequest;
use Google\Cloud\Ces\V1beta\ImportAppResponse;
use Google\Cloud\Ces\V1beta\ListAgentsRequest;
use Google\Cloud\Ces\V1beta\ListAppVersionsRequest;
use Google\Cloud\Ces\V1beta\ListAppsRequest;
use Google\Cloud\Ces\V1beta\ListChangelogsRequest;
use Google\Cloud\Ces\V1beta\ListConversationsRequest;
use Google\Cloud\Ces\V1beta\ListDeploymentsRequest;
use Google\Cloud\Ces\V1beta\ListExamplesRequest;
use Google\Cloud\Ces\V1beta\ListGuardrailsRequest;
use Google\Cloud\Ces\V1beta\ListToolsRequest;
use Google\Cloud\Ces\V1beta\ListToolsetsRequest;
use Google\Cloud\Ces\V1beta\RestoreAppVersionRequest;
use Google\Cloud\Ces\V1beta\RestoreAppVersionResponse;
use Google\Cloud\Ces\V1beta\Tool;
use Google\Cloud\Ces\V1beta\Toolset;
use Google\Cloud\Ces\V1beta\UpdateAgentRequest;
use Google\Cloud\Ces\V1beta\UpdateAppRequest;
use Google\Cloud\Ces\V1beta\UpdateDeploymentRequest;
use Google\Cloud\Ces\V1beta\UpdateExampleRequest;
use Google\Cloud\Ces\V1beta\UpdateGuardrailRequest;
use Google\Cloud\Ces\V1beta\UpdateToolRequest;
use Google\Cloud\Ces\V1beta\UpdateToolsetRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The service that manages agent-related resources in Gemini Enterprise for
 * Customer Engagement (CES).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface<OperationResponse> batchDeleteConversationsAsync(BatchDeleteConversationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Agent> createAgentAsync(CreateAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAppAsync(CreateAppRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AppVersion> createAppVersionAsync(CreateAppVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Deployment> createDeploymentAsync(CreateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Example> createExampleAsync(CreateExampleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Guardrail> createGuardrailAsync(CreateGuardrailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tool> createToolAsync(CreateToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Toolset> createToolsetAsync(CreateToolsetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAgentAsync(DeleteAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAppAsync(DeleteAppRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAppVersionAsync(DeleteAppVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteConversationAsync(DeleteConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDeploymentAsync(DeleteDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteExampleAsync(DeleteExampleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteGuardrailAsync(DeleteGuardrailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteToolAsync(DeleteToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteToolsetAsync(DeleteToolsetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportAppAsync(ExportAppRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Agent> getAgentAsync(GetAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<App> getAppAsync(GetAppRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AppVersion> getAppVersionAsync(GetAppVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Changelog> getChangelogAsync(GetChangelogRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Conversation> getConversationAsync(GetConversationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Deployment> getDeploymentAsync(GetDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Example> getExampleAsync(GetExampleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Guardrail> getGuardrailAsync(GetGuardrailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tool> getToolAsync(GetToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Toolset> getToolsetAsync(GetToolsetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importAppAsync(ImportAppRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAgentsAsync(ListAgentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAppVersionsAsync(ListAppVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAppsAsync(ListAppsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listChangelogsAsync(ListChangelogsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listConversationsAsync(ListConversationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDeploymentsAsync(ListDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listExamplesAsync(ListExamplesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listGuardrailsAsync(ListGuardrailsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listToolsAsync(ListToolsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listToolsetsAsync(ListToolsetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> restoreAppVersionAsync(RestoreAppVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Agent> updateAgentAsync(UpdateAgentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<App> updateAppAsync(UpdateAppRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Deployment> updateDeploymentAsync(UpdateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Example> updateExampleAsync(UpdateExampleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Guardrail> updateGuardrailAsync(UpdateGuardrailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tool> updateToolAsync(UpdateToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Toolset> updateToolsetAsync(UpdateToolsetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class AgentServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.ces.v1beta.AgentService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'ces.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'ces.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/ces',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/agent_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/agent_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/agent_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/agent_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $agent
     *
     * @return string The formatted agent resource.
     *
     * @experimental
     */
    public static function agentName(string $project, string $location, string $app, string $agent): string
    {
        return self::getPathTemplate('agent')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a app
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     *
     * @return string The formatted app resource.
     *
     * @experimental
     */
    public static function appName(string $project, string $location, string $app): string
    {
        return self::getPathTemplate('app')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a app_version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $version
     *
     * @return string The formatted app_version resource.
     *
     * @experimental
     */
    public static function appVersionName(string $project, string $location, string $app, string $version): string
    {
        return self::getPathTemplate('appVersion')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a changelog
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $changelog
     *
     * @return string The formatted changelog resource.
     *
     * @experimental
     */
    public static function changelogName(string $project, string $location, string $app, string $changelog): string
    {
        return self::getPathTemplate('changelog')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'changelog' => $changelog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a conversation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $conversation
     *
     * @return string The formatted conversation resource.
     *
     * @experimental
     */
    public static function conversationName(string $project, string $location, string $app, string $conversation): string
    {
        return self::getPathTemplate('conversation')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * deidentify_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $deidentifyTemplate
     *
     * @return string The formatted deidentify_template resource.
     *
     * @experimental
     */
    public static function deidentifyTemplateName(string $organization, string $location, string $deidentifyTemplate): string
    {
        return self::getPathTemplate('deidentifyTemplate')->render([
            'organization' => $organization,
            'location' => $location,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a deployment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $deployment
     *
     * @return string The formatted deployment resource.
     *
     * @experimental
     */
    public static function deploymentName(string $project, string $location, string $app, string $deployment): string
    {
        return self::getPathTemplate('deployment')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dialogflow_agent resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted dialogflow_agent resource.
     *
     * @experimental
     */
    public static function dialogflowAgentName(string $project, string $location, string $agent): string
    {
        return self::getPathTemplate('dialogflowAgent')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a engine
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $engine
     *
     * @return string The formatted engine resource.
     *
     * @experimental
     */
    public static function engineName(string $project, string $location, string $collection, string $engine): string
    {
        return self::getPathTemplate('engine')->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'engine' => $engine,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a example
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $example
     *
     * @return string The formatted example resource.
     *
     * @experimental
     */
    public static function exampleName(string $project, string $location, string $app, string $example): string
    {
        return self::getPathTemplate('example')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'example' => $example,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a guardrail
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $guardrail
     *
     * @return string The formatted guardrail resource.
     *
     * @experimental
     */
    public static function guardrailName(string $project, string $location, string $app, string $guardrail): string
    {
        return self::getPathTemplate('guardrail')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'guardrail' => $guardrail,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * inspect_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $inspectTemplate
     *
     * @return string The formatted inspect_template resource.
     *
     * @experimental
     */
    public static function inspectTemplateName(string $organization, string $location, string $inspectTemplate): string
    {
        return self::getPathTemplate('inspectTemplate')->render([
            'organization' => $organization,
            'location' => $location,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     *
     * @experimental
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_deidentify_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $deidentifyTemplate
     *
     * @return string The formatted organization_location_deidentify_template resource.
     *
     * @experimental
     */
    public static function organizationLocationDeidentifyTemplateName(string $organization, string $location, string $deidentifyTemplate): string
    {
        return self::getPathTemplate('organizationLocationDeidentifyTemplate')->render([
            'organization' => $organization,
            'location' => $location,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_inspect_template resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $inspectTemplate
     *
     * @return string The formatted organization_location_inspect_template resource.
     *
     * @experimental
     */
    public static function organizationLocationInspectTemplateName(string $organization, string $location, string $inspectTemplate): string
    {
        return self::getPathTemplate('organizationLocationInspectTemplate')->render([
            'organization' => $organization,
            'location' => $location,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_deidentify_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deidentifyTemplate
     *
     * @return string The formatted project_location_deidentify_template resource.
     *
     * @experimental
     */
    public static function projectLocationDeidentifyTemplateName(string $project, string $location, string $deidentifyTemplate): string
    {
        return self::getPathTemplate('projectLocationDeidentifyTemplate')->render([
            'project' => $project,
            'location' => $location,
            'deidentify_template' => $deidentifyTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_inspect_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $inspectTemplate
     *
     * @return string The formatted project_location_inspect_template resource.
     *
     * @experimental
     */
    public static function projectLocationInspectTemplateName(string $project, string $location, string $inspectTemplate): string
    {
        return self::getPathTemplate('projectLocationInspectTemplate')->render([
            'project' => $project,
            'location' => $location,
            'inspect_template' => $inspectTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $secretVersion
     *
     * @return string The formatted secret_version resource.
     *
     * @experimental
     */
    public static function secretVersionName(string $project, string $secret, string $secretVersion): string
    {
        return self::getPathTemplate('secretVersion')->render([
            'project' => $project,
            'secret' => $secret,
            'secret_version' => $secretVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $namespace
     * @param string $service
     *
     * @return string The formatted service resource.
     *
     * @experimental
     */
    public static function serviceName(string $project, string $location, string $namespace, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'location' => $location,
            'namespace' => $namespace,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $tool
     *
     * @return string The formatted tool resource.
     *
     * @experimental
     */
    public static function toolName(string $project, string $location, string $app, string $tool): string
    {
        return self::getPathTemplate('tool')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'tool' => $tool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a toolset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $toolset
     *
     * @return string The formatted toolset resource.
     *
     * @experimental
     */
    public static function toolsetName(string $project, string $location, string $app, string $toolset): string
    {
        return self::getPathTemplate('toolset')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'toolset' => $toolset,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/locations/{location}/apps/{app}/agents/{agent}
     * - app: projects/{project}/locations/{location}/apps/{app}
     * - appVersion: projects/{project}/locations/{location}/apps/{app}/versions/{version}
     * - changelog: projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}
     * - conversation: projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}
     * - deidentifyTemplate: organizations/{organization}/locations/{location}/deidentifyTemplates/{deidentify_template}
     * - deployment: projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
     * - dialogflowAgent: projects/{project}/locations/{location}/agents/{agent}
     * - engine: projects/{project}/locations/{location}/collections/{collection}/engines/{engine}
     * - example: projects/{project}/locations/{location}/apps/{app}/examples/{example}
     * - guardrail: projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}
     * - inspectTemplate: organizations/{organization}/locations/{location}/inspectTemplates/{inspect_template}
     * - location: projects/{project}/locations/{location}
     * - organizationLocationDeidentifyTemplate: organizations/{organization}/locations/{location}/deidentifyTemplates/{deidentify_template}
     * - organizationLocationInspectTemplate: organizations/{organization}/locations/{location}/inspectTemplates/{inspect_template}
     * - projectLocationDeidentifyTemplate: projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}
     * - projectLocationInspectTemplate: projects/{project}/locations/{location}/inspectTemplates/{inspect_template}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{secret_version}
     * - service: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}
     * - tool: projects/{project}/locations/{location}/apps/{app}/tools/{tool}
     * - toolset: projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'ces.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Ces\V1beta\AgentServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new AgentServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Batch deletes the specified conversations.
     *
     * The async variant is {@see AgentServiceClient::batchDeleteConversationsAsync()}
     * .
     *
     * @example samples/V1beta/AgentServiceClient/batch_delete_conversations.php
     *
     * @param BatchDeleteConversationsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BatchDeleteConversationsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function batchDeleteConversations(BatchDeleteConversationsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BatchDeleteConversations', $request, $callOptions)->wait();
    }

    /**
     * Creates a new agent in the given app.
     *
     * The async variant is {@see AgentServiceClient::createAgentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_agent.php
     *
     * @param CreateAgentRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Agent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createAgent(CreateAgentRequest $request, array $callOptions = []): Agent
    {
        return $this->startApiCall('CreateAgent', $request, $callOptions)->wait();
    }

    /**
     * Creates a new app in the given project and location.
     *
     * The async variant is {@see AgentServiceClient::createAppAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_app.php
     *
     * @param CreateAppRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<App>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createApp(CreateAppRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateApp', $request, $callOptions)->wait();
    }

    /**
     * Creates a new app version in the given app.
     *
     * The async variant is {@see AgentServiceClient::createAppVersionAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_app_version.php
     *
     * @param CreateAppVersionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AppVersion
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createAppVersion(CreateAppVersionRequest $request, array $callOptions = []): AppVersion
    {
        return $this->startApiCall('CreateAppVersion', $request, $callOptions)->wait();
    }

    /**
     * Creates a new deployment in the given app.
     *
     * The async variant is {@see AgentServiceClient::createDeploymentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_deployment.php
     *
     * @param CreateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createDeployment(CreateDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('CreateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Creates a new example in the given app.
     *
     * The async variant is {@see AgentServiceClient::createExampleAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_example.php
     *
     * @param CreateExampleRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Example
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createExample(CreateExampleRequest $request, array $callOptions = []): Example
    {
        return $this->startApiCall('CreateExample', $request, $callOptions)->wait();
    }

    /**
     * Creates a new guardrail in the given app.
     *
     * The async variant is {@see AgentServiceClient::createGuardrailAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_guardrail.php
     *
     * @param CreateGuardrailRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Guardrail
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createGuardrail(CreateGuardrailRequest $request, array $callOptions = []): Guardrail
    {
        return $this->startApiCall('CreateGuardrail', $request, $callOptions)->wait();
    }

    /**
     * Creates a new tool in the given app.
     *
     * The async variant is {@see AgentServiceClient::createToolAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_tool.php
     *
     * @param CreateToolRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tool
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createTool(CreateToolRequest $request, array $callOptions = []): Tool
    {
        return $this->startApiCall('CreateTool', $request, $callOptions)->wait();
    }

    /**
     * Creates a new toolset in the given app.
     *
     * The async variant is {@see AgentServiceClient::createToolsetAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/create_toolset.php
     *
     * @param CreateToolsetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Toolset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createToolset(CreateToolsetRequest $request, array $callOptions = []): Toolset
    {
        return $this->startApiCall('CreateToolset', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified agent.
     *
     * The async variant is {@see AgentServiceClient::deleteAgentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_agent.php
     *
     * @param DeleteAgentRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAgent(DeleteAgentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAgent', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified app.
     *
     * The async variant is {@see AgentServiceClient::deleteAppAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_app.php
     *
     * @param DeleteAppRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteApp(DeleteAppRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteApp', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified app version.
     *
     * The async variant is {@see AgentServiceClient::deleteAppVersionAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_app_version.php
     *
     * @param DeleteAppVersionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAppVersion(DeleteAppVersionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAppVersion', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified conversation.
     *
     * The async variant is {@see AgentServiceClient::deleteConversationAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_conversation.php
     *
     * @param DeleteConversationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteConversation(DeleteConversationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConversation', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified deployment.
     *
     * The async variant is {@see AgentServiceClient::deleteDeploymentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_deployment.php
     *
     * @param DeleteDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteDeployment(DeleteDeploymentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDeployment', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified example.
     *
     * The async variant is {@see AgentServiceClient::deleteExampleAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_example.php
     *
     * @param DeleteExampleRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteExample(DeleteExampleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteExample', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified guardrail.
     *
     * The async variant is {@see AgentServiceClient::deleteGuardrailAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_guardrail.php
     *
     * @param DeleteGuardrailRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteGuardrail(DeleteGuardrailRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteGuardrail', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified tool.
     *
     * The async variant is {@see AgentServiceClient::deleteToolAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_tool.php
     *
     * @param DeleteToolRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteTool(DeleteToolRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTool', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified toolset.
     *
     * The async variant is {@see AgentServiceClient::deleteToolsetAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/delete_toolset.php
     *
     * @param DeleteToolsetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteToolset(DeleteToolsetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteToolset', $request, $callOptions)->wait();
    }

    /**
     * Exports the specified app.
     *
     * The async variant is {@see AgentServiceClient::exportAppAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/export_app.php
     *
     * @param ExportAppRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ExportAppResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function exportApp(ExportAppRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportApp', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified agent.
     *
     * The async variant is {@see AgentServiceClient::getAgentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_agent.php
     *
     * @param GetAgentRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Agent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAgent(GetAgentRequest $request, array $callOptions = []): Agent
    {
        return $this->startApiCall('GetAgent', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified app.
     *
     * The async variant is {@see AgentServiceClient::getAppAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_app.php
     *
     * @param GetAppRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return App
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getApp(GetAppRequest $request, array $callOptions = []): App
    {
        return $this->startApiCall('GetApp', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified app version.
     *
     * The async variant is {@see AgentServiceClient::getAppVersionAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_app_version.php
     *
     * @param GetAppVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AppVersion
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAppVersion(GetAppVersionRequest $request, array $callOptions = []): AppVersion
    {
        return $this->startApiCall('GetAppVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets the specified changelog.
     *
     * The async variant is {@see AgentServiceClient::getChangelogAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_changelog.php
     *
     * @param GetChangelogRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Changelog
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getChangelog(GetChangelogRequest $request, array $callOptions = []): Changelog
    {
        return $this->startApiCall('GetChangelog', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified conversation.
     *
     * The async variant is {@see AgentServiceClient::getConversationAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_conversation.php
     *
     * @param GetConversationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Conversation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getConversation(GetConversationRequest $request, array $callOptions = []): Conversation
    {
        return $this->startApiCall('GetConversation', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified deployment.
     *
     * The async variant is {@see AgentServiceClient::getDeploymentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_deployment.php
     *
     * @param GetDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDeployment(GetDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('GetDeployment', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified example.
     *
     * The async variant is {@see AgentServiceClient::getExampleAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_example.php
     *
     * @param GetExampleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Example
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getExample(GetExampleRequest $request, array $callOptions = []): Example
    {
        return $this->startApiCall('GetExample', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified guardrail.
     *
     * The async variant is {@see AgentServiceClient::getGuardrailAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_guardrail.php
     *
     * @param GetGuardrailRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Guardrail
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getGuardrail(GetGuardrailRequest $request, array $callOptions = []): Guardrail
    {
        return $this->startApiCall('GetGuardrail', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified tool.
     *
     * The async variant is {@see AgentServiceClient::getToolAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_tool.php
     *
     * @param GetToolRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tool
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getTool(GetToolRequest $request, array $callOptions = []): Tool
    {
        return $this->startApiCall('GetTool', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified toolset.
     *
     * The async variant is {@see AgentServiceClient::getToolsetAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_toolset.php
     *
     * @param GetToolsetRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Toolset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getToolset(GetToolsetRequest $request, array $callOptions = []): Toolset
    {
        return $this->startApiCall('GetToolset', $request, $callOptions)->wait();
    }

    /**
     * Imports the specified app.
     *
     * The async variant is {@see AgentServiceClient::importAppAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/import_app.php
     *
     * @param ImportAppRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ImportAppResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function importApp(ImportAppRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportApp', $request, $callOptions)->wait();
    }

    /**
     * Lists agents in the given app.
     *
     * The async variant is {@see AgentServiceClient::listAgentsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_agents.php
     *
     * @param ListAgentsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAgents(ListAgentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAgents', $request, $callOptions);
    }

    /**
     * Lists all app versions in the given app.
     *
     * The async variant is {@see AgentServiceClient::listAppVersionsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_app_versions.php
     *
     * @param ListAppVersionsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAppVersions(ListAppVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAppVersions', $request, $callOptions);
    }

    /**
     * Lists apps in the given project and location.
     *
     * The async variant is {@see AgentServiceClient::listAppsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_apps.php
     *
     * @param ListAppsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listApps(ListAppsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApps', $request, $callOptions);
    }

    /**
     * Lists the changelogs of the specified app.
     *
     * The async variant is {@see AgentServiceClient::listChangelogsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_changelogs.php
     *
     * @param ListChangelogsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listChangelogs(ListChangelogsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListChangelogs', $request, $callOptions);
    }

    /**
     * Lists conversations in the given app.
     *
     * The async variant is {@see AgentServiceClient::listConversationsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_conversations.php
     *
     * @param ListConversationsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listConversations(ListConversationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConversations', $request, $callOptions);
    }

    /**
     * Lists deployments in the given app.
     *
     * The async variant is {@see AgentServiceClient::listDeploymentsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_deployments.php
     *
     * @param ListDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listDeployments(ListDeploymentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDeployments', $request, $callOptions);
    }

    /**
     * Lists examples in the given app.
     *
     * The async variant is {@see AgentServiceClient::listExamplesAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_examples.php
     *
     * @param ListExamplesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listExamples(ListExamplesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListExamples', $request, $callOptions);
    }

    /**
     * Lists guardrails in the given app.
     *
     * The async variant is {@see AgentServiceClient::listGuardrailsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_guardrails.php
     *
     * @param ListGuardrailsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listGuardrails(ListGuardrailsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGuardrails', $request, $callOptions);
    }

    /**
     * Lists tools in the given app.
     *
     * The async variant is {@see AgentServiceClient::listToolsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_tools.php
     *
     * @param ListToolsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listTools(ListToolsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTools', $request, $callOptions);
    }

    /**
     * Lists toolsets in the given app.
     *
     * The async variant is {@see AgentServiceClient::listToolsetsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_toolsets.php
     *
     * @param ListToolsetsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listToolsets(ListToolsetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListToolsets', $request, $callOptions);
    }

    /**
     * Restores the specified app version.
     * This will create a new app version from the current draft app and overwrite
     * the current draft with the specified app version.
     *
     * The async variant is {@see AgentServiceClient::restoreAppVersionAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/restore_app_version.php
     *
     * @param RestoreAppVersionRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<RestoreAppVersionResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function restoreAppVersion(RestoreAppVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreAppVersion', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified agent.
     *
     * The async variant is {@see AgentServiceClient::updateAgentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/update_agent.php
     *
     * @param UpdateAgentRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Agent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateAgent(UpdateAgentRequest $request, array $callOptions = []): Agent
    {
        return $this->startApiCall('UpdateAgent', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified app.
     *
     * The async variant is {@see AgentServiceClient::updateAppAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/update_app.php
     *
     * @param UpdateAppRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return App
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateApp(UpdateAppRequest $request, array $callOptions = []): App
    {
        return $this->startApiCall('UpdateApp', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified deployment.
     *
     * The async variant is {@see AgentServiceClient::updateDeploymentAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/update_deployment.php
     *
     * @param UpdateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateDeployment(UpdateDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('UpdateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified example.
     *
     * The async variant is {@see AgentServiceClient::updateExampleAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/update_example.php
     *
     * @param UpdateExampleRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Example
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateExample(UpdateExampleRequest $request, array $callOptions = []): Example
    {
        return $this->startApiCall('UpdateExample', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified guardrail.
     *
     * The async variant is {@see AgentServiceClient::updateGuardrailAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/update_guardrail.php
     *
     * @param UpdateGuardrailRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Guardrail
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateGuardrail(UpdateGuardrailRequest $request, array $callOptions = []): Guardrail
    {
        return $this->startApiCall('UpdateGuardrail', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified tool.
     *
     * The async variant is {@see AgentServiceClient::updateToolAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/update_tool.php
     *
     * @param UpdateToolRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tool
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateTool(UpdateToolRequest $request, array $callOptions = []): Tool
    {
        return $this->startApiCall('UpdateTool', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified toolset.
     *
     * The async variant is {@see AgentServiceClient::updateToolsetAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/update_toolset.php
     *
     * @param UpdateToolsetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Toolset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateToolset(UpdateToolsetRequest $request, array $callOptions = []): Toolset
    {
        return $this->startApiCall('UpdateToolset', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see AgentServiceClient::getLocationAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see AgentServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1beta/AgentServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
