<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/ces/v1beta/evaluation_service.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Ces\V1beta\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Ces\V1beta\CreateEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\CreateEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\CreateEvaluationRequest;
use Google\Cloud\Ces\V1beta\CreateScheduledEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationResultRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\DeleteScheduledEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\Evaluation;
use Google\Cloud\Ces\V1beta\EvaluationDataset;
use Google\Cloud\Ces\V1beta\EvaluationExpectation;
use Google\Cloud\Ces\V1beta\EvaluationResult;
use Google\Cloud\Ces\V1beta\EvaluationRun;
use Google\Cloud\Ces\V1beta\GenerateEvaluationRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationResultRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\GetScheduledEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\ImportEvaluationsRequest;
use Google\Cloud\Ces\V1beta\ImportEvaluationsResponse;
use Google\Cloud\Ces\V1beta\ListEvaluationDatasetsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationExpectationsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationResultsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationRunsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationsRequest;
use Google\Cloud\Ces\V1beta\ListScheduledEvaluationRunsRequest;
use Google\Cloud\Ces\V1beta\RunEvaluationRequest;
use Google\Cloud\Ces\V1beta\RunEvaluationResponse;
use Google\Cloud\Ces\V1beta\ScheduledEvaluationRun;
use Google\Cloud\Ces\V1beta\TestPersonaVoiceRequest;
use Google\Cloud\Ces\V1beta\TestPersonaVoiceResponse;
use Google\Cloud\Ces\V1beta\UpdateEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\UpdateEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\UpdateEvaluationRequest;
use Google\Cloud\Ces\V1beta\UpdateScheduledEvaluationRunRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: EvaluationService exposes methods to perform evaluation for the CES app.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface<Evaluation> createEvaluationAsync(CreateEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationDataset> createEvaluationDatasetAsync(CreateEvaluationDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationExpectation> createEvaluationExpectationAsync(CreateEvaluationExpectationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ScheduledEvaluationRun> createScheduledEvaluationRunAsync(CreateScheduledEvaluationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteEvaluationAsync(DeleteEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteEvaluationDatasetAsync(DeleteEvaluationDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteEvaluationExpectationAsync(DeleteEvaluationExpectationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteEvaluationResultAsync(DeleteEvaluationResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEvaluationRunAsync(DeleteEvaluationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteScheduledEvaluationRunAsync(DeleteScheduledEvaluationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> generateEvaluationAsync(GenerateEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Evaluation> getEvaluationAsync(GetEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationDataset> getEvaluationDatasetAsync(GetEvaluationDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationExpectation> getEvaluationExpectationAsync(GetEvaluationExpectationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationResult> getEvaluationResultAsync(GetEvaluationResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationRun> getEvaluationRunAsync(GetEvaluationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ScheduledEvaluationRun> getScheduledEvaluationRunAsync(GetScheduledEvaluationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importEvaluationsAsync(ImportEvaluationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEvaluationDatasetsAsync(ListEvaluationDatasetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEvaluationExpectationsAsync(ListEvaluationExpectationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEvaluationResultsAsync(ListEvaluationResultsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEvaluationRunsAsync(ListEvaluationRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEvaluationsAsync(ListEvaluationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listScheduledEvaluationRunsAsync(ListScheduledEvaluationRunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> runEvaluationAsync(RunEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestPersonaVoiceResponse> testPersonaVoiceAsync(TestPersonaVoiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Evaluation> updateEvaluationAsync(UpdateEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationDataset> updateEvaluationDatasetAsync(UpdateEvaluationDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EvaluationExpectation> updateEvaluationExpectationAsync(UpdateEvaluationExpectationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ScheduledEvaluationRun> updateScheduledEvaluationRunAsync(UpdateScheduledEvaluationRunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class EvaluationServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.ces.v1beta.EvaluationService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'ces.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'ces.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/ces',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/evaluation_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/evaluation_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/evaluation_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/evaluation_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     *
     * @experimental
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     *
     * @experimental
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $agent
     *
     * @return string The formatted agent resource.
     *
     * @experimental
     */
    public static function agentName(string $project, string $location, string $app, string $agent): string
    {
        return self::getPathTemplate('agent')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a app
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     *
     * @return string The formatted app resource.
     *
     * @experimental
     */
    public static function appName(string $project, string $location, string $app): string
    {
        return self::getPathTemplate('app')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a app_version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $version
     *
     * @return string The formatted app_version resource.
     *
     * @experimental
     */
    public static function appVersionName(string $project, string $location, string $app, string $version): string
    {
        return self::getPathTemplate('appVersion')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a changelog
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $changelog
     *
     * @return string The formatted changelog resource.
     *
     * @experimental
     */
    public static function changelogName(string $project, string $location, string $app, string $changelog): string
    {
        return self::getPathTemplate('changelog')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'changelog' => $changelog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a conversation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $conversation
     *
     * @return string The formatted conversation resource.
     *
     * @experimental
     */
    public static function conversationName(string $project, string $location, string $app, string $conversation): string
    {
        return self::getPathTemplate('conversation')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a evaluation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $evaluation
     *
     * @return string The formatted evaluation resource.
     *
     * @experimental
     */
    public static function evaluationName(string $project, string $location, string $app, string $evaluation): string
    {
        return self::getPathTemplate('evaluation')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * evaluation_dataset resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $evaluationDataset
     *
     * @return string The formatted evaluation_dataset resource.
     *
     * @experimental
     */
    public static function evaluationDatasetName(string $project, string $location, string $app, string $evaluationDataset): string
    {
        return self::getPathTemplate('evaluationDataset')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'evaluation_dataset' => $evaluationDataset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * evaluation_expectation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $evaluationExpectation
     *
     * @return string The formatted evaluation_expectation resource.
     *
     * @experimental
     */
    public static function evaluationExpectationName(string $project, string $location, string $app, string $evaluationExpectation): string
    {
        return self::getPathTemplate('evaluationExpectation')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'evaluation_expectation' => $evaluationExpectation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * evaluation_result resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $evaluation
     * @param string $evaluationResult
     *
     * @return string The formatted evaluation_result resource.
     *
     * @experimental
     */
    public static function evaluationResultName(string $project, string $location, string $app, string $evaluation, string $evaluationResult): string
    {
        return self::getPathTemplate('evaluationResult')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'evaluation' => $evaluation,
            'evaluation_result' => $evaluationResult,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * evaluation_run resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $evaluationRun
     *
     * @return string The formatted evaluation_run resource.
     *
     * @experimental
     */
    public static function evaluationRunName(string $project, string $location, string $app, string $evaluationRun): string
    {
        return self::getPathTemplate('evaluationRun')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'evaluation_run' => $evaluationRun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * scheduled_evaluation_run resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $scheduledEvaluationRun
     *
     * @return string The formatted scheduled_evaluation_run resource.
     *
     * @experimental
     */
    public static function scheduledEvaluationRunName(string $project, string $location, string $app, string $scheduledEvaluationRun): string
    {
        return self::getPathTemplate('scheduledEvaluationRun')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'scheduled_evaluation_run' => $scheduledEvaluationRun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $tool
     *
     * @return string The formatted tool resource.
     *
     * @experimental
     */
    public static function toolName(string $project, string $location, string $app, string $tool): string
    {
        return self::getPathTemplate('tool')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'tool' => $tool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a toolset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $toolset
     *
     * @return string The formatted toolset resource.
     *
     * @experimental
     */
    public static function toolsetName(string $project, string $location, string $app, string $toolset): string
    {
        return self::getPathTemplate('toolset')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'toolset' => $toolset,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/locations/{location}/apps/{app}/agents/{agent}
     * - app: projects/{project}/locations/{location}/apps/{app}
     * - appVersion: projects/{project}/locations/{location}/apps/{app}/versions/{version}
     * - changelog: projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}
     * - conversation: projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}
     * - evaluation: projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}
     * - evaluationDataset: projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluation_dataset}
     * - evaluationExpectation: projects/{project}/locations/{location}/apps/{app}/evaluationExpectations/{evaluation_expectation}
     * - evaluationResult: projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{evaluation_result}
     * - evaluationRun: projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluation_run}
     * - scheduledEvaluationRun: projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}
     * - tool: projects/{project}/locations/{location}/apps/{app}/tools/{tool}
     * - toolset: projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'ces.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Ces\V1beta\EvaluationServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new EvaluationServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an evaluation.
     *
     * The async variant is {@see EvaluationServiceClient::createEvaluationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/create_evaluation.php
     *
     * @param CreateEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Evaluation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createEvaluation(CreateEvaluationRequest $request, array $callOptions = []): Evaluation
    {
        return $this->startApiCall('CreateEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Creates an evaluation dataset.
     *
     * The async variant is
     * {@see EvaluationServiceClient::createEvaluationDatasetAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/create_evaluation_dataset.php
     *
     * @param CreateEvaluationDatasetRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationDataset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createEvaluationDataset(CreateEvaluationDatasetRequest $request, array $callOptions = []): EvaluationDataset
    {
        return $this->startApiCall('CreateEvaluationDataset', $request, $callOptions)->wait();
    }

    /**
     * Creates an evaluation expectation.
     *
     * The async variant is
     * {@see EvaluationServiceClient::createEvaluationExpectationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/create_evaluation_expectation.php
     *
     * @param CreateEvaluationExpectationRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationExpectation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createEvaluationExpectation(CreateEvaluationExpectationRequest $request, array $callOptions = []): EvaluationExpectation
    {
        return $this->startApiCall('CreateEvaluationExpectation', $request, $callOptions)->wait();
    }

    /**
     * Creates a scheduled evaluation run.
     *
     * The async variant is
     * {@see EvaluationServiceClient::createScheduledEvaluationRunAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/create_scheduled_evaluation_run.php
     *
     * @param CreateScheduledEvaluationRunRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScheduledEvaluationRun
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createScheduledEvaluationRun(CreateScheduledEvaluationRunRequest $request, array $callOptions = []): ScheduledEvaluationRun
    {
        return $this->startApiCall('CreateScheduledEvaluationRun', $request, $callOptions)->wait();
    }

    /**
     * Deletes an evaluation.
     *
     * The async variant is {@see EvaluationServiceClient::deleteEvaluationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/delete_evaluation.php
     *
     * @param DeleteEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteEvaluation(DeleteEvaluationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Deletes an evaluation dataset.
     *
     * The async variant is
     * {@see EvaluationServiceClient::deleteEvaluationDatasetAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/delete_evaluation_dataset.php
     *
     * @param DeleteEvaluationDatasetRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteEvaluationDataset(DeleteEvaluationDatasetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEvaluationDataset', $request, $callOptions)->wait();
    }

    /**
     * Deletes an evaluation expectation.
     *
     * The async variant is
     * {@see EvaluationServiceClient::deleteEvaluationExpectationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/delete_evaluation_expectation.php
     *
     * @param DeleteEvaluationExpectationRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteEvaluationExpectation(DeleteEvaluationExpectationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEvaluationExpectation', $request, $callOptions)->wait();
    }

    /**
     * Deletes an evaluation result.
     *
     * The async variant is
     * {@see EvaluationServiceClient::deleteEvaluationResultAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/delete_evaluation_result.php
     *
     * @param DeleteEvaluationResultRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteEvaluationResult(DeleteEvaluationResultRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEvaluationResult', $request, $callOptions)->wait();
    }

    /**
     * Deletes an evaluation run.
     *
     * The async variant is {@see EvaluationServiceClient::deleteEvaluationRunAsync()}
     * .
     *
     * @example samples/V1beta/EvaluationServiceClient/delete_evaluation_run.php
     *
     * @param DeleteEvaluationRunRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteEvaluationRun(DeleteEvaluationRunRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEvaluationRun', $request, $callOptions)->wait();
    }

    /**
     * Deletes a scheduled evaluation run.
     *
     * The async variant is
     * {@see EvaluationServiceClient::deleteScheduledEvaluationRunAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/delete_scheduled_evaluation_run.php
     *
     * @param DeleteScheduledEvaluationRunRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteScheduledEvaluationRun(DeleteScheduledEvaluationRunRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteScheduledEvaluationRun', $request, $callOptions)->wait();
    }

    /**
     * Creates a golden evaluation from a conversation.
     *
     * The async variant is {@see EvaluationServiceClient::generateEvaluationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/generate_evaluation.php
     *
     * @param GenerateEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Evaluation>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function generateEvaluation(GenerateEvaluationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('GenerateEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified evaluation.
     *
     * The async variant is {@see EvaluationServiceClient::getEvaluationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/get_evaluation.php
     *
     * @param GetEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Evaluation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEvaluation(GetEvaluationRequest $request, array $callOptions = []): Evaluation
    {
        return $this->startApiCall('GetEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified evaluation dataset.
     *
     * The async variant is {@see EvaluationServiceClient::getEvaluationDatasetAsync()}
     * .
     *
     * @example samples/V1beta/EvaluationServiceClient/get_evaluation_dataset.php
     *
     * @param GetEvaluationDatasetRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationDataset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEvaluationDataset(GetEvaluationDatasetRequest $request, array $callOptions = []): EvaluationDataset
    {
        return $this->startApiCall('GetEvaluationDataset', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified evaluation expectation.
     *
     * The async variant is
     * {@see EvaluationServiceClient::getEvaluationExpectationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/get_evaluation_expectation.php
     *
     * @param GetEvaluationExpectationRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationExpectation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEvaluationExpectation(GetEvaluationExpectationRequest $request, array $callOptions = []): EvaluationExpectation
    {
        return $this->startApiCall('GetEvaluationExpectation', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified evaluation result.
     *
     * The async variant is {@see EvaluationServiceClient::getEvaluationResultAsync()}
     * .
     *
     * @example samples/V1beta/EvaluationServiceClient/get_evaluation_result.php
     *
     * @param GetEvaluationResultRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationResult
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEvaluationResult(GetEvaluationResultRequest $request, array $callOptions = []): EvaluationResult
    {
        return $this->startApiCall('GetEvaluationResult', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified evaluation run.
     *
     * The async variant is {@see EvaluationServiceClient::getEvaluationRunAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/get_evaluation_run.php
     *
     * @param GetEvaluationRunRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationRun
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEvaluationRun(GetEvaluationRunRequest $request, array $callOptions = []): EvaluationRun
    {
        return $this->startApiCall('GetEvaluationRun', $request, $callOptions)->wait();
    }

    /**
     * Gets details of the specified scheduled evaluation run.
     *
     * The async variant is
     * {@see EvaluationServiceClient::getScheduledEvaluationRunAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/get_scheduled_evaluation_run.php
     *
     * @param GetScheduledEvaluationRunRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScheduledEvaluationRun
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getScheduledEvaluationRun(GetScheduledEvaluationRunRequest $request, array $callOptions = []): ScheduledEvaluationRun
    {
        return $this->startApiCall('GetScheduledEvaluationRun', $request, $callOptions)->wait();
    }

    /**
     * Imports evaluations into the app.
     *
     * The async variant is {@see EvaluationServiceClient::importEvaluationsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/import_evaluations.php
     *
     * @param ImportEvaluationsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ImportEvaluationsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function importEvaluations(ImportEvaluationsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportEvaluations', $request, $callOptions)->wait();
    }

    /**
     * Lists all evaluation datasets in the given app.
     *
     * The async variant is
     * {@see EvaluationServiceClient::listEvaluationDatasetsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/list_evaluation_datasets.php
     *
     * @param ListEvaluationDatasetsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listEvaluationDatasets(ListEvaluationDatasetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEvaluationDatasets', $request, $callOptions);
    }

    /**
     * Lists all evaluation expectations in the given app.
     *
     * The async variant is
     * {@see EvaluationServiceClient::listEvaluationExpectationsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/list_evaluation_expectations.php
     *
     * @param ListEvaluationExpectationsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listEvaluationExpectations(ListEvaluationExpectationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEvaluationExpectations', $request, $callOptions);
    }

    /**
     * Lists all evaluation results for a given evaluation.
     *
     * The async variant is
     * {@see EvaluationServiceClient::listEvaluationResultsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/list_evaluation_results.php
     *
     * @param ListEvaluationResultsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listEvaluationResults(ListEvaluationResultsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEvaluationResults', $request, $callOptions);
    }

    /**
     * Lists all evaluation runs in the given app.
     *
     * The async variant is {@see EvaluationServiceClient::listEvaluationRunsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/list_evaluation_runs.php
     *
     * @param ListEvaluationRunsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listEvaluationRuns(ListEvaluationRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEvaluationRuns', $request, $callOptions);
    }

    /**
     * Lists all evaluations in the given app.
     *
     * The async variant is {@see EvaluationServiceClient::listEvaluationsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/list_evaluations.php
     *
     * @param ListEvaluationsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listEvaluations(ListEvaluationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEvaluations', $request, $callOptions);
    }

    /**
     * Lists all scheduled evaluation runs in the given app.
     *
     * The async variant is
     * {@see EvaluationServiceClient::listScheduledEvaluationRunsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/list_scheduled_evaluation_runs.php
     *
     * @param ListScheduledEvaluationRunsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listScheduledEvaluationRuns(ListScheduledEvaluationRunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListScheduledEvaluationRuns', $request, $callOptions);
    }

    /**
     * Runs an evaluation of the app.
     *
     * The async variant is {@see EvaluationServiceClient::runEvaluationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/run_evaluation.php
     *
     * @param RunEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<RunEvaluationResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function runEvaluation(RunEvaluationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RunEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Tests the voice of a persona. Also accepts a default persona.
     *
     * The async variant is {@see EvaluationServiceClient::testPersonaVoiceAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/test_persona_voice.php
     *
     * @param TestPersonaVoiceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestPersonaVoiceResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function testPersonaVoice(TestPersonaVoiceRequest $request, array $callOptions = []): TestPersonaVoiceResponse
    {
        return $this->startApiCall('TestPersonaVoice', $request, $callOptions)->wait();
    }

    /**
     * Updates an evaluation.
     *
     * The async variant is {@see EvaluationServiceClient::updateEvaluationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/update_evaluation.php
     *
     * @param UpdateEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Evaluation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateEvaluation(UpdateEvaluationRequest $request, array $callOptions = []): Evaluation
    {
        return $this->startApiCall('UpdateEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Updates an evaluation dataset.
     *
     * The async variant is
     * {@see EvaluationServiceClient::updateEvaluationDatasetAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/update_evaluation_dataset.php
     *
     * @param UpdateEvaluationDatasetRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationDataset
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateEvaluationDataset(UpdateEvaluationDatasetRequest $request, array $callOptions = []): EvaluationDataset
    {
        return $this->startApiCall('UpdateEvaluationDataset', $request, $callOptions)->wait();
    }

    /**
     * Updates an evaluation expectation.
     *
     * The async variant is
     * {@see EvaluationServiceClient::updateEvaluationExpectationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/update_evaluation_expectation.php
     *
     * @param UpdateEvaluationExpectationRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EvaluationExpectation
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateEvaluationExpectation(UpdateEvaluationExpectationRequest $request, array $callOptions = []): EvaluationExpectation
    {
        return $this->startApiCall('UpdateEvaluationExpectation', $request, $callOptions)->wait();
    }

    /**
     * Updates a scheduled evaluation run.
     *
     * The async variant is
     * {@see EvaluationServiceClient::updateScheduledEvaluationRunAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/update_scheduled_evaluation_run.php
     *
     * @param UpdateScheduledEvaluationRunRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ScheduledEvaluationRun
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateScheduledEvaluationRun(UpdateScheduledEvaluationRunRequest $request, array $callOptions = []): ScheduledEvaluationRun
    {
        return $this->startApiCall('UpdateScheduledEvaluationRun', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see EvaluationServiceClient::getLocationAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see EvaluationServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1beta/EvaluationServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
