<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

return [
    'interfaces' => [
        'google.cloud.ces.v1beta.EvaluationService' => [
            'CreateEvaluation' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/evaluations',
                'body' => 'evaluation',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'CreateEvaluationDataset' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/evaluationDatasets',
                'body' => 'evaluation_dataset',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'CreateEvaluationExpectation' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/evaluationExpectations',
                'body' => 'evaluation_expectation',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'CreateScheduledEvaluationRun' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/scheduledEvaluationRuns',
                'body' => 'scheduled_evaluation_run',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'DeleteEvaluation' => [
                'method' => 'delete',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteEvaluationDataset' => [
                'method' => 'delete',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluationDatasets/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteEvaluationExpectation' => [
                'method' => 'delete',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluationExpectations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteEvaluationResult' => [
                'method' => 'delete',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluations/*/results/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteEvaluationRun' => [
                'method' => 'delete',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluationRuns/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteScheduledEvaluationRun' => [
                'method' => 'delete',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/scheduledEvaluationRuns/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GenerateEvaluation' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{conversation=projects/*/locations/*/apps/*/conversations/*}:generateEvaluation',
                'body' => '*',
                'placeholders' => [
                    'conversation' => [
                        'getters' => [
                            'getConversation',
                        ],
                    ],
                ],
            ],
            'GetEvaluation' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetEvaluationDataset' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluationDatasets/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetEvaluationExpectation' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluationExpectations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetEvaluationResult' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluations/*/results/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetEvaluationRun' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/evaluationRuns/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetScheduledEvaluationRun' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/apps/*/scheduledEvaluationRuns/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'ImportEvaluations' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}:importEvaluations',
                'body' => '*',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListEvaluationDatasets' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/evaluationDatasets',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListEvaluationExpectations' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/evaluationExpectations',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListEvaluationResults' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*/evaluations/*}/results',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListEvaluationRuns' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/evaluationRuns',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListEvaluations' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/evaluations',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListScheduledEvaluationRuns' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{parent=projects/*/locations/*/apps/*}/scheduledEvaluationRuns',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'RunEvaluation' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{app=projects/*/locations/*/apps/*}:runEvaluation',
                'body' => '*',
                'placeholders' => [
                    'app' => [
                        'getters' => [
                            'getApp',
                        ],
                    ],
                ],
            ],
            'TestPersonaVoice' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{app=projects/*/locations/*/apps/*}:testPersonaVoice',
                'body' => '*',
                'placeholders' => [
                    'app' => [
                        'getters' => [
                            'getApp',
                        ],
                    ],
                ],
            ],
            'UpdateEvaluation' => [
                'method' => 'patch',
                'uriTemplate' => '/v1beta/{evaluation.name=projects/*/locations/*/apps/*/evaluations/*}',
                'body' => 'evaluation',
                'placeholders' => [
                    'evaluation.name' => [
                        'getters' => [
                            'getEvaluation',
                            'getName',
                        ],
                    ],
                ],
            ],
            'UpdateEvaluationDataset' => [
                'method' => 'patch',
                'uriTemplate' => '/v1beta/{evaluation_dataset.name=projects/*/locations/*/apps/*/evaluationDatasets/*}',
                'body' => 'evaluation_dataset',
                'placeholders' => [
                    'evaluation_dataset.name' => [
                        'getters' => [
                            'getEvaluationDataset',
                            'getName',
                        ],
                    ],
                ],
            ],
            'UpdateEvaluationExpectation' => [
                'method' => 'patch',
                'uriTemplate' => '/v1beta/{evaluation_expectation.name=projects/*/locations/*/apps/*/evaluationExpectations/*}',
                'body' => 'evaluation_expectation',
                'placeholders' => [
                    'evaluation_expectation.name' => [
                        'getters' => [
                            'getEvaluationExpectation',
                            'getName',
                        ],
                    ],
                ],
            ],
            'UpdateScheduledEvaluationRun' => [
                'method' => 'patch',
                'uriTemplate' => '/v1beta/{scheduled_evaluation_run.name=projects/*/locations/*/apps/*/scheduledEvaluationRuns/*}',
                'body' => 'scheduled_evaluation_run',
                'placeholders' => [
                    'scheduled_evaluation_run.name' => [
                        'getters' => [
                            'getScheduledEvaluationRun',
                            'getName',
                        ],
                    ],
                ],
            ],
        ],
        'google.cloud.location.Locations' => [
            'GetLocation' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'ListLocations' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*}/locations',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
        ],
        'google.longrunning.Operations' => [
            'CancelOperation' => [
                'method' => 'post',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/operations/*}:cancel',
                'body' => '*',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteOperation' => [
                'method' => 'delete',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/operations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetOperation' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*/operations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'ListOperations' => [
                'method' => 'get',
                'uriTemplate' => '/v1beta/{name=projects/*/locations/*}/operations',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
        ],
    ],
    'numericEnums' => true,
];
