<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * This file was automatically generated - do not edit!
 */

namespace Google\Cloud\Ces\Tests\Unit\V1beta\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\Testing\GeneratedTest;
use Google\ApiCore\Testing\MockTransport;
use Google\Cloud\Ces\V1beta\Client\EvaluationServiceClient;
use Google\Cloud\Ces\V1beta\CreateEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\CreateEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\CreateEvaluationRequest;
use Google\Cloud\Ces\V1beta\CreateScheduledEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationResultRequest;
use Google\Cloud\Ces\V1beta\DeleteEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\DeleteScheduledEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\Evaluation;
use Google\Cloud\Ces\V1beta\EvaluationDataset;
use Google\Cloud\Ces\V1beta\EvaluationExpectation;
use Google\Cloud\Ces\V1beta\EvaluationResult;
use Google\Cloud\Ces\V1beta\EvaluationRun;
use Google\Cloud\Ces\V1beta\GenerateEvaluationRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationResultRequest;
use Google\Cloud\Ces\V1beta\GetEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\GetScheduledEvaluationRunRequest;
use Google\Cloud\Ces\V1beta\ImportEvaluationsRequest;
use Google\Cloud\Ces\V1beta\ImportEvaluationsResponse;
use Google\Cloud\Ces\V1beta\ListEvaluationDatasetsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationDatasetsResponse;
use Google\Cloud\Ces\V1beta\ListEvaluationExpectationsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationExpectationsResponse;
use Google\Cloud\Ces\V1beta\ListEvaluationResultsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationResultsResponse;
use Google\Cloud\Ces\V1beta\ListEvaluationRunsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationRunsResponse;
use Google\Cloud\Ces\V1beta\ListEvaluationsRequest;
use Google\Cloud\Ces\V1beta\ListEvaluationsResponse;
use Google\Cloud\Ces\V1beta\ListScheduledEvaluationRunsRequest;
use Google\Cloud\Ces\V1beta\ListScheduledEvaluationRunsResponse;
use Google\Cloud\Ces\V1beta\RunEvaluationRequest;
use Google\Cloud\Ces\V1beta\RunEvaluationResponse;
use Google\Cloud\Ces\V1beta\ScheduledEvaluationRun;
use Google\Cloud\Ces\V1beta\ScheduledEvaluationRun\SchedulingConfig;
use Google\Cloud\Ces\V1beta\ScheduledEvaluationRun\SchedulingConfig\Frequency;
use Google\Cloud\Ces\V1beta\TestPersonaVoiceRequest;
use Google\Cloud\Ces\V1beta\TestPersonaVoiceResponse;
use Google\Cloud\Ces\V1beta\UpdateEvaluationDatasetRequest;
use Google\Cloud\Ces\V1beta\UpdateEvaluationExpectationRequest;
use Google\Cloud\Ces\V1beta\UpdateEvaluationRequest;
use Google\Cloud\Ces\V1beta\UpdateScheduledEvaluationRunRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\GetOperationRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\Any;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;
use Google\Rpc\Code;
use stdClass;

/**
 * @group ces
 *
 * @group gapic
 */
class EvaluationServiceClientTest extends GeneratedTest
{
    /** @return TransportInterface */
    private function createTransport($deserialize = null)
    {
        return new MockTransport($deserialize);
    }

    /** @return CredentialsWrapper */
    private function createCredentials()
    {
        return $this->getMockBuilder(CredentialsWrapper::class)->disableOriginalConstructor()->getMock();
    }

    /** @return EvaluationServiceClient */
    private function createClient(array $options = [])
    {
        $options += [
            'credentials' => $this->createCredentials(),
        ];
        return new EvaluationServiceClient($options);
    }

    /** @test */
    public function createEvaluationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $invalid = false;
        $expectedResponse = new Evaluation();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setInvalid($invalid);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $evaluation = new Evaluation();
        $evaluationDisplayName = 'evaluationDisplayName-871245423';
        $evaluation->setDisplayName($evaluationDisplayName);
        $request = (new CreateEvaluationRequest())
            ->setParent($formattedParent)
            ->setEvaluation($evaluation);
        $response = $gapicClient->createEvaluation($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/CreateEvaluation', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $actualValue = $actualRequestObject->getEvaluation();
        $this->assertProtobufEquals($evaluation, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createEvaluationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $evaluation = new Evaluation();
        $evaluationDisplayName = 'evaluationDisplayName-871245423';
        $evaluation->setDisplayName($evaluationDisplayName);
        $request = (new CreateEvaluationRequest())
            ->setParent($formattedParent)
            ->setEvaluation($evaluation);
        try {
            $gapicClient->createEvaluation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createEvaluationDatasetTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $etag = 'etag3123477';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $expectedResponse = new EvaluationDataset();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $evaluationDataset = new EvaluationDataset();
        $evaluationDatasetDisplayName = 'evaluationDatasetDisplayName-58213583';
        $evaluationDataset->setDisplayName($evaluationDatasetDisplayName);
        $request = (new CreateEvaluationDatasetRequest())
            ->setParent($formattedParent)
            ->setEvaluationDataset($evaluationDataset);
        $response = $gapicClient->createEvaluationDataset($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/CreateEvaluationDataset', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $actualValue = $actualRequestObject->getEvaluationDataset();
        $this->assertProtobufEquals($evaluationDataset, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createEvaluationDatasetExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $evaluationDataset = new EvaluationDataset();
        $evaluationDatasetDisplayName = 'evaluationDatasetDisplayName-58213583';
        $evaluationDataset->setDisplayName($evaluationDatasetDisplayName);
        $request = (new CreateEvaluationDatasetRequest())
            ->setParent($formattedParent)
            ->setEvaluationDataset($evaluationDataset);
        try {
            $gapicClient->createEvaluationDataset($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createEvaluationExpectationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $etag = 'etag3123477';
        $expectedResponse = new EvaluationExpectation();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setEtag($etag);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $evaluationExpectation = new EvaluationExpectation();
        $evaluationExpectationDisplayName = 'evaluationExpectationDisplayName-1786265363';
        $evaluationExpectation->setDisplayName($evaluationExpectationDisplayName);
        $request = (new CreateEvaluationExpectationRequest())
            ->setParent($formattedParent)
            ->setEvaluationExpectation($evaluationExpectation);
        $response = $gapicClient->createEvaluationExpectation($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/CreateEvaluationExpectation', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $actualValue = $actualRequestObject->getEvaluationExpectation();
        $this->assertProtobufEquals($evaluationExpectation, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createEvaluationExpectationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $evaluationExpectation = new EvaluationExpectation();
        $evaluationExpectationDisplayName = 'evaluationExpectationDisplayName-1786265363';
        $evaluationExpectation->setDisplayName($evaluationExpectationDisplayName);
        $request = (new CreateEvaluationExpectationRequest())
            ->setParent($formattedParent)
            ->setEvaluationExpectation($evaluationExpectation);
        try {
            $gapicClient->createEvaluationExpectation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createScheduledEvaluationRunTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $active = true;
        $lastCompletedRun = 'lastCompletedRun1718413486';
        $totalExecutions = 2074550218;
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $expectedResponse = new ScheduledEvaluationRun();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setActive($active);
        $expectedResponse->setLastCompletedRun($lastCompletedRun);
        $expectedResponse->setTotalExecutions($totalExecutions);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $scheduledEvaluationRun = new ScheduledEvaluationRun();
        $scheduledEvaluationRunDisplayName = 'scheduledEvaluationRunDisplayName-336218357';
        $scheduledEvaluationRun->setDisplayName($scheduledEvaluationRunDisplayName);
        $scheduledEvaluationRunRequest = new RunEvaluationRequest();
        $requestApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $scheduledEvaluationRunRequest->setApp($requestApp);
        $scheduledEvaluationRun->setRequest($scheduledEvaluationRunRequest);
        $scheduledEvaluationRunSchedulingConfig = new SchedulingConfig();
        $schedulingConfigFrequency = Frequency::FREQUENCY_UNSPECIFIED;
        $scheduledEvaluationRunSchedulingConfig->setFrequency($schedulingConfigFrequency);
        $schedulingConfigStartTime = new Timestamp();
        $scheduledEvaluationRunSchedulingConfig->setStartTime($schedulingConfigStartTime);
        $scheduledEvaluationRun->setSchedulingConfig($scheduledEvaluationRunSchedulingConfig);
        $request = (new CreateScheduledEvaluationRunRequest())
            ->setParent($formattedParent)
            ->setScheduledEvaluationRun($scheduledEvaluationRun);
        $response = $gapicClient->createScheduledEvaluationRun($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/CreateScheduledEvaluationRun', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $actualValue = $actualRequestObject->getScheduledEvaluationRun();
        $this->assertProtobufEquals($scheduledEvaluationRun, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createScheduledEvaluationRunExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $scheduledEvaluationRun = new ScheduledEvaluationRun();
        $scheduledEvaluationRunDisplayName = 'scheduledEvaluationRunDisplayName-336218357';
        $scheduledEvaluationRun->setDisplayName($scheduledEvaluationRunDisplayName);
        $scheduledEvaluationRunRequest = new RunEvaluationRequest();
        $requestApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $scheduledEvaluationRunRequest->setApp($requestApp);
        $scheduledEvaluationRun->setRequest($scheduledEvaluationRunRequest);
        $scheduledEvaluationRunSchedulingConfig = new SchedulingConfig();
        $schedulingConfigFrequency = Frequency::FREQUENCY_UNSPECIFIED;
        $scheduledEvaluationRunSchedulingConfig->setFrequency($schedulingConfigFrequency);
        $schedulingConfigStartTime = new Timestamp();
        $scheduledEvaluationRunSchedulingConfig->setStartTime($schedulingConfigStartTime);
        $scheduledEvaluationRun->setSchedulingConfig($scheduledEvaluationRunSchedulingConfig);
        $request = (new CreateScheduledEvaluationRunRequest())
            ->setParent($formattedParent)
            ->setScheduledEvaluationRun($scheduledEvaluationRun);
        try {
            $gapicClient->createScheduledEvaluationRun($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $expectedResponse = new GPBEmpty();
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]');
        $request = (new DeleteEvaluationRequest())
            ->setName($formattedName);
        $gapicClient->deleteEvaluation($request);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/DeleteEvaluation', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]');
        $request = (new DeleteEvaluationRequest())
            ->setName($formattedName);
        try {
            $gapicClient->deleteEvaluation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationDatasetTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $expectedResponse = new GPBEmpty();
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationDatasetName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_DATASET]');
        $request = (new DeleteEvaluationDatasetRequest())
            ->setName($formattedName);
        $gapicClient->deleteEvaluationDataset($request);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/DeleteEvaluationDataset', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationDatasetExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationDatasetName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_DATASET]');
        $request = (new DeleteEvaluationDatasetRequest())
            ->setName($formattedName);
        try {
            $gapicClient->deleteEvaluationDataset($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationExpectationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $expectedResponse = new GPBEmpty();
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationExpectationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_EXPECTATION]');
        $request = (new DeleteEvaluationExpectationRequest())
            ->setName($formattedName);
        $gapicClient->deleteEvaluationExpectation($request);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/DeleteEvaluationExpectation', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationExpectationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationExpectationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_EXPECTATION]');
        $request = (new DeleteEvaluationExpectationRequest())
            ->setName($formattedName);
        try {
            $gapicClient->deleteEvaluationExpectation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationResultTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $expectedResponse = new GPBEmpty();
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationResultName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]', '[EVALUATION_RESULT]');
        $request = (new DeleteEvaluationResultRequest())
            ->setName($formattedName);
        $gapicClient->deleteEvaluationResult($request);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/DeleteEvaluationResult', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationResultExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationResultName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]', '[EVALUATION_RESULT]');
        $request = (new DeleteEvaluationResultRequest())
            ->setName($formattedName);
        try {
            $gapicClient->deleteEvaluationResult($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationRunTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/deleteEvaluationRunTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $expectedResponse = new GPBEmpty();
        $anyResponse = new Any();
        $anyResponse->setValue($expectedResponse->serializeToString());
        $completeOperation = new Operation();
        $completeOperation->setName('operations/deleteEvaluationRunTest');
        $completeOperation->setDone(true);
        $completeOperation->setResponse($anyResponse);
        $operationsTransport->addResponse($completeOperation);
        // Mock request
        $formattedName = $gapicClient->evaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_RUN]');
        $request = (new DeleteEvaluationRunRequest())
            ->setName($formattedName);
        $response = $gapicClient->deleteEvaluationRun($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $apiRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($apiRequests));
        $operationsRequestsEmpty = $operationsTransport->popReceivedCalls();
        $this->assertSame(0, count($operationsRequestsEmpty));
        $actualApiFuncCall = $apiRequests[0]->getFuncCall();
        $actualApiRequestObject = $apiRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/DeleteEvaluationRun', $actualApiFuncCall);
        $actualValue = $actualApiRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/deleteEvaluationRunTest');
        $response->pollUntilComplete([
            'initialPollDelayMillis' => 1,
        ]);
        $this->assertTrue($response->isDone());
        $this->assertEquals($expectedResponse, $response->getResult());
        $apiRequestsEmpty = $transport->popReceivedCalls();
        $this->assertSame(0, count($apiRequestsEmpty));
        $operationsRequests = $operationsTransport->popReceivedCalls();
        $this->assertSame(1, count($operationsRequests));
        $actualOperationsFuncCall = $operationsRequests[0]->getFuncCall();
        $actualOperationsRequestObject = $operationsRequests[0]->getRequestObject();
        $this->assertSame('/google.longrunning.Operations/GetOperation', $actualOperationsFuncCall);
        $this->assertEquals($expectedOperationsRequestObject, $actualOperationsRequestObject);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function deleteEvaluationRunExceptionTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/deleteEvaluationRunTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $operationsTransport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_RUN]');
        $request = (new DeleteEvaluationRunRequest())
            ->setName($formattedName);
        $response = $gapicClient->deleteEvaluationRun($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/deleteEvaluationRunTest');
        try {
            $response->pollUntilComplete([
                'initialPollDelayMillis' => 1,
            ]);
            // If the pollUntilComplete() method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stubs are exhausted
        $transport->popReceivedCalls();
        $operationsTransport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function deleteScheduledEvaluationRunTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $expectedResponse = new GPBEmpty();
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->scheduledEvaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[SCHEDULED_EVALUATION_RUN]');
        $request = (new DeleteScheduledEvaluationRunRequest())
            ->setName($formattedName);
        $gapicClient->deleteScheduledEvaluationRun($request);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/DeleteScheduledEvaluationRun', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function deleteScheduledEvaluationRunExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->scheduledEvaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[SCHEDULED_EVALUATION_RUN]');
        $request = (new DeleteScheduledEvaluationRunRequest())
            ->setName($formattedName);
        try {
            $gapicClient->deleteScheduledEvaluationRun($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function generateEvaluationTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/generateEvaluationTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $invalid = false;
        $expectedResponse = new Evaluation();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setInvalid($invalid);
        $anyResponse = new Any();
        $anyResponse->setValue($expectedResponse->serializeToString());
        $completeOperation = new Operation();
        $completeOperation->setName('operations/generateEvaluationTest');
        $completeOperation->setDone(true);
        $completeOperation->setResponse($anyResponse);
        $operationsTransport->addResponse($completeOperation);
        // Mock request
        $formattedConversation = $gapicClient->conversationName('[PROJECT]', '[LOCATION]', '[APP]', '[CONVERSATION]');
        $request = (new GenerateEvaluationRequest())
            ->setConversation($formattedConversation);
        $response = $gapicClient->generateEvaluation($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $apiRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($apiRequests));
        $operationsRequestsEmpty = $operationsTransport->popReceivedCalls();
        $this->assertSame(0, count($operationsRequestsEmpty));
        $actualApiFuncCall = $apiRequests[0]->getFuncCall();
        $actualApiRequestObject = $apiRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/GenerateEvaluation', $actualApiFuncCall);
        $actualValue = $actualApiRequestObject->getConversation();
        $this->assertProtobufEquals($formattedConversation, $actualValue);
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/generateEvaluationTest');
        $response->pollUntilComplete([
            'initialPollDelayMillis' => 1,
        ]);
        $this->assertTrue($response->isDone());
        $this->assertEquals($expectedResponse, $response->getResult());
        $apiRequestsEmpty = $transport->popReceivedCalls();
        $this->assertSame(0, count($apiRequestsEmpty));
        $operationsRequests = $operationsTransport->popReceivedCalls();
        $this->assertSame(1, count($operationsRequests));
        $actualOperationsFuncCall = $operationsRequests[0]->getFuncCall();
        $actualOperationsRequestObject = $operationsRequests[0]->getRequestObject();
        $this->assertSame('/google.longrunning.Operations/GetOperation', $actualOperationsFuncCall);
        $this->assertEquals($expectedOperationsRequestObject, $actualOperationsRequestObject);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function generateEvaluationExceptionTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/generateEvaluationTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $operationsTransport->addResponse(null, $status);
        // Mock request
        $formattedConversation = $gapicClient->conversationName('[PROJECT]', '[LOCATION]', '[APP]', '[CONVERSATION]');
        $request = (new GenerateEvaluationRequest())
            ->setConversation($formattedConversation);
        $response = $gapicClient->generateEvaluation($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/generateEvaluationTest');
        try {
            $response->pollUntilComplete([
                'initialPollDelayMillis' => 1,
            ]);
            // If the pollUntilComplete() method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stubs are exhausted
        $transport->popReceivedCalls();
        $operationsTransport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function getEvaluationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name2 = 'name2-1052831874';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $invalid = false;
        $expectedResponse = new Evaluation();
        $expectedResponse->setName($name2);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setInvalid($invalid);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]');
        $request = (new GetEvaluationRequest())
            ->setName($formattedName);
        $response = $gapicClient->getEvaluation($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/GetEvaluation', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]');
        $request = (new GetEvaluationRequest())
            ->setName($formattedName);
        try {
            $gapicClient->getEvaluation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationDatasetTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name2 = 'name2-1052831874';
        $displayName = 'displayName1615086568';
        $etag = 'etag3123477';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $expectedResponse = new EvaluationDataset();
        $expectedResponse->setName($name2);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationDatasetName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_DATASET]');
        $request = (new GetEvaluationDatasetRequest())
            ->setName($formattedName);
        $response = $gapicClient->getEvaluationDataset($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/GetEvaluationDataset', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationDatasetExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationDatasetName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_DATASET]');
        $request = (new GetEvaluationDatasetRequest())
            ->setName($formattedName);
        try {
            $gapicClient->getEvaluationDataset($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationExpectationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name2 = 'name2-1052831874';
        $displayName = 'displayName1615086568';
        $etag = 'etag3123477';
        $expectedResponse = new EvaluationExpectation();
        $expectedResponse->setName($name2);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setEtag($etag);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationExpectationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_EXPECTATION]');
        $request = (new GetEvaluationExpectationRequest())
            ->setName($formattedName);
        $response = $gapicClient->getEvaluationExpectation($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/GetEvaluationExpectation', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationExpectationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationExpectationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_EXPECTATION]');
        $request = (new GetEvaluationExpectationRequest())
            ->setName($formattedName);
        try {
            $gapicClient->getEvaluationExpectation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationResultTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name2 = 'name2-1052831874';
        $displayName = 'displayName1615086568';
        $evaluationRun = 'evaluationRun592114440';
        $initiatedBy = 'initiatedBy-175406037';
        $appVersion = 'appVersion-901870406';
        $appVersionDisplayName = 'appVersionDisplayName-1832050867';
        $changelog = 'changelog1455272340';
        $expectedResponse = new EvaluationResult();
        $expectedResponse->setName($name2);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setEvaluationRun($evaluationRun);
        $expectedResponse->setInitiatedBy($initiatedBy);
        $expectedResponse->setAppVersion($appVersion);
        $expectedResponse->setAppVersionDisplayName($appVersionDisplayName);
        $expectedResponse->setChangelog($changelog);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationResultName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]', '[EVALUATION_RESULT]');
        $request = (new GetEvaluationResultRequest())
            ->setName($formattedName);
        $response = $gapicClient->getEvaluationResult($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/GetEvaluationResult', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationResultExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationResultName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]', '[EVALUATION_RESULT]');
        $request = (new GetEvaluationResultRequest())
            ->setName($formattedName);
        try {
            $gapicClient->getEvaluationResult($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationRunTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name2 = 'name2-1052831874';
        $displayName = 'displayName1615086568';
        $initiatedBy = 'initiatedBy-175406037';
        $appVersion = 'appVersion-901870406';
        $appVersionDisplayName = 'appVersionDisplayName-1832050867';
        $changelog = 'changelog1455272340';
        $evaluationDataset = 'evaluationDataset-925604235';
        $runCount = 485221797;
        $scheduledEvaluationRun = 'scheduledEvaluationRun1474728154';
        $expectedResponse = new EvaluationRun();
        $expectedResponse->setName($name2);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setInitiatedBy($initiatedBy);
        $expectedResponse->setAppVersion($appVersion);
        $expectedResponse->setAppVersionDisplayName($appVersionDisplayName);
        $expectedResponse->setChangelog($changelog);
        $expectedResponse->setEvaluationDataset($evaluationDataset);
        $expectedResponse->setRunCount($runCount);
        $expectedResponse->setScheduledEvaluationRun($scheduledEvaluationRun);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->evaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_RUN]');
        $request = (new GetEvaluationRunRequest())
            ->setName($formattedName);
        $response = $gapicClient->getEvaluationRun($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/GetEvaluationRun', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getEvaluationRunExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->evaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION_RUN]');
        $request = (new GetEvaluationRunRequest())
            ->setName($formattedName);
        try {
            $gapicClient->getEvaluationRun($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getScheduledEvaluationRunTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name2 = 'name2-1052831874';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $active = true;
        $lastCompletedRun = 'lastCompletedRun1718413486';
        $totalExecutions = 2074550218;
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $expectedResponse = new ScheduledEvaluationRun();
        $expectedResponse->setName($name2);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setActive($active);
        $expectedResponse->setLastCompletedRun($lastCompletedRun);
        $expectedResponse->setTotalExecutions($totalExecutions);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedName = $gapicClient->scheduledEvaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[SCHEDULED_EVALUATION_RUN]');
        $request = (new GetScheduledEvaluationRunRequest())
            ->setName($formattedName);
        $response = $gapicClient->getScheduledEvaluationRun($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/GetScheduledEvaluationRun', $actualFuncCall);
        $actualValue = $actualRequestObject->getName();
        $this->assertProtobufEquals($formattedName, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getScheduledEvaluationRunExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedName = $gapicClient->scheduledEvaluationRunName('[PROJECT]', '[LOCATION]', '[APP]', '[SCHEDULED_EVALUATION_RUN]');
        $request = (new GetScheduledEvaluationRunRequest())
            ->setName($formattedName);
        try {
            $gapicClient->getScheduledEvaluationRun($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function importEvaluationsTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/importEvaluationsTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $importFailureCount = 663262976;
        $expectedResponse = new ImportEvaluationsResponse();
        $expectedResponse->setImportFailureCount($importFailureCount);
        $anyResponse = new Any();
        $anyResponse->setValue($expectedResponse->serializeToString());
        $completeOperation = new Operation();
        $completeOperation->setName('operations/importEvaluationsTest');
        $completeOperation->setDone(true);
        $completeOperation->setResponse($anyResponse);
        $operationsTransport->addResponse($completeOperation);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ImportEvaluationsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->importEvaluations($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $apiRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($apiRequests));
        $operationsRequestsEmpty = $operationsTransport->popReceivedCalls();
        $this->assertSame(0, count($operationsRequestsEmpty));
        $actualApiFuncCall = $apiRequests[0]->getFuncCall();
        $actualApiRequestObject = $apiRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/ImportEvaluations', $actualApiFuncCall);
        $actualValue = $actualApiRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/importEvaluationsTest');
        $response->pollUntilComplete([
            'initialPollDelayMillis' => 1,
        ]);
        $this->assertTrue($response->isDone());
        $this->assertEquals($expectedResponse, $response->getResult());
        $apiRequestsEmpty = $transport->popReceivedCalls();
        $this->assertSame(0, count($apiRequestsEmpty));
        $operationsRequests = $operationsTransport->popReceivedCalls();
        $this->assertSame(1, count($operationsRequests));
        $actualOperationsFuncCall = $operationsRequests[0]->getFuncCall();
        $actualOperationsRequestObject = $operationsRequests[0]->getRequestObject();
        $this->assertSame('/google.longrunning.Operations/GetOperation', $actualOperationsFuncCall);
        $this->assertEquals($expectedOperationsRequestObject, $actualOperationsRequestObject);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function importEvaluationsExceptionTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/importEvaluationsTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $operationsTransport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ImportEvaluationsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->importEvaluations($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/importEvaluationsTest');
        try {
            $response->pollUntilComplete([
                'initialPollDelayMillis' => 1,
            ]);
            // If the pollUntilComplete() method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stubs are exhausted
        $transport->popReceivedCalls();
        $operationsTransport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function listEvaluationDatasetsTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $nextPageToken = '';
        $evaluationDatasetsElement = new EvaluationDataset();
        $evaluationDatasets = [
            $evaluationDatasetsElement,
        ];
        $expectedResponse = new ListEvaluationDatasetsResponse();
        $expectedResponse->setNextPageToken($nextPageToken);
        $expectedResponse->setEvaluationDatasets($evaluationDatasets);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationDatasetsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->listEvaluationDatasets($request);
        $this->assertEquals($expectedResponse, $response->getPage()->getResponseObject());
        $resources = iterator_to_array($response->iterateAllElements());
        $this->assertSame(1, count($resources));
        $this->assertEquals($expectedResponse->getEvaluationDatasets()[0], $resources[0]);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/ListEvaluationDatasets', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationDatasetsExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationDatasetsRequest())
            ->setParent($formattedParent);
        try {
            $gapicClient->listEvaluationDatasets($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationExpectationsTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $nextPageToken = '';
        $evaluationExpectationsElement = new EvaluationExpectation();
        $evaluationExpectations = [
            $evaluationExpectationsElement,
        ];
        $expectedResponse = new ListEvaluationExpectationsResponse();
        $expectedResponse->setNextPageToken($nextPageToken);
        $expectedResponse->setEvaluationExpectations($evaluationExpectations);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationExpectationsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->listEvaluationExpectations($request);
        $this->assertEquals($expectedResponse, $response->getPage()->getResponseObject());
        $resources = iterator_to_array($response->iterateAllElements());
        $this->assertSame(1, count($resources));
        $this->assertEquals($expectedResponse->getEvaluationExpectations()[0], $resources[0]);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/ListEvaluationExpectations', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationExpectationsExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationExpectationsRequest())
            ->setParent($formattedParent);
        try {
            $gapicClient->listEvaluationExpectations($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationResultsTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $nextPageToken = '';
        $evaluationResultsElement = new EvaluationResult();
        $evaluationResults = [
            $evaluationResultsElement,
        ];
        $expectedResponse = new ListEvaluationResultsResponse();
        $expectedResponse->setNextPageToken($nextPageToken);
        $expectedResponse->setEvaluationResults($evaluationResults);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->evaluationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]');
        $request = (new ListEvaluationResultsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->listEvaluationResults($request);
        $this->assertEquals($expectedResponse, $response->getPage()->getResponseObject());
        $resources = iterator_to_array($response->iterateAllElements());
        $this->assertSame(1, count($resources));
        $this->assertEquals($expectedResponse->getEvaluationResults()[0], $resources[0]);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/ListEvaluationResults', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationResultsExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->evaluationName('[PROJECT]', '[LOCATION]', '[APP]', '[EVALUATION]');
        $request = (new ListEvaluationResultsRequest())
            ->setParent($formattedParent);
        try {
            $gapicClient->listEvaluationResults($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationRunsTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $nextPageToken = '';
        $evaluationRunsElement = new EvaluationRun();
        $evaluationRuns = [
            $evaluationRunsElement,
        ];
        $expectedResponse = new ListEvaluationRunsResponse();
        $expectedResponse->setNextPageToken($nextPageToken);
        $expectedResponse->setEvaluationRuns($evaluationRuns);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationRunsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->listEvaluationRuns($request);
        $this->assertEquals($expectedResponse, $response->getPage()->getResponseObject());
        $resources = iterator_to_array($response->iterateAllElements());
        $this->assertSame(1, count($resources));
        $this->assertEquals($expectedResponse->getEvaluationRuns()[0], $resources[0]);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/ListEvaluationRuns', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationRunsExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationRunsRequest())
            ->setParent($formattedParent);
        try {
            $gapicClient->listEvaluationRuns($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationsTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $nextPageToken = '';
        $evaluationsElement = new Evaluation();
        $evaluations = [
            $evaluationsElement,
        ];
        $expectedResponse = new ListEvaluationsResponse();
        $expectedResponse->setNextPageToken($nextPageToken);
        $expectedResponse->setEvaluations($evaluations);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->listEvaluations($request);
        $this->assertEquals($expectedResponse, $response->getPage()->getResponseObject());
        $resources = iterator_to_array($response->iterateAllElements());
        $this->assertSame(1, count($resources));
        $this->assertEquals($expectedResponse->getEvaluations()[0], $resources[0]);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/ListEvaluations', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listEvaluationsExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListEvaluationsRequest())
            ->setParent($formattedParent);
        try {
            $gapicClient->listEvaluations($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listScheduledEvaluationRunsTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $nextPageToken = '';
        $scheduledEvaluationRunsElement = new ScheduledEvaluationRun();
        $scheduledEvaluationRuns = [
            $scheduledEvaluationRunsElement,
        ];
        $expectedResponse = new ListScheduledEvaluationRunsResponse();
        $expectedResponse->setNextPageToken($nextPageToken);
        $expectedResponse->setScheduledEvaluationRuns($scheduledEvaluationRuns);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListScheduledEvaluationRunsRequest())
            ->setParent($formattedParent);
        $response = $gapicClient->listScheduledEvaluationRuns($request);
        $this->assertEquals($expectedResponse, $response->getPage()->getResponseObject());
        $resources = iterator_to_array($response->iterateAllElements());
        $this->assertSame(1, count($resources));
        $this->assertEquals($expectedResponse->getScheduledEvaluationRuns()[0], $resources[0]);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/ListScheduledEvaluationRuns', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listScheduledEvaluationRunsExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new ListScheduledEvaluationRunsRequest())
            ->setParent($formattedParent);
        try {
            $gapicClient->listScheduledEvaluationRuns($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function runEvaluationTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/runEvaluationTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $evaluationRun = 'evaluationRun592114440';
        $expectedResponse = new RunEvaluationResponse();
        $expectedResponse->setEvaluationRun($evaluationRun);
        $anyResponse = new Any();
        $anyResponse->setValue($expectedResponse->serializeToString());
        $completeOperation = new Operation();
        $completeOperation->setName('operations/runEvaluationTest');
        $completeOperation->setDone(true);
        $completeOperation->setResponse($anyResponse);
        $operationsTransport->addResponse($completeOperation);
        // Mock request
        $formattedApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new RunEvaluationRequest())
            ->setApp($formattedApp);
        $response = $gapicClient->runEvaluation($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $apiRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($apiRequests));
        $operationsRequestsEmpty = $operationsTransport->popReceivedCalls();
        $this->assertSame(0, count($operationsRequestsEmpty));
        $actualApiFuncCall = $apiRequests[0]->getFuncCall();
        $actualApiRequestObject = $apiRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/RunEvaluation', $actualApiFuncCall);
        $actualValue = $actualApiRequestObject->getApp();
        $this->assertProtobufEquals($formattedApp, $actualValue);
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/runEvaluationTest');
        $response->pollUntilComplete([
            'initialPollDelayMillis' => 1,
        ]);
        $this->assertTrue($response->isDone());
        $this->assertEquals($expectedResponse, $response->getResult());
        $apiRequestsEmpty = $transport->popReceivedCalls();
        $this->assertSame(0, count($apiRequestsEmpty));
        $operationsRequests = $operationsTransport->popReceivedCalls();
        $this->assertSame(1, count($operationsRequests));
        $actualOperationsFuncCall = $operationsRequests[0]->getFuncCall();
        $actualOperationsRequestObject = $operationsRequests[0]->getRequestObject();
        $this->assertSame('/google.longrunning.Operations/GetOperation', $actualOperationsFuncCall);
        $this->assertEquals($expectedOperationsRequestObject, $actualOperationsRequestObject);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function runEvaluationExceptionTest()
    {
        $operationsTransport = $this->createTransport();
        $operationsClient = new OperationsClient([
            'apiEndpoint' => '',
            'transport' => $operationsTransport,
            'credentials' => $this->createCredentials(),
        ]);
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
            'operationsClient' => $operationsClient,
        ]);
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
        // Mock response
        $incompleteOperation = new Operation();
        $incompleteOperation->setName('operations/runEvaluationTest');
        $incompleteOperation->setDone(false);
        $transport->addResponse($incompleteOperation);
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $operationsTransport->addResponse(null, $status);
        // Mock request
        $formattedApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $request = (new RunEvaluationRequest())
            ->setApp($formattedApp);
        $response = $gapicClient->runEvaluation($request);
        $this->assertFalse($response->isDone());
        $this->assertNull($response->getResult());
        $expectedOperationsRequestObject = new GetOperationRequest();
        $expectedOperationsRequestObject->setName('operations/runEvaluationTest');
        try {
            $response->pollUntilComplete([
                'initialPollDelayMillis' => 1,
            ]);
            // If the pollUntilComplete() method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stubs are exhausted
        $transport->popReceivedCalls();
        $operationsTransport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
        $this->assertTrue($operationsTransport->isExhausted());
    }

    /** @test */
    public function testPersonaVoiceTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $audio = '-42';
        $expectedResponse = new TestPersonaVoiceResponse();
        $expectedResponse->setAudio($audio);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $personaId = 'personaId679047822';
        $text = 'text3556653';
        $request = (new TestPersonaVoiceRequest())
            ->setApp($formattedApp)
            ->setPersonaId($personaId)
            ->setText($text);
        $response = $gapicClient->testPersonaVoice($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/TestPersonaVoice', $actualFuncCall);
        $actualValue = $actualRequestObject->getApp();
        $this->assertProtobufEquals($formattedApp, $actualValue);
        $actualValue = $actualRequestObject->getPersonaId();
        $this->assertProtobufEquals($personaId, $actualValue);
        $actualValue = $actualRequestObject->getText();
        $this->assertProtobufEquals($text, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function testPersonaVoiceExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $formattedApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $personaId = 'personaId679047822';
        $text = 'text3556653';
        $request = (new TestPersonaVoiceRequest())
            ->setApp($formattedApp)
            ->setPersonaId($personaId)
            ->setText($text);
        try {
            $gapicClient->testPersonaVoice($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateEvaluationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $invalid = false;
        $expectedResponse = new Evaluation();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setInvalid($invalid);
        $transport->addResponse($expectedResponse);
        // Mock request
        $evaluation = new Evaluation();
        $evaluationDisplayName = 'evaluationDisplayName-871245423';
        $evaluation->setDisplayName($evaluationDisplayName);
        $request = (new UpdateEvaluationRequest())
            ->setEvaluation($evaluation);
        $response = $gapicClient->updateEvaluation($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/UpdateEvaluation', $actualFuncCall);
        $actualValue = $actualRequestObject->getEvaluation();
        $this->assertProtobufEquals($evaluation, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateEvaluationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $evaluation = new Evaluation();
        $evaluationDisplayName = 'evaluationDisplayName-871245423';
        $evaluation->setDisplayName($evaluationDisplayName);
        $request = (new UpdateEvaluationRequest())
            ->setEvaluation($evaluation);
        try {
            $gapicClient->updateEvaluation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateEvaluationDatasetTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $etag = 'etag3123477';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $expectedResponse = new EvaluationDataset();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $transport->addResponse($expectedResponse);
        // Mock request
        $evaluationDataset = new EvaluationDataset();
        $evaluationDatasetDisplayName = 'evaluationDatasetDisplayName-58213583';
        $evaluationDataset->setDisplayName($evaluationDatasetDisplayName);
        $request = (new UpdateEvaluationDatasetRequest())
            ->setEvaluationDataset($evaluationDataset);
        $response = $gapicClient->updateEvaluationDataset($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/UpdateEvaluationDataset', $actualFuncCall);
        $actualValue = $actualRequestObject->getEvaluationDataset();
        $this->assertProtobufEquals($evaluationDataset, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateEvaluationDatasetExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $evaluationDataset = new EvaluationDataset();
        $evaluationDatasetDisplayName = 'evaluationDatasetDisplayName-58213583';
        $evaluationDataset->setDisplayName($evaluationDatasetDisplayName);
        $request = (new UpdateEvaluationDatasetRequest())
            ->setEvaluationDataset($evaluationDataset);
        try {
            $gapicClient->updateEvaluationDataset($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateEvaluationExpectationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $etag = 'etag3123477';
        $expectedResponse = new EvaluationExpectation();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setEtag($etag);
        $transport->addResponse($expectedResponse);
        // Mock request
        $evaluationExpectation = new EvaluationExpectation();
        $evaluationExpectationDisplayName = 'evaluationExpectationDisplayName-1786265363';
        $evaluationExpectation->setDisplayName($evaluationExpectationDisplayName);
        $request = (new UpdateEvaluationExpectationRequest())
            ->setEvaluationExpectation($evaluationExpectation);
        $response = $gapicClient->updateEvaluationExpectation($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/UpdateEvaluationExpectation', $actualFuncCall);
        $actualValue = $actualRequestObject->getEvaluationExpectation();
        $this->assertProtobufEquals($evaluationExpectation, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateEvaluationExpectationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $evaluationExpectation = new EvaluationExpectation();
        $evaluationExpectationDisplayName = 'evaluationExpectationDisplayName-1786265363';
        $evaluationExpectation->setDisplayName($evaluationExpectationDisplayName);
        $request = (new UpdateEvaluationExpectationRequest())
            ->setEvaluationExpectation($evaluationExpectation);
        try {
            $gapicClient->updateEvaluationExpectation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateScheduledEvaluationRunTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $active = true;
        $lastCompletedRun = 'lastCompletedRun1718413486';
        $totalExecutions = 2074550218;
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $expectedResponse = new ScheduledEvaluationRun();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setActive($active);
        $expectedResponse->setLastCompletedRun($lastCompletedRun);
        $expectedResponse->setTotalExecutions($totalExecutions);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $transport->addResponse($expectedResponse);
        // Mock request
        $scheduledEvaluationRun = new ScheduledEvaluationRun();
        $scheduledEvaluationRunDisplayName = 'scheduledEvaluationRunDisplayName-336218357';
        $scheduledEvaluationRun->setDisplayName($scheduledEvaluationRunDisplayName);
        $scheduledEvaluationRunRequest = new RunEvaluationRequest();
        $requestApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $scheduledEvaluationRunRequest->setApp($requestApp);
        $scheduledEvaluationRun->setRequest($scheduledEvaluationRunRequest);
        $scheduledEvaluationRunSchedulingConfig = new SchedulingConfig();
        $schedulingConfigFrequency = Frequency::FREQUENCY_UNSPECIFIED;
        $scheduledEvaluationRunSchedulingConfig->setFrequency($schedulingConfigFrequency);
        $schedulingConfigStartTime = new Timestamp();
        $scheduledEvaluationRunSchedulingConfig->setStartTime($schedulingConfigStartTime);
        $scheduledEvaluationRun->setSchedulingConfig($scheduledEvaluationRunSchedulingConfig);
        $request = (new UpdateScheduledEvaluationRunRequest())
            ->setScheduledEvaluationRun($scheduledEvaluationRun);
        $response = $gapicClient->updateScheduledEvaluationRun($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/UpdateScheduledEvaluationRun', $actualFuncCall);
        $actualValue = $actualRequestObject->getScheduledEvaluationRun();
        $this->assertProtobufEquals($scheduledEvaluationRun, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function updateScheduledEvaluationRunExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        // Mock request
        $scheduledEvaluationRun = new ScheduledEvaluationRun();
        $scheduledEvaluationRunDisplayName = 'scheduledEvaluationRunDisplayName-336218357';
        $scheduledEvaluationRun->setDisplayName($scheduledEvaluationRunDisplayName);
        $scheduledEvaluationRunRequest = new RunEvaluationRequest();
        $requestApp = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $scheduledEvaluationRunRequest->setApp($requestApp);
        $scheduledEvaluationRun->setRequest($scheduledEvaluationRunRequest);
        $scheduledEvaluationRunSchedulingConfig = new SchedulingConfig();
        $schedulingConfigFrequency = Frequency::FREQUENCY_UNSPECIFIED;
        $scheduledEvaluationRunSchedulingConfig->setFrequency($schedulingConfigFrequency);
        $schedulingConfigStartTime = new Timestamp();
        $scheduledEvaluationRunSchedulingConfig->setStartTime($schedulingConfigStartTime);
        $scheduledEvaluationRun->setSchedulingConfig($scheduledEvaluationRunSchedulingConfig);
        $request = (new UpdateScheduledEvaluationRunRequest())
            ->setScheduledEvaluationRun($scheduledEvaluationRun);
        try {
            $gapicClient->updateScheduledEvaluationRun($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getLocationTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name2 = 'name2-1052831874';
        $locationId = 'locationId552319461';
        $displayName = 'displayName1615086568';
        $expectedResponse = new Location();
        $expectedResponse->setName($name2);
        $expectedResponse->setLocationId($locationId);
        $expectedResponse->setDisplayName($displayName);
        $transport->addResponse($expectedResponse);
        $request = new GetLocationRequest();
        $response = $gapicClient->getLocation($request);
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.location.Locations/GetLocation', $actualFuncCall);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function getLocationExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        $request = new GetLocationRequest();
        try {
            $gapicClient->getLocation($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listLocationsTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $nextPageToken = '';
        $locationsElement = new Location();
        $locations = [
            $locationsElement,
        ];
        $expectedResponse = new ListLocationsResponse();
        $expectedResponse->setNextPageToken($nextPageToken);
        $expectedResponse->setLocations($locations);
        $transport->addResponse($expectedResponse);
        $request = new ListLocationsRequest();
        $response = $gapicClient->listLocations($request);
        $this->assertEquals($expectedResponse, $response->getPage()->getResponseObject());
        $resources = iterator_to_array($response->iterateAllElements());
        $this->assertSame(1, count($resources));
        $this->assertEquals($expectedResponse->getLocations()[0], $resources[0]);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.location.Locations/ListLocations', $actualFuncCall);
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function listLocationsExceptionTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        $status = new stdClass();
        $status->code = Code::DATA_LOSS;
        $status->details = 'internal error';
        $expectedExceptionMessage  = json_encode([
            'message' => 'internal error',
            'code' => Code::DATA_LOSS,
            'status' => 'DATA_LOSS',
            'details' => [],
        ], JSON_PRETTY_PRINT);
        $transport->addResponse(null, $status);
        $request = new ListLocationsRequest();
        try {
            $gapicClient->listLocations($request);
            // If the $gapicClient method call did not throw, fail the test
            $this->fail('Expected an ApiException, but no exception was thrown.');
        } catch (ApiException $ex) {
            $this->assertEquals($status->code, $ex->getCode());
            $this->assertEquals($expectedExceptionMessage, $ex->getMessage());
        }
        // Call popReceivedCalls to ensure the stub is exhausted
        $transport->popReceivedCalls();
        $this->assertTrue($transport->isExhausted());
    }

    /** @test */
    public function createEvaluationAsyncTest()
    {
        $transport = $this->createTransport();
        $gapicClient = $this->createClient([
            'transport' => $transport,
        ]);
        $this->assertTrue($transport->isExhausted());
        // Mock response
        $name = 'name3373707';
        $displayName = 'displayName1615086568';
        $description = 'description-1724546052';
        $createdBy = 'createdBy1369680142';
        $lastUpdatedBy = 'lastUpdatedBy1312226212';
        $etag = 'etag3123477';
        $invalid = false;
        $expectedResponse = new Evaluation();
        $expectedResponse->setName($name);
        $expectedResponse->setDisplayName($displayName);
        $expectedResponse->setDescription($description);
        $expectedResponse->setCreatedBy($createdBy);
        $expectedResponse->setLastUpdatedBy($lastUpdatedBy);
        $expectedResponse->setEtag($etag);
        $expectedResponse->setInvalid($invalid);
        $transport->addResponse($expectedResponse);
        // Mock request
        $formattedParent = $gapicClient->appName('[PROJECT]', '[LOCATION]', '[APP]');
        $evaluation = new Evaluation();
        $evaluationDisplayName = 'evaluationDisplayName-871245423';
        $evaluation->setDisplayName($evaluationDisplayName);
        $request = (new CreateEvaluationRequest())
            ->setParent($formattedParent)
            ->setEvaluation($evaluation);
        $response = $gapicClient->createEvaluationAsync($request)->wait();
        $this->assertEquals($expectedResponse, $response);
        $actualRequests = $transport->popReceivedCalls();
        $this->assertSame(1, count($actualRequests));
        $actualFuncCall = $actualRequests[0]->getFuncCall();
        $actualRequestObject = $actualRequests[0]->getRequestObject();
        $this->assertSame('/google.cloud.ces.v1beta.EvaluationService/CreateEvaluation', $actualFuncCall);
        $actualValue = $actualRequestObject->getParent();
        $this->assertProtobufEquals($formattedParent, $actualValue);
        $actualValue = $actualRequestObject->getEvaluation();
        $this->assertProtobufEquals($evaluation, $actualValue);
        $this->assertTrue($transport->isExhausted());
    }
}
