# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        module AgentService
          # Path helper methods for the AgentService API.
          module Paths
            ##
            # Create a fully-qualified Agent resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param agent [String]
            #
            # @return [::String]
            def agent_path project:, location:, app:, agent:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/agents/#{agent}"
            end

            ##
            # Create a fully-qualified App resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            #
            # @return [::String]
            def app_path project:, location:, app:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}"
            end

            ##
            # Create a fully-qualified AppVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param version [String]
            #
            # @return [::String]
            def app_version_path project:, location:, app:, version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/versions/#{version}"
            end

            ##
            # Create a fully-qualified Changelog resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param changelog [String]
            #
            # @return [::String]
            def changelog_path project:, location:, app:, changelog:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/changelogs/#{changelog}"
            end

            ##
            # Create a fully-qualified Conversation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param conversation [String]
            #
            # @return [::String]
            def conversation_path project:, location:, app:, conversation:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/conversations/#{conversation}"
            end

            ##
            # Create a fully-qualified DeidentifyTemplate resource string.
            #
            # @overload deidentify_template_path(organization:, location:, deidentify_template:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/deidentifyTemplates/{deidentify_template}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param deidentify_template [String]
            #
            # @overload deidentify_template_path(project:, location:, deidentify_template:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param deidentify_template [String]
            #
            # @return [::String]
            def deidentify_template_path **args
              resources = {
                "deidentify_template:location:organization" => (proc do |organization:, location:, deidentify_template:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/deidentifyTemplates/#{deidentify_template}"
                end),
                "deidentify_template:location:project" => (proc do |project:, location:, deidentify_template:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/deidentifyTemplates/#{deidentify_template}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Deployment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param deployment [String]
            #
            # @return [::String]
            def deployment_path project:, location:, app:, deployment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/deployments/#{deployment}"
            end

            ##
            # Create a fully-qualified DialogflowAgent resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/agents/{agent}`
            #
            # @param project [String]
            # @param location [String]
            # @param agent [String]
            #
            # @return [::String]
            def dialogflow_agent_path project:, location:, agent:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/agents/#{agent}"
            end

            ##
            # Create a fully-qualified Engine resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
            #
            # @param project [String]
            # @param location [String]
            # @param collection [String]
            # @param engine [String]
            #
            # @return [::String]
            def engine_path project:, location:, collection:, engine:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"

              "projects/#{project}/locations/#{location}/collections/#{collection}/engines/#{engine}"
            end

            ##
            # Create a fully-qualified Example resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/examples/{example}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param example [String]
            #
            # @return [::String]
            def example_path project:, location:, app:, example:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/examples/#{example}"
            end

            ##
            # Create a fully-qualified Guardrail resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param guardrail [String]
            #
            # @return [::String]
            def guardrail_path project:, location:, app:, guardrail:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/guardrails/#{guardrail}"
            end

            ##
            # Create a fully-qualified InspectTemplate resource string.
            #
            # @overload inspect_template_path(organization:, location:, inspect_template:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/inspectTemplates/{inspect_template}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param inspect_template [String]
            #
            # @overload inspect_template_path(project:, location:, inspect_template:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/inspectTemplates/{inspect_template}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param inspect_template [String]
            #
            # @return [::String]
            def inspect_template_path **args
              resources = {
                "inspect_template:location:organization" => (proc do |organization:, location:, inspect_template:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/inspectTemplates/#{inspect_template}"
                end),
                "inspect_template:location:project" => (proc do |project:, location:, inspect_template:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/inspectTemplates/#{inspect_template}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/secrets/{secret}/versions/{secret_version}`
            #
            # @param project [String]
            # @param secret [String]
            # @param secret_version [String]
            #
            # @return [::String]
            def secret_version_path project:, secret:, secret_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

              "projects/#{project}/secrets/#{secret}/versions/#{secret_version}"
            end

            ##
            # Create a fully-qualified Service resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}`
            #
            # @param project [String]
            # @param location [String]
            # @param namespace [String]
            # @param service [String]
            #
            # @return [::String]
            def service_path project:, location:, namespace:, service:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "namespace cannot contain /" if namespace.to_s.include? "/"

              "projects/#{project}/locations/#{location}/namespaces/#{namespace}/services/#{service}"
            end

            ##
            # Create a fully-qualified Tool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param tool [String]
            #
            # @return [::String]
            def tool_path project:, location:, app:, tool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/tools/#{tool}"
            end

            ##
            # Create a fully-qualified Toolset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param toolset [String]
            #
            # @return [::String]
            def toolset_path project:, location:, app:, toolset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/toolsets/#{toolset}"
            end

            extend self
          end
        end
      end
    end
  end
end
