# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/ces/v1beta/agent_service_pb"
require "google/cloud/ces/v1beta/agent_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Ces
      module V1beta
        module AgentService
          module Rest
            ##
            # REST client for the AgentService service.
            #
            # The service that manages agent-related resources in Gemini Enterprise for
            # Customer Engagement (CES).
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "ces.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :agent_service_stub

              ##
              # Configure the AgentService Client class.
              #
              # See {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AgentService clients
              #   ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Ces", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AgentService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @agent_service_stub.universe_domain
              end

              ##
              # Create a new AgentService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AgentService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @agent_service_stub = ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @agent_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @agent_service_stub.endpoint
                  config.universe_domain = @agent_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @agent_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Ces::V1beta::AgentService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @agent_service_stub.logger
              end

              # Service calls

              ##
              # Lists apps in the given project and location.
              #
              # @overload list_apps(request, options = nil)
              #   Pass arguments to `list_apps` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListAppsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListAppsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_apps(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_apps` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location to list apps from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListAppsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_apps AgentService.ListApps}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the apps.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::App>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::App>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListAppsRequest.new
              #
              #   # Call the list_apps method.
              #   result = client.list_apps request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::App.
              #     p item
              #   end
              #
              def list_apps request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListAppsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_apps.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_apps.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_apps.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_apps request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_apps, "apps", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified app.
              #
              # @overload get_app(request, options = nil)
              #   Pass arguments to `get_app` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetAppRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetAppRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_app(name: nil)
              #   Pass arguments to `get_app` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the app to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::App]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::App]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetAppRequest.new
              #
              #   # Call the get_app method.
              #   result = client.get_app request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::App.
              #   p result
              #
              def get_app request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetAppRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_app.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_app.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_app.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_app request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new app in the given project and location.
              #
              # @overload create_app(request, options = nil)
              #   Pass arguments to `create_app` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateAppRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateAppRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_app(parent: nil, app_id: nil, app: nil)
              #   Pass arguments to `create_app` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the location to create an app in.
              #   @param app_id [::String]
              #     Optional. The ID to use for the app, which will become the final component
              #     of the app's resource name. If not provided, a unique ID will be
              #     automatically assigned for the app.
              #   @param app [::Google::Cloud::Ces::V1beta::App, ::Hash]
              #     Required. The app to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateAppRequest.new
              #
              #   # Call the create_app method.
              #   result = client.create_app request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_app request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateAppRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_app.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_app.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_app.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_app request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified app.
              #
              # @overload update_app(request, options = nil)
              #   Pass arguments to `update_app` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateAppRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateAppRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_app(app: nil, update_mask: nil)
              #   Pass arguments to `update_app` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param app [::Google::Cloud::Ces::V1beta::App, ::Hash]
              #     Required. The app to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::App]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::App]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateAppRequest.new
              #
              #   # Call the update_app method.
              #   result = client.update_app request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::App.
              #   p result
              #
              def update_app request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateAppRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_app.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_app.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_app.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.update_app request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified app.
              #
              # @overload delete_app(request, options = nil)
              #   Pass arguments to `delete_app` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteAppRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteAppRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_app(name: nil, etag: nil)
              #   Pass arguments to `delete_app` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the app to delete.
              #   @param etag [::String]
              #     Optional. The current etag of the app. If an etag is not provided, the
              #     deletion will overwrite any concurrent changes. If an etag is provided and
              #     does not match the current etag of the app, deletion will be blocked and an
              #     ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteAppRequest.new
              #
              #   # Call the delete_app method.
              #   result = client.delete_app request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_app request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteAppRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_app.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_app.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_app.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_app request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports the specified app.
              #
              # @overload export_app(request, options = nil)
              #   Pass arguments to `export_app` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ExportAppRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ExportAppRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_app(name: nil, export_format: nil, gcs_uri: nil)
              #   Pass arguments to `export_app` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the app to export.
              #   @param export_format [::Google::Cloud::Ces::V1beta::ExportAppRequest::ExportFormat]
              #     Required. The format to export the app in.
              #   @param gcs_uri [::String]
              #     Optional. The [Google Cloud
              #     Storage](https://cloud.google.com/storage/docs/) URI to which to export the
              #     app. The format of this URI must be `gs://<bucket-name>/<object-name>`. The
              #     exported app archive will be written directly to the specified GCS object.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ExportAppRequest.new
              #
              #   # Call the export_app method.
              #   result = client.export_app request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_app request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ExportAppRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_app.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_app.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_app.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.export_app request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports the specified app.
              #
              # @overload import_app(request, options = nil)
              #   Pass arguments to `import_app` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ImportAppRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ImportAppRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_app(gcs_uri: nil, app_content: nil, parent: nil, display_name: nil, app_id: nil, import_options: nil)
              #   Pass arguments to `import_app` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_uri [::String]
              #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
              #     from which to import app. The format of this URI must be
              #     `gs://<bucket-name>/<object-name>`.
              #
              #     Note: The following parameters are mutually exclusive: `gcs_uri`, `app_content`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param app_content [::String]
              #     Raw bytes representing the compressed zip file with the app folder
              #     structure.
              #
              #     Note: The following parameters are mutually exclusive: `app_content`, `gcs_uri`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The parent resource name with the location of the app to import.
              #   @param display_name [::String]
              #     Optional. The display name of the app to import.
              #     * If the app is created on import, and the display name is specified,
              #     the imported app will use this display name. If a conflict is detected
              #     with an existing app, a timestamp will be appended to the display name
              #     to make it unique.
              #     * If the app is a reimport, this field should not be set. Providing a
              #     display name during reimport will result in an INVALID_ARGUMENT error.
              #   @param app_id [::String]
              #     Optional. The ID to use for the imported app.
              #     *  If not specified, a unique ID will be automatically assigned for
              #     the app.
              #     *  Otherwise, the imported app will use this ID as the final component of
              #     its resource name. If an app with the same ID already exists at the
              #     specified location in the project, the content of the existing app will be
              #     replaced.
              #   @param import_options [::Google::Cloud::Ces::V1beta::ImportAppRequest::ImportOptions, ::Hash]
              #     Optional. Options governing the import process for the app.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ImportAppRequest.new
              #
              #   # Call the import_app method.
              #   result = client.import_app request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_app request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ImportAppRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_app.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_app.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_app.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.import_app request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists agents in the given app.
              #
              # @overload list_agents(request, options = nil)
              #   Pass arguments to `list_agents` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListAgentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListAgentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_agents(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_agents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list agents from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListAgentsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_agents AgentService.ListAgents}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the agents.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Agent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Agent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListAgentsRequest.new
              #
              #   # Call the list_agents method.
              #   result = client.list_agents request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Agent.
              #     p item
              #   end
              #
              def list_agents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListAgentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_agents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_agents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_agents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_agents request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_agents, "agents", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified agent.
              #
              # @overload get_agent(request, options = nil)
              #   Pass arguments to `get_agent` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_agent(name: nil)
              #   Pass arguments to `get_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the agent to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Agent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Agent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetAgentRequest.new
              #
              #   # Call the get_agent method.
              #   result = client.get_agent request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Agent.
              #   p result
              #
              def get_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_agent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new agent in the given app.
              #
              # @overload create_agent(request, options = nil)
              #   Pass arguments to `create_agent` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_agent(parent: nil, agent_id: nil, agent: nil)
              #   Pass arguments to `create_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to create an agent in.
              #   @param agent_id [::String]
              #     Optional. The ID to use for the agent, which will become the final
              #     component of the agent's resource name. If not provided, a unique ID will
              #     be automatically assigned for the agent.
              #   @param agent [::Google::Cloud::Ces::V1beta::Agent, ::Hash]
              #     Required. The agent to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Agent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Agent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateAgentRequest.new
              #
              #   # Call the create_agent method.
              #   result = client.create_agent request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Agent.
              #   p result
              #
              def create_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_agent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified agent.
              #
              # @overload update_agent(request, options = nil)
              #   Pass arguments to `update_agent` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_agent(agent: nil, update_mask: nil)
              #   Pass arguments to `update_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param agent [::Google::Cloud::Ces::V1beta::Agent, ::Hash]
              #     Required. The agent to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Agent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Agent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateAgentRequest.new
              #
              #   # Call the update_agent method.
              #   result = client.update_agent request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Agent.
              #   p result
              #
              def update_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.update_agent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified agent.
              #
              # @overload delete_agent(request, options = nil)
              #   Pass arguments to `delete_agent` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteAgentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteAgentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_agent(name: nil, force: nil, etag: nil)
              #   Pass arguments to `delete_agent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the agent to delete.
              #   @param force [::Boolean]
              #     Optional. Indicates whether to forcefully delete the agent, even if it is
              #     still referenced by other app/agents/examples.
              #
              #     *  If `force = false`, the deletion fails if other agents/examples
              #     reference it.
              #     *  If `force = true`, delete the agent and remove it from all referencing
              #     apps/agents/examples.
              #   @param etag [::String]
              #     Optional. The current etag of the agent. If an etag is not provided, the
              #     deletion will overwrite any concurrent changes. If an etag is provided and
              #     does not match the current etag of the agent, deletion will be blocked and
              #     an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteAgentRequest.new
              #
              #   # Call the delete_agent method.
              #   result = client.delete_agent request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_agent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteAgentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_agent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_agent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_agent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_agent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists examples in the given app.
              #
              # @overload list_examples(request, options = nil)
              #   Pass arguments to `list_examples` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListExamplesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListExamplesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_examples(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_examples` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list examples from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListExamplesResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_examples AgentService.ListExamples}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the examples.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Example>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Example>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListExamplesRequest.new
              #
              #   # Call the list_examples method.
              #   result = client.list_examples request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Example.
              #     p item
              #   end
              #
              def list_examples request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListExamplesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_examples.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_examples.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_examples.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_examples request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_examples, "examples", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified example.
              #
              # @overload get_example(request, options = nil)
              #   Pass arguments to `get_example` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetExampleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetExampleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_example(name: nil)
              #   Pass arguments to `get_example` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the example to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Example]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Example]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetExampleRequest.new
              #
              #   # Call the get_example method.
              #   result = client.get_example request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Example.
              #   p result
              #
              def get_example request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetExampleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_example.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_example.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_example.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_example request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new example in the given app.
              #
              # @overload create_example(request, options = nil)
              #   Pass arguments to `create_example` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateExampleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateExampleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_example(parent: nil, example_id: nil, example: nil)
              #   Pass arguments to `create_example` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to create an example in.
              #   @param example_id [::String]
              #     Optional. The ID to use for the example, which will become the final
              #     component of the example's resource name. If not provided, a unique ID will
              #     be automatically assigned for the example.
              #   @param example [::Google::Cloud::Ces::V1beta::Example, ::Hash]
              #     Required. The example to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Example]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Example]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateExampleRequest.new
              #
              #   # Call the create_example method.
              #   result = client.create_example request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Example.
              #   p result
              #
              def create_example request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateExampleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_example.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_example.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_example.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_example request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified example.
              #
              # @overload update_example(request, options = nil)
              #   Pass arguments to `update_example` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateExampleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateExampleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_example(example: nil, update_mask: nil)
              #   Pass arguments to `update_example` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param example [::Google::Cloud::Ces::V1beta::Example, ::Hash]
              #     Required. The example to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Example]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Example]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateExampleRequest.new
              #
              #   # Call the update_example method.
              #   result = client.update_example request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Example.
              #   p result
              #
              def update_example request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateExampleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_example.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_example.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_example.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.update_example request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified example.
              #
              # @overload delete_example(request, options = nil)
              #   Pass arguments to `delete_example` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteExampleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteExampleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_example(name: nil, etag: nil)
              #   Pass arguments to `delete_example` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the example to delete.
              #   @param etag [::String]
              #     Optional. The current etag of the example. If an etag is not provided, the
              #     deletion will overwrite any concurrent changes. If an etag is provided and
              #     does not match the current etag of the example, deletion will be blocked
              #     and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteExampleRequest.new
              #
              #   # Call the delete_example method.
              #   result = client.delete_example request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_example request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteExampleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_example.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_example.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_example.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_example request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists tools in the given app.
              #
              # @overload list_tools(request, options = nil)
              #   Pass arguments to `list_tools` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListToolsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListToolsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tools(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_tools` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list tools from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListToolsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_tools AgentService.ListTools}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the tools. Use
              #     "include_system_tools=true" to include system tools in the response. See
              #     https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Tool>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Tool>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListToolsRequest.new
              #
              #   # Call the list_tools method.
              #   result = client.list_tools request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Tool.
              #     p item
              #   end
              #
              def list_tools request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListToolsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tools.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tools.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tools.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_tools request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_tools, "tools", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified tool.
              #
              # @overload get_tool(request, options = nil)
              #   Pass arguments to `get_tool` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetToolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetToolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tool(name: nil)
              #   Pass arguments to `get_tool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the tool to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Tool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Tool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetToolRequest.new
              #
              #   # Call the get_tool method.
              #   result = client.get_tool request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Tool.
              #   p result
              #
              def get_tool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetToolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_tool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists conversations in the given app.
              #
              # @overload list_conversations(request, options = nil)
              #   Pass arguments to `list_conversations` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_conversations(parent: nil, page_size: nil, page_token: nil, filter: nil, source: nil)
              #   Pass arguments to `list_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list conversations from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListConversationsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_conversations AgentService.ListConversations}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the conversations.
              #     See https://google.aip.dev/160 for more details.
              #   @param source [::Google::Cloud::Ces::V1beta::Conversation::Source]
              #     Optional. Indicate the source of the conversation. If not set, Source.Live
              #     will be applied by default.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Conversation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Conversation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListConversationsRequest.new
              #
              #   # Call the list_conversations method.
              #   result = client.list_conversations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Conversation.
              #     p item
              #   end
              #
              def list_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_conversations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_conversations, "conversations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified conversation.
              #
              # @overload get_conversation(request, options = nil)
              #   Pass arguments to `get_conversation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_conversation(name: nil, source: nil)
              #   Pass arguments to `get_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the conversation to retrieve.
              #   @param source [::Google::Cloud::Ces::V1beta::Conversation::Source]
              #     Optional. Indicate the source of the conversation. If not set, all source
              #     will be searched.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetConversationRequest.new
              #
              #   # Call the get_conversation method.
              #   result = client.get_conversation request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Conversation.
              #   p result
              #
              def get_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified conversation.
              #
              # @overload delete_conversation(request, options = nil)
              #   Pass arguments to `delete_conversation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_conversation(name: nil, source: nil)
              #   Pass arguments to `delete_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the conversation to delete.
              #   @param source [::Google::Cloud::Ces::V1beta::Conversation::Source]
              #     Optional. Indicate the source of the conversation. If not set, Source.Live
              #     will be applied by default.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteConversationRequest.new
              #
              #   # Call the delete_conversation method.
              #   result = client.delete_conversation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Batch deletes the specified conversations.
              #
              # @overload batch_delete_conversations(request, options = nil)
              #   Pass arguments to `batch_delete_conversations` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_delete_conversations(parent: nil, conversations: nil)
              #   Pass arguments to `batch_delete_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to delete conversations from.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param conversations [::Array<::String>]
              #     Required. The resource names of the conversations to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest.new
              #
              #   # Call the batch_delete_conversations method.
              #   result = client.batch_delete_conversations request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_delete_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_delete_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_delete_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_delete_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.batch_delete_conversations request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new tool in the given app.
              #
              # @overload create_tool(request, options = nil)
              #   Pass arguments to `create_tool` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateToolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateToolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tool(parent: nil, tool_id: nil, tool: nil)
              #   Pass arguments to `create_tool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to create a tool in.
              #   @param tool_id [::String]
              #     Optional. The ID to use for the tool, which will become the final component
              #     of the tool's resource name. If not provided, a unique ID will be
              #     automatically assigned for the tool.
              #   @param tool [::Google::Cloud::Ces::V1beta::Tool, ::Hash]
              #     Required. The tool to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Tool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Tool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateToolRequest.new
              #
              #   # Call the create_tool method.
              #   result = client.create_tool request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Tool.
              #   p result
              #
              def create_tool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateToolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_tool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified tool.
              #
              # @overload update_tool(request, options = nil)
              #   Pass arguments to `update_tool` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateToolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateToolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tool(tool: nil, update_mask: nil)
              #   Pass arguments to `update_tool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tool [::Google::Cloud::Ces::V1beta::Tool, ::Hash]
              #     Required. The tool to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Tool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Tool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateToolRequest.new
              #
              #   # Call the update_tool method.
              #   result = client.update_tool request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Tool.
              #   p result
              #
              def update_tool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateToolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.update_tool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified tool.
              #
              # @overload delete_tool(request, options = nil)
              #   Pass arguments to `delete_tool` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteToolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteToolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tool(name: nil, force: nil, etag: nil)
              #   Pass arguments to `delete_tool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the tool to delete.
              #   @param force [::Boolean]
              #     Optional. Indicates whether to forcefully delete the tool, even if it is
              #     still referenced by agents/examples.
              #
              #     *  If `force = false`, the deletion will fail if any agents still
              #     reference the tool.
              #     *  If `force = true`, all existing references from agents will be removed
              #     and the tool will be deleted.
              #   @param etag [::String]
              #     Optional. The current etag of the tool. If an etag is not provided, the
              #     deletion will overwrite any concurrent changes. If an etag is provided and
              #     does not match the current etag of the tool, deletion will be blocked and
              #     an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteToolRequest.new
              #
              #   # Call the delete_tool method.
              #   result = client.delete_tool request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_tool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteToolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_tool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists guardrails in the given app.
              #
              # @overload list_guardrails(request, options = nil)
              #   Pass arguments to `list_guardrails` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListGuardrailsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListGuardrailsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_guardrails(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_guardrails` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list guardrails from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListGuardrailsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_guardrails AgentService.ListGuardrails}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the guardrails.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Guardrail>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Guardrail>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListGuardrailsRequest.new
              #
              #   # Call the list_guardrails method.
              #   result = client.list_guardrails request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Guardrail.
              #     p item
              #   end
              #
              def list_guardrails request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListGuardrailsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_guardrails.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_guardrails.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_guardrails.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_guardrails request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_guardrails, "guardrails", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified guardrail.
              #
              # @overload get_guardrail(request, options = nil)
              #   Pass arguments to `get_guardrail` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetGuardrailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetGuardrailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_guardrail(name: nil)
              #   Pass arguments to `get_guardrail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the guardrail to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Guardrail]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Guardrail]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetGuardrailRequest.new
              #
              #   # Call the get_guardrail method.
              #   result = client.get_guardrail request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Guardrail.
              #   p result
              #
              def get_guardrail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetGuardrailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_guardrail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_guardrail.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_guardrail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_guardrail request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new guardrail in the given app.
              #
              # @overload create_guardrail(request, options = nil)
              #   Pass arguments to `create_guardrail` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateGuardrailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateGuardrailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_guardrail(parent: nil, guardrail_id: nil, guardrail: nil)
              #   Pass arguments to `create_guardrail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to create a guardrail in.
              #   @param guardrail_id [::String]
              #     Optional. The ID to use for the guardrail, which will become the final
              #     component of the guardrail's resource name. If not provided, a unique ID
              #     will be automatically assigned for the guardrail.
              #   @param guardrail [::Google::Cloud::Ces::V1beta::Guardrail, ::Hash]
              #     Required. The guardrail to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Guardrail]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Guardrail]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateGuardrailRequest.new
              #
              #   # Call the create_guardrail method.
              #   result = client.create_guardrail request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Guardrail.
              #   p result
              #
              def create_guardrail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateGuardrailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_guardrail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_guardrail.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_guardrail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_guardrail request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified guardrail.
              #
              # @overload update_guardrail(request, options = nil)
              #   Pass arguments to `update_guardrail` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_guardrail(guardrail: nil, update_mask: nil)
              #   Pass arguments to `update_guardrail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param guardrail [::Google::Cloud::Ces::V1beta::Guardrail, ::Hash]
              #     Required. The guardrail to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Guardrail]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Guardrail]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateGuardrailRequest.new
              #
              #   # Call the update_guardrail method.
              #   result = client.update_guardrail request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Guardrail.
              #   p result
              #
              def update_guardrail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_guardrail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_guardrail.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_guardrail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.update_guardrail request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified guardrail.
              #
              # @overload delete_guardrail(request, options = nil)
              #   Pass arguments to `delete_guardrail` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_guardrail(name: nil, force: nil, etag: nil)
              #   Pass arguments to `delete_guardrail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the guardrail to delete.
              #   @param force [::Boolean]
              #     Optional. Indicates whether to forcefully delete the guardrail, even if it
              #     is still referenced by app/agents.
              #
              #     *  If `force = false`, the deletion fails if any apps/agents still
              #     reference the guardrail.
              #     *  If `force = true`, all existing references from apps/agents will be
              #     removed and the guardrail will be deleted.
              #   @param etag [::String]
              #     Optional. The current etag of the guardrail. If an etag is not provided,
              #     the deletion will overwrite any concurrent changes. If an etag is provided
              #     and does not match the current etag of the guardrail, deletion will be
              #     blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteGuardrailRequest.new
              #
              #   # Call the delete_guardrail method.
              #   result = client.delete_guardrail request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_guardrail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_guardrail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_guardrail.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_guardrail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_guardrail request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists deployments in the given app.
              #
              # @overload list_deployments(request, options = nil)
              #   Pass arguments to `list_deployments` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListDeploymentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListDeploymentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_deployments(parent: nil, page_size: nil, page_token: nil, order_by: nil)
              #   Pass arguments to `list_deployments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent app.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of deployments to return. The service may
              #     return fewer than this value. If unspecified, at most 50 deployments will
              #     be returned. The maximum value is 1000; values above 1000 will be coerced
              #     to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListDeployments` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListDeployments` must
              #     match the call that provided the page token.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Deployment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Deployment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListDeploymentsRequest.new
              #
              #   # Call the list_deployments method.
              #   result = client.list_deployments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Deployment.
              #     p item
              #   end
              #
              def list_deployments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListDeploymentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_deployments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_deployments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_deployments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_deployments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_deployments, "deployments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified deployment.
              #
              # @overload get_deployment(request, options = nil)
              #   Pass arguments to `get_deployment` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_deployment(name: nil)
              #   Pass arguments to `get_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetDeploymentRequest.new
              #
              #   # Call the get_deployment method.
              #   result = client.get_deployment request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Deployment.
              #   p result
              #
              def get_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new deployment in the given app.
              #
              # @overload create_deployment(request, options = nil)
              #   Pass arguments to `create_deployment` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_deployment(parent: nil, deployment_id: nil, deployment: nil)
              #   Pass arguments to `create_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent app.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param deployment_id [::String]
              #     Optional. The ID to use for the deployment, which will become the final
              #     component of the deployment's resource name. If not provided, a unique ID
              #     will be automatically assigned for the deployment.
              #   @param deployment [::Google::Cloud::Ces::V1beta::Deployment, ::Hash]
              #     Required. The deployment to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateDeploymentRequest.new
              #
              #   # Call the create_deployment method.
              #   result = client.create_deployment request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Deployment.
              #   p result
              #
              def create_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified deployment.
              #
              # @overload update_deployment(request, options = nil)
              #   Pass arguments to `update_deployment` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_deployment(deployment: nil, update_mask: nil)
              #   Pass arguments to `update_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param deployment [::Google::Cloud::Ces::V1beta::Deployment, ::Hash]
              #     Required. The deployment to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Deployment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Deployment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateDeploymentRequest.new
              #
              #   # Call the update_deployment method.
              #   result = client.update_deployment request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Deployment.
              #   p result
              #
              def update_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.update_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified deployment.
              #
              # @overload delete_deployment(request, options = nil)
              #   Pass arguments to `delete_deployment` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_deployment(name: nil, etag: nil)
              #   Pass arguments to `delete_deployment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the deployment to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
              #   @param etag [::String]
              #     Optional. The etag of the deployment.
              #     If an etag is provided and does not match the current etag of the
              #     deployment, deletion will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteDeploymentRequest.new
              #
              #   # Call the delete_deployment method.
              #   result = client.delete_deployment request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_deployment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_deployment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_deployment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_deployment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_deployment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists toolsets in the given app.
              #
              # @overload list_toolsets(request, options = nil)
              #   Pass arguments to `list_toolsets` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListToolsetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListToolsetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_toolsets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_toolsets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list toolsets from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListToolsetsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_toolsets AgentService.ListToolsets}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the toolsets.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Toolset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Toolset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListToolsetsRequest.new
              #
              #   # Call the list_toolsets method.
              #   result = client.list_toolsets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Toolset.
              #     p item
              #   end
              #
              def list_toolsets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListToolsetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_toolsets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_toolsets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_toolsets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_toolsets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_toolsets, "toolsets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified toolset.
              #
              # @overload get_toolset(request, options = nil)
              #   Pass arguments to `get_toolset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetToolsetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetToolsetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_toolset(name: nil)
              #   Pass arguments to `get_toolset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the toolset to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Toolset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Toolset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetToolsetRequest.new
              #
              #   # Call the get_toolset method.
              #   result = client.get_toolset request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Toolset.
              #   p result
              #
              def get_toolset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetToolsetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_toolset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_toolset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_toolset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_toolset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new toolset in the given app.
              #
              # @overload create_toolset(request, options = nil)
              #   Pass arguments to `create_toolset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateToolsetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateToolsetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_toolset(parent: nil, toolset_id: nil, toolset: nil)
              #   Pass arguments to `create_toolset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to create a toolset in.
              #   @param toolset_id [::String]
              #     Optional. The ID to use for the toolset, which will become the final
              #     component of the toolset's resource name. If not provided, a unique ID will
              #     be automatically assigned for the toolset.
              #   @param toolset [::Google::Cloud::Ces::V1beta::Toolset, ::Hash]
              #     Required. The toolset to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Toolset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Toolset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateToolsetRequest.new
              #
              #   # Call the create_toolset method.
              #   result = client.create_toolset request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Toolset.
              #   p result
              #
              def create_toolset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateToolsetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_toolset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_toolset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_toolset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_toolset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified toolset.
              #
              # @overload update_toolset(request, options = nil)
              #   Pass arguments to `update_toolset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateToolsetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateToolsetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_toolset(toolset: nil, update_mask: nil)
              #   Pass arguments to `update_toolset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param toolset [::Google::Cloud::Ces::V1beta::Toolset, ::Hash]
              #     Required. The toolset to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Toolset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Toolset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateToolsetRequest.new
              #
              #   # Call the update_toolset method.
              #   result = client.update_toolset request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Toolset.
              #   p result
              #
              def update_toolset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateToolsetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_toolset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_toolset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_toolset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.update_toolset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified toolset.
              #
              # @overload delete_toolset(request, options = nil)
              #   Pass arguments to `delete_toolset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteToolsetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteToolsetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_toolset(name: nil, force: nil, etag: nil)
              #   Pass arguments to `delete_toolset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the toolset to delete.
              #   @param force [::Boolean]
              #     Optional. Indicates whether to forcefully delete the toolset, even if it is
              #     still referenced by app/agents.
              #
              #     *  If `force = false`, the deletion fails if any agents still
              #     reference the toolset.
              #     *  If `force = true`, all existing references from agents will be
              #     removed and the toolset will be deleted.
              #   @param etag [::String]
              #     Optional. The current etag of the toolset. If an etag is not provided, the
              #     deletion will overwrite any concurrent changes. If an etag is provided and
              #     does not match the current etag of the toolset, deletion will be blocked
              #     and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteToolsetRequest.new
              #
              #   # Call the delete_toolset method.
              #   result = client.delete_toolset request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_toolset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteToolsetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_toolset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_toolset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_toolset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_toolset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all app versions in the given app.
              #
              # @overload list_app_versions(request, options = nil)
              #   Pass arguments to `list_app_versions` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListAppVersionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListAppVersionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_app_versions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_app_versions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list app versions from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListAppVersionsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_app_versions AgentService.ListAppVersions}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the app versions.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::AppVersion>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::AppVersion>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListAppVersionsRequest.new
              #
              #   # Call the list_app_versions method.
              #   result = client.list_app_versions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::AppVersion.
              #     p item
              #   end
              #
              def list_app_versions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListAppVersionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_app_versions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_app_versions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_app_versions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_app_versions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_app_versions, "app_versions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified app version.
              #
              # @overload get_app_version(request, options = nil)
              #   Pass arguments to `get_app_version` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetAppVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetAppVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_app_version(name: nil)
              #   Pass arguments to `get_app_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the app version to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::AppVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::AppVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetAppVersionRequest.new
              #
              #   # Call the get_app_version method.
              #   result = client.get_app_version request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::AppVersion.
              #   p result
              #
              def get_app_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetAppVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_app_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_app_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_app_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_app_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new app version in the given app.
              #
              # @overload create_app_version(request, options = nil)
              #   Pass arguments to `create_app_version` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateAppVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateAppVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_app_version(parent: nil, app_version_id: nil, app_version: nil)
              #   Pass arguments to `create_app_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to create an app version in.
              #   @param app_version_id [::String]
              #     Optional. The ID to use for the app version, which will become the final
              #     component of the app version's resource name. If not provided, a unique ID
              #     will be automatically assigned for the app version.
              #   @param app_version [::Google::Cloud::Ces::V1beta::AppVersion, ::Hash]
              #     Required. The app version to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::AppVersion]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::AppVersion]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateAppVersionRequest.new
              #
              #   # Call the create_app_version method.
              #   result = client.create_app_version request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::AppVersion.
              #   p result
              #
              def create_app_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateAppVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_app_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_app_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_app_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.create_app_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified app version.
              #
              # @overload delete_app_version(request, options = nil)
              #   Pass arguments to `delete_app_version` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_app_version(name: nil, etag: nil)
              #   Pass arguments to `delete_app_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the app version to delete.
              #   @param etag [::String]
              #     Optional. The current etag of the app version. If an etag is not provided,
              #     the deletion will overwrite any concurrent changes. If an etag is provided
              #     and does not match the current etag of the app version, deletion will be
              #     blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteAppVersionRequest.new
              #
              #   # Call the delete_app_version method.
              #   result = client.delete_app_version request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_app_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_app_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_app_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_app_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.delete_app_version request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Restores the specified app version.
              # This will create a new app version from the current draft app and overwrite
              # the current draft with the specified app version.
              #
              # @overload restore_app_version(request, options = nil)
              #   Pass arguments to `restore_app_version` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload restore_app_version(name: nil)
              #   Pass arguments to `restore_app_version` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the app version to restore.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::RestoreAppVersionRequest.new
              #
              #   # Call the restore_app_version method.
              #   result = client.restore_app_version request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def restore_app_version request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.restore_app_version.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.restore_app_version.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.restore_app_version.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.restore_app_version request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the changelogs of the specified app.
              #
              # @overload list_changelogs(request, options = nil)
              #   Pass arguments to `list_changelogs` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListChangelogsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListChangelogsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_changelogs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_changelogs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list changelogs from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListChangelogsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client#list_changelogs AgentService.ListChangelogs}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the changelogs.
              #     See https://google.aip.dev/160 for more details.
              #
              #     The filter string can be used to filter by `action`, `resource_type`,
              #     `resource_name`, `author`, and `create_time`.
              #     The `:` comparator can be used for case-insensitive partial matching on
              #     string fields, while `=` performs an exact case-sensitive match.
              #
              #     Examples:
              #     * `action:update` (case-insensitive partial match)
              #     * `action="Create"` (case-sensitive exact match)
              #     * `resource_type:agent`
              #     * `resource_name:my-agent`
              #     * `author:me@example.com`
              #     * `create_time > "2025-01-01T00:00:00Z"`
              #     * `create_time <= "2025-01-01T00:00:00Z" AND resource_type:tool`
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time" is supported.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Changelog>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Changelog>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListChangelogsRequest.new
              #
              #   # Call the list_changelogs method.
              #   result = client.list_changelogs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Changelog.
              #     p item
              #   end
              #
              def list_changelogs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListChangelogsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_changelogs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_changelogs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_changelogs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.list_changelogs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @agent_service_stub, :list_changelogs, "changelogs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the specified changelog.
              #
              # @overload get_changelog(request, options = nil)
              #   Pass arguments to `get_changelog` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetChangelogRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetChangelogRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_changelog(name: nil)
              #   Pass arguments to `get_changelog` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the changelog to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Changelog]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Changelog]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetChangelogRequest.new
              #
              #   # Call the get_changelog method.
              #   result = client.get_changelog request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Changelog.
              #   p result
              #
              def get_changelog request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetChangelogRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_changelog.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_changelog.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_changelog.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @agent_service_stub.get_changelog request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AgentService REST API.
              #
              # This class represents the configuration for AgentService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Ces::V1beta::AgentService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_apps to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_apps.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_apps.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "ces.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the AgentService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_apps`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_apps
                  ##
                  # RPC-specific configuration for `get_app`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_app
                  ##
                  # RPC-specific configuration for `create_app`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_app
                  ##
                  # RPC-specific configuration for `update_app`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_app
                  ##
                  # RPC-specific configuration for `delete_app`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_app
                  ##
                  # RPC-specific configuration for `export_app`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_app
                  ##
                  # RPC-specific configuration for `import_app`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_app
                  ##
                  # RPC-specific configuration for `list_agents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_agents
                  ##
                  # RPC-specific configuration for `get_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_agent
                  ##
                  # RPC-specific configuration for `create_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_agent
                  ##
                  # RPC-specific configuration for `update_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_agent
                  ##
                  # RPC-specific configuration for `delete_agent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_agent
                  ##
                  # RPC-specific configuration for `list_examples`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_examples
                  ##
                  # RPC-specific configuration for `get_example`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_example
                  ##
                  # RPC-specific configuration for `create_example`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_example
                  ##
                  # RPC-specific configuration for `update_example`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_example
                  ##
                  # RPC-specific configuration for `delete_example`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_example
                  ##
                  # RPC-specific configuration for `list_tools`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tools
                  ##
                  # RPC-specific configuration for `get_tool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tool
                  ##
                  # RPC-specific configuration for `list_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_conversations
                  ##
                  # RPC-specific configuration for `get_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_conversation
                  ##
                  # RPC-specific configuration for `delete_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_conversation
                  ##
                  # RPC-specific configuration for `batch_delete_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_delete_conversations
                  ##
                  # RPC-specific configuration for `create_tool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tool
                  ##
                  # RPC-specific configuration for `update_tool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tool
                  ##
                  # RPC-specific configuration for `delete_tool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tool
                  ##
                  # RPC-specific configuration for `list_guardrails`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_guardrails
                  ##
                  # RPC-specific configuration for `get_guardrail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_guardrail
                  ##
                  # RPC-specific configuration for `create_guardrail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_guardrail
                  ##
                  # RPC-specific configuration for `update_guardrail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_guardrail
                  ##
                  # RPC-specific configuration for `delete_guardrail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_guardrail
                  ##
                  # RPC-specific configuration for `list_deployments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_deployments
                  ##
                  # RPC-specific configuration for `get_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_deployment
                  ##
                  # RPC-specific configuration for `create_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_deployment
                  ##
                  # RPC-specific configuration for `update_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_deployment
                  ##
                  # RPC-specific configuration for `delete_deployment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_deployment
                  ##
                  # RPC-specific configuration for `list_toolsets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_toolsets
                  ##
                  # RPC-specific configuration for `get_toolset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_toolset
                  ##
                  # RPC-specific configuration for `create_toolset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_toolset
                  ##
                  # RPC-specific configuration for `update_toolset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_toolset
                  ##
                  # RPC-specific configuration for `delete_toolset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_toolset
                  ##
                  # RPC-specific configuration for `list_app_versions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_app_versions
                  ##
                  # RPC-specific configuration for `get_app_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_app_version
                  ##
                  # RPC-specific configuration for `create_app_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_app_version
                  ##
                  # RPC-specific configuration for `delete_app_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_app_version
                  ##
                  # RPC-specific configuration for `restore_app_version`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :restore_app_version
                  ##
                  # RPC-specific configuration for `list_changelogs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_changelogs
                  ##
                  # RPC-specific configuration for `get_changelog`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_changelog

                  # @private
                  def initialize parent_rpcs = nil
                    list_apps_config = parent_rpcs.list_apps if parent_rpcs.respond_to? :list_apps
                    @list_apps = ::Gapic::Config::Method.new list_apps_config
                    get_app_config = parent_rpcs.get_app if parent_rpcs.respond_to? :get_app
                    @get_app = ::Gapic::Config::Method.new get_app_config
                    create_app_config = parent_rpcs.create_app if parent_rpcs.respond_to? :create_app
                    @create_app = ::Gapic::Config::Method.new create_app_config
                    update_app_config = parent_rpcs.update_app if parent_rpcs.respond_to? :update_app
                    @update_app = ::Gapic::Config::Method.new update_app_config
                    delete_app_config = parent_rpcs.delete_app if parent_rpcs.respond_to? :delete_app
                    @delete_app = ::Gapic::Config::Method.new delete_app_config
                    export_app_config = parent_rpcs.export_app if parent_rpcs.respond_to? :export_app
                    @export_app = ::Gapic::Config::Method.new export_app_config
                    import_app_config = parent_rpcs.import_app if parent_rpcs.respond_to? :import_app
                    @import_app = ::Gapic::Config::Method.new import_app_config
                    list_agents_config = parent_rpcs.list_agents if parent_rpcs.respond_to? :list_agents
                    @list_agents = ::Gapic::Config::Method.new list_agents_config
                    get_agent_config = parent_rpcs.get_agent if parent_rpcs.respond_to? :get_agent
                    @get_agent = ::Gapic::Config::Method.new get_agent_config
                    create_agent_config = parent_rpcs.create_agent if parent_rpcs.respond_to? :create_agent
                    @create_agent = ::Gapic::Config::Method.new create_agent_config
                    update_agent_config = parent_rpcs.update_agent if parent_rpcs.respond_to? :update_agent
                    @update_agent = ::Gapic::Config::Method.new update_agent_config
                    delete_agent_config = parent_rpcs.delete_agent if parent_rpcs.respond_to? :delete_agent
                    @delete_agent = ::Gapic::Config::Method.new delete_agent_config
                    list_examples_config = parent_rpcs.list_examples if parent_rpcs.respond_to? :list_examples
                    @list_examples = ::Gapic::Config::Method.new list_examples_config
                    get_example_config = parent_rpcs.get_example if parent_rpcs.respond_to? :get_example
                    @get_example = ::Gapic::Config::Method.new get_example_config
                    create_example_config = parent_rpcs.create_example if parent_rpcs.respond_to? :create_example
                    @create_example = ::Gapic::Config::Method.new create_example_config
                    update_example_config = parent_rpcs.update_example if parent_rpcs.respond_to? :update_example
                    @update_example = ::Gapic::Config::Method.new update_example_config
                    delete_example_config = parent_rpcs.delete_example if parent_rpcs.respond_to? :delete_example
                    @delete_example = ::Gapic::Config::Method.new delete_example_config
                    list_tools_config = parent_rpcs.list_tools if parent_rpcs.respond_to? :list_tools
                    @list_tools = ::Gapic::Config::Method.new list_tools_config
                    get_tool_config = parent_rpcs.get_tool if parent_rpcs.respond_to? :get_tool
                    @get_tool = ::Gapic::Config::Method.new get_tool_config
                    list_conversations_config = parent_rpcs.list_conversations if parent_rpcs.respond_to? :list_conversations
                    @list_conversations = ::Gapic::Config::Method.new list_conversations_config
                    get_conversation_config = parent_rpcs.get_conversation if parent_rpcs.respond_to? :get_conversation
                    @get_conversation = ::Gapic::Config::Method.new get_conversation_config
                    delete_conversation_config = parent_rpcs.delete_conversation if parent_rpcs.respond_to? :delete_conversation
                    @delete_conversation = ::Gapic::Config::Method.new delete_conversation_config
                    batch_delete_conversations_config = parent_rpcs.batch_delete_conversations if parent_rpcs.respond_to? :batch_delete_conversations
                    @batch_delete_conversations = ::Gapic::Config::Method.new batch_delete_conversations_config
                    create_tool_config = parent_rpcs.create_tool if parent_rpcs.respond_to? :create_tool
                    @create_tool = ::Gapic::Config::Method.new create_tool_config
                    update_tool_config = parent_rpcs.update_tool if parent_rpcs.respond_to? :update_tool
                    @update_tool = ::Gapic::Config::Method.new update_tool_config
                    delete_tool_config = parent_rpcs.delete_tool if parent_rpcs.respond_to? :delete_tool
                    @delete_tool = ::Gapic::Config::Method.new delete_tool_config
                    list_guardrails_config = parent_rpcs.list_guardrails if parent_rpcs.respond_to? :list_guardrails
                    @list_guardrails = ::Gapic::Config::Method.new list_guardrails_config
                    get_guardrail_config = parent_rpcs.get_guardrail if parent_rpcs.respond_to? :get_guardrail
                    @get_guardrail = ::Gapic::Config::Method.new get_guardrail_config
                    create_guardrail_config = parent_rpcs.create_guardrail if parent_rpcs.respond_to? :create_guardrail
                    @create_guardrail = ::Gapic::Config::Method.new create_guardrail_config
                    update_guardrail_config = parent_rpcs.update_guardrail if parent_rpcs.respond_to? :update_guardrail
                    @update_guardrail = ::Gapic::Config::Method.new update_guardrail_config
                    delete_guardrail_config = parent_rpcs.delete_guardrail if parent_rpcs.respond_to? :delete_guardrail
                    @delete_guardrail = ::Gapic::Config::Method.new delete_guardrail_config
                    list_deployments_config = parent_rpcs.list_deployments if parent_rpcs.respond_to? :list_deployments
                    @list_deployments = ::Gapic::Config::Method.new list_deployments_config
                    get_deployment_config = parent_rpcs.get_deployment if parent_rpcs.respond_to? :get_deployment
                    @get_deployment = ::Gapic::Config::Method.new get_deployment_config
                    create_deployment_config = parent_rpcs.create_deployment if parent_rpcs.respond_to? :create_deployment
                    @create_deployment = ::Gapic::Config::Method.new create_deployment_config
                    update_deployment_config = parent_rpcs.update_deployment if parent_rpcs.respond_to? :update_deployment
                    @update_deployment = ::Gapic::Config::Method.new update_deployment_config
                    delete_deployment_config = parent_rpcs.delete_deployment if parent_rpcs.respond_to? :delete_deployment
                    @delete_deployment = ::Gapic::Config::Method.new delete_deployment_config
                    list_toolsets_config = parent_rpcs.list_toolsets if parent_rpcs.respond_to? :list_toolsets
                    @list_toolsets = ::Gapic::Config::Method.new list_toolsets_config
                    get_toolset_config = parent_rpcs.get_toolset if parent_rpcs.respond_to? :get_toolset
                    @get_toolset = ::Gapic::Config::Method.new get_toolset_config
                    create_toolset_config = parent_rpcs.create_toolset if parent_rpcs.respond_to? :create_toolset
                    @create_toolset = ::Gapic::Config::Method.new create_toolset_config
                    update_toolset_config = parent_rpcs.update_toolset if parent_rpcs.respond_to? :update_toolset
                    @update_toolset = ::Gapic::Config::Method.new update_toolset_config
                    delete_toolset_config = parent_rpcs.delete_toolset if parent_rpcs.respond_to? :delete_toolset
                    @delete_toolset = ::Gapic::Config::Method.new delete_toolset_config
                    list_app_versions_config = parent_rpcs.list_app_versions if parent_rpcs.respond_to? :list_app_versions
                    @list_app_versions = ::Gapic::Config::Method.new list_app_versions_config
                    get_app_version_config = parent_rpcs.get_app_version if parent_rpcs.respond_to? :get_app_version
                    @get_app_version = ::Gapic::Config::Method.new get_app_version_config
                    create_app_version_config = parent_rpcs.create_app_version if parent_rpcs.respond_to? :create_app_version
                    @create_app_version = ::Gapic::Config::Method.new create_app_version_config
                    delete_app_version_config = parent_rpcs.delete_app_version if parent_rpcs.respond_to? :delete_app_version
                    @delete_app_version = ::Gapic::Config::Method.new delete_app_version_config
                    restore_app_version_config = parent_rpcs.restore_app_version if parent_rpcs.respond_to? :restore_app_version
                    @restore_app_version = ::Gapic::Config::Method.new restore_app_version_config
                    list_changelogs_config = parent_rpcs.list_changelogs if parent_rpcs.respond_to? :list_changelogs
                    @list_changelogs = ::Gapic::Config::Method.new list_changelogs_config
                    get_changelog_config = parent_rpcs.get_changelog if parent_rpcs.respond_to? :get_changelog
                    @get_changelog = ::Gapic::Config::Method.new get_changelog_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
