# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        module EvaluationService
          # Path helper methods for the EvaluationService API.
          module Paths
            ##
            # Create a fully-qualified Agent resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param agent [String]
            #
            # @return [::String]
            def agent_path project:, location:, app:, agent:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/agents/#{agent}"
            end

            ##
            # Create a fully-qualified App resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            #
            # @return [::String]
            def app_path project:, location:, app:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}"
            end

            ##
            # Create a fully-qualified AppVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param version [String]
            #
            # @return [::String]
            def app_version_path project:, location:, app:, version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/versions/#{version}"
            end

            ##
            # Create a fully-qualified Changelog resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param changelog [String]
            #
            # @return [::String]
            def changelog_path project:, location:, app:, changelog:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/changelogs/#{changelog}"
            end

            ##
            # Create a fully-qualified Conversation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param conversation [String]
            #
            # @return [::String]
            def conversation_path project:, location:, app:, conversation:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/conversations/#{conversation}"
            end

            ##
            # Create a fully-qualified Evaluation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param evaluation [String]
            #
            # @return [::String]
            def evaluation_path project:, location:, app:, evaluation:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/evaluations/#{evaluation}"
            end

            ##
            # Create a fully-qualified EvaluationDataset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluation_dataset}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param evaluation_dataset [String]
            #
            # @return [::String]
            def evaluation_dataset_path project:, location:, app:, evaluation_dataset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/evaluationDatasets/#{evaluation_dataset}"
            end

            ##
            # Create a fully-qualified EvaluationExpectation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/evaluationExpectations/{evaluation_expectation}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param evaluation_expectation [String]
            #
            # @return [::String]
            def evaluation_expectation_path project:, location:, app:, evaluation_expectation:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/evaluationExpectations/#{evaluation_expectation}"
            end

            ##
            # Create a fully-qualified EvaluationResult resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{evaluation_result}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param evaluation [String]
            # @param evaluation_result [String]
            #
            # @return [::String]
            def evaluation_result_path project:, location:, app:, evaluation:, evaluation_result:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"
              raise ::ArgumentError, "evaluation cannot contain /" if evaluation.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/evaluations/#{evaluation}/results/#{evaluation_result}"
            end

            ##
            # Create a fully-qualified EvaluationRun resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluation_run}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param evaluation_run [String]
            #
            # @return [::String]
            def evaluation_run_path project:, location:, app:, evaluation_run:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/evaluationRuns/#{evaluation_run}"
            end

            ##
            # Create a fully-qualified ScheduledEvaluationRun resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param scheduled_evaluation_run [String]
            #
            # @return [::String]
            def scheduled_evaluation_run_path project:, location:, app:, scheduled_evaluation_run:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/scheduledEvaluationRuns/#{scheduled_evaluation_run}"
            end

            ##
            # Create a fully-qualified Tool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param tool [String]
            #
            # @return [::String]
            def tool_path project:, location:, app:, tool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/tools/#{tool}"
            end

            ##
            # Create a fully-qualified Toolset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param toolset [String]
            #
            # @return [::String]
            def toolset_path project:, location:, app:, toolset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/toolsets/#{toolset}"
            end

            extend self
          end
        end
      end
    end
  end
end
