# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/ces/v1beta/evaluation_service_pb"
require "google/cloud/ces/v1beta/evaluation_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Ces
      module V1beta
        module EvaluationService
          module Rest
            ##
            # REST client for the EvaluationService service.
            #
            # EvaluationService exposes methods to perform evaluation for the CES app.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "ces.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :evaluation_service_stub

              ##
              # Configure the EvaluationService Client class.
              #
              # See {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all EvaluationService clients
              #   ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Ces", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the EvaluationService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @evaluation_service_stub.universe_domain
              end

              ##
              # Create a new EvaluationService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the EvaluationService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @evaluation_service_stub = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @evaluation_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @evaluation_service_stub.endpoint
                  config.universe_domain = @evaluation_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @evaluation_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @evaluation_service_stub.logger
              end

              # Service calls

              ##
              # Runs an evaluation of the app.
              #
              # @overload run_evaluation(request, options = nil)
              #   Pass arguments to `run_evaluation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::RunEvaluationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::RunEvaluationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_evaluation(app: nil, evaluations: nil, evaluation_dataset: nil, display_name: nil, app_version: nil, config: nil, run_count: nil, persona_run_configs: nil, optimization_config: nil, scheduled_evaluation_run: nil, golden_run_method: nil)
              #   Pass arguments to `run_evaluation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param app [::String]
              #     Required. The app to evaluate.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param evaluations [::Array<::String>]
              #     Optional. List of evaluations to run.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
              #   @param evaluation_dataset [::String]
              #     Optional. An evaluation dataset to run.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
              #   @param display_name [::String]
              #     Optional. The display name of the evaluation run.
              #   @param app_version [::String]
              #     Optional. The app version to evaluate.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
              #   @param config [::Google::Cloud::Ces::V1beta::EvaluationConfig, ::Hash]
              #     Optional. The configuration to use for the run.
              #   @param run_count [::Integer]
              #     Optional. The number of times to run the evaluation. If not set, the
              #     default value is 1 per golden, and 5 per scenario.
              #   @param persona_run_configs [::Array<::Google::Cloud::Ces::V1beta::PersonaRunConfig, ::Hash>]
              #     Optional. The configuration to use for the run per persona.
              #   @param optimization_config [::Google::Cloud::Ces::V1beta::OptimizationConfig, ::Hash]
              #     Optional. Configuration for running the optimization step after the
              #     evaluation run. If not set, the optimization step will not be run.
              #   @param scheduled_evaluation_run [::String]
              #     Optional. The resource name of the `ScheduledEvaluationRun` that is
              #     triggering this evaluation run.
              #
              #     If this field is set, the `scheduled_evaluation_run` field on the created
              #     `EvaluationRun` resource will be populated from this value.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
              #   @param golden_run_method [::Google::Cloud::Ces::V1beta::GoldenRunMethod]
              #     Optional. The method to run the evaluation if it is a golden evaluation. If
              #     not set, default to STABLE.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::RunEvaluationRequest.new
              #
              #   # Call the run_evaluation method.
              #   result = client.run_evaluation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def run_evaluation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::RunEvaluationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_evaluation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_evaluation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_evaluation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.run_evaluation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an evaluation.
              #
              # @overload create_evaluation(request, options = nil)
              #   Pass arguments to `create_evaluation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateEvaluationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateEvaluationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_evaluation(parent: nil, evaluation_id: nil, evaluation: nil)
              #   Pass arguments to `create_evaluation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The app to create the evaluation for.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param evaluation_id [::String]
              #     Optional. The ID to use for the evaluation, which will become the final
              #     component of the evaluation's resource name. If not provided, a unique ID
              #     will be automatically assigned for the evaluation.
              #   @param evaluation [::Google::Cloud::Ces::V1beta::Evaluation, ::Hash]
              #     Required. The evaluation to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Evaluation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Evaluation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateEvaluationRequest.new
              #
              #   # Call the create_evaluation method.
              #   result = client.create_evaluation request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Evaluation.
              #   p result
              #
              def create_evaluation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateEvaluationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_evaluation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_evaluation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_evaluation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.create_evaluation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a golden evaluation from a conversation.
              #
              # @overload generate_evaluation(request, options = nil)
              #   Pass arguments to `generate_evaluation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_evaluation(conversation: nil, source: nil)
              #   Pass arguments to `generate_evaluation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversation [::String]
              #     Required. The conversation to create the golden evaluation for.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}`
              #   @param source [::Google::Cloud::Ces::V1beta::Conversation::Source]
              #     Optional. Indicate the source of the conversation. If not set, all sources
              #     will be searched.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GenerateEvaluationRequest.new
              #
              #   # Call the generate_evaluation method.
              #   result = client.generate_evaluation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def generate_evaluation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_evaluation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_evaluation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_evaluation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.generate_evaluation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports evaluations into the app.
              #
              # @overload import_evaluations(request, options = nil)
              #   Pass arguments to `import_evaluations` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_evaluations(conversation_list: nil, gcs_uri: nil, csv_content: nil, parent: nil, import_options: nil)
              #   Pass arguments to `import_evaluations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversation_list [::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest::ConversationList, ::Hash]
              #     The conversations to import the evaluations from.
              #
              #     Note: The following parameters are mutually exclusive: `conversation_list`, `gcs_uri`, `csv_content`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param gcs_uri [::String]
              #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
              #     from which to import evaluations. The format of this URI must be
              #     `gs://<bucket-name>/<object-name>`.
              #
              #     Note: The following parameters are mutually exclusive: `gcs_uri`, `conversation_list`, `csv_content`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param csv_content [::String]
              #     Raw bytes representing the csv file with the evaluations structure.
              #
              #     Note: The following parameters are mutually exclusive: `csv_content`, `conversation_list`, `gcs_uri`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The app to import the evaluations into.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param import_options [::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest::ImportOptions, ::Hash]
              #     Optional. Options governing the import process for the evaluations.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ImportEvaluationsRequest.new
              #
              #   # Call the import_evaluations method.
              #   result = client.import_evaluations request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_evaluations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_evaluations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_evaluations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_evaluations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.import_evaluations request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an evaluation dataset.
              #
              # @overload create_evaluation_dataset(request, options = nil)
              #   Pass arguments to `create_evaluation_dataset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_evaluation_dataset(parent: nil, evaluation_dataset_id: nil, evaluation_dataset: nil)
              #   Pass arguments to `create_evaluation_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The app to create the evaluation for.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param evaluation_dataset_id [::String]
              #     Optional. The ID to use for the evaluation dataset, which will become the
              #     final component of the evaluation dataset's resource name. If not provided,
              #     a unique ID will be automatically assigned for the evaluation.
              #   @param evaluation_dataset [::Google::Cloud::Ces::V1beta::EvaluationDataset, ::Hash]
              #     Required. The evaluation dataset to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationDataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationDataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest.new
              #
              #   # Call the create_evaluation_dataset method.
              #   result = client.create_evaluation_dataset request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationDataset.
              #   p result
              #
              def create_evaluation_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_evaluation_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_evaluation_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_evaluation_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.create_evaluation_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an evaluation.
              #
              # @overload update_evaluation(request, options = nil)
              #   Pass arguments to `update_evaluation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_evaluation(evaluation: nil, update_mask: nil)
              #   Pass arguments to `update_evaluation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param evaluation [::Google::Cloud::Ces::V1beta::Evaluation, ::Hash]
              #     Required. The evaluation to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Evaluation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Evaluation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateEvaluationRequest.new
              #
              #   # Call the update_evaluation method.
              #   result = client.update_evaluation request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Evaluation.
              #   p result
              #
              def update_evaluation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_evaluation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_evaluation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_evaluation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.update_evaluation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an evaluation dataset.
              #
              # @overload update_evaluation_dataset(request, options = nil)
              #   Pass arguments to `update_evaluation_dataset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_evaluation_dataset(evaluation_dataset: nil, update_mask: nil)
              #   Pass arguments to `update_evaluation_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param evaluation_dataset [::Google::Cloud::Ces::V1beta::EvaluationDataset, ::Hash]
              #     Required. The evaluation dataset to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationDataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationDataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest.new
              #
              #   # Call the update_evaluation_dataset method.
              #   result = client.update_evaluation_dataset request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationDataset.
              #   p result
              #
              def update_evaluation_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_evaluation_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_evaluation_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_evaluation_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.update_evaluation_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an evaluation.
              #
              # @overload delete_evaluation(request, options = nil)
              #   Pass arguments to `delete_evaluation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_evaluation(name: nil, force: nil, etag: nil)
              #   Pass arguments to `delete_evaluation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation to delete.
              #   @param force [::Boolean]
              #     Optional. Indicates whether to forcefully delete the evaluation, even if it
              #     is still referenced by evaluation datasets.
              #
              #     *  If `force = false`, the deletion will fail if any datasets still
              #     reference the evaluation.
              #     *  If `force = true`, all existing references from datasets will be removed
              #     and the evaluation will be deleted.
              #   @param etag [::String]
              #     Optional. The current etag of the evaluation. If an etag is not provided,
              #     the deletion will overwrite any concurrent changes. If an etag is provided
              #     and does not match the current etag of the evaluation, deletion will be
              #     blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteEvaluationRequest.new
              #
              #   # Call the delete_evaluation method.
              #   result = client.delete_evaluation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_evaluation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_evaluation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_evaluation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_evaluation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.delete_evaluation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an evaluation result.
              #
              # @overload delete_evaluation_result(request, options = nil)
              #   Pass arguments to `delete_evaluation_result` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_evaluation_result(name: nil)
              #   Pass arguments to `delete_evaluation_result` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation result to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest.new
              #
              #   # Call the delete_evaluation_result method.
              #   result = client.delete_evaluation_result request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_evaluation_result request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_evaluation_result.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_evaluation_result.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_evaluation_result.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.delete_evaluation_result request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an evaluation dataset.
              #
              # @overload delete_evaluation_dataset(request, options = nil)
              #   Pass arguments to `delete_evaluation_dataset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_evaluation_dataset(name: nil, etag: nil)
              #   Pass arguments to `delete_evaluation_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation dataset to delete.
              #   @param etag [::String]
              #     Optional. The current etag of the evaluation dataset. If an etag is not
              #     provided, the deletion will overwrite any concurrent changes. If an etag is
              #     provided and does not match the current etag of the evaluation dataset,
              #     deletion will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest.new
              #
              #   # Call the delete_evaluation_dataset method.
              #   result = client.delete_evaluation_dataset request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_evaluation_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_evaluation_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_evaluation_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_evaluation_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.delete_evaluation_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an evaluation run.
              #
              # @overload delete_evaluation_run(request, options = nil)
              #   Pass arguments to `delete_evaluation_run` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_evaluation_run(name: nil)
              #   Pass arguments to `delete_evaluation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation run to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest.new
              #
              #   # Call the delete_evaluation_run method.
              #   result = client.delete_evaluation_run request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_evaluation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_evaluation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_evaluation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_evaluation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.delete_evaluation_run request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified evaluation.
              #
              # @overload get_evaluation(request, options = nil)
              #   Pass arguments to `get_evaluation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetEvaluationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetEvaluationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_evaluation(name: nil)
              #   Pass arguments to `get_evaluation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::Evaluation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::Evaluation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetEvaluationRequest.new
              #
              #   # Call the get_evaluation method.
              #   result = client.get_evaluation request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::Evaluation.
              #   p result
              #
              def get_evaluation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetEvaluationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_evaluation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_evaluation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_evaluation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.get_evaluation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified evaluation result.
              #
              # @overload get_evaluation_result(request, options = nil)
              #   Pass arguments to `get_evaluation_result` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_evaluation_result(name: nil)
              #   Pass arguments to `get_evaluation_result` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation result to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationResult]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationResult]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetEvaluationResultRequest.new
              #
              #   # Call the get_evaluation_result method.
              #   result = client.get_evaluation_result request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationResult.
              #   p result
              #
              def get_evaluation_result request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_evaluation_result.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_evaluation_result.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_evaluation_result.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.get_evaluation_result request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified evaluation dataset.
              #
              # @overload get_evaluation_dataset(request, options = nil)
              #   Pass arguments to `get_evaluation_dataset` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_evaluation_dataset(name: nil)
              #   Pass arguments to `get_evaluation_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation dataset to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationDataset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationDataset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest.new
              #
              #   # Call the get_evaluation_dataset method.
              #   result = client.get_evaluation_dataset request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationDataset.
              #   p result
              #
              def get_evaluation_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_evaluation_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_evaluation_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_evaluation_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.get_evaluation_dataset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified evaluation run.
              #
              # @overload get_evaluation_run(request, options = nil)
              #   Pass arguments to `get_evaluation_run` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_evaluation_run(name: nil)
              #   Pass arguments to `get_evaluation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation run to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetEvaluationRunRequest.new
              #
              #   # Call the get_evaluation_run method.
              #   result = client.get_evaluation_run request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationRun.
              #   p result
              #
              def get_evaluation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_evaluation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_evaluation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_evaluation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.get_evaluation_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all evaluations in the given app.
              #
              # @overload list_evaluations(request, options = nil)
              #   Pass arguments to `list_evaluations` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListEvaluationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListEvaluationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_evaluations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, last_ten_results: nil)
              #   Pass arguments to `list_evaluations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list evaluations from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListEvaluationsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client#list_evaluations EvaluationService.ListEvaluations}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the evaluations.
              #     See https://google.aip.dev/160 for more details.
              #     Currently supports filtering by the following fields:
              #     * evaluation_datasets, using the evaluation dataset ID in the format
              #       evaluation_datasets:evaluation_dataset_id.
              #     * tags, using the tag in the format tags:tag.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time", and
              #     "update_time" are supported. Time fields are ordered in descending order,
              #     and the name field is ordered in ascending order. If not included,
              #     "update_time" will be the default. See https://google.aip.dev/132#ordering
              #     for more details.
              #   @param last_ten_results [::Boolean]
              #     Optional. Whether to include the last 10 evaluation results for each
              #     evaluation in the response.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Evaluation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::Evaluation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListEvaluationsRequest.new
              #
              #   # Call the list_evaluations method.
              #   result = client.list_evaluations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::Evaluation.
              #     p item
              #   end
              #
              def list_evaluations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListEvaluationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_evaluations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_evaluations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_evaluations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.list_evaluations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @evaluation_service_stub, :list_evaluations, "evaluations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all evaluation results for a given evaluation.
              #
              # @overload list_evaluation_results(request, options = nil)
              #   Pass arguments to `list_evaluation_results` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_evaluation_results(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_evaluation_results` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the evaluation to list evaluation results
              #     from. To filter by evaluation run, use `-` as the evaluation ID and specify
              #     the evaluation run ID in the filter. For example:
              #     `projects/{project}/locations/{location}/apps/{app}/evaluations/-`
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListEvaluationResultsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client#list_evaluation_results EvaluationService.ListEvaluationResults}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the evaluation results.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time", and
              #     "update_time" are supported. Time fields are ordered in descending order,
              #     and the name field is ordered in ascending order. If not included,
              #     "update_time" will be the default. See https://google.aip.dev/132#ordering
              #     for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationResult>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationResult>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest.new
              #
              #   # Call the list_evaluation_results method.
              #   result = client.list_evaluation_results request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::EvaluationResult.
              #     p item
              #   end
              #
              def list_evaluation_results request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_evaluation_results.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_evaluation_results.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_evaluation_results.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.list_evaluation_results request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @evaluation_service_stub, :list_evaluation_results, "evaluation_results", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all evaluation datasets in the given app.
              #
              # @overload list_evaluation_datasets(request, options = nil)
              #   Pass arguments to `list_evaluation_datasets` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_evaluation_datasets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_evaluation_datasets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list evaluation datasets from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client#list_evaluation_datasets EvaluationService.ListEvaluationDatasets}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the evaluation datasets.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time", and
              #     "update_time" are supported. Time fields are ordered in descending order,
              #     and the name field is ordered in ascending order. If not included,
              #     "update_time" will be the default. See https://google.aip.dev/132#ordering
              #     for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationDataset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationDataset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest.new
              #
              #   # Call the list_evaluation_datasets method.
              #   result = client.list_evaluation_datasets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::EvaluationDataset.
              #     p item
              #   end
              #
              def list_evaluation_datasets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_evaluation_datasets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_evaluation_datasets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_evaluation_datasets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.list_evaluation_datasets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @evaluation_service_stub, :list_evaluation_datasets, "evaluation_datasets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all evaluation runs in the given app.
              #
              # @overload list_evaluation_runs(request, options = nil)
              #   Pass arguments to `list_evaluation_runs` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_evaluation_runs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_evaluation_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list evaluation runs from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListEvaluationRunsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client#list_evaluation_runs EvaluationService.ListEvaluationRuns}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the evaluation runs.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time", and
              #     "update_time" are supported. Time fields are ordered in descending order,
              #     and the name field is ordered in ascending order. If not included,
              #     "update_time" will be the default. See https://google.aip.dev/132#ordering
              #     for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationRun>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationRun>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest.new
              #
              #   # Call the list_evaluation_runs method.
              #   result = client.list_evaluation_runs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::EvaluationRun.
              #     p item
              #   end
              #
              def list_evaluation_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_evaluation_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_evaluation_runs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_evaluation_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.list_evaluation_runs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @evaluation_service_stub, :list_evaluation_runs, "evaluation_runs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all evaluation expectations in the given app.
              #
              # @overload list_evaluation_expectations(request, options = nil)
              #   Pass arguments to `list_evaluation_expectations` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_evaluation_expectations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_evaluation_expectations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list evaluation expectations
              #     from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client#list_evaluation_expectations EvaluationService.ListEvaluationExpectations}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the evaluation expectations.
              #     See https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. Only "name" and "create_time", and
              #     "update_time" are supported. Time fields are ordered in descending order,
              #     and the name field is ordered in ascending order. If not included,
              #     "update_time" will be the default. See https://google.aip.dev/132#ordering
              #     for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationExpectation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::EvaluationExpectation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest.new
              #
              #   # Call the list_evaluation_expectations method.
              #   result = client.list_evaluation_expectations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::EvaluationExpectation.
              #     p item
              #   end
              #
              def list_evaluation_expectations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_evaluation_expectations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_evaluation_expectations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_evaluation_expectations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.list_evaluation_expectations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @evaluation_service_stub, :list_evaluation_expectations, "evaluation_expectations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified evaluation expectation.
              #
              # @overload get_evaluation_expectation(request, options = nil)
              #   Pass arguments to `get_evaluation_expectation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_evaluation_expectation(name: nil)
              #   Pass arguments to `get_evaluation_expectation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation expectation to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest.new
              #
              #   # Call the get_evaluation_expectation method.
              #   result = client.get_evaluation_expectation request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationExpectation.
              #   p result
              #
              def get_evaluation_expectation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_evaluation_expectation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_evaluation_expectation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_evaluation_expectation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.get_evaluation_expectation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an evaluation expectation.
              #
              # @overload create_evaluation_expectation(request, options = nil)
              #   Pass arguments to `create_evaluation_expectation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_evaluation_expectation(parent: nil, evaluation_expectation_id: nil, evaluation_expectation: nil)
              #   Pass arguments to `create_evaluation_expectation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The app to create the evaluation expectation for.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param evaluation_expectation_id [::String]
              #     Optional. The ID to use for the evaluation expectation, which will become
              #     the final component of the evaluation expectation's resource name. If not
              #     provided, a unique ID will be automatically assigned for the evaluation
              #     expectation.
              #   @param evaluation_expectation [::Google::Cloud::Ces::V1beta::EvaluationExpectation, ::Hash]
              #     Required. The evaluation expectation to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest.new
              #
              #   # Call the create_evaluation_expectation method.
              #   result = client.create_evaluation_expectation request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationExpectation.
              #   p result
              #
              def create_evaluation_expectation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_evaluation_expectation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_evaluation_expectation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_evaluation_expectation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.create_evaluation_expectation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an evaluation expectation.
              #
              # @overload update_evaluation_expectation(request, options = nil)
              #   Pass arguments to `update_evaluation_expectation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_evaluation_expectation(evaluation_expectation: nil, update_mask: nil)
              #   Pass arguments to `update_evaluation_expectation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param evaluation_expectation [::Google::Cloud::Ces::V1beta::EvaluationExpectation, ::Hash]
              #     Required. The evaluation expectation to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest.new
              #
              #   # Call the update_evaluation_expectation method.
              #   result = client.update_evaluation_expectation request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::EvaluationExpectation.
              #   p result
              #
              def update_evaluation_expectation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_evaluation_expectation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_evaluation_expectation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_evaluation_expectation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.update_evaluation_expectation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an evaluation expectation.
              #
              # @overload delete_evaluation_expectation(request, options = nil)
              #   Pass arguments to `delete_evaluation_expectation` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_evaluation_expectation(name: nil, etag: nil)
              #   Pass arguments to `delete_evaluation_expectation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the evaluation expectation to delete.
              #   @param etag [::String]
              #     Optional. The current etag of the evaluation expectation. If an etag is not
              #     provided, the deletion will overwrite any concurrent changes. If an etag is
              #     provided and does not match the current etag of the evaluation expectation,
              #     deletion will be blocked and an ABORTED error will be returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest.new
              #
              #   # Call the delete_evaluation_expectation method.
              #   result = client.delete_evaluation_expectation request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_evaluation_expectation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_evaluation_expectation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_evaluation_expectation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_evaluation_expectation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.delete_evaluation_expectation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a scheduled evaluation run.
              #
              # @overload create_scheduled_evaluation_run(request, options = nil)
              #   Pass arguments to `create_scheduled_evaluation_run` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_scheduled_evaluation_run(parent: nil, scheduled_evaluation_run_id: nil, scheduled_evaluation_run: nil)
              #   Pass arguments to `create_scheduled_evaluation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The app to create the scheduled evaluation run for.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param scheduled_evaluation_run_id [::String]
              #     Optional. The ID to use for the scheduled evaluation run, which will become
              #     the final component of the scheduled evaluation run's resource name. If not
              #     provided, a unique ID will be automatically assigned.
              #   @param scheduled_evaluation_run [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun, ::Hash]
              #     Required. The scheduled evaluation run to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest.new
              #
              #   # Call the create_scheduled_evaluation_run method.
              #   result = client.create_scheduled_evaluation_run request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.
              #   p result
              #
              def create_scheduled_evaluation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_scheduled_evaluation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_scheduled_evaluation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_scheduled_evaluation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.create_scheduled_evaluation_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of the specified scheduled evaluation run.
              #
              # @overload get_scheduled_evaluation_run(request, options = nil)
              #   Pass arguments to `get_scheduled_evaluation_run` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_scheduled_evaluation_run(name: nil)
              #   Pass arguments to `get_scheduled_evaluation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the scheduled evaluation run to retrieve.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest.new
              #
              #   # Call the get_scheduled_evaluation_run method.
              #   result = client.get_scheduled_evaluation_run request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.
              #   p result
              #
              def get_scheduled_evaluation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_scheduled_evaluation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_scheduled_evaluation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_scheduled_evaluation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.get_scheduled_evaluation_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all scheduled evaluation runs in the given app.
              #
              # @overload list_scheduled_evaluation_runs(request, options = nil)
              #   Pass arguments to `list_scheduled_evaluation_runs` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_scheduled_evaluation_runs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_scheduled_evaluation_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the app to list scheduled evaluation runs
              #     from.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. The
              #     {::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsResponse#next_page_token next_page_token}
              #     value returned from a previous list
              #     {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client#list_scheduled_evaluation_runs EvaluationService.ListScheduledEvaluationRuns}
              #     call.
              #   @param filter [::String]
              #     Optional. Filter to be applied when listing the scheduled evaluation runs.
              #     See https://google.aip.dev/160 for more details.
              #     Currently supports filtering by:
              #     * request.evaluations:evaluation_id
              #     * request.evaluation_dataset:evaluation_dataset_id
              #   @param order_by [::String]
              #     Optional. Field to sort by. Supported fields are:
              #     "name" (ascending), "create_time" (descending), "update_time" (descending),
              #     "next_scheduled_execution" (ascending), and
              #     "last_completed_run.create_time" (descending).
              #     If not included, "update_time" will be the default.
              #     See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest.new
              #
              #   # Call the list_scheduled_evaluation_runs method.
              #   result = client.list_scheduled_evaluation_runs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.
              #     p item
              #   end
              #
              def list_scheduled_evaluation_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_scheduled_evaluation_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_scheduled_evaluation_runs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_scheduled_evaluation_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.list_scheduled_evaluation_runs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @evaluation_service_stub, :list_scheduled_evaluation_runs, "scheduled_evaluation_runs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a scheduled evaluation run.
              #
              # @overload update_scheduled_evaluation_run(request, options = nil)
              #   Pass arguments to `update_scheduled_evaluation_run` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_scheduled_evaluation_run(scheduled_evaluation_run: nil, update_mask: nil)
              #   Pass arguments to `update_scheduled_evaluation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param scheduled_evaluation_run [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun, ::Hash]
              #     Required. The scheduled evaluation run to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to control which fields get updated. If the
              #     mask is not present, all fields will be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest.new
              #
              #   # Call the update_scheduled_evaluation_run method.
              #   result = client.update_scheduled_evaluation_run request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.
              #   p result
              #
              def update_scheduled_evaluation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_scheduled_evaluation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_scheduled_evaluation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_scheduled_evaluation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.update_scheduled_evaluation_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a scheduled evaluation run.
              #
              # @overload delete_scheduled_evaluation_run(request, options = nil)
              #   Pass arguments to `delete_scheduled_evaluation_run` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_scheduled_evaluation_run(name: nil, etag: nil)
              #   Pass arguments to `delete_scheduled_evaluation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the scheduled evaluation run to delete.
              #   @param etag [::String]
              #     Optional. The etag of the ScheduledEvaluationRun.
              #     If provided, it must match the server's etag.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest.new
              #
              #   # Call the delete_scheduled_evaluation_run method.
              #   result = client.delete_scheduled_evaluation_run request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_scheduled_evaluation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_scheduled_evaluation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_scheduled_evaluation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_scheduled_evaluation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.delete_scheduled_evaluation_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Tests the voice of a persona. Also accepts a default persona.
              #
              # @overload test_persona_voice(request, options = nil)
              #   Pass arguments to `test_persona_voice` via a request object, either of type
              #   {::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_persona_voice(app: nil, persona_id: nil, text: nil)
              #   Pass arguments to `test_persona_voice` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param app [::String]
              #     Required. the resource name of the app to test the persona voice for.
              #     Format:
              #     `projects/{project}/locations/{location}/apps/{app}`
              #   @param persona_id [::String]
              #     Required. The persona ID to test the voice for. Also accepts "default".
              #   @param text [::String]
              #     Required. The text to test the voice for.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Ces::V1beta::TestPersonaVoiceResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Ces::V1beta::TestPersonaVoiceResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/ces/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest.new
              #
              #   # Call the test_persona_voice method.
              #   result = client.test_persona_voice request
              #
              #   # The returned object is of type Google::Cloud::Ces::V1beta::TestPersonaVoiceResponse.
              #   p result
              #
              def test_persona_voice request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_persona_voice.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Ces::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_persona_voice.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_persona_voice.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @evaluation_service_stub.test_persona_voice request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the EvaluationService REST API.
              #
              # This class represents the configuration for EvaluationService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # run_evaluation to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.run_evaluation.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.run_evaluation.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "ces.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the EvaluationService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `run_evaluation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_evaluation
                  ##
                  # RPC-specific configuration for `create_evaluation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_evaluation
                  ##
                  # RPC-specific configuration for `generate_evaluation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_evaluation
                  ##
                  # RPC-specific configuration for `import_evaluations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_evaluations
                  ##
                  # RPC-specific configuration for `create_evaluation_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_evaluation_dataset
                  ##
                  # RPC-specific configuration for `update_evaluation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_evaluation
                  ##
                  # RPC-specific configuration for `update_evaluation_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_evaluation_dataset
                  ##
                  # RPC-specific configuration for `delete_evaluation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_evaluation
                  ##
                  # RPC-specific configuration for `delete_evaluation_result`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_evaluation_result
                  ##
                  # RPC-specific configuration for `delete_evaluation_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_evaluation_dataset
                  ##
                  # RPC-specific configuration for `delete_evaluation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_evaluation_run
                  ##
                  # RPC-specific configuration for `get_evaluation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_evaluation
                  ##
                  # RPC-specific configuration for `get_evaluation_result`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_evaluation_result
                  ##
                  # RPC-specific configuration for `get_evaluation_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_evaluation_dataset
                  ##
                  # RPC-specific configuration for `get_evaluation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_evaluation_run
                  ##
                  # RPC-specific configuration for `list_evaluations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_evaluations
                  ##
                  # RPC-specific configuration for `list_evaluation_results`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_evaluation_results
                  ##
                  # RPC-specific configuration for `list_evaluation_datasets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_evaluation_datasets
                  ##
                  # RPC-specific configuration for `list_evaluation_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_evaluation_runs
                  ##
                  # RPC-specific configuration for `list_evaluation_expectations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_evaluation_expectations
                  ##
                  # RPC-specific configuration for `get_evaluation_expectation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_evaluation_expectation
                  ##
                  # RPC-specific configuration for `create_evaluation_expectation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_evaluation_expectation
                  ##
                  # RPC-specific configuration for `update_evaluation_expectation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_evaluation_expectation
                  ##
                  # RPC-specific configuration for `delete_evaluation_expectation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_evaluation_expectation
                  ##
                  # RPC-specific configuration for `create_scheduled_evaluation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_scheduled_evaluation_run
                  ##
                  # RPC-specific configuration for `get_scheduled_evaluation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_scheduled_evaluation_run
                  ##
                  # RPC-specific configuration for `list_scheduled_evaluation_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_scheduled_evaluation_runs
                  ##
                  # RPC-specific configuration for `update_scheduled_evaluation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_scheduled_evaluation_run
                  ##
                  # RPC-specific configuration for `delete_scheduled_evaluation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_scheduled_evaluation_run
                  ##
                  # RPC-specific configuration for `test_persona_voice`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_persona_voice

                  # @private
                  def initialize parent_rpcs = nil
                    run_evaluation_config = parent_rpcs.run_evaluation if parent_rpcs.respond_to? :run_evaluation
                    @run_evaluation = ::Gapic::Config::Method.new run_evaluation_config
                    create_evaluation_config = parent_rpcs.create_evaluation if parent_rpcs.respond_to? :create_evaluation
                    @create_evaluation = ::Gapic::Config::Method.new create_evaluation_config
                    generate_evaluation_config = parent_rpcs.generate_evaluation if parent_rpcs.respond_to? :generate_evaluation
                    @generate_evaluation = ::Gapic::Config::Method.new generate_evaluation_config
                    import_evaluations_config = parent_rpcs.import_evaluations if parent_rpcs.respond_to? :import_evaluations
                    @import_evaluations = ::Gapic::Config::Method.new import_evaluations_config
                    create_evaluation_dataset_config = parent_rpcs.create_evaluation_dataset if parent_rpcs.respond_to? :create_evaluation_dataset
                    @create_evaluation_dataset = ::Gapic::Config::Method.new create_evaluation_dataset_config
                    update_evaluation_config = parent_rpcs.update_evaluation if parent_rpcs.respond_to? :update_evaluation
                    @update_evaluation = ::Gapic::Config::Method.new update_evaluation_config
                    update_evaluation_dataset_config = parent_rpcs.update_evaluation_dataset if parent_rpcs.respond_to? :update_evaluation_dataset
                    @update_evaluation_dataset = ::Gapic::Config::Method.new update_evaluation_dataset_config
                    delete_evaluation_config = parent_rpcs.delete_evaluation if parent_rpcs.respond_to? :delete_evaluation
                    @delete_evaluation = ::Gapic::Config::Method.new delete_evaluation_config
                    delete_evaluation_result_config = parent_rpcs.delete_evaluation_result if parent_rpcs.respond_to? :delete_evaluation_result
                    @delete_evaluation_result = ::Gapic::Config::Method.new delete_evaluation_result_config
                    delete_evaluation_dataset_config = parent_rpcs.delete_evaluation_dataset if parent_rpcs.respond_to? :delete_evaluation_dataset
                    @delete_evaluation_dataset = ::Gapic::Config::Method.new delete_evaluation_dataset_config
                    delete_evaluation_run_config = parent_rpcs.delete_evaluation_run if parent_rpcs.respond_to? :delete_evaluation_run
                    @delete_evaluation_run = ::Gapic::Config::Method.new delete_evaluation_run_config
                    get_evaluation_config = parent_rpcs.get_evaluation if parent_rpcs.respond_to? :get_evaluation
                    @get_evaluation = ::Gapic::Config::Method.new get_evaluation_config
                    get_evaluation_result_config = parent_rpcs.get_evaluation_result if parent_rpcs.respond_to? :get_evaluation_result
                    @get_evaluation_result = ::Gapic::Config::Method.new get_evaluation_result_config
                    get_evaluation_dataset_config = parent_rpcs.get_evaluation_dataset if parent_rpcs.respond_to? :get_evaluation_dataset
                    @get_evaluation_dataset = ::Gapic::Config::Method.new get_evaluation_dataset_config
                    get_evaluation_run_config = parent_rpcs.get_evaluation_run if parent_rpcs.respond_to? :get_evaluation_run
                    @get_evaluation_run = ::Gapic::Config::Method.new get_evaluation_run_config
                    list_evaluations_config = parent_rpcs.list_evaluations if parent_rpcs.respond_to? :list_evaluations
                    @list_evaluations = ::Gapic::Config::Method.new list_evaluations_config
                    list_evaluation_results_config = parent_rpcs.list_evaluation_results if parent_rpcs.respond_to? :list_evaluation_results
                    @list_evaluation_results = ::Gapic::Config::Method.new list_evaluation_results_config
                    list_evaluation_datasets_config = parent_rpcs.list_evaluation_datasets if parent_rpcs.respond_to? :list_evaluation_datasets
                    @list_evaluation_datasets = ::Gapic::Config::Method.new list_evaluation_datasets_config
                    list_evaluation_runs_config = parent_rpcs.list_evaluation_runs if parent_rpcs.respond_to? :list_evaluation_runs
                    @list_evaluation_runs = ::Gapic::Config::Method.new list_evaluation_runs_config
                    list_evaluation_expectations_config = parent_rpcs.list_evaluation_expectations if parent_rpcs.respond_to? :list_evaluation_expectations
                    @list_evaluation_expectations = ::Gapic::Config::Method.new list_evaluation_expectations_config
                    get_evaluation_expectation_config = parent_rpcs.get_evaluation_expectation if parent_rpcs.respond_to? :get_evaluation_expectation
                    @get_evaluation_expectation = ::Gapic::Config::Method.new get_evaluation_expectation_config
                    create_evaluation_expectation_config = parent_rpcs.create_evaluation_expectation if parent_rpcs.respond_to? :create_evaluation_expectation
                    @create_evaluation_expectation = ::Gapic::Config::Method.new create_evaluation_expectation_config
                    update_evaluation_expectation_config = parent_rpcs.update_evaluation_expectation if parent_rpcs.respond_to? :update_evaluation_expectation
                    @update_evaluation_expectation = ::Gapic::Config::Method.new update_evaluation_expectation_config
                    delete_evaluation_expectation_config = parent_rpcs.delete_evaluation_expectation if parent_rpcs.respond_to? :delete_evaluation_expectation
                    @delete_evaluation_expectation = ::Gapic::Config::Method.new delete_evaluation_expectation_config
                    create_scheduled_evaluation_run_config = parent_rpcs.create_scheduled_evaluation_run if parent_rpcs.respond_to? :create_scheduled_evaluation_run
                    @create_scheduled_evaluation_run = ::Gapic::Config::Method.new create_scheduled_evaluation_run_config
                    get_scheduled_evaluation_run_config = parent_rpcs.get_scheduled_evaluation_run if parent_rpcs.respond_to? :get_scheduled_evaluation_run
                    @get_scheduled_evaluation_run = ::Gapic::Config::Method.new get_scheduled_evaluation_run_config
                    list_scheduled_evaluation_runs_config = parent_rpcs.list_scheduled_evaluation_runs if parent_rpcs.respond_to? :list_scheduled_evaluation_runs
                    @list_scheduled_evaluation_runs = ::Gapic::Config::Method.new list_scheduled_evaluation_runs_config
                    update_scheduled_evaluation_run_config = parent_rpcs.update_scheduled_evaluation_run if parent_rpcs.respond_to? :update_scheduled_evaluation_run
                    @update_scheduled_evaluation_run = ::Gapic::Config::Method.new update_scheduled_evaluation_run_config
                    delete_scheduled_evaluation_run_config = parent_rpcs.delete_scheduled_evaluation_run if parent_rpcs.respond_to? :delete_scheduled_evaluation_run
                    @delete_scheduled_evaluation_run = ::Gapic::Config::Method.new delete_scheduled_evaluation_run_config
                    test_persona_voice_config = parent_rpcs.test_persona_voice if parent_rpcs.respond_to? :test_persona_voice
                    @test_persona_voice = ::Gapic::Config::Method.new test_persona_voice_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
