# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        module SessionService
          # Path helper methods for the SessionService API.
          module Paths
            ##
            # Create a fully-qualified Agent resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param agent [String]
            #
            # @return [::String]
            def agent_path project:, location:, app:, agent:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/agents/#{agent}"
            end

            ##
            # Create a fully-qualified Session resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/sessions/{session}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param session [String]
            #
            # @return [::String]
            def session_path project:, location:, app:, session:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/sessions/#{session}"
            end

            ##
            # Create a fully-qualified Tool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param tool [String]
            #
            # @return [::String]
            def tool_path project:, location:, app:, tool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/tools/#{tool}"
            end

            ##
            # Create a fully-qualified Toolset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
            #
            # @param project [String]
            # @param location [String]
            # @param app [String]
            # @param toolset [String]
            #
            # @return [::String]
            def toolset_path project:, location:, app:, toolset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "app cannot contain /" if app.to_s.include? "/"

              "projects/#{project}/locations/#{location}/apps/#{app}/toolsets/#{toolset}"
            end

            extend self
          end
        end
      end
    end
  end
end
