# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/ces/v1beta/version"

require "google/cloud/ces/v1beta/tool_service/credentials"
require "google/cloud/ces/v1beta/tool_service/paths"
require "google/cloud/ces/v1beta/tool_service/client"
require "google/cloud/ces/v1beta/tool_service/rest"

module Google
  module Cloud
    module Ces
      module V1beta
        ##
        # Tool service provides APIs for interacting with CES tools.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/ces/v1beta/tool_service"
        #     client = ::Google::Cloud::Ces::V1beta::ToolService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/ces/v1beta/tool_service/rest"
        #     client = ::Google::Cloud::Ces::V1beta::ToolService::Rest::Client.new
        #
        module ToolService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "tool_service", "helpers.rb"
require "google/cloud/ces/v1beta/tool_service/helpers" if ::File.file? helper_path
