# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_apps AgentService.ListApps}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to list apps from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListAppsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_apps AgentService.ListApps}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the apps.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListAppsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_apps AgentService.ListApps}.
        # @!attribute [rw] apps
        #   @return [::Array<::Google::Cloud::Ces::V1beta::App>]
        #     The list of apps.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListAppsRequest#page_token ListAppsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListAppsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_app AgentService.GetApp}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the app to retrieve.
        class GetAppRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_app AgentService.CreateApp}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to create an app in.
        # @!attribute [rw] app_id
        #   @return [::String]
        #     Optional. The ID to use for the app, which will become the final component
        #     of the app's resource name. If not provided, a unique ID will be
        #     automatically assigned for the app.
        # @!attribute [rw] app
        #   @return [::Google::Cloud::Ces::V1beta::App]
        #     Required. The app to create.
        class CreateAppRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#update_app AgentService.UpdateApp}.
        # @!attribute [rw] app
        #   @return [::Google::Cloud::Ces::V1beta::App]
        #     Required. The app to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateAppRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_app AgentService.DeleteApp}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the app to delete.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the app. If an etag is not provided, the
        #     deletion will overwrite any concurrent changes. If an etag is provided and
        #     does not match the current etag of the app, deletion will be blocked and an
        #     ABORTED error will be returned.
        class DeleteAppRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#export_app AgentService.ExportApp}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the app to export.
        # @!attribute [rw] export_format
        #   @return [::Google::Cloud::Ces::V1beta::ExportAppRequest::ExportFormat]
        #     Required. The format to export the app in.
        # @!attribute [rw] gcs_uri
        #   @return [::String]
        #     Optional. The [Google Cloud
        #     Storage](https://cloud.google.com/storage/docs/) URI to which to export the
        #     app. The format of this URI must be `gs://<bucket-name>/<object-name>`. The
        #     exported app archive will be written directly to the specified GCS object.
        class ExportAppRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Export format for the app.
          module ExportFormat
            # The export format is unspecified.
            EXPORT_FORMAT_UNSPECIFIED = 0

            # The export format is JSON.
            JSON = 1

            # The export format is YAML.
            YAML = 2
          end
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#export_app AgentService.ExportApp}.
        # @!attribute [rw] app_content
        #   @return [::String]
        #     App folder compressed as a zip file.
        #
        #     Note: The following fields are mutually exclusive: `app_content`, `app_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] app_uri
        #   @return [::String]
        #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
        #     to which the app was exported.
        #
        #     Note: The following fields are mutually exclusive: `app_uri`, `app_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ExportAppResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#import_app AgentService.ImportApp}.
        # @!attribute [rw] gcs_uri
        #   @return [::String]
        #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
        #     from which to import app. The format of this URI must be
        #     `gs://<bucket-name>/<object-name>`.
        #
        #     Note: The following fields are mutually exclusive: `gcs_uri`, `app_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] app_content
        #   @return [::String]
        #     Raw bytes representing the compressed zip file with the app folder
        #     structure.
        #
        #     Note: The following fields are mutually exclusive: `app_content`, `gcs_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name with the location of the app to import.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the app to import.
        #     * If the app is created on import, and the display name is specified,
        #     the imported app will use this display name. If a conflict is detected
        #     with an existing app, a timestamp will be appended to the display name
        #     to make it unique.
        #     * If the app is a reimport, this field should not be set. Providing a
        #     display name during reimport will result in an INVALID_ARGUMENT error.
        # @!attribute [rw] app_id
        #   @return [::String]
        #     Optional. The ID to use for the imported app.
        #     *  If not specified, a unique ID will be automatically assigned for
        #     the app.
        #     *  Otherwise, the imported app will use this ID as the final component of
        #     its resource name. If an app with the same ID already exists at the
        #     specified location in the project, the content of the existing app will be
        #     replaced.
        # @!attribute [rw] import_options
        #   @return [::Google::Cloud::Ces::V1beta::ImportAppRequest::ImportOptions]
        #     Optional. Options governing the import process for the app.
        class ImportAppRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration options for the app import process.
          # These options control how the import behaves, particularly when
          # conflicts arise with existing app data.
          # @!attribute [rw] conflict_resolution_strategy
          #   @return [::Google::Cloud::Ces::V1beta::ImportAppRequest::ImportOptions::ConflictResolutionStrategy]
          #     Optional. The strategy to use when resolving conflicts during import.
          class ImportOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the strategy for handling conflicts when an app with the same ID
            # already exists, or when imported resources (like Agents, Tools, etc.)
            # have the same display names as existing resources within that app.
            module ConflictResolutionStrategy
              # The conflict resolution strategy is unspecified.
              CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED = 0

              # Replace existing data with imported data.
              # If an app with the same `app_id` already exists, its content will be
              # updated based on the imported app.
              # - Resources (App, Agents, Tools, Examples, Guardrails, Toolsets) in the
              #   imported app that have the same display name as existing resources
              #   will overwrite the existing ones.
              # - Imported resources with new display names will be created.
              # - Existing resources that do not have a matching display name in the
              #   imported app will remain untouched.
              REPLACE = 1

              # Overwrite existing data with imported data.
              # If an app with the same `app_id` already exists, its content will be
              # overwritten with the imported app.
              # - Existing resources (Agents, Tools, Examples, Guardrails, Toolsets) in
              #   the app will be deleted.
              # - Imported resources will be created as new resources.
              OVERWRITE = 2
            end
          end
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#import_app AgentService.ImportApp}.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the app that was imported.
        # @!attribute [rw] warnings
        #   @return [::Array<::String>]
        #     Warning messages generated during the import process.
        #     If errors occur for specific resources, they will not be included in the
        #     imported app and the error will be mentioned here.
        class ImportAppResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_agents AgentService.ListAgents}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list agents from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListAgentsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_agents AgentService.ListAgents}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the agents.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListAgentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_agents AgentService.ListAgents}.
        # @!attribute [rw] agents
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Agent>]
        #     The list of agents.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListAgentsRequest#page_token ListAgentsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListAgentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_agent AgentService.GetAgent}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the agent to retrieve.
        class GetAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_agent AgentService.CreateAgent}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to create an agent in.
        # @!attribute [rw] agent_id
        #   @return [::String]
        #     Optional. The ID to use for the agent, which will become the final
        #     component of the agent's resource name. If not provided, a unique ID will
        #     be automatically assigned for the agent.
        # @!attribute [rw] agent
        #   @return [::Google::Cloud::Ces::V1beta::Agent]
        #     Required. The agent to create.
        class CreateAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#update_agent AgentService.UpdateAgent}.
        # @!attribute [rw] agent
        #   @return [::Google::Cloud::Ces::V1beta::Agent]
        #     Required. The agent to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_agent AgentService.DeleteAgent}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the agent to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Indicates whether to forcefully delete the agent, even if it is
        #     still referenced by other app/agents/examples.
        #
        #     *  If `force = false`, the deletion fails if other agents/examples
        #     reference it.
        #     *  If `force = true`, delete the agent and remove it from all referencing
        #     apps/agents/examples.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the agent. If an etag is not provided, the
        #     deletion will overwrite any concurrent changes. If an etag is provided and
        #     does not match the current etag of the agent, deletion will be blocked and
        #     an ABORTED error will be returned.
        class DeleteAgentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation of the
        #     operation. Operations that have been cancelled successfully have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of `1`,
        #     corresponding to `Code.CANCELLED`.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_examples AgentService.ListExamples}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list examples from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListExamplesResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_examples AgentService.ListExamples}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the examples.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListExamplesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_examples AgentService.ListExamples}.
        # @!attribute [rw] examples
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Example>]
        #     The list of examples.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListExamplesRequest#page_token ListExamplesRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListExamplesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_example AgentService.GetExample}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the example to retrieve.
        class GetExampleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_example AgentService.CreateExample}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to create an example in.
        # @!attribute [rw] example_id
        #   @return [::String]
        #     Optional. The ID to use for the example, which will become the final
        #     component of the example's resource name. If not provided, a unique ID will
        #     be automatically assigned for the example.
        # @!attribute [rw] example
        #   @return [::Google::Cloud::Ces::V1beta::Example]
        #     Required. The example to create.
        class CreateExampleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#update_example AgentService.UpdateExample}.
        # @!attribute [rw] example
        #   @return [::Google::Cloud::Ces::V1beta::Example]
        #     Required. The example to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateExampleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_example AgentService.DeleteExample}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the example to delete.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the example. If an etag is not provided, the
        #     deletion will overwrite any concurrent changes. If an etag is provided and
        #     does not match the current etag of the example, deletion will be blocked
        #     and an ABORTED error will be returned.
        class DeleteExampleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_tools AgentService.ListTools}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list tools from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListToolsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_tools AgentService.ListTools}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the tools. Use
        #     "include_system_tools=true" to include system tools in the response. See
        #     https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListToolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_tools AgentService.ListTools}.
        # @!attribute [rw] tools
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Tool>]
        #     The list of tools.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListToolsRequest#page_token ListToolsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListToolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_tool AgentService.GetTool}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the tool to retrieve.
        class GetToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_tool AgentService.CreateTool}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to create a tool in.
        # @!attribute [rw] tool_id
        #   @return [::String]
        #     Optional. The ID to use for the tool, which will become the final component
        #     of the tool's resource name. If not provided, a unique ID will be
        #     automatically assigned for the tool.
        # @!attribute [rw] tool
        #   @return [::Google::Cloud::Ces::V1beta::Tool]
        #     Required. The tool to create.
        class CreateToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#update_tool AgentService.UpdateTool}.
        # @!attribute [rw] tool
        #   @return [::Google::Cloud::Ces::V1beta::Tool]
        #     Required. The tool to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_tool AgentService.DeleteTool}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the tool to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Indicates whether to forcefully delete the tool, even if it is
        #     still referenced by agents/examples.
        #
        #     *  If `force = false`, the deletion will fail if any agents still
        #     reference the tool.
        #     *  If `force = true`, all existing references from agents will be removed
        #     and the tool will be deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the tool. If an etag is not provided, the
        #     deletion will overwrite any concurrent changes. If an etag is provided and
        #     does not match the current etag of the tool, deletion will be blocked and
        #     an ABORTED error will be returned.
        class DeleteToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_conversations AgentService.ListConversations}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list conversations from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListConversationsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_conversations AgentService.ListConversations}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the conversations.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::Ces::V1beta::Conversation::Source]
        #     Optional. Indicate the source of the conversation. If not set, Source.Live
        #     will be applied by default.
        class ListConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_conversations AgentService.ListConversations}.
        # @!attribute [rw] conversations
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Conversation>]
        #     The list of conversations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListConversationsRequest#page_token ListConversationsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_conversation AgentService.GetConversation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the conversation to retrieve.
        # @!attribute [rw] source
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Ces::V1beta::Conversation::Source]
        #     Optional. Indicate the source of the conversation. If not set, all source
        #     will be searched.
        class GetConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_conversation AgentService.DeleteConversation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the conversation to delete.
        # @!attribute [rw] source
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Ces::V1beta::Conversation::Source]
        #     Optional. Indicate the source of the conversation. If not set, Source.Live
        #     will be applied by default.
        class DeleteConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#batch_delete_conversations AgentService.BatchDeleteConversations}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to delete conversations from.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] conversations
        #   @return [::Array<::String>]
        #     Required. The resource names of the conversations to delete.
        class BatchDeleteConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#batch_delete_conversations AgentService.BatchDeleteConversations}.
        # @!attribute [rw] deleted_conversations
        #   @return [::Array<::String>]
        #     The list of conversations that were successfully deleted.
        # @!attribute [rw] failed_conversations
        #   @return [::Array<::String>]
        #     The list of conversations that failed to be deleted.
        # @!attribute [rw] error_messages
        #   @return [::Array<::String>]
        #     Optional. A list of error messages associated with conversations that
        #     failed to be deleted.
        class BatchDeleteConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_guardrails AgentService.ListGuardrails}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list guardrails from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListGuardrailsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_guardrails AgentService.ListGuardrails}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the guardrails.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListGuardrailsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_guardrails AgentService.ListGuardrails}.
        # @!attribute [rw] guardrails
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Guardrail>]
        #     The list of guardrails.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListGuardrailsRequest#page_token ListGuardrailsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListGuardrailsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_guardrail AgentService.GetGuardrail}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the guardrail to retrieve.
        class GetGuardrailRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_guardrail AgentService.CreateGuardrail}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to create a guardrail in.
        # @!attribute [rw] guardrail_id
        #   @return [::String]
        #     Optional. The ID to use for the guardrail, which will become the final
        #     component of the guardrail's resource name. If not provided, a unique ID
        #     will be automatically assigned for the guardrail.
        # @!attribute [rw] guardrail
        #   @return [::Google::Cloud::Ces::V1beta::Guardrail]
        #     Required. The guardrail to create.
        class CreateGuardrailRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#update_guardrail AgentService.UpdateGuardrail}.
        # @!attribute [rw] guardrail
        #   @return [::Google::Cloud::Ces::V1beta::Guardrail]
        #     Required. The guardrail to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateGuardrailRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_guardrail AgentService.DeleteGuardrail}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the guardrail to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Indicates whether to forcefully delete the guardrail, even if it
        #     is still referenced by app/agents.
        #
        #     *  If `force = false`, the deletion fails if any apps/agents still
        #     reference the guardrail.
        #     *  If `force = true`, all existing references from apps/agents will be
        #     removed and the guardrail will be deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the guardrail. If an etag is not provided,
        #     the deletion will overwrite any concurrent changes. If an etag is provided
        #     and does not match the current etag of the guardrail, deletion will be
        #     blocked and an ABORTED error will be returned.
        class DeleteGuardrailRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_deployments AgentService.ListDeployments}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent app.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of deployments to return. The service may
        #     return fewer than this value. If unspecified, at most 50 deployments will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDeployments` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListDeployments` must
        #     match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListDeploymentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_deployments AgentService.ListDeployments}.
        # @!attribute [rw] deployments
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Deployment>]
        #     The list of deployments.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDeploymentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_deployment AgentService.GetDeployment}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
        class GetDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_deployment AgentService.CreateDeployment}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent app.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] deployment_id
        #   @return [::String]
        #     Optional. The ID to use for the deployment, which will become the final
        #     component of the deployment's resource name. If not provided, a unique ID
        #     will be automatically assigned for the deployment.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::Ces::V1beta::Deployment]
        #     Required. The deployment to create.
        class CreateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#update_deployment AgentService.UpdateDeployment}.
        # @!attribute [rw] deployment
        #   @return [::Google::Cloud::Ces::V1beta::Deployment]
        #     Required. The deployment to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdateDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_deployment AgentService.DeleteDeployment}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the deployment to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag of the deployment.
        #     If an etag is provided and does not match the current etag of the
        #     deployment, deletion will be blocked and an ABORTED error will be returned.
        class DeleteDeploymentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_toolsets AgentService.ListToolsets}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list toolsets from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListToolsetsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_toolsets AgentService.ListToolsets}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the toolsets.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListToolsetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_toolsets AgentService.ListToolsets}.
        # @!attribute [rw] toolsets
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Toolset>]
        #     The list of toolsets.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListToolsetsRequest#page_token ListToolsetsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListToolsetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_toolset AgentService.GetToolset}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the toolset to retrieve.
        class GetToolsetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_toolset AgentService.CreateToolset}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to create a toolset in.
        # @!attribute [rw] toolset_id
        #   @return [::String]
        #     Optional. The ID to use for the toolset, which will become the final
        #     component of the toolset's resource name. If not provided, a unique ID will
        #     be automatically assigned for the toolset.
        # @!attribute [rw] toolset
        #   @return [::Google::Cloud::Ces::V1beta::Toolset]
        #     Required. The toolset to create.
        class CreateToolsetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#update_toolset AgentService.UpdateToolset}.
        # @!attribute [rw] toolset
        #   @return [::Google::Cloud::Ces::V1beta::Toolset]
        #     Required. The toolset to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateToolsetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_toolset AgentService.DeleteToolset}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the toolset to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Indicates whether to forcefully delete the toolset, even if it is
        #     still referenced by app/agents.
        #
        #     *  If `force = false`, the deletion fails if any agents still
        #     reference the toolset.
        #     *  If `force = true`, all existing references from agents will be
        #     removed and the toolset will be deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the toolset. If an etag is not provided, the
        #     deletion will overwrite any concurrent changes. If an etag is provided and
        #     does not match the current etag of the toolset, deletion will be blocked
        #     and an ABORTED error will be returned.
        class DeleteToolsetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_app_versions AgentService.ListAppVersions}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list app versions from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListAppVersionsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_app_versions AgentService.ListAppVersions}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the app versions.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListAppVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_app_versions AgentService.ListAppVersions}.
        # @!attribute [rw] app_versions
        #   @return [::Array<::Google::Cloud::Ces::V1beta::AppVersion>]
        #     The list of app versions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListAppVersionsRequest#page_token ListAppVersionsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListAppVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_app_version AgentService.GetAppVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the app version to retrieve.
        class GetAppVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#delete_app_version AgentService.DeleteAppVersion}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the app version to delete.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the app version. If an etag is not provided,
        #     the deletion will overwrite any concurrent changes. If an etag is provided
        #     and does not match the current etag of the app version, deletion will be
        #     blocked and an ABORTED error will be returned.
        class DeleteAppVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#create_app_version AgentService.CreateAppVersion}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to create an app version in.
        # @!attribute [rw] app_version_id
        #   @return [::String]
        #     Optional. The ID to use for the app version, which will become the final
        #     component of the app version's resource name. If not provided, a unique ID
        #     will be automatically assigned for the app version.
        # @!attribute [rw] app_version
        #   @return [::Google::Cloud::Ces::V1beta::AppVersion]
        #     Required. The app version to create.
        class CreateAppVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#restore_app_version AgentService.RestoreAppVersion}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the app version to restore.
        class RestoreAppVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#restore_app_version AgentService.RestoreAppVersion}
        class RestoreAppVersionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # [AgentService.GenerateAppResource][google.cloud.ces.v1beta.AgentService.GenerateAppResource].
        # @!attribute [rw] agent
        #   @return [::Google::Cloud::Ces::V1beta::Agent]
        #     Agent generated by the LLM assistant.
        #
        #     Note: The following fields are mutually exclusive: `agent`, `toolset`, `app_snapshot`, `tools`, `evaluations`, `app_resources`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] toolset
        #   @return [::Google::Cloud::Ces::V1beta::Toolset]
        #     Toolset generated by the LLM assistant. Supports Open API toolset schema
        #     generation.
        #
        #     Note: The following fields are mutually exclusive: `toolset`, `agent`, `app_snapshot`, `tools`, `evaluations`, `app_resources`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] app_snapshot
        #   @return [::Google::Cloud::Ces::V1beta::AppSnapshot]
        #     App snapshot generated by the LLM assistant. This snapshot contains the
        #     app, agents & tools generated by the LLM assistant.
        #
        #     Note: The following fields are mutually exclusive: `app_snapshot`, `agent`, `toolset`, `tools`, `evaluations`, `app_resources`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tools
        #   @return [::Google::Cloud::Ces::V1beta::GenerateAppResourceResponse::Tools]
        #     The list of tools generated by the LLM assistant.
        #
        #     Note: The following fields are mutually exclusive: `tools`, `agent`, `toolset`, `app_snapshot`, `evaluations`, `app_resources`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] evaluations
        #   @return [::Google::Cloud::Ces::V1beta::GenerateAppResourceResponse::Evaluations]
        #     Evaluations generated by the LLM assistant.
        #
        #     Note: The following fields are mutually exclusive: `evaluations`, `agent`, `toolset`, `app_snapshot`, `tools`, `app_resources`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] app_resources
        #   @return [::Google::Cloud::Ces::V1beta::GenerateAppResourceResponse::AppResources]
        #     The app resources generated by the LLM assistant.
        #
        #     Note: The following fields are mutually exclusive: `app_resources`, `agent`, `toolset`, `app_snapshot`, `tools`, `evaluations`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generate_result_info
        #   @return [::Google::Cloud::Ces::V1beta::GenerateAppResourceResponse::GenerateResultInfo]
        #     Additional information about the generated result.
        class GenerateAppResourceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The list of evaluations generated by the LLM assistant.
          # @!attribute [rw] evaluations
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation>]
          #     The list of generated evaluations.
          class Evaluations
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The list of tools generated by the LLM assistant.
          # @!attribute [rw] tools
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Tool>]
          #     The list of tools generated by the LLM assistant.
          class Tools
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The list of app resources generated by the LLM assistant.
          # @!attribute [rw] app_snapshot
          #   @return [::Google::Cloud::Ces::V1beta::AppSnapshot]
          #     The app snapshot generated by the LLM assistant. This snapshot contains
          #     the app, agents & tools generated by the LLM assistant.
          # @!attribute [rw] evaluations
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation>]
          #     The list of evaluations generated by the LLM assistant.
          class AppResources
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # This provides additional information about the generated result.
          # @!attribute [rw] explanation
          #   @return [::String]
          #     An explanation of the changes in the generated resource.
          class GenerateResultInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_changelogs AgentService.ListChangelogs}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list changelogs from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListChangelogsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::AgentService::Client#list_changelogs AgentService.ListChangelogs}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the changelogs.
        #     See https://google.aip.dev/160 for more details.
        #
        #     The filter string can be used to filter by `action`, `resource_type`,
        #     `resource_name`, `author`, and `create_time`.
        #     The `:` comparator can be used for case-insensitive partial matching on
        #     string fields, while `=` performs an exact case-sensitive match.
        #
        #     Examples:
        #     * `action:update` (case-insensitive partial match)
        #     * `action="Create"` (case-sensitive exact match)
        #     * `resource_type:agent`
        #     * `resource_name:my-agent`
        #     * `author:me@example.com`
        #     * `create_time > "2025-01-01T00:00:00Z"`
        #     * `create_time <= "2025-01-01T00:00:00Z" AND resource_type:tool`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time" is supported.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListChangelogsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#list_changelogs AgentService.ListChangelogs}.
        # @!attribute [rw] changelogs
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Changelog>]
        #     The list of changelogs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListChangelogsRequest#page_token ListChangelogsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListChangelogsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::AgentService::Client#get_changelog AgentService.GetChangelog}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the changelog to retrieve.
        class GetChangelogRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
