# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Changelogs represent a change made to the app or to an resource within the
        # app.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the changelog.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/changelogs/{changelog}`
        # @!attribute [r] author
        #   @return [::String]
        #     Output only. Email address of the change author.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Display name of the change. It typically should be the display
        #     name of the resource that was changed.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Description of the change. which typically captures the
        #     changed fields in the resource.
        # @!attribute [r] resource
        #   @return [::String]
        #     Output only. The resource that was changed.
        # @!attribute [r] resource_type
        #   @return [::String]
        #     Output only. The type of the resource that was changed.
        # @!attribute [r] action
        #   @return [::String]
        #     Output only. The action that was performed on the resource.
        # @!attribute [r] original_resource
        #   @return [::Google::Protobuf::Struct]
        #     Output only. The original resource before the change.
        # @!attribute [r] new_resource
        #   @return [::Google::Protobuf::Struct]
        #     Output only. The new resource after the change.
        # @!attribute [r] dependent_resources
        #   @return [::Array<::Google::Protobuf::Struct>]
        #     Output only. The dependent resources that were changed.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the change was made.
        # @!attribute [r] sequence_number
        #   @return [::Integer]
        #     Output only. The monotonically increasing sequence number of the changelog.
        class Changelog
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
