# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Configuration of an Action for the tool to use.
        # Note: This can be either an Action or an Operation. See
        # https://cloud.google.com/integration-connectors/docs/entities-operation-action
        # for details.
        # @!attribute [rw] connection_action_id
        #   @return [::String]
        #     ID of a Connection action for the tool to use.
        #
        #     Note: The following fields are mutually exclusive: `connection_action_id`, `entity_operation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] entity_operation
        #   @return [::Google::Cloud::Ces::V1beta::Action::EntityOperation]
        #     Entity operation configuration for the tool to use.
        #
        #     Note: The following fields are mutually exclusive: `entity_operation`, `connection_action_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] input_fields
        #   @return [::Array<::String>]
        #     Optional. Entity fields to use as inputs for the operation.
        #     If no fields are specified, all fields of the Entity will be used.
        # @!attribute [rw] output_fields
        #   @return [::Array<::String>]
        #     Optional. Entity fields to return from the operation.
        #     If no fields are specified, all fields of the Entity will be returned.
        class Action
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Entity CRUD operation specification.
          # @!attribute [rw] entity_id
          #   @return [::String]
          #     Required. ID of the entity.
          # @!attribute [rw] operation
          #   @return [::Google::Cloud::Ces::V1beta::Action::EntityOperation::OperationType]
          #     Required. Operation to perform on the entity.
          class EntityOperation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The operation to perform on the entity.
            module OperationType
              # Operation type unspecified. Invalid, ConnectorTool create/update
              # will fail.
              OPERATION_TYPE_UNSPECIFIED = 0

              # List operation.
              LIST = 1

              # Get operation.
              GET = 2

              # Create operation.
              CREATE = 3

              # Update operation.
              UPDATE = 4

              # Delete operation.
              DELETE = 5
            end
          end
        end

        # A ConnectorTool allows connections to different integrations.
        # See: https://cloud.google.com/integration-connectors/docs/overview.
        # @!attribute [rw] connection
        #   @return [::String]
        #     Required. The full resource name of the referenced Integration Connectors
        #     Connection.
        #     Format:
        #     `projects/{project}/locations/{location}/connections/{connection}`
        # @!attribute [rw] action
        #   @return [::Google::Cloud::Ces::V1beta::Action]
        #     Required. Action for the tool to use.
        # @!attribute [rw] auth_config
        #   @return [::Google::Cloud::Ces::V1beta::EndUserAuthConfig]
        #     Optional. Configures how authentication is handled in Integration
        #     Connectors. By default, an admin authentication is passed in the
        #     Integration Connectors API requests. You can override it with a different
        #     end-user authentication config.
        #     **Note**: The Connection must have authentication override enabled in
        #     order to specify an EUC configuration here - otherwise, the ConnectorTool
        #     creation will fail. See
        #     https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
        #     for details.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The name of the tool that can be used by the Agent to decide
        #     whether to call this ConnectorTool.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the tool that can be used by the Agent to
        #     decide whether to call this ConnectorTool.
        class ConnectorTool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
