# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # A toolset that generates tools from an Integration Connectors Connection.
        # @!attribute [rw] connection
        #   @return [::String]
        #     Required. The full resource name of the referenced Integration Connectors
        #     Connection.
        #     Format:
        #     `projects/{project}/locations/{location}/connections/{connection}`
        # @!attribute [rw] auth_config
        #   @return [::Google::Cloud::Ces::V1beta::EndUserAuthConfig]
        #     Optional. Configures how authentication is handled in Integration
        #     Connectors. By default, an admin authentication is passed in the
        #     Integration Connectors API requests. You can override it with a different
        #     end-user authentication config.
        #     **Note**: The Connection must have authentication override enabled in
        #     order to specify an EUC configuration here - otherwise, the Toolset
        #     creation will fail. See:
        #     https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
        # @!attribute [rw] connector_actions
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Action>]
        #     Required. The list of connector actions/entity operations to generate tools
        #     for.
        class ConnectorToolset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
