# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Aggregated metrics for an evaluation or evaluation dataset.
        # @!attribute [r] metrics_by_app_version
        #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::MetricsByAppVersion>]
        #     Output only. Aggregated metrics, grouped by app version ID.
        class AggregatedMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metrics for a single tool.
          # @!attribute [r] tool
          #   @return [::String]
          #     Output only. The name of the tool.
          # @!attribute [r] pass_count
          #   @return [::Integer]
          #     Output only. The number of times the tool passed.
          # @!attribute [r] fail_count
          #   @return [::Integer]
          #     Output only. The number of times the tool failed.
          class ToolMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metrics for turn latency.
          # @!attribute [r] average_latency
          #   @return [::Google::Protobuf::Duration]
          #     Output only. The average latency of the turns.
          class TurnLatencyMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metrics for tool call latency.
          # @!attribute [r] tool
          #   @return [::String]
          #     Output only. The name of the tool.
          # @!attribute [r] average_latency
          #   @return [::Google::Protobuf::Duration]
          #     Output only. The average latency of the tool calls.
          class ToolCallLatencyMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metrics for semantic similarity results.
          # @!attribute [r] score
          #   @return [::Float]
          #     Output only. The average semantic similarity score (0-4).
          class SemanticSimilarityMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metrics for hallucination results.
          # @!attribute [r] score
          #   @return [::Float]
          #     Output only. The average hallucination score (0 to 1).
          class HallucinationMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metrics aggregated per app version.
          # @!attribute [r] app_version_id
          #   @return [::String]
          #     Output only. The app version ID.
          # @!attribute [r] tool_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::ToolMetrics>]
          #     Output only. Metrics for each tool within this app version.
          # @!attribute [r] semantic_similarity_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::SemanticSimilarityMetrics>]
          #     Output only. Metrics for semantic similarity within this app version.
          # @!attribute [r] hallucination_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::HallucinationMetrics>]
          #     Output only. Metrics for hallucination within this app version.
          # @!attribute [r] tool_call_latency_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::ToolCallLatencyMetrics>]
          #     Output only. Metrics for tool call latency within this app version.
          # @!attribute [r] turn_latency_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::TurnLatencyMetrics>]
          #     Output only. Metrics for turn latency within this app version.
          # @!attribute [r] pass_count
          #   @return [::Integer]
          #     Output only. The number of times the evaluation passed.
          # @!attribute [r] fail_count
          #   @return [::Integer]
          #     Output only. The number of times the evaluation failed.
          # @!attribute [r] metrics_by_turn
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::MetricsByTurn>]
          #     Output only. Metrics aggregated per turn within this app version.
          class MetricsByAppVersion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metrics aggregated per turn.
          # @!attribute [r] turn_index
          #   @return [::Integer]
          #     Output only. The turn index (0-based).
          # @!attribute [r] tool_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::ToolMetrics>]
          #     Output only. Metrics for each tool within this turn.
          # @!attribute [r] semantic_similarity_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::SemanticSimilarityMetrics>]
          #     Output only. Metrics for semantic similarity within this turn.
          # @!attribute [r] hallucination_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::HallucinationMetrics>]
          #     Output only. Metrics for hallucination within this turn.
          # @!attribute [r] tool_call_latency_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::ToolCallLatencyMetrics>]
          #     Output only. Metrics for tool call latency within this turn.
          # @!attribute [r] turn_latency_metrics
          #   @return [::Array<::Google::Cloud::Ces::V1beta::AggregatedMetrics::TurnLatencyMetrics>]
          #     Output only. Metrics for turn latency within this turn.
          class MetricsByTurn
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # An evaluation represents all of the information needed to simulate and
        # evaluate an agent.
        # @!attribute [rw] golden
        #   @return [::Google::Cloud::Ces::V1beta::Evaluation::Golden]
        #     Optional. The golden steps to be evaluated.
        #
        #     Note: The following fields are mutually exclusive: `golden`, `scenario`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] scenario
        #   @return [::Google::Cloud::Ces::V1beta::Evaluation::Scenario]
        #     Optional. The config for a scenario.
        #
        #     Note: The following fields are mutually exclusive: `scenario`, `golden`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of this evaluation.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User-defined display name of the evaluation. Unique within an
        #     App.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-defined description of the evaluation.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Optional. User defined tags to categorize the evaluation.
        # @!attribute [r] evaluation_datasets
        #   @return [::Array<::String>]
        #     Output only. List of evaluation datasets the evaluation belongs to.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation was created.
        # @!attribute [r] created_by
        #   @return [::String]
        #     Output only. The user who created the evaluation.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation was last updated.
        # @!attribute [r] last_updated_by
        #   @return [::String]
        #     Output only. The user who last updated the evaluation.
        # @!attribute [r] evaluation_runs
        #   @return [::Array<::String>]
        #     Output only. The EvaluationRuns that this Evaluation is associated with.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation. If the etag is empty, the update will
        #     overwrite any concurrent changes.
        # @!attribute [r] aggregated_metrics
        #   @return [::Google::Cloud::Ces::V1beta::AggregatedMetrics]
        #     Output only. The aggregated metrics for this evaluation across all runs.
        # @!attribute [r] last_completed_result
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult]
        #     Output only. The latest evaluation result for this evaluation.
        # @!attribute [r] invalid
        #   @return [::Boolean]
        #     Output only. Whether the evaluation is invalid. This can happen if an
        #     evaluation is referencing a tool, toolset, or agent that has since been
        #     deleted.
        # @!attribute [r] last_ten_results
        #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult>]
        #     Output only. The last 10 evaluation results for this evaluation. This is
        #     only populated if include_last_ten_results is set to true in the
        #     ListEvaluationsRequest or GetEvaluationRequest.
        class Evaluation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a single, checkable requirement.
          # @!attribute [rw] tool_call
          #   @return [::Google::Cloud::Ces::V1beta::ToolCall]
          #     Optional. Check that a specific tool was called with the parameters.
          #
          #     Note: The following fields are mutually exclusive: `tool_call`, `tool_response`, `agent_response`, `agent_transfer`, `updated_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] tool_response
          #   @return [::Google::Cloud::Ces::V1beta::ToolResponse]
          #     Optional. Check that a specific tool had the expected response.
          #
          #     Note: The following fields are mutually exclusive: `tool_response`, `tool_call`, `agent_response`, `agent_transfer`, `updated_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] agent_response
          #   @return [::Google::Cloud::Ces::V1beta::Message]
          #     Optional. Check that the agent responded with the correct response. The
          #     role "agent" is implied.
          #
          #     Note: The following fields are mutually exclusive: `agent_response`, `tool_call`, `tool_response`, `agent_transfer`, `updated_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] agent_transfer
          #   @return [::Google::Cloud::Ces::V1beta::AgentTransfer]
          #     Optional. Check that the agent transferred the conversation to a
          #     different agent.
          #
          #     Note: The following fields are mutually exclusive: `agent_transfer`, `tool_call`, `tool_response`, `agent_response`, `updated_variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] updated_variables
          #   @return [::Google::Protobuf::Struct]
          #     Optional. Check that the agent updated the session variables to the
          #     expected values. Used to also capture agent variable updates for golden
          #     evals.
          #
          #     Note: The following fields are mutually exclusive: `updated_variables`, `tool_call`, `tool_response`, `agent_response`, `agent_transfer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] note
          #   @return [::String]
          #     Optional. A note for this requirement, useful in reporting when specific
          #     checks fail. E.g., "Check_Payment_Tool_Called".
          class GoldenExpectation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A step defines a singular action to happen during the evaluation.
          # @!attribute [rw] user_input
          #   @return [::Google::Cloud::Ces::V1beta::SessionInput]
          #     Optional. User input for the conversation.
          #
          #     Note: The following fields are mutually exclusive: `user_input`, `agent_transfer`, `expectation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] agent_transfer
          #   @return [::Google::Cloud::Ces::V1beta::AgentTransfer]
          #     Optional. Transfer the conversation to a different agent.
          #
          #     Note: The following fields are mutually exclusive: `agent_transfer`, `user_input`, `expectation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] expectation
          #   @return [::Google::Cloud::Ces::V1beta::Evaluation::GoldenExpectation]
          #     Optional. Executes an expectation on the current turn.
          #
          #     Note: The following fields are mutually exclusive: `expectation`, `user_input`, `agent_transfer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Step
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A golden turn defines a single turn in a golden conversation.
          # @!attribute [rw] steps
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation::Step>]
          #     Required. The steps required to replay a golden conversation.
          # @!attribute [rw] root_span
          #   @return [::Google::Cloud::Ces::V1beta::Span]
          #     Optional. The root span of the golden turn for processing and maintaining
          #     audio information.
          class GoldenTurn
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The steps required to replay a golden conversation.
          # @!attribute [rw] turns
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation::GoldenTurn>]
          #     Required. The golden turns required to replay a golden conversation.
          class Golden
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The expectation to evaluate the conversation produced by the simulation.
          # @!attribute [rw] tool_expectation
          #   @return [::Google::Cloud::Ces::V1beta::Evaluation::ScenarioExpectation::ToolExpectation]
          #     Optional. The tool call and response pair to be evaluated.
          #
          #     Note: The following fields are mutually exclusive: `tool_expectation`, `agent_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] agent_response
          #   @return [::Google::Cloud::Ces::V1beta::Message]
          #     Optional. The agent response to be evaluated.
          #
          #     Note: The following fields are mutually exclusive: `agent_response`, `tool_expectation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ScenarioExpectation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The tool call and response pair to be evaluated.
            # @!attribute [rw] expected_tool_call
            #   @return [::Google::Cloud::Ces::V1beta::ToolCall]
            #     Required. The expected tool call, with the parameters of interest
            #     specified. Any parameters not specified will be hallucinated by the
            #     LLM.
            # @!attribute [rw] mock_tool_response
            #   @return [::Google::Cloud::Ces::V1beta::ToolResponse]
            #     Required. The tool response to mock, with the parameters of interest
            #     specified. Any parameters not specified will be hallucinated by the
            #     LLM.
            class ToolExpectation
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The config for a scenario
          # @!attribute [rw] task
          #   @return [::String]
          #     Required. The task to be targeted by the scenario.
          # @!attribute [rw] user_facts
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation::Scenario::UserFact>]
          #     Optional. The user facts to be used by the scenario.
          # @!attribute [rw] max_turns
          #   @return [::Integer]
          #     Optional. The maximum number of turns to simulate. If not specified, the
          #     simulation will continue until the task is complete.
          # @!attribute [rw] rubrics
          #   @return [::Array<::String>]
          #     Required. The rubrics to score the scenario against.
          # @!attribute [rw] scenario_expectations
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation::ScenarioExpectation>]
          #     Required. The ScenarioExpectations to evaluate the conversation produced
          #     by the user simulation.
          # @!attribute [rw] variable_overrides
          #   @return [::Google::Protobuf::Struct]
          #     Optional. Variables / Session Parameters as context for the session,
          #     keyed by variable names. Members of this struct will override any default
          #     values set by the system.
          #
          #     Note, these are different from user facts, which are facts known to the
          #     user. Variables are parameters known to the agent: i.e. MDN (phone
          #     number) passed by the telephony system.
          # @!attribute [rw] task_completion_behavior
          #   @return [::Google::Cloud::Ces::V1beta::Evaluation::Scenario::TaskCompletionBehavior]
          #     Optional. The expected behavior of the user task.
          # @!attribute [rw] user_goal_behavior
          #   @return [::Google::Cloud::Ces::V1beta::Evaluation::Scenario::UserGoalBehavior]
          #     Optional. The expected behavior of the user goal.
          class Scenario
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Facts about the user as a key value pair.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. The name of the user fact.
            # @!attribute [rw] value
            #   @return [::String]
            #     Required. The value of the user fact.
            class UserFact
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The expected behavior of the user task. This is used to determine whether
            # the scenario is successful.
            module TaskCompletionBehavior
              # Behavior unspecified. Will default to TASK_SATISFIED.
              TASK_COMPLETION_BEHAVIOR_UNSPECIFIED = 0

              # The user task should be completed successfully.
              TASK_SATISFIED = 1

              # The user task should be rejected.
              TASK_REJECTED = 2
            end

            # The expected behavior of the user goal. This is used to determine whether
            # the scenario is successful.
            module UserGoalBehavior
              # Behavior unspecified. Will default to USER_GOAL_SATISFIED.
              USER_GOAL_BEHAVIOR_UNSPECIFIED = 0

              # The user goal should be completed successfully.
              USER_GOAL_SATISFIED = 1

              # The user goal should be rejected.
              USER_GOAL_REJECTED = 2

              # Ignore the user goal status.
              USER_GOAL_IGNORED = 3
            end
          end
        end

        # An evaluation dataset represents a set of evaluations that are grouped
        # together basaed on shared tags.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of this evaluation dataset.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User-defined display name of the evaluation dataset. Unique
        #     within an App.
        # @!attribute [rw] evaluations
        #   @return [::Array<::String>]
        #     Optional. Evaluations that are included in this dataset.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation dataset was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation dataset was last updated.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation. If the etag is empty, the update will
        #     overwrite any concurrent changes.
        # @!attribute [r] created_by
        #   @return [::String]
        #     Output only. The user who created the evaluation dataset.
        # @!attribute [r] last_updated_by
        #   @return [::String]
        #     Output only. The user who last updated the evaluation dataset.
        # @!attribute [r] aggregated_metrics
        #   @return [::Google::Cloud::Ces::V1beta::AggregatedMetrics]
        #     Output only. The aggregated metrics for this evaluation dataset across all
        #     runs.
        class EvaluationDataset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An evaluation result represents the output of running an Evaluation.
        # @!attribute [r] golden_result
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::GoldenResult]
        #     Output only. The outcome of a golden evaluation.
        #
        #     Note: The following fields are mutually exclusive: `golden_result`, `scenario_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] scenario_result
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::ScenarioResult]
        #     Output only. The outcome of a scenario evaluation.
        #
        #     Note: The following fields are mutually exclusive: `scenario_result`, `golden_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the evaluation result.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the Evaluation Result. Unique within an
        #     Evaluation. By default, it has the following format:
        #     "<evaluation-display-name> result
        #     - <timestamp>".
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation result was created.
        # @!attribute [r] evaluation_status
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::Outcome]
        #     Output only. The outcome of the evaluation. Only populated if
        #     execution_state is COMPLETE.
        # @!attribute [r] evaluation_run
        #   @return [::String]
        #     Output only. The evaluation run that produced this result.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
        # @!attribute [r] persona
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationPersona]
        #     Output only. The persona used to generate the conversation for the
        #     evaluation result.
        # @!attribute [r] error_info
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationErrorInfo]
        #     Output only. Error information for the evaluation result.
        # @!attribute [r] error
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Rpc::Status]
        #     Output only. Deprecated: Use `error_info` instead. Errors encountered
        #     during execution.
        # @!attribute [r] initiated_by
        #   @return [::String]
        #     Output only. The user who initiated the evaluation run that resulted in
        #     this result.
        # @!attribute [r] app_version
        #   @return [::String]
        #     Output only. The app version used to generate the conversation that
        #     resulted in this result. Format:
        #     `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
        # @!attribute [r] app_version_display_name
        #   @return [::String]
        #     Output only. The display name of the `app_version` that the evaluation ran
        #     against.
        # @!attribute [r] changelog
        #   @return [::String]
        #     Output only. The changelog of the app version that the evaluation ran
        #     against. This is populated if user runs evaluation on latest/draft.
        # @!attribute [r] changelog_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time of the changelog of the app version that the
        #     evaluation ran against. This is populated if user runs evaluation on
        #     latest/draft.
        # @!attribute [r] execution_state
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::ExecutionState]
        #     Output only. The state of the evaluation result execution.
        # @!attribute [r] evaluation_metrics_thresholds
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationMetricsThresholds]
        #     Output only. The evaluation thresholds for the result.
        # @!attribute [r] config
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationConfig]
        #     Output only. The configuration used in the evaluation run that resulted in
        #     this result.
        # @!attribute [r] golden_run_method
        #   @return [::Google::Cloud::Ces::V1beta::GoldenRunMethod]
        #     Output only. The method used to run the golden evaluation.
        class EvaluationResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the expectation and the result of that expectation.
          # @!attribute [r] observed_tool_call
          #   @return [::Google::Cloud::Ces::V1beta::ToolCall]
          #     Output only. The result of the tool call expectation.
          #
          #     Note: The following fields are mutually exclusive: `observed_tool_call`, `observed_tool_response`, `observed_agent_response`, `observed_agent_transfer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] observed_tool_response
          #   @return [::Google::Cloud::Ces::V1beta::ToolResponse]
          #     Output only. The result of the tool response expectation.
          #
          #     Note: The following fields are mutually exclusive: `observed_tool_response`, `observed_tool_call`, `observed_agent_response`, `observed_agent_transfer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] observed_agent_response
          #   @return [::Google::Cloud::Ces::V1beta::Message]
          #     Output only. The result of the agent response expectation.
          #
          #     Note: The following fields are mutually exclusive: `observed_agent_response`, `observed_tool_call`, `observed_tool_response`, `observed_agent_transfer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] observed_agent_transfer
          #   @return [::Google::Cloud::Ces::V1beta::AgentTransfer]
          #     Output only. The result of the agent transfer expectation.
          #
          #     Note: The following fields are mutually exclusive: `observed_agent_transfer`, `observed_tool_call`, `observed_tool_response`, `observed_agent_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] expectation
          #   @return [::Google::Cloud::Ces::V1beta::Evaluation::GoldenExpectation]
          #     Output only. The expectation that was evaluated.
          # @!attribute [r] outcome
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::Outcome]
          #     Output only. The outcome of the expectation.
          # @!attribute [r] semantic_similarity_result
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::SemanticSimilarityResult]
          #     Output only. The result of the semantic similarity check.
          # @!attribute [r] tool_invocation_result
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::GoldenExpectationOutcome::ToolInvocationResult]
          #     Output only. The result of the tool invocation check.
          class GoldenExpectationOutcome
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The result of the tool invocation check.
            # @!attribute [r] parameter_correctness_score
            #   @return [::Float]
            #     Output only. The tool invocation parameter correctness score. This
            #     indicates the percent of parameters from the expected tool call that
            #     were also present in the actual tool call.
            # @!attribute [r] outcome
            #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::Outcome]
            #     Output only. The outcome of the tool invocation check. This is
            #     determined by comparing the parameter_correctness_score to the
            #     threshold. If the score is equal to or above the threshold, the outcome
            #     will be PASS. Otherwise, the outcome will be FAIL.
            class ToolInvocationResult
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The result of a golden evaluation.
          # @!attribute [r] turn_replay_results
          #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult::GoldenResult::TurnReplayResult>]
          #     Output only. The result of running each turn of the golden conversation.
          class GoldenResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The result of running a single turn of the golden conversation.
            # @!attribute [r] conversation
            #   @return [::String]
            #     Output only. The conversation that was generated for this turn.
            # @!attribute [r] expectation_outcome
            #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult::GoldenExpectationOutcome>]
            #     Output only. The outcome of each expectation.
            # @!attribute [r] hallucination_result
            #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::HallucinationResult]
            #     Output only. The result of the hallucination check.
            # @!attribute [r] tool_invocation_score
            #   @deprecated This field is deprecated and may be removed in the next major version update.
            #   @return [::Float]
            #     Output only. Deprecated. Use OverallToolInvocationResult instead.
            # @!attribute [r] tool_ordered_invocation_score
            #   @return [::Float]
            #     Output only. The overall tool ordered invocation score for this turn.
            #     This indicates the overall percent of tools from the expected turn that
            #     were actually invoked in the expected order.
            # @!attribute [r] turn_latency
            #   @return [::Google::Protobuf::Duration]
            #     Output only. Duration of the turn.
            # @!attribute [r] tool_call_latencies
            #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult::ToolCallLatency>]
            #     Output only. The latency of each tool call in the turn.
            # @!attribute [r] semantic_similarity_result
            #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::SemanticSimilarityResult]
            #     Output only. The result of the semantic similarity check.
            # @!attribute [r] overall_tool_invocation_result
            #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::OverallToolInvocationResult]
            #     Output only. The result of the overall tool invocation check.
            # @!attribute [r] error_info
            #   @return [::Google::Cloud::Ces::V1beta::EvaluationErrorInfo]
            #     Output only. Information about the error that occurred during this
            #     turn.
            class TurnReplayResult
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The outcome of the evaluation against the rubric.
          # @!attribute [r] rubric
          #   @return [::String]
          #     Output only. The rubric that was used to evaluate the conversation.
          # @!attribute [r] score
          #   @return [::Float]
          #     Output only. The score of the conversation against the rubric.
          # @!attribute [r] score_explanation
          #   @return [::String]
          #     Output only. The rater's response to the rubric.
          class ScenarioRubricOutcome
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The outcome of a scenario expectation.
          # @!attribute [r] observed_tool_call
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::ScenarioExpectationOutcome::ObservedToolCall]
          #     Output only. The observed tool call.
          #
          #     Note: The following fields are mutually exclusive: `observed_tool_call`, `observed_agent_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] observed_agent_response
          #   @return [::Google::Cloud::Ces::V1beta::Message]
          #     Output only. The observed agent response.
          #
          #     Note: The following fields are mutually exclusive: `observed_agent_response`, `observed_tool_call`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] expectation
          #   @return [::Google::Cloud::Ces::V1beta::Evaluation::ScenarioExpectation]
          #     Output only. The expectation that was evaluated.
          # @!attribute [r] outcome
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::Outcome]
          #     Output only. The outcome of the ScenarioExpectation.
          class ScenarioExpectationOutcome
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The observed tool call and response.
            # @!attribute [r] tool_call
            #   @return [::Google::Cloud::Ces::V1beta::ToolCall]
            #     Output only. The observed tool call.
            # @!attribute [r] tool_response
            #   @return [::Google::Cloud::Ces::V1beta::ToolResponse]
            #     Output only. The observed tool response.
            class ObservedToolCall
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The outcome of a scenario evaluation.
          # @!attribute [r] conversation
          #   @return [::String]
          #     Output only. The conversation that was generated in the scenario.
          # @!attribute [r] task
          #   @return [::String]
          #     Output only. The task that was used when running the scenario for this
          #     result.
          # @!attribute [r] user_facts
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation::Scenario::UserFact>]
          #     Output only. The user facts that were used by the scenario for this
          #     result.
          # @!attribute [r] expectation_outcomes
          #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult::ScenarioExpectationOutcome>]
          #     Output only. The outcome of each expectation.
          # @!attribute [r] rubric_outcomes
          #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult::ScenarioRubricOutcome>]
          #     Output only. The outcome of the rubric.
          # @!attribute [r] hallucination_result
          #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult::HallucinationResult>]
          #     Output only. The result of the hallucination check.
          #     There will be one hallucination result for each turn in the conversation.
          # @!attribute [r] task_completion_result
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::TaskCompletionResult]
          #     Output only. The result of the task completion check.
          # @!attribute [r] tool_call_latencies
          #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult::ToolCallLatency>]
          #     Output only. The latency of each tool call execution in the conversation.
          # @!attribute [r] user_goal_satisfaction_result
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::UserGoalSatisfactionResult]
          #     Output only. The result of the user goal satisfaction check.
          # @!attribute [r] all_expectations_satisfied
          #   @return [::Boolean]
          #     Output only. Whether all expectations were satisfied for this turn.
          # @!attribute [r] task_completed
          #   @return [::Boolean]
          #     Output only. Whether the task was completed for this turn. This is a
          #     composite of all expectations satisfied, no hallucinations, and user goal
          #     satisfaction.
          class ScenarioResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The latency of a tool call execution.
          # @!attribute [r] tool
          #   @return [::String]
          #     Output only. The name of the tool that got executed.
          #     Format:
          #     `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`.
          # @!attribute [r] display_name
          #   @return [::String]
          #     Output only. The display name of the tool.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The start time of the tool call execution.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The end time of the tool call execution.
          # @!attribute [r] execution_latency
          #   @return [::Google::Protobuf::Duration]
          #     Output only. The latency of the tool call execution.
          class ToolCallLatency
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The result of the hallucination check for a single turn.
          # @!attribute [r] score
          #   @return [::Integer]
          #     Output only. The hallucination score. Can be -1, 0, 1.
          # @!attribute [r] label
          #   @return [::String]
          #     Output only. The label associated with each score.
          #     Score 1: Justified
          #     Score 0: Not Justified
          #     Score -1: No Claim To Assess
          # @!attribute [r] explanation
          #   @return [::String]
          #     Output only. The explanation for the hallucination score.
          class HallucinationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The result of a user goal satisfaction check for a conversation.
          # @!attribute [r] score
          #   @return [::Integer]
          #     Output only. The user task satisfaction score. Can be -1, 0, 1.
          # @!attribute [r] label
          #   @return [::String]
          #     Output only. The label associated with each score.
          #     Score 1: User Task Satisfied
          #     Score 0: User Task Not Satisfied
          #     Score -1: User Task Unspecified
          # @!attribute [r] explanation
          #   @return [::String]
          #     Output only. The explanation for the user task satisfaction score.
          class UserGoalSatisfactionResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The result of the semantic similarity check.
          # @!attribute [r] score
          #   @return [::Integer]
          #     Output only. The semantic similarity score. Can be 0, 1, 2, 3, or 4.
          # @!attribute [r] label
          #   @return [::String]
          #     Output only. The label associated with each score.
          #     Score 4: Fully Consistent
          #     Score 3: Mostly Consistent
          #     Score 2: Partially Consistent (Minor Omissions)
          #     Score 1: Largely Inconsistent (Major Omissions)
          #     Score 0: Completely Inconsistent / Contradictory
          # @!attribute [r] explanation
          #   @return [::String]
          #     Output only. The explanation for the semantic similarity score.
          # @!attribute [r] outcome
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::Outcome]
          #     Output only. The outcome of the semantic similarity check. This is
          #     determined by comparing the score to the
          #     semantic_similarity_success_threshold. If the score is equal to or above
          #     the threshold, the outcome will be PASS. Otherwise, the outcome will be
          #     FAIL.
          class SemanticSimilarityResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The result of the overall tool invocation check.
          # @!attribute [rw] tool_invocation_score
          #   @return [::Float]
          #     The overall tool invocation score for this turn. This indicates the
          #     overall percent of tools from the expected turn that were actually
          #     invoked.
          # @!attribute [r] outcome
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationResult::Outcome]
          #     Output only. The outcome of the tool invocation check. This is determined
          #     by comparing the tool_invocation_score to the
          #     overall_tool_invocation_correctness_threshold. If the
          #     score is equal to or above the threshold, the outcome will be PASS.
          #     Otherwise, the outcome will be FAIL.
          class OverallToolInvocationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The result of the task completion check for the conversation.
          # @!attribute [r] score
          #   @return [::Integer]
          #     Output only. The task completion score. Can be -1, 0, 1
          # @!attribute [r] label
          #   @return [::String]
          #     Output only. The label associated with each score.
          #     Score 1: Task Completed
          #     Score 0: Task Not Completed
          #     Score -1: User Goal Undefined
          # @!attribute [r] explanation
          #   @return [::String]
          #     Output only. The explanation for the task completion score.
          class TaskCompletionResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The outcome of the evaluation or expectation.
          module Outcome
            # Evaluation outcome is not specified.
            OUTCOME_UNSPECIFIED = 0

            # Evaluation/Expectation passed. In the case of an evaluation, this means
            # that all expectations were met.
            PASS = 1

            # Evaluation/Expectation failed. In the case of an evaluation, this means
            # that at least one expectation was not met.
            FAIL = 2
          end

          # The state of the evaluation result execution.
          module ExecutionState
            # Evaluation result execution state is not specified.
            EXECUTION_STATE_UNSPECIFIED = 0

            # Evaluation result execution is running.
            RUNNING = 1

            # Evaluation result execution has completed.
            COMPLETED = 2

            # Evaluation result execution failed due to an internal error.
            ERROR = 3
          end
        end

        # An evaluation run represents an all the evaluation results from an
        # evaluation execution.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the evaluation run.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User-defined display name of the evaluation run.
        #     default: "<evaluation-dataset-display-name> run - <timestamp>".
        # @!attribute [r] evaluation_results
        #   @return [::Array<::String>]
        #     Output only. The evaluation results that are part of this run.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}/results/{result}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation run was created.
        # @!attribute [r] initiated_by
        #   @return [::String]
        #     Output only. The user who initiated the evaluation run.
        # @!attribute [r] app_version
        #   @return [::String]
        #     Output only. The app version to evaluate.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
        # @!attribute [r] app_version_display_name
        #   @return [::String]
        #     Output only. The display name of the `app_version` that the evaluation ran
        #     against.
        # @!attribute [r] changelog
        #   @return [::String]
        #     Output only. The changelog of the app version that the evaluation ran
        #     against. This is populated if user runs evaluation on latest/draft.
        # @!attribute [r] changelog_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time of the changelog of the app version that the
        #     evaluation ran against. This is populated if user runs evaluation on
        #     latest/draft.
        # @!attribute [r] evaluations
        #   @return [::Array<::String>]
        #     Output only. The evaluations that are part of this run. The list may
        #     contain evaluations of either type. This field is mutually exclusive with
        #     `evaluation_dataset`.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
        # @!attribute [r] evaluation_dataset
        #   @return [::String]
        #     Output only. The evaluation dataset that this run is associated with. This
        #     field is mutually exclusive with `evaluations`. Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
        # @!attribute [r] evaluation_type
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationRun::EvaluationType]
        #     Output only. The type of the evaluations in this run.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationRun::EvaluationRunState]
        #     Output only. The state of the evaluation run.
        # @!attribute [r] progress
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationRun::Progress]
        #     Output only. The progress of the evaluation run.
        # @!attribute [r] config
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationConfig]
        #     Output only. The configuration used in the run.
        # @!attribute [r] error
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Rpc::Status]
        #     Output only. Deprecated: Use error_info instead. Errors encountered during
        #     execution.
        # @!attribute [r] error_info
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationErrorInfo]
        #     Output only. Error information for the evaluation run.
        # @!attribute [r] evaluation_run_summaries
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Ces::V1beta::EvaluationRun::EvaluationRunSummary}]
        #     Output only. Map of evaluation name to EvaluationRunSummary.
        # @!attribute [r] run_count
        #   @return [::Integer]
        #     Output only. The number of times the evaluations inside the run were run.
        # @!attribute [r] persona_run_configs
        #   @return [::Array<::Google::Cloud::Ces::V1beta::PersonaRunConfig>]
        #     Output only. The configuration to use for the run per persona.
        # @!attribute [rw] optimization_config
        #   @return [::Google::Cloud::Ces::V1beta::OptimizationConfig]
        #     Optional. Configuration for running the optimization step after the
        #     evaluation run. If not set, the optimization step will not be run.
        # @!attribute [r] scheduled_evaluation_run
        #   @return [::String]
        #     Output only. The scheduled evaluation run resource name that created this
        #     evaluation run. This field is only set if the evaluation run was created
        #     by a scheduled evaluation run.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
        # @!attribute [r] golden_run_method
        #   @return [::Google::Cloud::Ces::V1beta::GoldenRunMethod]
        #     Output only. The method used to run the evaluation.
        class EvaluationRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The progress of the evaluation run.
          # @!attribute [r] total_count
          #   @return [::Integer]
          #     Output only. Total number of evaluation results in this run.
          # @!attribute [r] failed_count
          #   @return [::Integer]
          #     Output only. Number of completed evaluation results with an outcome of
          #     FAIL. (EvaluationResult.execution_state is COMPLETED and
          #     EvaluationResult.evaluation_status is FAIL).
          # @!attribute [r] error_count
          #   @return [::Integer]
          #     Output only. Number of evaluation results that failed to execute.
          #     (EvaluationResult.execution_state is ERROR).
          # @!attribute [r] completed_count
          #   @return [::Integer]
          #     Output only. Number of evaluation results that finished successfully.
          #     (EvaluationResult.execution_state is COMPLETED).
          # @!attribute [r] passed_count
          #   @return [::Integer]
          #     Output only. Number of completed evaluation results with an outcome of
          #     PASS. (EvaluationResult.execution_state is COMPLETED and
          #     EvaluationResult.evaluation_status is PASS).
          class Progress
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Contains the summary of passed and failed result counts for a specific
          # evaluation in an evaluation run.
          # @!attribute [r] passed_count
          #   @return [::Integer]
          #     Output only. Number of passed results for the associated Evaluation in
          #     this run.
          # @!attribute [r] failed_count
          #   @return [::Integer]
          #     Output only. Number of failed results for the associated Evaluation in
          #     this run.
          # @!attribute [r] error_count
          #   @return [::Integer]
          #     Output only. Number of error results for the associated Evaluation in
          #     this run.
          class EvaluationRunSummary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Ces::V1beta::EvaluationRun::EvaluationRunSummary]
          class EvaluationRunSummariesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of the evaluations in this run.
          # Additional values may be added in the future.
          module EvaluationType
            # Evaluation type is not specified.
            EVALUATION_TYPE_UNSPECIFIED = 0

            # Golden evaluation.
            GOLDEN = 1

            # Scenario evaluation.
            SCENARIO = 2

            # Indicates the run includes a mix of golden and scenario evaluations.
            MIXED = 3
          end

          # The state of the evaluation run.
          module EvaluationRunState
            # Evaluation run state is not specified.
            EVALUATION_RUN_STATE_UNSPECIFIED = 0

            # Evaluation run is running.
            RUNNING = 1

            # Evaluation run has completed.
            COMPLETED = 2

            # The evaluation run has an error.
            ERROR = 3
          end
        end

        # An evaluation expectation represents a specific criteria to evaluate against.
        # @!attribute [rw] llm_criteria
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationExpectation::LlmCriteria]
        #     Optional. Evaluation criteria based on an LLM prompt.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of this evaluation expectation.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationExpectations/{evaluation_expectation}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User-defined display name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation expectation was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation expectation was last updated.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation. If the etag is empty, the update will
        #     overwrite any concurrent changes.
        class EvaluationExpectation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for LLM-based evaluation criteria.
          # @!attribute [rw] prompt
          #   @return [::String]
          #     Required. The prompt/instructions provided to the LLM judge.
          class LlmCriteria
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # EvaluationConfig configures settings for running the evaluation.
        # @!attribute [rw] input_audio_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Ces::V1beta::InputAudioConfig]
        #     Optional. Configuration for processing the input audio.
        # @!attribute [rw] output_audio_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Ces::V1beta::OutputAudioConfig]
        #     Optional. Configuration for generating the output audio.
        # @!attribute [rw] evaluation_channel
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationConfig::EvaluationChannel]
        #     Optional. The channel to evaluate.
        class EvaluationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The channel to evaluate.
          module EvaluationChannel
            # Unspecified evaluation channel.
            EVALUATION_CHANNEL_UNSPECIFIED = 0

            # Text-only evaluation channel.
            TEXT = 1

            # Audio evaluation channel.
            AUDIO = 2
          end
        end

        # Information about an error encountered during an evaluation execution.
        # @!attribute [r] error_type
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationErrorInfo::ErrorType]
        #     Output only. The type of error.
        # @!attribute [r] error_message
        #   @return [::String]
        #     Output only. The error message.
        # @!attribute [r] session_id
        #   @return [::String]
        #     Output only. The session ID for the conversation that caused the error.
        class EvaluationErrorInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of error
          module ErrorType
            # Unspecified error type.
            ERROR_TYPE_UNSPECIFIED = 0

            # Failure during runtime execution.
            RUNTIME_FAILURE = 1

            # Failure to retrieve conversation from CES Runtime.
            CONVERSATION_RETRIEVAL_FAILURE = 2

            # Failure to calculate a metric / outcome.
            METRIC_CALCULATION_FAILURE = 3

            # Failure to update the evaluation.
            EVALUATION_UPDATE_FAILURE = 4

            # Ran out of quota.
            QUOTA_EXHAUSTED = 5

            # Failure during user simulation.
            USER_SIMULATION_FAILURE = 6
          end
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#run_evaluation EvaluationService.RunEvaluation}.
        # @!attribute [rw] app
        #   @return [::String]
        #     Required. The app to evaluate.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] evaluations
        #   @return [::Array<::String>]
        #     Optional. List of evaluations to run.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
        # @!attribute [rw] evaluation_dataset
        #   @return [::String]
        #     Optional. An evaluation dataset to run.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationDatasets/{evaluationDataset}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the evaluation run.
        # @!attribute [rw] app_version
        #   @return [::String]
        #     Optional. The app version to evaluate.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/versions/{version}`
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationConfig]
        #     Optional. The configuration to use for the run.
        # @!attribute [rw] run_count
        #   @return [::Integer]
        #     Optional. The number of times to run the evaluation. If not set, the
        #     default value is 1 per golden, and 5 per scenario.
        # @!attribute [rw] persona_run_configs
        #   @return [::Array<::Google::Cloud::Ces::V1beta::PersonaRunConfig>]
        #     Optional. The configuration to use for the run per persona.
        # @!attribute [rw] optimization_config
        #   @return [::Google::Cloud::Ces::V1beta::OptimizationConfig]
        #     Optional. Configuration for running the optimization step after the
        #     evaluation run. If not set, the optimization step will not be run.
        # @!attribute [rw] scheduled_evaluation_run
        #   @return [::String]
        #     Optional. The resource name of the `ScheduledEvaluationRun` that is
        #     triggering this evaluation run.
        #
        #     If this field is set, the `scheduled_evaluation_run` field on the created
        #     `EvaluationRun` resource will be populated from this value.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/scheduledEvaluationRuns/{scheduled_evaluation_run}`
        # @!attribute [rw] golden_run_method
        #   @return [::Google::Cloud::Ces::V1beta::GoldenRunMethod]
        #     Optional. The method to run the evaluation if it is a golden evaluation. If
        #     not set, default to STABLE.
        class RunEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a scheduled evaluation run configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the scheduled evaluation run config.
        #     Format:
        #     projects/\\{projectId}/locations/\\{locationId}/apps/\\{appId}/scheduledEvaluationRuns/\\{scheduledEvaluationRunId}
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User-defined display name of the scheduled evaluation run config.
        # @!attribute [rw] request
        #   @return [::Google::Cloud::Ces::V1beta::RunEvaluationRequest]
        #     Required. The RunEvaluationRequest to schedule
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-defined description of the scheduled evaluation run.
        # @!attribute [rw] scheduling_config
        #   @return [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun::SchedulingConfig]
        #     Required. Configuration for the timing and frequency with which to execute
        #     the evaluations.
        # @!attribute [rw] active
        #   @return [::Boolean]
        #     Optional. Whether this config is active
        # @!attribute [r] last_completed_run
        #   @return [::String]
        #     Output only. The last successful EvaluationRun of this scheduled execution.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluationRun}`
        # @!attribute [r] total_executions
        #   @return [::Integer]
        #     Output only. The total number of times this run has been executed
        # @!attribute [r] next_scheduled_execution_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The next time this is scheduled to execute
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the scheduled evaluation run was created.
        # @!attribute [r] created_by
        #   @return [::String]
        #     Output only. The user who created the scheduled evaluation run.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the evaluation was last updated.
        # @!attribute [r] last_updated_by
        #   @return [::String]
        #     Output only. The user who last updated the evaluation.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation. If the etag is empty, the update will
        #     overwrite any concurrent changes.
        class ScheduledEvaluationRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Eval scheduling configuration details
          # @!attribute [rw] frequency
          #   @return [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun::SchedulingConfig::Frequency]
          #     Required. The frequency with which to run the eval
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. Timestamp when the eval should start.
          # @!attribute [rw] days_of_week
          #   @return [::Array<::Integer>]
          #     Optional. The days of the week to run the eval. Applicable only for
          #     Weekly and Biweekly frequencies. 1 is Monday, 2 is Tuesday, ..., 7 is
          #     Sunday.
          class SchedulingConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The frequencies evals can be run at
            module Frequency
              # The frequency is unspecified.
              FREQUENCY_UNSPECIFIED = 0

              # Indicates a one-time scheduled run that should not repeat
              NONE = 1

              # Run the evaluation daily.
              DAILY = 2

              # Run the evaluation weekly.
              WEEKLY = 3

              # Run the evaluation biweekly.
              BIWEEKLY = 4
            end
          end
        end

        # Configuration for running an evaluation for a specific persona.
        # @!attribute [rw] persona
        #   @return [::String]
        #     Optional. The persona to use for the evaluation.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationPersonas/{evaluationPersona}`
        # @!attribute [rw] task_count
        #   @return [::Integer]
        #     Optional. The number of tasks to run for the persona.
        class PersonaRunConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for running the optimization step after the evaluation run.
        # @!attribute [rw] generate_loss_report
        #   @return [::Boolean]
        #     Optional. Whether to generate a loss report.
        # @!attribute [r] assistant_session_name
        #   @return [::String]
        #     Output only. The assistant session to use for the optimization based on
        #     this evaluation run. Format:
        #     `projects/{project}/locations/{location}/apps/{app}/assistantSessions/{assistantSession}`
        # @!attribute [r] report_summary
        #   @return [::String]
        #     Output only. The summary of the loss report.
        # @!attribute [r] should_suggest_fix
        #   @return [::Boolean]
        #     Output only. Whether to suggest a fix for the losses.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Ces::V1beta::OptimizationConfig::OptimizationStatus]
        #     Output only. The status of the optimization run.
        # @!attribute [r] error_message
        #   @return [::String]
        #     Output only. The error message if the optimization run failed.
        class OptimizationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of the optimization run.
          module OptimizationStatus
            # Optimization status is not specified.
            OPTIMIZATION_STATUS_UNSPECIFIED = 0

            # Optimization is running.
            RUNNING = 1

            # Optimization has completed.
            COMPLETED = 2

            # Optimization failed due to an internal error.
            ERROR = 3
          end
        end

        # The method used to run the evaluation.
        module GoldenRunMethod
          # Run method is not specified.
          GOLDEN_RUN_METHOD_UNSPECIFIED = 0

          # Run the evaluation as stable replay, where each turn is a unique session
          # with the previous expected turns injected as context.
          STABLE = 1

          # Run the evaluation as naive replay, where the run is a single
          # session with no context injected.
          NAIVE = 2
        end
      end
    end
  end
end
