# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#run_evaluation EvaluationService.RunEvaluation}.
        # @!attribute [rw] evaluation_run
        #   @return [::String]
        #     The name of the evaluation run that was created.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluation_run}`
        class RunEvaluationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Operation metadata for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#run_evaluation EvaluationService.RunEvaluation}
        # @!attribute [r] evaluations
        #   @return [::Array<::String>]
        #     Output only. The list of evaluations that were run.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluations/{evaluation}`
        # @!attribute [r] evaluation_run
        #   @return [::String]
        #     Output only. The evaluation run that was created.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluationRuns/{evaluation_run}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation completed.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. The verb of the operation.
        # @!attribute [r] cancel_requested
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation of the
        #     operation. Operations that have been cancelled successfully have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of `1`,
        #     corresponding to `Code.CANCELLED`.
        class RunEvaluationOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Operation metadata for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#generate_evaluation EvaluationService.GenerateEvaluation}.
        class GenerateEvaluationOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Operation metadata for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#delete_evaluation_run EvaluationService.DeleteEvaluationRun}.
        class DeleteEvaluationRunOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#create_evaluation EvaluationService.CreateEvaluation}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The app to create the evaluation for.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] evaluation_id
        #   @return [::String]
        #     Optional. The ID to use for the evaluation, which will become the final
        #     component of the evaluation's resource name. If not provided, a unique ID
        #     will be automatically assigned for the evaluation.
        # @!attribute [rw] evaluation
        #   @return [::Google::Cloud::Ces::V1beta::Evaluation]
        #     Required. The evaluation to create.
        class CreateEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#generate_evaluation EvaluationService.GenerateEvaluation}.
        # @!attribute [rw] conversation
        #   @return [::String]
        #     Required. The conversation to create the golden evaluation for.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/conversations/{conversation}`
        # @!attribute [rw] source
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Ces::V1beta::Conversation::Source]
        #     Optional. Indicate the source of the conversation. If not set, all sources
        #     will be searched.
        class GenerateEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#import_evaluations EvaluationService.ImportEvaluations}.
        # @!attribute [rw] conversation_list
        #   @return [::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest::ConversationList]
        #     The conversations to import the evaluations from.
        #
        #     Note: The following fields are mutually exclusive: `conversation_list`, `gcs_uri`, `csv_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_uri
        #   @return [::String]
        #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
        #     from which to import evaluations. The format of this URI must be
        #     `gs://<bucket-name>/<object-name>`.
        #
        #     Note: The following fields are mutually exclusive: `gcs_uri`, `conversation_list`, `csv_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] csv_content
        #   @return [::String]
        #     Raw bytes representing the csv file with the evaluations structure.
        #
        #     Note: The following fields are mutually exclusive: `csv_content`, `conversation_list`, `gcs_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The app to import the evaluations into.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] import_options
        #   @return [::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest::ImportOptions]
        #     Optional. Options governing the import process for the evaluations.
        class ImportEvaluationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A list of conversation resource names.
          # @!attribute [rw] conversations
          #   @return [::Array<::String>]
          #     Optional. Conversation resource names.
          class ConversationList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration options for the evaluation import process.
          # These options control how the import behaves, particularly when
          # conflicts arise with existing evaluations data.
          # @!attribute [rw] conflict_resolution_strategy
          #   @return [::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest::ImportOptions::ConflictResolutionStrategy]
          #     Optional. The strategy to use when resolving conflicts during import.
          class ImportOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the strategy for handling conflicts when an evaluation with the
            # same evaluation ID already exists in the app.
            module ConflictResolutionStrategy
              # The conflict resolution strategy is unspecified.
              CONFLICT_RESOLUTION_STRATEGY_UNSPECIFIED = 0

              # Overwrite the existing evaluation with the new one.
              OVERWRITE = 1

              # Keep the existing evaluation and skip the new one.
              SKIP = 2

              # Keep the existing evaluation and duplicate the new one as a new
              # evaluation.
              DUPLICATE = 3
            end
          end
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#import_evaluations EvaluationService.ImportEvaluations}.
        # @!attribute [rw] evaluations
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation>]
        #     The list of evaluations that were imported into the app.
        # @!attribute [rw] error_messages
        #   @return [::Array<::String>]
        #     Optional. A list of error messages associated with evaluations that failed
        #     to be imported.
        # @!attribute [rw] import_failure_count
        #   @return [::Integer]
        #     The number of evaluations that were not imported due to errors.
        class ImportEvaluationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#import_evaluations EvaluationService.ImportEvaluations}.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        class ImportEvaluationsOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#create_evaluation_dataset EvaluationService.CreateEvaluationDataset}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The app to create the evaluation for.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] evaluation_dataset_id
        #   @return [::String]
        #     Optional. The ID to use for the evaluation dataset, which will become the
        #     final component of the evaluation dataset's resource name. If not provided,
        #     a unique ID will be automatically assigned for the evaluation.
        # @!attribute [rw] evaluation_dataset
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationDataset]
        #     Required. The evaluation dataset to create.
        class CreateEvaluationDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#update_evaluation EvaluationService.UpdateEvaluation}.
        # @!attribute [rw] evaluation
        #   @return [::Google::Cloud::Ces::V1beta::Evaluation]
        #     Required. The evaluation to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#update_evaluation_dataset EvaluationService.UpdateEvaluationDataset}.
        # @!attribute [rw] evaluation_dataset
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationDataset]
        #     Required. The evaluation dataset to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateEvaluationDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#delete_evaluation EvaluationService.DeleteEvaluation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Indicates whether to forcefully delete the evaluation, even if it
        #     is still referenced by evaluation datasets.
        #
        #     *  If `force = false`, the deletion will fail if any datasets still
        #     reference the evaluation.
        #     *  If `force = true`, all existing references from datasets will be removed
        #     and the evaluation will be deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the evaluation. If an etag is not provided,
        #     the deletion will overwrite any concurrent changes. If an etag is provided
        #     and does not match the current etag of the evaluation, deletion will be
        #     blocked and an ABORTED error will be returned.
        class DeleteEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#delete_evaluation_result EvaluationService.DeleteEvaluationResult}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation result to delete.
        class DeleteEvaluationResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#delete_evaluation_dataset EvaluationService.DeleteEvaluationDataset}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation dataset to delete.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the evaluation dataset. If an etag is not
        #     provided, the deletion will overwrite any concurrent changes. If an etag is
        #     provided and does not match the current etag of the evaluation dataset,
        #     deletion will be blocked and an ABORTED error will be returned.
        class DeleteEvaluationDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#delete_evaluation_run EvaluationService.DeleteEvaluationRun}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation run to delete.
        class DeleteEvaluationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#get_evaluation EvaluationService.GetEvaluation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation to retrieve.
        class GetEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#get_evaluation_result EvaluationService.GetEvaluationResult}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation result to retrieve.
        class GetEvaluationResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#get_evaluation_dataset EvaluationService.GetEvaluationDataset}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation dataset to retrieve.
        class GetEvaluationDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#get_evaluation_run EvaluationService.GetEvaluationRun}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation run to retrieve.
        class GetEvaluationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluations EvaluationService.ListEvaluations}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list evaluations from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluations EvaluationService.ListEvaluations}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the evaluations.
        #     See https://google.aip.dev/160 for more details.
        #     Currently supports filtering by the following fields:
        #     * evaluation_datasets, using the evaluation dataset ID in the format
        #       evaluation_datasets:evaluation_dataset_id.
        #     * tags, using the tag in the format tags:tag.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time", and
        #     "update_time" are supported. Time fields are ordered in descending order,
        #     and the name field is ordered in ascending order. If not included,
        #     "update_time" will be the default. See https://google.aip.dev/132#ordering
        #     for more details.
        # @!attribute [rw] last_ten_results
        #   @return [::Boolean]
        #     Optional. Whether to include the last 10 evaluation results for each
        #     evaluation in the response.
        class ListEvaluationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_results EvaluationService.ListEvaluationResults}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the evaluation to list evaluation results
        #     from. To filter by evaluation run, use `-` as the evaluation ID and specify
        #     the evaluation run ID in the filter. For example:
        #     `projects/{project}/locations/{location}/apps/{app}/evaluations/-`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationResultsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_results EvaluationService.ListEvaluationResults}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the evaluation results.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time", and
        #     "update_time" are supported. Time fields are ordered in descending order,
        #     and the name field is ordered in ascending order. If not included,
        #     "update_time" will be the default. See https://google.aip.dev/132#ordering
        #     for more details.
        class ListEvaluationResultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_datasets EvaluationService.ListEvaluationDatasets}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list evaluation datasets from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_datasets EvaluationService.ListEvaluationDatasets}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the evaluation datasets.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time", and
        #     "update_time" are supported. Time fields are ordered in descending order,
        #     and the name field is ordered in ascending order. If not included,
        #     "update_time" will be the default. See https://google.aip.dev/132#ordering
        #     for more details.
        class ListEvaluationDatasetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_runs EvaluationService.ListEvaluationRuns}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list evaluation runs from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationRunsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_runs EvaluationService.ListEvaluationRuns}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the evaluation runs.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time", and
        #     "update_time" are supported. Time fields are ordered in descending order,
        #     and the name field is ordered in ascending order. If not included,
        #     "update_time" will be the default. See https://google.aip.dev/132#ordering
        #     for more details.
        class ListEvaluationRunsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluations EvaluationService.ListEvaluations}.
        # @!attribute [rw] evaluations
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Evaluation>]
        #     The list of evaluations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationsRequest#page_token ListEvaluationsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListEvaluationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_results EvaluationService.ListEvaluationResults}.
        # @!attribute [rw] evaluation_results
        #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationResult>]
        #     The list of evaluation results.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest#page_token ListEvaluationResultsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListEvaluationResultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_datasets EvaluationService.ListEvaluationDatasets}.
        # @!attribute [rw] evaluation_datasets
        #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationDataset>]
        #     The list of evaluation datasets.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest#page_token ListEvaluationDatasetsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListEvaluationDatasetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_runs EvaluationService.ListEvaluationRuns}.
        # @!attribute [rw] evaluation_runs
        #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationRun>]
        #     The list of evaluation runs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest#page_token ListEvaluationRunsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListEvaluationRunsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#create_scheduled_evaluation_run EvaluationService.CreateScheduledEvaluationRun}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The app to create the scheduled evaluation run for.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] scheduled_evaluation_run_id
        #   @return [::String]
        #     Optional. The ID to use for the scheduled evaluation run, which will become
        #     the final component of the scheduled evaluation run's resource name. If not
        #     provided, a unique ID will be automatically assigned.
        # @!attribute [rw] scheduled_evaluation_run
        #   @return [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
        #     Required. The scheduled evaluation run to create.
        class CreateScheduledEvaluationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#get_scheduled_evaluation_run EvaluationService.GetScheduledEvaluationRun}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the scheduled evaluation run to retrieve.
        class GetScheduledEvaluationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_scheduled_evaluation_runs EvaluationService.ListScheduledEvaluationRuns}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list scheduled evaluation runs
        #     from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_scheduled_evaluation_runs EvaluationService.ListScheduledEvaluationRuns}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the scheduled evaluation runs.
        #     See https://google.aip.dev/160 for more details.
        #     Currently supports filtering by:
        #     * request.evaluations:evaluation_id
        #     * request.evaluation_dataset:evaluation_dataset_id
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Supported fields are:
        #     "name" (ascending), "create_time" (descending), "update_time" (descending),
        #     "next_scheduled_execution" (ascending), and
        #     "last_completed_run.create_time" (descending).
        #     If not included, "update_time" will be the default.
        #     See https://google.aip.dev/132#ordering for more details.
        class ListScheduledEvaluationRunsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_scheduled_evaluation_runs EvaluationService.ListScheduledEvaluationRuns}.
        # @!attribute [rw] scheduled_evaluation_runs
        #   @return [::Array<::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun>]
        #     The list of scheduled evaluation runs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest#page_token ListScheduledEvaluationRunsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListScheduledEvaluationRunsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#update_scheduled_evaluation_run EvaluationService.UpdateScheduledEvaluationRun}.
        # @!attribute [rw] scheduled_evaluation_run
        #   @return [::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun]
        #     Required. The scheduled evaluation run to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateScheduledEvaluationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#delete_scheduled_evaluation_run EvaluationService.DeleteScheduledEvaluationRun}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the scheduled evaluation run to delete.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag of the ScheduledEvaluationRun.
        #     If provided, it must match the server's etag.
        class DeleteScheduledEvaluationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#test_persona_voice EvaluationService.TestPersonaVoice}.
        # @!attribute [rw] app
        #   @return [::String]
        #     Required. the resource name of the app to test the persona voice for.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] persona_id
        #   @return [::String]
        #     Required. The persona ID to test the voice for. Also accepts "default".
        # @!attribute [rw] text
        #   @return [::String]
        #     Required. The text to test the voice for.
        class TestPersonaVoiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#test_persona_voice EvaluationService.TestPersonaVoice}.
        # @!attribute [rw] audio
        #   @return [::String]
        #     The audio data bytes of the synthesized voice.
        class TestPersonaVoiceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#create_evaluation_expectation EvaluationService.CreateEvaluationExpectation}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The app to create the evaluation expectation for.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] evaluation_expectation_id
        #   @return [::String]
        #     Optional. The ID to use for the evaluation expectation, which will become
        #     the final component of the evaluation expectation's resource name. If not
        #     provided, a unique ID will be automatically assigned for the evaluation
        #     expectation.
        # @!attribute [rw] evaluation_expectation
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
        #     Required. The evaluation expectation to create.
        class CreateEvaluationExpectationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#update_evaluation_expectation EvaluationService.UpdateEvaluationExpectation}.
        # @!attribute [rw] evaluation_expectation
        #   @return [::Google::Cloud::Ces::V1beta::EvaluationExpectation]
        #     Required. The evaluation expectation to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to control which fields get updated. If the
        #     mask is not present, all fields will be updated.
        class UpdateEvaluationExpectationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#delete_evaluation_expectation EvaluationService.DeleteEvaluationExpectation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation expectation to delete.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the evaluation expectation. If an etag is not
        #     provided, the deletion will overwrite any concurrent changes. If an etag is
        #     provided and does not match the current etag of the evaluation expectation,
        #     deletion will be blocked and an ABORTED error will be returned.
        class DeleteEvaluationExpectationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#get_evaluation_expectation EvaluationService.GetEvaluationExpectation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the evaluation expectation to retrieve.
        class GetEvaluationExpectationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_expectations EvaluationService.ListEvaluationExpectations}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app to list evaluation expectations
        #     from.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsResponse#next_page_token next_page_token}
        #     value returned from a previous list
        #     {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_expectations EvaluationService.ListEvaluationExpectations}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter to be applied when listing the evaluation expectations.
        #     See https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. Only "name" and "create_time", and
        #     "update_time" are supported. Time fields are ordered in descending order,
        #     and the name field is ordered in ascending order. If not included,
        #     "update_time" will be the default. See https://google.aip.dev/132#ordering
        #     for more details.
        class ListEvaluationExpectationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::EvaluationService::Client#list_evaluation_expectations EvaluationService.ListEvaluationExpectations}.
        # @!attribute [rw] evaluation_expectations
        #   @return [::Array<::Google::Cloud::Ces::V1beta::EvaluationExpectation>]
        #     The list of evaluation expectations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest#page_token ListEvaluationExpectationsRequest.page_token}
        #     to retrieve the next page. Absence of this field indicates there are no
        #     subsequent pages.
        class ListEvaluationExpectationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
