# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # The file search tool allows the agent to search across the files uploaded by
        # the app/agent developer. It has presets to give relatively good quality
        # search over the uploaded files and summarization of the retrieved results.
        # @!attribute [rw] corpus_type
        #   @return [::Google::Cloud::Ces::V1beta::FileSearchTool::CorpusType]
        #     Optional. The type of the corpus. Default is FULLY_MANAGED.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The tool name.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The tool description.
        # @!attribute [rw] file_corpus
        #   @return [::String]
        #     Optional. The corpus where files are stored.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/ragCorpora/\\{rag_corpus}
        class FileSearchTool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the Vertex RAG corpus.
          module CorpusType
            # Unspecified corpus type.
            CORPUS_TYPE_UNSPECIFIED = 0

            # The corpus is created and owned by the user.
            USER_OWNED = 1

            # The corpus is created by the agent.
            FULLY_MANAGED = 2
          end
        end
      end
    end
  end
end
