# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Guardrail contains a list of checks and balances to keep the agents safe and
        # secure.
        # @!attribute [rw] content_filter
        #   @return [::Google::Cloud::Ces::V1beta::Guardrail::ContentFilter]
        #     Optional. Guardrail that bans certain content from being used in the
        #     conversation.
        #
        #     Note: The following fields are mutually exclusive: `content_filter`, `llm_prompt_security`, `llm_policy`, `model_safety`, `code_callback`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] llm_prompt_security
        #   @return [::Google::Cloud::Ces::V1beta::Guardrail::LlmPromptSecurity]
        #     Optional. Guardrail that blocks the conversation if the prompt is
        #     considered unsafe based on the LLM classification.
        #
        #     Note: The following fields are mutually exclusive: `llm_prompt_security`, `content_filter`, `llm_policy`, `model_safety`, `code_callback`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] llm_policy
        #   @return [::Google::Cloud::Ces::V1beta::Guardrail::LlmPolicy]
        #     Optional. Guardrail that blocks the conversation if the LLM response is
        #     considered violating the policy based on the LLM classification.
        #
        #     Note: The following fields are mutually exclusive: `llm_policy`, `content_filter`, `llm_prompt_security`, `model_safety`, `code_callback`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] model_safety
        #   @return [::Google::Cloud::Ces::V1beta::Guardrail::ModelSafety]
        #     Optional. Guardrail that blocks the conversation if the LLM response is
        #     considered unsafe based on the model safety settings.
        #
        #     Note: The following fields are mutually exclusive: `model_safety`, `content_filter`, `llm_prompt_security`, `llm_policy`, `code_callback`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] code_callback
        #   @return [::Google::Cloud::Ces::V1beta::Guardrail::CodeCallback]
        #     Optional. Guardrail that potentially blocks the conversation based on the
        #     result of the callback execution.
        #
        #     Note: The following fields are mutually exclusive: `code_callback`, `content_filter`, `llm_prompt_security`, `llm_policy`, `model_safety`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the guardrail.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the guardrail.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the guardrail.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Optional. Whether the guardrail is enabled.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::Ces::V1beta::TriggerAction]
        #     Optional. Action to take when the guardrail is triggered.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the guardrail was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the guardrail was last updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Etag used to ensure the object hasn't changed during a read-modify-write
        #     operation. If the etag is empty, the update will overwrite any concurrent
        #     changes.
        class Guardrail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Guardrail that bans certain content from being used in the conversation.
          # @!attribute [rw] banned_contents
          #   @return [::Array<::String>]
          #     Optional. List of banned phrases. Applies to both user inputs and agent
          #     responses.
          # @!attribute [rw] banned_contents_in_user_input
          #   @return [::Array<::String>]
          #     Optional. List of banned phrases. Applies only to user inputs.
          # @!attribute [rw] banned_contents_in_agent_response
          #   @return [::Array<::String>]
          #     Optional. List of banned phrases. Applies only to agent responses.
          # @!attribute [rw] match_type
          #   @return [::Google::Cloud::Ces::V1beta::Guardrail::ContentFilter::MatchType]
          #     Required. Match type for the content filter.
          # @!attribute [rw] disregard_diacritics
          #   @return [::Boolean]
          #     Optional. If true, diacritics are ignored during matching.
          class ContentFilter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Match type for the content filter.
            module MatchType
              # Match type is not specified.
              MATCH_TYPE_UNSPECIFIED = 0

              # Content is matched for substrings character by character.
              SIMPLE_STRING_MATCH = 1

              # Content only matches if the pattern found in the text is
              # surrounded by word delimiters. Banned phrases can also contain word
              # delimiters.
              WORD_BOUNDARY_STRING_MATCH = 2

              # Content is matched using regular expression syntax.
              REGEXP_MATCH = 3
            end
          end

          # Guardrail that blocks the conversation if the input is considered unsafe
          # based on the LLM classification.
          # @!attribute [rw] default_settings
          #   @return [::Google::Cloud::Ces::V1beta::Guardrail::LlmPromptSecurity::DefaultSecuritySettings]
          #     Optional. Use the system's predefined default security settings.
          #     To select this mode, include an empty 'default_settings' message
          #     in the request. The 'default_prompt_template' field within
          #     will be populated by the server in the response.
          #
          #     Note: The following fields are mutually exclusive: `default_settings`, `custom_policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] custom_policy
          #   @return [::Google::Cloud::Ces::V1beta::Guardrail::LlmPolicy]
          #     Optional. Use a user-defined LlmPolicy to configure the security
          #     guardrail.
          #
          #     Note: The following fields are mutually exclusive: `custom_policy`, `default_settings`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] fail_open
          #   @return [::Boolean]
          #     Optional. If true, the guardrail will not trigger if it receives any
          #     errors from the LLM. By default, the guardrail will trigger if it
          #     receives any errors from the LLM. This flag will be ignored if the
          #     guardrail is configured to use a custom policy, and will use the
          #     fail_open setting in the custom policy instead.
          class LlmPromptSecurity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration for default system security settings.
            # @!attribute [r] default_prompt_template
            #   @return [::String]
            #     Output only. The default prompt template used by the system.
            #     This field is for display purposes to show the user what prompt
            #     the system uses by default. It is OUTPUT_ONLY.
            class DefaultSecuritySettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Guardrail that blocks the conversation if the LLM response is considered
          # violating the policy based on the LLM classification.
          # @!attribute [rw] max_conversation_messages
          #   @return [::Integer]
          #     Optional. When checking this policy, consider the last 'n' messages in
          #     the conversation. When not set a default value of 10 will be used.
          # @!attribute [rw] model_settings
          #   @return [::Google::Cloud::Ces::V1beta::ModelSettings]
          #     Optional. Model settings.
          # @!attribute [rw] prompt
          #   @return [::String]
          #     Required. Policy prompt.
          # @!attribute [rw] policy_scope
          #   @return [::Google::Cloud::Ces::V1beta::Guardrail::LlmPolicy::PolicyScope]
          #     Required. Defines when to apply the policy check during the conversation.
          #     If set to `POLICY_SCOPE_UNSPECIFIED`, the policy will be applied to the
          #     user input. When applying the policy to the agent response, additional
          #     latency will be introduced before the agent can respond.
          # @!attribute [rw] fail_open
          #   @return [::Boolean]
          #     Optional. If an error occurs during the policy check, fail open and do
          #     not trigger the guardrail.
          # @!attribute [rw] allow_short_utterance
          #   @return [::Boolean]
          #     Optional. By default, the LLM policy check is bypassed for short
          #     utterances. Enabling this setting applies the policy check to all
          #     utterances, including those that would normally be skipped.
          class LlmPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines when to apply the policy check during the conversation.
            module PolicyScope
              # Policy scope is not specified.
              POLICY_SCOPE_UNSPECIFIED = 0

              # Policy check is triggered on user input.
              USER_QUERY = 1

              # Policy check is triggered on agent response. Applying this policy
              # scope will introduce additional latency before the agent can respond.
              AGENT_RESPONSE = 2

              # Policy check is triggered on both user input and agent response.
              # Applying this policy scope will introduce additional latency before
              # the agent can respond.
              USER_QUERY_AND_AGENT_RESPONSE = 3
            end
          end

          # Model safety settings overrides. When this is set, it will override the
          # default settings and trigger the guardrail if the response is considered
          # unsafe.
          # @!attribute [rw] safety_settings
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Guardrail::ModelSafety::SafetySetting>]
          #     Required. List of safety settings.
          class ModelSafety
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Safety setting.
            # @!attribute [rw] category
            #   @return [::Google::Cloud::Ces::V1beta::Guardrail::ModelSafety::HarmCategory]
            #     Required. The harm category.
            # @!attribute [rw] threshold
            #   @return [::Google::Cloud::Ces::V1beta::Guardrail::ModelSafety::HarmBlockThreshold]
            #     Required. The harm block threshold.
            class SafetySetting
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Harm category.
            module HarmCategory
              # The harm category is unspecified.
              HARM_CATEGORY_UNSPECIFIED = 0

              # The harm category is hate speech.
              HARM_CATEGORY_HATE_SPEECH = 1

              # The harm category is dangerous content.
              HARM_CATEGORY_DANGEROUS_CONTENT = 2

              # The harm category is harassment.
              HARM_CATEGORY_HARASSMENT = 3

              # The harm category is sexually explicit content.
              HARM_CATEGORY_SEXUALLY_EXPLICIT = 4
            end

            # Probability based thresholds levels for blocking.
            module HarmBlockThreshold
              # Unspecified harm block threshold.
              HARM_BLOCK_THRESHOLD_UNSPECIFIED = 0

              # Block low threshold and above (i.e. block more).
              BLOCK_LOW_AND_ABOVE = 1

              # Block medium threshold and above.
              BLOCK_MEDIUM_AND_ABOVE = 2

              # Block only high threshold (i.e. block less).
              BLOCK_ONLY_HIGH = 3

              # Block none.
              BLOCK_NONE = 4

              # Turn off the safety filter.
              OFF = 5
            end
          end

          # Guardrail that blocks the conversation based on the code callbacks
          # provided.
          # @!attribute [rw] before_agent_callback
          #   @return [::Google::Cloud::Ces::V1beta::Callback]
          #     Optional. The callback to execute before the agent is called.
          #     Each callback function is expected to return a structure (e.g., a dict or
          #     object) containing at least:
          #       - 'decision': Either 'OK' or 'TRIGGER'.
          #       - 'reason': A string explaining the decision.
          #     A 'TRIGGER' decision may halt further processing.
          # @!attribute [rw] after_agent_callback
          #   @return [::Google::Cloud::Ces::V1beta::Callback]
          #     Optional. The callback to execute after the agent is called.
          #     Each callback function is expected to return a structure (e.g., a dict or
          #     object) containing at least:
          #       - 'decision': Either 'OK' or 'TRIGGER'.
          #       - 'reason': A string explaining the decision.
          #     A 'TRIGGER' decision may halt further processing.
          # @!attribute [rw] before_model_callback
          #   @return [::Google::Cloud::Ces::V1beta::Callback]
          #     Optional. The callback to execute before the model is called. If there
          #     are multiple calls to the model, the callback will be executed multiple
          #     times. Each callback function is expected to return a structure (e.g., a
          #     dict or object) containing at least:
          #       - 'decision': Either 'OK' or 'TRIGGER'.
          #       - 'reason': A string explaining the decision.
          #     A 'TRIGGER' decision may halt further processing.
          # @!attribute [rw] after_model_callback
          #   @return [::Google::Cloud::Ces::V1beta::Callback]
          #     Optional. The callback to execute after the model is called. If there are
          #     multiple calls to the model, the callback will be executed multiple
          #     times. Each callback function is expected to return a structure (e.g., a
          #     dict or object) containing at least:
          #       - 'decision': Either 'OK' or 'TRIGGER'.
          #       - 'reason': A string explaining the decision.
          #     A 'TRIGGER' decision may halt further processing.
          class CodeCallback
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
