# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Represents an Omnichannel resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the omnichannel resource.
        #     Format:
        #     `projects/{project}/locations/{location}/omnichannels/{omnichannel}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the omnichannel resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human-readable description of the omnichannel resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the omnichannel resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the omnichannel resource was last updated.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Etag used to ensure the object hasn't changed during a
        #     read-modify-write operation.
        # @!attribute [rw] integration_config
        #   @return [::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig]
        #     Optional. The integration config for the omnichannel resource.
        class Omnichannel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # OmnichannelIntegrationConfig contains all App integration configs.
        # @!attribute [rw] channel_configs
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::ChannelConfig}]
        #     Optional. Various of configuration for handling App events.
        # @!attribute [rw] subscriber_configs
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::SubscriberConfig}]
        #     Optional. Various of subscribers configs.
        # @!attribute [rw] routing_configs
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::RoutingConfig}]
        #     Optional. The key of routing_configs is a key of `app_configs`, value is a
        #     `RoutingConfig`, which contains subscriber's key.
        class OmnichannelIntegrationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # ChannelConfig contains config for various of app integration.
          # @!attribute [rw] whatsapp_config
          #   @return [::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::WhatsappConfig]
          #     WhatsApp config.
          class ChannelConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # How Omnichannel should receive/reply events from WhatsApp.
          # @!attribute [rw] phone_number_id
          #   @return [::String]
          #     The Phone Number ID associated with the WhatsApp Business Account.
          # @!attribute [rw] phone_number
          #   @return [::String]
          #     The phone number used for sending/receiving messages.
          # @!attribute [rw] whatsapp_business_account_id
          #   @return [::String]
          #     The customer's WhatsApp Business Account (WABA) ID.
          # @!attribute [rw] webhook_verify_token
          #   @return [::String]
          #     The verify token configured in the Meta App Dashboard for webhook
          #     verification.
          # @!attribute [rw] whatsapp_business_token
          #   @return [::String]
          #     The access token for authenticating API calls to the WhatsApp Cloud API.
          #     https://developers.facebook.com/docs/whatsapp/business-management-api/get-started/#business-integration-system-user-access-tokens
          # @!attribute [rw] meta_business_portfolio_id
          #   @return [::String]
          #     The Meta Business Portfolio (MBP) ID.
          #     https://www.facebook.com/business/help/1710077379203657
          class WhatsappConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configs of subscribers.
          # @!attribute [rw] ces_app_config
          #   @return [::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::CesAppConfig]
          #     Ces app config.
          class SubscriberConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configs for CES app.
          # @!attribute [rw] app
          #   @return [::String]
          #     The unique identifier of the CES app.
          #     Format: `projects/{project}/locations/{location}/apps/{app}`
          class CesAppConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Routing config specify how/who to route app events to a subscriber.
          # @!attribute [rw] subscriber_key
          #   @return [::String]
          #     The key of the subscriber.
          class RoutingConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::ChannelConfig]
          class ChannelConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::SubscriberConfig]
          class SubscriberConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Ces::V1beta::OmnichannelIntegrationConfig::RoutingConfig]
          class RoutingConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
