# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # A toolset that contains a list of tools that are defined by an OpenAPI
        # schema.
        # @!attribute [rw] open_api_schema
        #   @return [::String]
        #     Required. The OpenAPI schema of the toolset.
        # @!attribute [rw] api_authentication
        #   @return [::Google::Cloud::Ces::V1beta::ApiAuthentication]
        #     Optional. Authentication information required by the API.
        # @!attribute [rw] tls_config
        #   @return [::Google::Cloud::Ces::V1beta::TlsConfig]
        #     Optional. The TLS configuration. Includes the custom server certificates
        # @!attribute [rw] service_directory_config
        #   @return [::Google::Cloud::Ces::V1beta::ServiceDirectoryConfig]
        #     Optional. Service Directory configuration.
        # @!attribute [rw] ignore_unknown_fields
        #   @return [::Boolean]
        #     Optional. If true, the agent will ignore unknown fields in the API response
        #     for all operations defined in the OpenAPI schema.
        # @!attribute [rw] url
        #   @return [::String]
        #     Optional. The server URL of the Open API schema.
        #     This field is only set in toolsets in the environment dependencies during
        #     the export process if the schema contains a server url. During the import
        #     process, if this url is present in the environment dependencies and the
        #     schema has the $env_var placeholder, it will replace the placeholder in the
        #     schema.
        class OpenApiToolset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
