# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Represents a select subset of an OpenAPI 3.0 schema object.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Ces::V1beta::Schema::Type]
        #     Required. The type of the data.
        # @!attribute [rw] properties
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Ces::V1beta::Schema}]
        #     Optional. Properties of Type.OBJECT.
        # @!attribute [rw] required
        #   @return [::Array<::String>]
        #     Optional. Required properties of Type.OBJECT.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the data.
        # @!attribute [rw] items
        #   @return [::Google::Cloud::Ces::V1beta::Schema]
        #     Optional. Schema of the elements of Type.ARRAY.
        # @!attribute [rw] nullable
        #   @return [::Boolean]
        #     Optional. Indicates if the value may be null.
        # @!attribute [rw] unique_items
        #   @return [::Boolean]
        #     Optional. Indicate the items in the array must be unique. Only applies to
        #     TYPE.ARRAY.
        # @!attribute [rw] prefix_items
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Schema>]
        #     Optional. Schemas of initial elements of Type.ARRAY.
        # @!attribute [rw] additional_properties
        #   @return [::Google::Cloud::Ces::V1beta::Schema]
        #     Optional. Can either be a boolean or an object, controls the presence of
        #     additional properties.
        # @!attribute [rw] any_of
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Schema>]
        #     Optional. The value should be validated against any (one or more) of the
        #     subschemas in the list.
        # @!attribute [rw] enum
        #   @return [::Array<::String>]
        #     Optional. Possible values of the element of primitive type with enum
        #     format. Examples:
        #     1. We can define direction as :
        #     \\{type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
        #     2. We can define apartment number as :
        #     \\{type:INTEGER, format:enum, enum:["101", "201", "301"]}
        # @!attribute [rw] default
        #   @return [::Google::Protobuf::Value]
        #     Optional. Default value of the data.
        # @!attribute [rw] ref
        #   @return [::String]
        #     Optional. Allows indirect references between schema nodes. The value should
        #     be a valid reference to a child of the root `defs`.
        #
        #     For example, the following schema defines a reference to a schema node
        #     named "Pet":
        #
        #     type: object
        #     properties:
        #       pet:
        #         ref: #/defs/Pet
        #     defs:
        #       Pet:
        #         type: object
        #         properties:
        #           name:
        #             type: string
        #
        #     The value of the "pet" property is a reference to the schema node
        #     named "Pet".
        #     See details in
        #     https://json-schema.org/understanding-json-schema/structuring.
        # @!attribute [rw] defs
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Ces::V1beta::Schema}]
        #     Optional. A map of definitions for use by `ref`. Only allowed at the root
        #     of the schema.
        # @!attribute [rw] title
        #   @return [::String]
        #     Optional. The title of the schema.
        # @!attribute [rw] min_items
        #   @return [::Integer]
        #     Optional. Minimum number of the elements for Type.ARRAY.
        # @!attribute [rw] max_items
        #   @return [::Integer]
        #     Optional. Maximum number of the elements for Type.ARRAY.
        # @!attribute [rw] minimum
        #   @return [::Float]
        #     Optional. Minimum value for Type.INTEGER and Type.NUMBER.
        # @!attribute [rw] maximum
        #   @return [::Float]
        #     Optional. Maximum value for Type.INTEGER and Type.NUMBER.
        class Schema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Ces::V1beta::Schema]
          class PropertiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Ces::V1beta::Schema]
          class DefsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # OpenAPI data types.
          module Type
            # Type unspecified.
            TYPE_UNSPECIFIED = 0

            # String type.
            STRING = 1

            # Integer type.
            INTEGER = 2

            # Number type.
            NUMBER = 3

            # Boolean type.
            BOOLEAN = 4

            # Object type.
            OBJECT = 5

            # Array type.
            ARRAY = 6
          end
        end
      end
    end
  end
end
