# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # InputAudioConfig configures how the CES agent should interpret incoming audio
        # data.
        # @!attribute [rw] audio_encoding
        #   @return [::Google::Cloud::Ces::V1beta::AudioEncoding]
        #     Required. The encoding of the input audio data.
        # @!attribute [rw] sample_rate_hertz
        #   @return [::Integer]
        #     Optional. The sample rate (in Hertz) of the input audio data.
        # @!attribute [rw] noise_suppression_level
        #   @return [::String]
        #     Optional. Whether to enable noise suppression on the input audio.
        #     Available values are "low", "moderate", "high", "very_high".
        class InputAudioConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # OutputAudioConfig configures how the CES agent should synthesize outgoing
        # audio responses.
        # @!attribute [rw] audio_encoding
        #   @return [::Google::Cloud::Ces::V1beta::AudioEncoding]
        #     Required. The encoding of the output audio data.
        # @!attribute [rw] sample_rate_hertz
        #   @return [::Integer]
        #     Optional. The sample rate (in Hertz) of the output audio data.
        class OutputAudioConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration for the session.
        # @!attribute [rw] session
        #   @return [::String]
        #     Required. The unique identifier of the session.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/sessions/{session}`
        # @!attribute [rw] input_audio_config
        #   @return [::Google::Cloud::Ces::V1beta::InputAudioConfig]
        #     Optional. Configuration for processing the input audio.
        # @!attribute [rw] output_audio_config
        #   @return [::Google::Cloud::Ces::V1beta::OutputAudioConfig]
        #     Optional. Configuration for generating the output audio.
        # @!attribute [rw] historical_contexts
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Message>]
        #     Optional. The historical context of the session, including user inputs,
        #     agent responses, and other messages. Typically, CES agent would manage
        #     session automatically so client doesn't need to explicitly populate this
        #     field. However, client can optionally override the historical contexts to
        #     force the session start from certain state.
        # @!attribute [rw] entry_agent
        #   @return [::String]
        #     Optional. The entry agent to handle the session. If not specified, the
        #     session will be handled by the [root
        #     agent][google.cloud.ces.v1beta.App.root_agent] of the app. Format:
        #     `projects/{project}/locations/{location}/agents/{agent}`
        # @!attribute [rw] deployment
        #   @return [::String]
        #     Optional. The deployment of the app to use for the session.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}`
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Optional. The time zone of the user. If provided, the agent will use the
        #     time zone for date and time related variables. Otherwise, the agent will
        #     use the time zone specified in the App.time_zone_settings.
        #
        #     The format is the IANA Time Zone Database time zone, e.g.
        #     "America/Los_Angeles".
        # @!attribute [rw] remote_dialogflow_query_parameters
        #   @return [::Google::Cloud::Ces::V1beta::SessionConfig::RemoteDialogflowQueryParameters]
        #     Optional.
        #     [QueryParameters](https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters)
        #     to send to the remote
        #     [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
        #     agent when the session control is transferred to the remote agent.
        class SessionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # [QueryParameters](https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters)
          # to send to the remote
          # [Dialogflow](https://cloud.google.com/dialogflow/cx/docs/concept/console-conversational-agents)
          # agent when the session control is transferred to the remote agent.
          # @!attribute [rw] webhook_headers
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The HTTP headers to be sent as webhook_headers in
          #     [QueryParameters](https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters).
          # @!attribute [rw] payload
          #   @return [::Google::Protobuf::Struct]
          #     Optional. The payload to be sent in
          #     [QueryParameters](https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters).
          # @!attribute [rw] end_user_metadata
          #   @return [::Google::Protobuf::Struct]
          #     Optional. The end user metadata to be sent in
          #     [QueryParameters](https://cloud.google.com/dialogflow/cx/docs/reference/rpc/google.cloud.dialogflow.cx.v3#queryparameters).
          class RemoteDialogflowQueryParameters
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class WebhookHeadersEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Request for the client to execute the tools and return the execution results
        # before continuing the session.
        # @!attribute [rw] tool_calls
        #   @return [::Array<::Google::Cloud::Ces::V1beta::ToolCall>]
        #     Optional. The list of tool calls to execute.
        class ToolCalls
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Execution results for the requested tool calls from the client.
        # @!attribute [rw] tool_responses
        #   @return [::Array<::Google::Cloud::Ces::V1beta::ToolResponse>]
        #     Optional. The list of tool execution results.
        class ToolResponses
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Citations associated with the agent response.
        # @!attribute [rw] cited_chunks
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Citations::CitedChunk>]
        #     List of cited pieces of information.
        class Citations
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Piece of cited information.
          # @!attribute [rw] uri
          #   @return [::String]
          #     URI used for citation.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the cited document.
          # @!attribute [rw] text
          #   @return [::String]
          #     Text used for citaiton.
          class CitedChunk
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Event input.
        # @!attribute [rw] event
        #   @return [::String]
        #     Required. The name of the event.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input for the session.
        # @!attribute [rw] text
        #   @return [::String]
        #     Optional. Text data from the end user.
        #
        #     Note: The following fields are mutually exclusive: `text`, `dtmf`, `audio`, `tool_responses`, `image`, `blob`, `variables`, `event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dtmf
        #   @return [::String]
        #     Optional. DTMF digits from the end user.
        #
        #     Note: The following fields are mutually exclusive: `dtmf`, `text`, `audio`, `tool_responses`, `image`, `blob`, `variables`, `event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] audio
        #   @return [::String]
        #     Optional. Audio data from the end user.
        #
        #     Note: The following fields are mutually exclusive: `audio`, `text`, `dtmf`, `tool_responses`, `image`, `blob`, `variables`, `event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_responses
        #   @return [::Google::Cloud::Ces::V1beta::ToolResponses]
        #     Optional. Execution results for the tool calls from the client.
        #
        #     Note: The following fields are mutually exclusive: `tool_responses`, `text`, `dtmf`, `audio`, `image`, `blob`, `variables`, `event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image
        #   @return [::Google::Cloud::Ces::V1beta::Image]
        #     Optional. Image data from the end user.
        #
        #     Note: The following fields are mutually exclusive: `image`, `text`, `dtmf`, `audio`, `tool_responses`, `blob`, `variables`, `event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] blob
        #   @return [::Google::Cloud::Ces::V1beta::Blob]
        #     Optional. Blob data from the end user.
        #
        #     Note: The following fields are mutually exclusive: `blob`, `text`, `dtmf`, `audio`, `tool_responses`, `image`, `variables`, `event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] variables
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Contextual variables for the session, keyed by name. Only
        #     variables declared in the app will be used by the CES agent.
        #
        #     Unrecognized variables will still be sent to the [Dialogflow
        #     agent][Agent.RemoteDialogflowAgent] as additional session parameters.
        #
        #     Note: The following fields are mutually exclusive: `variables`, `text`, `dtmf`, `audio`, `tool_responses`, `image`, `blob`, `event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] event
        #   @return [::Google::Cloud::Ces::V1beta::Event]
        #     Optional. Event input.
        #
        #     Note: The following fields are mutually exclusive: `event`, `text`, `dtmf`, `audio`, `tool_responses`, `image`, `blob`, `variables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] will_continue
        #   @return [::Boolean]
        #     Optional. A flag to indicate if the current message is a fragment of a
        #     larger input in the bidi streaming session. When `true`, the agent will
        #     defer processing until a subsequent message with `will_continue` set to
        #     `false` is received.
        #
        #     Note: This flag has no effect on audio and DTMF inputs, which are always
        #     processed in real-time.
        class SessionInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output for the session.
        # @!attribute [rw] text
        #   @return [::String]
        #     Output text from the CES agent.
        #
        #     Note: The following fields are mutually exclusive: `text`, `audio`, `tool_calls`, `citations`, `google_search_suggestions`, `end_session`, `payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] audio
        #   @return [::String]
        #     Output audio from the CES agent.
        #
        #     Note: The following fields are mutually exclusive: `audio`, `text`, `tool_calls`, `citations`, `google_search_suggestions`, `end_session`, `payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_calls
        #   @return [::Google::Cloud::Ces::V1beta::ToolCalls]
        #     Request for the client to execute the tools.
        #
        #     Note: The following fields are mutually exclusive: `tool_calls`, `text`, `audio`, `citations`, `google_search_suggestions`, `end_session`, `payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] citations
        #   @return [::Google::Cloud::Ces::V1beta::Citations]
        #     Citations that provide the source information for the agent's generated
        #     text.
        #
        #     Note: The following fields are mutually exclusive: `citations`, `text`, `audio`, `tool_calls`, `google_search_suggestions`, `end_session`, `payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] google_search_suggestions
        #   @return [::Google::Cloud::Ces::V1beta::GoogleSearchSuggestions]
        #     The suggestions returned from Google Search as a result of invoking the
        #     {::Google::Cloud::Ces::V1beta::GoogleSearchTool GoogleSearchTool}.
        #
        #     Note: The following fields are mutually exclusive: `google_search_suggestions`, `text`, `audio`, `tool_calls`, `citations`, `end_session`, `payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] end_session
        #   @return [::Google::Cloud::Ces::V1beta::EndSession]
        #     Indicates the session has ended.
        #
        #     Note: The following fields are mutually exclusive: `end_session`, `text`, `audio`, `tool_calls`, `citations`, `google_search_suggestions`, `payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] payload
        #   @return [::Google::Protobuf::Struct]
        #     Custom payload with structured output from the CES agent.
        #
        #     Note: The following fields are mutually exclusive: `payload`, `text`, `audio`, `tool_calls`, `citations`, `google_search_suggestions`, `end_session`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] turn_index
        #   @return [::Integer]
        #     Indicates the sequential order of conversation turn to which this output
        #     belongs to, starting from 1.
        # @!attribute [rw] turn_completed
        #   @return [::Boolean]
        #     If true, the CES agent has detected the end of the current conversation
        #     turn and will provide no further output for this turn.
        # @!attribute [rw] diagnostic_info
        #   @return [::Google::Cloud::Ces::V1beta::SessionOutput::DiagnosticInfo]
        #     Optional. Diagnostic information contains execution details during the
        #     processing of the input. Only populated in the last SessionOutput (with
        #     `turn_completed=true`) for each turn.
        class SessionOutput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains execution details during the processing.
          # @!attribute [rw] messages
          #   @return [::Array<::Google::Cloud::Ces::V1beta::Message>]
          #     List of the messages that happened during the processing.
          # @!attribute [rw] root_span
          #   @return [::Google::Cloud::Ces::V1beta::Span]
          #     A trace of the entire request processing, represented as a root span.
          #     This span can contain nested child spans for specific operations.
          class DiagnosticInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Speech recognition result for the audio input.
        # @!attribute [rw] transcript
        #   @return [::String]
        #     Optional. Concatenated user speech segments captured during the current
        #     turn.
        class RecognitionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Indicates the agent's audio response has been interrupted. The client should
        # immediately stop any current audio playback (e.g., due to user barge-in or
        # a new agent response being generated).
        # @!attribute [rw] barge_in
        #   @return [::Boolean]
        #     Whether the interruption is caused by a user barge-in event.
        class InterruptionSignal
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Indicates the session has terminated, due to either successful completion
        # (e.g. user says "Good bye!" ) or an agent escalation.
        #
        # The agent will not process any further inputs after session is terminated and
        # the client should half-close and disconnect after receiving all remaining
        # responses from the agent.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Provides additional information about the end session signal,
        #     such as the reason for ending the session.
        class EndSession
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Indicates that the server will disconnect soon and the client should
        # half-close and restart the connection.
        class GoAway
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::SessionService::Client#run_session SessionService.RunSession}.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Ces::V1beta::SessionConfig]
        #     Required. The configuration for the session.
        # @!attribute [rw] inputs
        #   @return [::Array<::Google::Cloud::Ces::V1beta::SessionInput>]
        #     Required. Inputs for the session.
        class RunSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::SessionService::Client#run_session SessionService.RunSession}.
        # @!attribute [rw] outputs
        #   @return [::Array<::Google::Cloud::Ces::V1beta::SessionOutput>]
        #     Outputs for the session.
        class RunSessionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The top-level message sent by the client for the
        # {::Google::Cloud::Ces::V1beta::SessionService::Client#bidi_run_session SessionService.BidiRunSession}
        # method.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Ces::V1beta::SessionConfig]
        #     Optional. The initial config message for the session.
        #
        #     Note: The following fields are mutually exclusive: `config`, `realtime_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] realtime_input
        #   @return [::Google::Cloud::Ces::V1beta::SessionInput]
        #     Optional. Realtime input for the session.
        #
        #     Note: The following fields are mutually exclusive: `realtime_input`, `config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BidiSessionClientMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The top-level message returned from
        # {::Google::Cloud::Ces::V1beta::SessionService::Client#bidi_run_session SessionService.BidiRunSession}
        # method.
        # @!attribute [rw] session_output
        #   @return [::Google::Cloud::Ces::V1beta::SessionOutput]
        #     Optional. Processing result from the CES agent.
        #
        #     Note: The following fields are mutually exclusive: `session_output`, `recognition_result`, `interruption_signal`, `end_session`, `go_away`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] recognition_result
        #   @return [::Google::Cloud::Ces::V1beta::RecognitionResult]
        #     Optional. Realtime speech recognition result for the audio input.
        #
        #     Note: The following fields are mutually exclusive: `recognition_result`, `session_output`, `interruption_signal`, `end_session`, `go_away`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] interruption_signal
        #   @return [::Google::Cloud::Ces::V1beta::InterruptionSignal]
        #     Optional. Interruption signal detected from the audio input.
        #
        #     Note: The following fields are mutually exclusive: `interruption_signal`, `session_output`, `recognition_result`, `end_session`, `go_away`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] end_session
        #   @return [::Google::Cloud::Ces::V1beta::EndSession]
        #     Optional. Indicates that the session has ended.
        #
        #     Note: The following fields are mutually exclusive: `end_session`, `session_output`, `recognition_result`, `interruption_signal`, `go_away`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] go_away
        #   @return [::Google::Cloud::Ces::V1beta::GoAway]
        #     Optional. Indicates that the server will disconnect soon and the client
        #     should half-close and restart the connection.
        #
        #     Note: The following fields are mutually exclusive: `go_away`, `session_output`, `recognition_result`, `interruption_signal`, `end_session`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BidiSessionServerMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AudioEncoding specifies the encoding format for audio data.
        module AudioEncoding
          # Unspecified audio encoding.
          AUDIO_ENCODING_UNSPECIFIED = 0

          # 16-bit linear PCM audio encoding.
          LINEAR16 = 1

          # 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
          MULAW = 2

          # 8-bit samples that compand 14-bit audio samples using G.711 PCMU/A-law.
          ALAW = 3
        end
      end
    end
  end
end
