# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # A predicate to match a tool created by a toolset.
        # WILL BE DEPRECATED SOON.
        # @!attribute [rw] mcp_tool_predicate
        #   @return [::Google::Cloud::Ces::V1beta::ToolPredicate::McpToolPredicate]
        #     Optional. A tool predicate that is used to match a MCP tool.
        #
        #     Note: The following fields are mutually exclusive: `mcp_tool_predicate`, `open_api_tool_predicate`, `connector_tool_predicate`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] open_api_tool_predicate
        #   @return [::Google::Cloud::Ces::V1beta::ToolPredicate::OpenApiToolPredicate]
        #     Optional. A tool predicate that is used to match an OpenAPI tool.
        #
        #     Note: The following fields are mutually exclusive: `open_api_tool_predicate`, `mcp_tool_predicate`, `connector_tool_predicate`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] connector_tool_predicate
        #   @return [::Google::Cloud::Ces::V1beta::ToolPredicate::ConnectorToolPredicate]
        #     Optional. A tool predicate that is used to match a Connector tool.
        #
        #     Note: The following fields are mutually exclusive: `connector_tool_predicate`, `mcp_tool_predicate`, `open_api_tool_predicate`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the tool predicate and matches the tool
        #     predicate set.
        class ToolPredicate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A tool predicate that is used to match a MCP tool.
          # @!attribute [rw] tool_name
          #   @return [::String]
          #     Required. The name of the individual tool in the MCP toolset.
          class McpToolPredicate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A tool predicate that is used to match an OpenAPI tool.
          # If `operation_id` is specified, OpenAPI tools with the matching operation
          # ID would be selected. Otherwise, OpenAPI tools with the matching `path` and
          # `method` would be returned.
          # @!attribute [rw] operation_id
          #   @return [::String]
          #     Optional. The operationId field of the OpenAPI endpoint.
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. The path of the OpenAPI endpoint.
          # @!attribute [rw] method
          #   @return [::String]
          #     Optional. The HTTP method of the given path.
          class OpenApiToolPredicate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A tool predicate that is used to match a Connector tool. The specified
          # actions must match exactly one tool from the toolset.
          # @!attribute [rw] action
          #   @return [::Google::Cloud::Ces::V1beta::Action]
          #     The connector operation to match.
          class ConnectorToolPredicate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
