# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # Request message for
        # {::Google::Cloud::Ces::V1beta::ToolService::Client#execute_tool ToolService.ExecuteTool}.
        # @!attribute [rw] tool
        #   @return [::String]
        #     Optional. The name of the tool to execute.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/apps/\\{app}/tools/\\{tool}
        #
        #     Note: The following fields are mutually exclusive: `tool`, `toolset_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] toolset_tool
        #   @return [::Google::Cloud::Ces::V1beta::ToolsetTool]
        #     Optional. The toolset tool to execute. Only one tool should match the
        #     predicate from the toolset. Otherwise, an error will be returned.
        #
        #     Note: The following fields are mutually exclusive: `toolset_tool`, `tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app which the tool/toolset belongs to.
        #     Format: `projects/{project}/locations/{location}/apps/{app}`
        # @!attribute [rw] args
        #   @return [::Google::Protobuf::Struct]
        #     Optional. The input parameters and values for the tool in JSON object
        #     format.
        class ExecuteToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::ToolService::Client#execute_tool ToolService.ExecuteTool}.
        # @!attribute [rw] tool
        #   @return [::String]
        #     The name of the tool that got executed.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
        #
        #     Note: The following fields are mutually exclusive: `tool`, `toolset_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] toolset_tool
        #   @return [::Google::Cloud::Ces::V1beta::ToolsetTool]
        #     The toolset tool that got executed.
        #
        #     Note: The following fields are mutually exclusive: `toolset_tool`, `tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] response
        #   @return [::Google::Protobuf::Struct]
        #     Required. The tool execution result in JSON object format.
        #     Use "output" key to specify tool response and "error" key to specify
        #     error details (if any). If "output" and "error" keys are not specified,
        #     then whole "response" is treated as tool execution result.
        class ExecuteToolResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::ToolService::Client#retrieve_tool_schema ToolService.RetrieveToolSchema}.
        # @!attribute [rw] tool
        #   @return [::String]
        #     Optional. The name of the tool to retrieve the schema for.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/apps/\\{app}/tools/\\{tool}
        #
        #     Note: The following fields are mutually exclusive: `tool`, `toolset_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] toolset_tool
        #   @return [::Google::Cloud::Ces::V1beta::ToolsetTool]
        #     Optional. The toolset tool to retrieve the schema for. Only one tool
        #     should match the predicate from the toolset. Otherwise, an error will be
        #     returned.
        #
        #     Note: The following fields are mutually exclusive: `toolset_tool`, `tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the app which the tool/toolset belongs to.
        #     Format: `projects/{project}/locations/{location}/apps/{app}`
        class RetrieveToolSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::ToolService::Client#retrieve_tool_schema ToolService.RetrieveToolSchema}.
        # @!attribute [rw] tool
        #   @return [::String]
        #     The name of the tool that the schema is for.
        #     Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
        #
        #     Note: The following fields are mutually exclusive: `tool`, `toolset_tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] toolset_tool
        #   @return [::Google::Cloud::Ces::V1beta::ToolsetTool]
        #     The toolset tool that the schema is for.
        #
        #     Note: The following fields are mutually exclusive: `toolset_tool`, `tool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] input_schema
        #   @return [::Google::Cloud::Ces::V1beta::Schema]
        #     Required. The schema of the tool input parameters.
        # @!attribute [rw] output_schema
        #   @return [::Google::Cloud::Ces::V1beta::Schema]
        #     Required. The schema of the tool output parameters.
        class RetrieveToolSchemaResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Ces::V1beta::ToolService::Client#retrieve_tools ToolService.RetrieveTools}.
        # @!attribute [rw] toolset
        #   @return [::String]
        #     Required. The name of the toolset to retrieve the tools for.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
        # @!attribute [rw] tool_ids
        #   @return [::Array<::String>]
        #     Optional. The identifiers of the tools to retrieve from the toolset.
        #     If empty, all tools in the toolset will be returned.
        class RetrieveToolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Ces::V1beta::ToolService::Client#retrieve_tools ToolService.RetrieveTools}.
        # @!attribute [rw] tools
        #   @return [::Array<::Google::Cloud::Ces::V1beta::Tool>]
        #     Required. The list of tools that are included in the specified toolset.
        class RetrieveToolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
