# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # A toolset represents a group of dynamically managed tools that can be used
        # by the agent.
        # @!attribute [rw] mcp_toolset
        #   @return [::Google::Cloud::Ces::V1beta::McpToolset]
        #     Optional. A toolset that contains a list of tools that are offered by the
        #     MCP server.
        #
        #     Note: The following fields are mutually exclusive: `mcp_toolset`, `open_api_toolset`, `connector_toolset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] open_api_toolset
        #   @return [::Google::Cloud::Ces::V1beta::OpenApiToolset]
        #     Optional. A toolset that contains a list of tools that are defined by an
        #     OpenAPI schema.
        #
        #     Note: The following fields are mutually exclusive: `open_api_toolset`, `mcp_toolset`, `connector_toolset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] connector_toolset
        #   @return [::Google::Cloud::Ces::V1beta::ConnectorToolset]
        #     Optional. A toolset that generates tools from an Integration Connectors
        #     Connection.
        #
        #     Note: The following fields are mutually exclusive: `connector_toolset`, `mcp_toolset`, `open_api_toolset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the toolset.
        #     Format:
        #     `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the toolset. Must be unique within the same
        #     app.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the toolset.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the toolset was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the toolset was last updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     ETag used to ensure the object hasn't changed during a read-modify-write
        #     operation. If the etag is empty, the update will overwrite any concurrent
        #     changes.
        # @!attribute [rw] execution_type
        #   @return [::Google::Cloud::Ces::V1beta::ExecutionType]
        #     Optional. The execution type of the tools in the toolset.
        class Toolset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
