# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Ces
      module V1beta
        # A retrieval tool that uses Vertex AI RAG (Retrieval-Augmented Generation)
        # to retrieve data.
        # See http://cloud.google.com/vertex-ai/generative-ai/docs/rag-overview for
        # more details.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The vertex AI RAG retrieval tool name.
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. The tool description.
        # @!attribute [rw] rag_resources
        #   @return [::Array<::Google::Cloud::Ces::V1beta::VertexAiRagRetrievalTool::RagResource>]
        #     Optional. The list of rag resources to retrieve from.
        # @!attribute [rw] similarity_top_k
        #   @return [::Integer]
        #     Optional. The similarity top k.
        # @!attribute [rw] vector_distance_threshold
        #   @return [::Float]
        #     Optional. The vector distance threshold.
        class VertexAiRagRetrievalTool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The definition of the Rag resource.
          # @!attribute [rw] rag_corpus
          #   @return [::String]
          #     Required. RagCorpora resource name.
          #     Format:
          #     `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
          # @!attribute [rw] rag_file_ids
          #   @return [::Array<::String>]
          #     Optional. List of RAG file IDs. The files should be in the same
          #     `rag_corpus`.
          class RagResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
