# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/ces/v1beta/agent_service_pb"
require "google/cloud/ces/v1beta/agent_service/rest"


class ::Google::Cloud::Ces::V1beta::AgentService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_apps
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListAppsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_apps_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_apps_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_apps_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_apps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_apps parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_apps ::Google::Cloud::Ces::V1beta::ListAppsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_apps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_apps(::Google::Cloud::Ces::V1beta::ListAppsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_apps_client_stub.call_count
      end
    end
  end

  def test_get_app
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::App.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_app_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_app_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_app_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_app({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_app name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_app ::Google::Cloud::Ces::V1beta::GetAppRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_app({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_app(::Google::Cloud::Ces::V1beta::GetAppRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_app_client_stub.call_count
      end
    end
  end

  def test_create_app
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    app_id = "hello world"
    app = {}

    create_app_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_app_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_app_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_app({ parent: parent, app_id: app_id, app: app }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_app parent: parent, app_id: app_id, app: app do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_app ::Google::Cloud::Ces::V1beta::CreateAppRequest.new(parent: parent, app_id: app_id, app: app) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_app({ parent: parent, app_id: app_id, app: app }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_app(::Google::Cloud::Ces::V1beta::CreateAppRequest.new(parent: parent, app_id: app_id, app: app), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_app_client_stub.call_count
      end
    end
  end

  def test_update_app
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::App.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    app = {}
    update_mask = {}

    update_app_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_update_app_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_app_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_app({ app: app, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_app app: app, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_app ::Google::Cloud::Ces::V1beta::UpdateAppRequest.new(app: app, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_app({ app: app, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_app(::Google::Cloud::Ces::V1beta::UpdateAppRequest.new(app: app, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_app_client_stub.call_count
      end
    end
  end

  def test_delete_app
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_app_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_app_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_app_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_app({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_app name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_app ::Google::Cloud::Ces::V1beta::DeleteAppRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_app({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_app(::Google::Cloud::Ces::V1beta::DeleteAppRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_app_client_stub.call_count
      end
    end
  end

  def test_export_app
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    export_format = :EXPORT_FORMAT_UNSPECIFIED
    gcs_uri = "hello world"

    export_app_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_export_app_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_app_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_app({ name: name, export_format: export_format, gcs_uri: gcs_uri }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_app name: name, export_format: export_format, gcs_uri: gcs_uri do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_app ::Google::Cloud::Ces::V1beta::ExportAppRequest.new(name: name, export_format: export_format, gcs_uri: gcs_uri) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_app({ name: name, export_format: export_format, gcs_uri: gcs_uri }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_app(::Google::Cloud::Ces::V1beta::ExportAppRequest.new(name: name, export_format: export_format, gcs_uri: gcs_uri), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_app_client_stub.call_count
      end
    end
  end

  def test_import_app
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcs_uri = "hello world"
    parent = "hello world"
    display_name = "hello world"
    app_id = "hello world"
    import_options = {}

    import_app_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_import_app_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_app_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_app({ gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_app gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_app ::Google::Cloud::Ces::V1beta::ImportAppRequest.new(gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_app({ gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_app(::Google::Cloud::Ces::V1beta::ImportAppRequest.new(gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_app_client_stub.call_count
      end
    end
  end

  def test_list_agents
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListAgentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_agents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_agents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_agents_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_agents parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_agents ::Google::Cloud::Ces::V1beta::ListAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_agents(::Google::Cloud::Ces::V1beta::ListAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_agents_client_stub.call_count
      end
    end
  end

  def test_get_agent
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Agent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_agent_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_agent({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_agent name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_agent ::Google::Cloud::Ces::V1beta::GetAgentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_agent({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_agent(::Google::Cloud::Ces::V1beta::GetAgentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_agent_client_stub.call_count
      end
    end
  end

  def test_create_agent
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Agent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    agent_id = "hello world"
    agent = {}

    create_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_agent_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_agent({ parent: parent, agent_id: agent_id, agent: agent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_agent parent: parent, agent_id: agent_id, agent: agent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_agent ::Google::Cloud::Ces::V1beta::CreateAgentRequest.new(parent: parent, agent_id: agent_id, agent: agent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_agent({ parent: parent, agent_id: agent_id, agent: agent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_agent(::Google::Cloud::Ces::V1beta::CreateAgentRequest.new(parent: parent, agent_id: agent_id, agent: agent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_agent_client_stub.call_count
      end
    end
  end

  def test_update_agent
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Agent.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    agent = {}
    update_mask = {}

    update_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_update_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_agent_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_agent({ agent: agent, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_agent agent: agent, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_agent ::Google::Cloud::Ces::V1beta::UpdateAgentRequest.new(agent: agent, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_agent({ agent: agent, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_agent(::Google::Cloud::Ces::V1beta::UpdateAgentRequest.new(agent: agent, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_agent_client_stub.call_count
      end
    end
  end

  def test_delete_agent
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_agent_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_agent_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_agent_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_agent({ name: name, force: force, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_agent name: name, force: force, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_agent ::Google::Cloud::Ces::V1beta::DeleteAgentRequest.new(name: name, force: force, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_agent({ name: name, force: force, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_agent(::Google::Cloud::Ces::V1beta::DeleteAgentRequest.new(name: name, force: force, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_agent_client_stub.call_count
      end
    end
  end

  def test_list_examples
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListExamplesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_examples_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_examples_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_examples_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_examples({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_examples parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_examples ::Google::Cloud::Ces::V1beta::ListExamplesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_examples({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_examples(::Google::Cloud::Ces::V1beta::ListExamplesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_examples_client_stub.call_count
      end
    end
  end

  def test_get_example
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Example.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_example_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_example_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_example_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_example({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_example name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_example ::Google::Cloud::Ces::V1beta::GetExampleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_example({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_example(::Google::Cloud::Ces::V1beta::GetExampleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_example_client_stub.call_count
      end
    end
  end

  def test_create_example
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Example.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    example_id = "hello world"
    example = {}

    create_example_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_example_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_example_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_example({ parent: parent, example_id: example_id, example: example }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_example parent: parent, example_id: example_id, example: example do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_example ::Google::Cloud::Ces::V1beta::CreateExampleRequest.new(parent: parent, example_id: example_id, example: example) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_example({ parent: parent, example_id: example_id, example: example }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_example(::Google::Cloud::Ces::V1beta::CreateExampleRequest.new(parent: parent, example_id: example_id, example: example), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_example_client_stub.call_count
      end
    end
  end

  def test_update_example
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Example.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    example = {}
    update_mask = {}

    update_example_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_update_example_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_example_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_example({ example: example, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_example example: example, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_example ::Google::Cloud::Ces::V1beta::UpdateExampleRequest.new(example: example, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_example({ example: example, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_example(::Google::Cloud::Ces::V1beta::UpdateExampleRequest.new(example: example, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_example_client_stub.call_count
      end
    end
  end

  def test_delete_example
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_example_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_example_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_example_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_example({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_example name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_example ::Google::Cloud::Ces::V1beta::DeleteExampleRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_example({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_example(::Google::Cloud::Ces::V1beta::DeleteExampleRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_example_client_stub.call_count
      end
    end
  end

  def test_list_tools
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListToolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_tools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_tools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tools_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tools parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tools ::Google::Cloud::Ces::V1beta::ListToolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tools(::Google::Cloud::Ces::V1beta::ListToolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tools_client_stub.call_count
      end
    end
  end

  def test_get_tool
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Tool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_tool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tool_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tool ::Google::Cloud::Ces::V1beta::GetToolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tool(::Google::Cloud::Ces::V1beta::GetToolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tool_client_stub.call_count
      end
    end
  end

  def test_list_conversations
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListConversationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    source = :SOURCE_UNSPECIFIED

    list_conversations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_conversations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_conversations_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_conversations parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_conversations ::Google::Cloud::Ces::V1beta::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_conversations(::Google::Cloud::Ces::V1beta::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_conversations_client_stub.call_count
      end
    end
  end

  def test_get_conversation
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Conversation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    source = :SOURCE_UNSPECIFIED

    get_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_conversation({ name: name, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_conversation name: name, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_conversation ::Google::Cloud::Ces::V1beta::GetConversationRequest.new(name: name, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_conversation({ name: name, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_conversation(::Google::Cloud::Ces::V1beta::GetConversationRequest.new(name: name, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_conversation_client_stub.call_count
      end
    end
  end

  def test_delete_conversation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    source = :SOURCE_UNSPECIFIED

    delete_conversation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_conversation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_conversation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_conversation({ name: name, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_conversation name: name, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_conversation ::Google::Cloud::Ces::V1beta::DeleteConversationRequest.new(name: name, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_conversation({ name: name, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_conversation(::Google::Cloud::Ces::V1beta::DeleteConversationRequest.new(name: name, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_conversation_client_stub.call_count
      end
    end
  end

  def test_batch_delete_conversations
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversations = ["hello world"]

    batch_delete_conversations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_batch_delete_conversations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_delete_conversations_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_delete_conversations({ parent: parent, conversations: conversations }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_delete_conversations parent: parent, conversations: conversations do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_delete_conversations ::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest.new(parent: parent, conversations: conversations) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_delete_conversations({ parent: parent, conversations: conversations }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_delete_conversations(::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest.new(parent: parent, conversations: conversations), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_delete_conversations_client_stub.call_count
      end
    end
  end

  def test_create_tool
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Tool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tool_id = "hello world"
    tool = {}

    create_tool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_tool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tool_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tool({ parent: parent, tool_id: tool_id, tool: tool }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tool parent: parent, tool_id: tool_id, tool: tool do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tool ::Google::Cloud::Ces::V1beta::CreateToolRequest.new(parent: parent, tool_id: tool_id, tool: tool) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tool({ parent: parent, tool_id: tool_id, tool: tool }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tool(::Google::Cloud::Ces::V1beta::CreateToolRequest.new(parent: parent, tool_id: tool_id, tool: tool), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tool_client_stub.call_count
      end
    end
  end

  def test_update_tool
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Tool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tool = {}
    update_mask = {}

    update_tool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_update_tool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tool_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tool({ tool: tool, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tool tool: tool, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tool ::Google::Cloud::Ces::V1beta::UpdateToolRequest.new(tool: tool, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tool({ tool: tool, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tool(::Google::Cloud::Ces::V1beta::UpdateToolRequest.new(tool: tool, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tool_client_stub.call_count
      end
    end
  end

  def test_delete_tool
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_tool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_tool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tool_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tool({ name: name, force: force, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tool name: name, force: force, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tool ::Google::Cloud::Ces::V1beta::DeleteToolRequest.new(name: name, force: force, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tool({ name: name, force: force, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tool(::Google::Cloud::Ces::V1beta::DeleteToolRequest.new(name: name, force: force, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tool_client_stub.call_count
      end
    end
  end

  def test_list_guardrails
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListGuardrailsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_guardrails_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_guardrails_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_guardrails_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_guardrails({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_guardrails parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_guardrails ::Google::Cloud::Ces::V1beta::ListGuardrailsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_guardrails({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_guardrails(::Google::Cloud::Ces::V1beta::ListGuardrailsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_guardrails_client_stub.call_count
      end
    end
  end

  def test_get_guardrail
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Guardrail.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_guardrail_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_guardrail_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_guardrail_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_guardrail({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_guardrail name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_guardrail ::Google::Cloud::Ces::V1beta::GetGuardrailRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_guardrail({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_guardrail(::Google::Cloud::Ces::V1beta::GetGuardrailRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_guardrail_client_stub.call_count
      end
    end
  end

  def test_create_guardrail
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Guardrail.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    guardrail_id = "hello world"
    guardrail = {}

    create_guardrail_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_guardrail_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_guardrail_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_guardrail({ parent: parent, guardrail_id: guardrail_id, guardrail: guardrail }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_guardrail parent: parent, guardrail_id: guardrail_id, guardrail: guardrail do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_guardrail ::Google::Cloud::Ces::V1beta::CreateGuardrailRequest.new(parent: parent, guardrail_id: guardrail_id, guardrail: guardrail) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_guardrail({ parent: parent, guardrail_id: guardrail_id, guardrail: guardrail }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_guardrail(::Google::Cloud::Ces::V1beta::CreateGuardrailRequest.new(parent: parent, guardrail_id: guardrail_id, guardrail: guardrail), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_guardrail_client_stub.call_count
      end
    end
  end

  def test_update_guardrail
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Guardrail.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    guardrail = {}
    update_mask = {}

    update_guardrail_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_update_guardrail_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_guardrail_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_guardrail({ guardrail: guardrail, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_guardrail guardrail: guardrail, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_guardrail ::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest.new(guardrail: guardrail, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_guardrail({ guardrail: guardrail, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_guardrail(::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest.new(guardrail: guardrail, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_guardrail_client_stub.call_count
      end
    end
  end

  def test_delete_guardrail
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_guardrail_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_guardrail_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_guardrail_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_guardrail({ name: name, force: force, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_guardrail name: name, force: force, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_guardrail ::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest.new(name: name, force: force, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_guardrail({ name: name, force: force, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_guardrail(::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest.new(name: name, force: force, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_guardrail_client_stub.call_count
      end
    end
  end

  def test_list_deployments
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListDeploymentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_deployments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_deployments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_deployments_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_deployments parent: parent, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_deployments ::Google::Cloud::Ces::V1beta::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_deployments(::Google::Cloud::Ces::V1beta::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_deployments_client_stub.call_count
      end
    end
  end

  def test_get_deployment
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_deployment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_deployment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_deployment ::Google::Cloud::Ces::V1beta::GetDeploymentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_deployment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_deployment(::Google::Cloud::Ces::V1beta::GetDeploymentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_deployment_client_stub.call_count
      end
    end
  end

  def test_create_deployment
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}

    create_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_deployment ::Google::Cloud::Ces::V1beta::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_deployment(::Google::Cloud::Ces::V1beta::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_deployment_client_stub.call_count
      end
    end
  end

  def test_update_deployment
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Deployment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    deployment = {}
    update_mask = {}

    update_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_update_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_deployment({ deployment: deployment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_deployment deployment: deployment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_deployment ::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_deployment({ deployment: deployment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_deployment(::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_deployment_client_stub.call_count
      end
    end
  end

  def test_delete_deployment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_deployment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_deployment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_deployment_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_deployment({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_deployment name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_deployment ::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_deployment({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_deployment(::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_deployment_client_stub.call_count
      end
    end
  end

  def test_list_toolsets
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListToolsetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_toolsets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_toolsets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_toolsets_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_toolsets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_toolsets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_toolsets ::Google::Cloud::Ces::V1beta::ListToolsetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_toolsets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_toolsets(::Google::Cloud::Ces::V1beta::ListToolsetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_toolsets_client_stub.call_count
      end
    end
  end

  def test_get_toolset
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Toolset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_toolset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_toolset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_toolset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_toolset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_toolset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_toolset ::Google::Cloud::Ces::V1beta::GetToolsetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_toolset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_toolset(::Google::Cloud::Ces::V1beta::GetToolsetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_toolset_client_stub.call_count
      end
    end
  end

  def test_create_toolset
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Toolset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    toolset_id = "hello world"
    toolset = {}

    create_toolset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_toolset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_toolset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_toolset({ parent: parent, toolset_id: toolset_id, toolset: toolset }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_toolset parent: parent, toolset_id: toolset_id, toolset: toolset do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_toolset ::Google::Cloud::Ces::V1beta::CreateToolsetRequest.new(parent: parent, toolset_id: toolset_id, toolset: toolset) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_toolset({ parent: parent, toolset_id: toolset_id, toolset: toolset }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_toolset(::Google::Cloud::Ces::V1beta::CreateToolsetRequest.new(parent: parent, toolset_id: toolset_id, toolset: toolset), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_toolset_client_stub.call_count
      end
    end
  end

  def test_update_toolset
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Toolset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    toolset = {}
    update_mask = {}

    update_toolset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_update_toolset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_toolset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_toolset({ toolset: toolset, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_toolset toolset: toolset, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_toolset ::Google::Cloud::Ces::V1beta::UpdateToolsetRequest.new(toolset: toolset, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_toolset({ toolset: toolset, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_toolset(::Google::Cloud::Ces::V1beta::UpdateToolsetRequest.new(toolset: toolset, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_toolset_client_stub.call_count
      end
    end
  end

  def test_delete_toolset
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_toolset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_toolset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_toolset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_toolset({ name: name, force: force, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_toolset name: name, force: force, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_toolset ::Google::Cloud::Ces::V1beta::DeleteToolsetRequest.new(name: name, force: force, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_toolset({ name: name, force: force, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_toolset(::Google::Cloud::Ces::V1beta::DeleteToolsetRequest.new(name: name, force: force, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_toolset_client_stub.call_count
      end
    end
  end

  def test_list_app_versions
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListAppVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_app_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_app_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_app_versions_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_app_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_app_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_app_versions ::Google::Cloud::Ces::V1beta::ListAppVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_app_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_app_versions(::Google::Cloud::Ces::V1beta::ListAppVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_app_versions_client_stub.call_count
      end
    end
  end

  def test_get_app_version
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::AppVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_app_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_app_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_app_version_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_app_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_app_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_app_version ::Google::Cloud::Ces::V1beta::GetAppVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_app_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_app_version(::Google::Cloud::Ces::V1beta::GetAppVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_app_version_client_stub.call_count
      end
    end
  end

  def test_create_app_version
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::AppVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    app_version_id = "hello world"
    app_version = {}

    create_app_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_create_app_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_app_version_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_app_version({ parent: parent, app_version_id: app_version_id, app_version: app_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_app_version parent: parent, app_version_id: app_version_id, app_version: app_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_app_version ::Google::Cloud::Ces::V1beta::CreateAppVersionRequest.new(parent: parent, app_version_id: app_version_id, app_version: app_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_app_version({ parent: parent, app_version_id: app_version_id, app_version: app_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_app_version(::Google::Cloud::Ces::V1beta::CreateAppVersionRequest.new(parent: parent, app_version_id: app_version_id, app_version: app_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_app_version_client_stub.call_count
      end
    end
  end

  def test_delete_app_version
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_app_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_delete_app_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_app_version_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_app_version({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_app_version name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_app_version ::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_app_version({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_app_version(::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_app_version_client_stub.call_count
      end
    end
  end

  def test_restore_app_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restore_app_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_restore_app_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restore_app_version_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restore_app_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restore_app_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restore_app_version ::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restore_app_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restore_app_version(::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restore_app_version_client_stub.call_count
      end
    end
  end

  def test_list_changelogs
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListChangelogsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_changelogs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_list_changelogs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_changelogs_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_changelogs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_changelogs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_changelogs ::Google::Cloud::Ces::V1beta::ListChangelogsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_changelogs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_changelogs(::Google::Cloud::Ces::V1beta::ListChangelogsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_changelogs_client_stub.call_count
      end
    end
  end

  def test_get_changelog
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Changelog.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_changelog_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::AgentService::Rest::ServiceStub.stub :transcode_get_changelog_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_changelog_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_changelog({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_changelog name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_changelog ::Google::Cloud::Ces::V1beta::GetChangelogRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_changelog({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_changelog(::Google::Cloud::Ces::V1beta::GetChangelogRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_changelog_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Ces::V1beta::AgentService::Rest::Client::Configuration, config
  end
end
