# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/ces/v1beta/agent_service_pb"
require "google/cloud/ces/v1beta/agent_service"

class ::Google::Cloud::Ces::V1beta::AgentService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_apps
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListAppsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_apps_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_apps, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListAppsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_apps_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_apps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_apps parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_apps ::Google::Cloud::Ces::V1beta::ListAppsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_apps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_apps(::Google::Cloud::Ces::V1beta::ListAppsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_apps_client_stub.call_rpc_count
    end
  end

  def test_get_app
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::App.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_app_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_app, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetAppRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_app_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_app({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_app name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_app ::Google::Cloud::Ces::V1beta::GetAppRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_app({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_app(::Google::Cloud::Ces::V1beta::GetAppRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_app_client_stub.call_rpc_count
    end
  end

  def test_create_app
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    app_id = "hello world"
    app = {}

    create_app_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_app, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateAppRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["app_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::App), request["app"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_app_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_app({ parent: parent, app_id: app_id, app: app }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_app parent: parent, app_id: app_id, app: app do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_app ::Google::Cloud::Ces::V1beta::CreateAppRequest.new(parent: parent, app_id: app_id, app: app) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_app({ parent: parent, app_id: app_id, app: app }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_app(::Google::Cloud::Ces::V1beta::CreateAppRequest.new(parent: parent, app_id: app_id, app: app), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_app_client_stub.call_rpc_count
    end
  end

  def test_update_app
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::App.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    app = {}
    update_mask = {}

    update_app_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_app, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateAppRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::App), request["app"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_app_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_app({ app: app, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_app app: app, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_app ::Google::Cloud::Ces::V1beta::UpdateAppRequest.new(app: app, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_app({ app: app, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_app(::Google::Cloud::Ces::V1beta::UpdateAppRequest.new(app: app, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_app_client_stub.call_rpc_count
    end
  end

  def test_delete_app
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_app_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_app, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteAppRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_app_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_app({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_app name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_app ::Google::Cloud::Ces::V1beta::DeleteAppRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_app({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_app(::Google::Cloud::Ces::V1beta::DeleteAppRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_app_client_stub.call_rpc_count
    end
  end

  def test_export_app
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    export_format = :EXPORT_FORMAT_UNSPECIFIED
    gcs_uri = "hello world"

    export_app_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_app, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ExportAppRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :EXPORT_FORMAT_UNSPECIFIED, request["export_format"]
      assert_equal "hello world", request["gcs_uri"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_app_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_app({ name: name, export_format: export_format, gcs_uri: gcs_uri }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_app name: name, export_format: export_format, gcs_uri: gcs_uri do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_app ::Google::Cloud::Ces::V1beta::ExportAppRequest.new(name: name, export_format: export_format, gcs_uri: gcs_uri) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_app({ name: name, export_format: export_format, gcs_uri: gcs_uri }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_app(::Google::Cloud::Ces::V1beta::ExportAppRequest.new(name: name, export_format: export_format, gcs_uri: gcs_uri), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_app_client_stub.call_rpc_count
    end
  end

  def test_import_app
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcs_uri = "hello world"
    parent = "hello world"
    display_name = "hello world"
    app_id = "hello world"
    import_options = {}

    import_app_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_app, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ImportAppRequest, request
      assert_equal "hello world", request["gcs_uri"]
      assert_equal :gcs_uri, request.app
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["display_name"]
      assert_equal "hello world", request["app_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::ImportAppRequest::ImportOptions), request["import_options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_app_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_app({ gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_app gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_app ::Google::Cloud::Ces::V1beta::ImportAppRequest.new(gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_app({ gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_app(::Google::Cloud::Ces::V1beta::ImportAppRequest.new(gcs_uri: gcs_uri, parent: parent, display_name: display_name, app_id: app_id, import_options: import_options), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_app_client_stub.call_rpc_count
    end
  end

  def test_list_agents
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListAgentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_agents_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_agents, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListAgentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_agents_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_agents parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_agents ::Google::Cloud::Ces::V1beta::ListAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_agents({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_agents(::Google::Cloud::Ces::V1beta::ListAgentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_agents_client_stub.call_rpc_count
    end
  end

  def test_get_agent
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Agent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_agent_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_agent, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetAgentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_agent_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_agent({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_agent name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_agent ::Google::Cloud::Ces::V1beta::GetAgentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_agent({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_agent(::Google::Cloud::Ces::V1beta::GetAgentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_agent_client_stub.call_rpc_count
    end
  end

  def test_create_agent
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Agent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    agent_id = "hello world"
    agent = {}

    create_agent_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_agent, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateAgentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["agent_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Agent), request["agent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_agent_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_agent({ parent: parent, agent_id: agent_id, agent: agent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_agent parent: parent, agent_id: agent_id, agent: agent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_agent ::Google::Cloud::Ces::V1beta::CreateAgentRequest.new(parent: parent, agent_id: agent_id, agent: agent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_agent({ parent: parent, agent_id: agent_id, agent: agent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_agent(::Google::Cloud::Ces::V1beta::CreateAgentRequest.new(parent: parent, agent_id: agent_id, agent: agent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_agent_client_stub.call_rpc_count
    end
  end

  def test_update_agent
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Agent.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    agent = {}
    update_mask = {}

    update_agent_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_agent, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateAgentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Agent), request["agent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_agent_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_agent({ agent: agent, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_agent agent: agent, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_agent ::Google::Cloud::Ces::V1beta::UpdateAgentRequest.new(agent: agent, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_agent({ agent: agent, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_agent(::Google::Cloud::Ces::V1beta::UpdateAgentRequest.new(agent: agent, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_agent_client_stub.call_rpc_count
    end
  end

  def test_delete_agent
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_agent_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_agent, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteAgentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_agent_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_agent({ name: name, force: force, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_agent name: name, force: force, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_agent ::Google::Cloud::Ces::V1beta::DeleteAgentRequest.new(name: name, force: force, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_agent({ name: name, force: force, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_agent(::Google::Cloud::Ces::V1beta::DeleteAgentRequest.new(name: name, force: force, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_agent_client_stub.call_rpc_count
    end
  end

  def test_list_examples
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListExamplesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_examples_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_examples, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListExamplesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_examples_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_examples({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_examples parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_examples ::Google::Cloud::Ces::V1beta::ListExamplesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_examples({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_examples(::Google::Cloud::Ces::V1beta::ListExamplesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_examples_client_stub.call_rpc_count
    end
  end

  def test_get_example
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Example.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_example_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_example, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetExampleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_example_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_example({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_example name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_example ::Google::Cloud::Ces::V1beta::GetExampleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_example({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_example(::Google::Cloud::Ces::V1beta::GetExampleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_example_client_stub.call_rpc_count
    end
  end

  def test_create_example
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Example.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    example_id = "hello world"
    example = {}

    create_example_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_example, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateExampleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["example_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Example), request["example"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_example_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_example({ parent: parent, example_id: example_id, example: example }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_example parent: parent, example_id: example_id, example: example do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_example ::Google::Cloud::Ces::V1beta::CreateExampleRequest.new(parent: parent, example_id: example_id, example: example) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_example({ parent: parent, example_id: example_id, example: example }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_example(::Google::Cloud::Ces::V1beta::CreateExampleRequest.new(parent: parent, example_id: example_id, example: example), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_example_client_stub.call_rpc_count
    end
  end

  def test_update_example
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Example.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    example = {}
    update_mask = {}

    update_example_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_example, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateExampleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Example), request["example"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_example_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_example({ example: example, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_example example: example, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_example ::Google::Cloud::Ces::V1beta::UpdateExampleRequest.new(example: example, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_example({ example: example, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_example(::Google::Cloud::Ces::V1beta::UpdateExampleRequest.new(example: example, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_example_client_stub.call_rpc_count
    end
  end

  def test_delete_example
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_example_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_example, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteExampleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_example_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_example({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_example name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_example ::Google::Cloud::Ces::V1beta::DeleteExampleRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_example({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_example(::Google::Cloud::Ces::V1beta::DeleteExampleRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_example_client_stub.call_rpc_count
    end
  end

  def test_list_tools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListToolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_tools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_tools, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListToolsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_tools_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_tools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_tools parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_tools ::Google::Cloud::Ces::V1beta::ListToolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_tools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_tools(::Google::Cloud::Ces::V1beta::ListToolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_tools_client_stub.call_rpc_count
    end
  end

  def test_get_tool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Tool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_tool, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetToolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_tool_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_tool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_tool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_tool ::Google::Cloud::Ces::V1beta::GetToolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_tool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_tool(::Google::Cloud::Ces::V1beta::GetToolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_tool_client_stub.call_rpc_count
    end
  end

  def test_list_conversations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListConversationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    source = :SOURCE_UNSPECIFIED

    list_conversations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversations, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListConversationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal :SOURCE_UNSPECIFIED, request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversations_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversations parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversations ::Google::Cloud::Ces::V1beta::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversations(::Google::Cloud::Ces::V1beta::ListConversationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, source: source), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversations_client_stub.call_rpc_count
    end
  end

  def test_get_conversation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Conversation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    source = :SOURCE_UNSPECIFIED

    get_conversation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetConversationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :SOURCE_UNSPECIFIED, request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversation({ name: name, source: source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversation name: name, source: source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversation ::Google::Cloud::Ces::V1beta::GetConversationRequest.new(name: name, source: source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversation({ name: name, source: source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversation(::Google::Cloud::Ces::V1beta::GetConversationRequest.new(name: name, source: source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversation_client_stub.call_rpc_count
    end
  end

  def test_delete_conversation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    source = :SOURCE_UNSPECIFIED

    delete_conversation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_conversation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteConversationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :SOURCE_UNSPECIFIED, request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_conversation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_conversation({ name: name, source: source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_conversation name: name, source: source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_conversation ::Google::Cloud::Ces::V1beta::DeleteConversationRequest.new(name: name, source: source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_conversation({ name: name, source: source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_conversation(::Google::Cloud::Ces::V1beta::DeleteConversationRequest.new(name: name, source: source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_conversation_client_stub.call_rpc_count
    end
  end

  def test_batch_delete_conversations
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversations = ["hello world"]

    batch_delete_conversations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_delete_conversations, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["conversations"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_delete_conversations_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_delete_conversations({ parent: parent, conversations: conversations }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_delete_conversations parent: parent, conversations: conversations do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_delete_conversations ::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest.new(parent: parent, conversations: conversations) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_delete_conversations({ parent: parent, conversations: conversations }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_delete_conversations(::Google::Cloud::Ces::V1beta::BatchDeleteConversationsRequest.new(parent: parent, conversations: conversations), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_delete_conversations_client_stub.call_rpc_count
    end
  end

  def test_create_tool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Tool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tool_id = "hello world"
    tool = {}

    create_tool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_tool, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateToolRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["tool_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Tool), request["tool"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_tool_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_tool({ parent: parent, tool_id: tool_id, tool: tool }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_tool parent: parent, tool_id: tool_id, tool: tool do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_tool ::Google::Cloud::Ces::V1beta::CreateToolRequest.new(parent: parent, tool_id: tool_id, tool: tool) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_tool({ parent: parent, tool_id: tool_id, tool: tool }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_tool(::Google::Cloud::Ces::V1beta::CreateToolRequest.new(parent: parent, tool_id: tool_id, tool: tool), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_tool_client_stub.call_rpc_count
    end
  end

  def test_update_tool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Tool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    tool = {}
    update_mask = {}

    update_tool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_tool, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateToolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Tool), request["tool"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_tool_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_tool({ tool: tool, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_tool tool: tool, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_tool ::Google::Cloud::Ces::V1beta::UpdateToolRequest.new(tool: tool, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_tool({ tool: tool, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_tool(::Google::Cloud::Ces::V1beta::UpdateToolRequest.new(tool: tool, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_tool_client_stub.call_rpc_count
    end
  end

  def test_delete_tool
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_tool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_tool, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteToolRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_tool_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_tool({ name: name, force: force, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_tool name: name, force: force, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_tool ::Google::Cloud::Ces::V1beta::DeleteToolRequest.new(name: name, force: force, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_tool({ name: name, force: force, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_tool(::Google::Cloud::Ces::V1beta::DeleteToolRequest.new(name: name, force: force, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_tool_client_stub.call_rpc_count
    end
  end

  def test_list_guardrails
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListGuardrailsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_guardrails_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_guardrails, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListGuardrailsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_guardrails_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_guardrails({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_guardrails parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_guardrails ::Google::Cloud::Ces::V1beta::ListGuardrailsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_guardrails({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_guardrails(::Google::Cloud::Ces::V1beta::ListGuardrailsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_guardrails_client_stub.call_rpc_count
    end
  end

  def test_get_guardrail
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Guardrail.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_guardrail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_guardrail, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetGuardrailRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_guardrail_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_guardrail({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_guardrail name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_guardrail ::Google::Cloud::Ces::V1beta::GetGuardrailRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_guardrail({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_guardrail(::Google::Cloud::Ces::V1beta::GetGuardrailRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_guardrail_client_stub.call_rpc_count
    end
  end

  def test_create_guardrail
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Guardrail.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    guardrail_id = "hello world"
    guardrail = {}

    create_guardrail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_guardrail, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateGuardrailRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["guardrail_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Guardrail), request["guardrail"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_guardrail_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_guardrail({ parent: parent, guardrail_id: guardrail_id, guardrail: guardrail }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_guardrail parent: parent, guardrail_id: guardrail_id, guardrail: guardrail do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_guardrail ::Google::Cloud::Ces::V1beta::CreateGuardrailRequest.new(parent: parent, guardrail_id: guardrail_id, guardrail: guardrail) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_guardrail({ parent: parent, guardrail_id: guardrail_id, guardrail: guardrail }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_guardrail(::Google::Cloud::Ces::V1beta::CreateGuardrailRequest.new(parent: parent, guardrail_id: guardrail_id, guardrail: guardrail), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_guardrail_client_stub.call_rpc_count
    end
  end

  def test_update_guardrail
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Guardrail.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    guardrail = {}
    update_mask = {}

    update_guardrail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_guardrail, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Guardrail), request["guardrail"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_guardrail_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_guardrail({ guardrail: guardrail, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_guardrail guardrail: guardrail, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_guardrail ::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest.new(guardrail: guardrail, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_guardrail({ guardrail: guardrail, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_guardrail(::Google::Cloud::Ces::V1beta::UpdateGuardrailRequest.new(guardrail: guardrail, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_guardrail_client_stub.call_rpc_count
    end
  end

  def test_delete_guardrail
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_guardrail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_guardrail, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_guardrail_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_guardrail({ name: name, force: force, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_guardrail name: name, force: force, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_guardrail ::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest.new(name: name, force: force, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_guardrail({ name: name, force: force, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_guardrail(::Google::Cloud::Ces::V1beta::DeleteGuardrailRequest.new(name: name, force: force, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_guardrail_client_stub.call_rpc_count
    end
  end

  def test_list_deployments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListDeploymentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_deployments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_deployments, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListDeploymentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_deployments_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_deployments parent: parent, page_size: page_size, page_token: page_token, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_deployments ::Google::Cloud::Ces::V1beta::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_deployments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_deployments(::Google::Cloud::Ces::V1beta::ListDeploymentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_deployments_client_stub.call_rpc_count
    end
  end

  def test_get_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_deployment, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetDeploymentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_deployment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_deployment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_deployment ::Google::Cloud::Ces::V1beta::GetDeploymentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_deployment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_deployment(::Google::Cloud::Ces::V1beta::GetDeploymentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_deployment_client_stub.call_rpc_count
    end
  end

  def test_create_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_id = "hello world"
    deployment = {}

    create_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_deployment, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateDeploymentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["deployment_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Deployment), request["deployment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_deployment parent: parent, deployment_id: deployment_id, deployment: deployment do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_deployment ::Google::Cloud::Ces::V1beta::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_deployment({ parent: parent, deployment_id: deployment_id, deployment: deployment }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_deployment(::Google::Cloud::Ces::V1beta::CreateDeploymentRequest.new(parent: parent, deployment_id: deployment_id, deployment: deployment), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_deployment_client_stub.call_rpc_count
    end
  end

  def test_update_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Deployment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    deployment = {}
    update_mask = {}

    update_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_deployment, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Deployment), request["deployment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_deployment({ deployment: deployment, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_deployment deployment: deployment, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_deployment ::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_deployment({ deployment: deployment, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_deployment(::Google::Cloud::Ces::V1beta::UpdateDeploymentRequest.new(deployment: deployment, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_deployment_client_stub.call_rpc_count
    end
  end

  def test_delete_deployment
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_deployment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_deployment, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_deployment_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_deployment({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_deployment name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_deployment ::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_deployment({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_deployment(::Google::Cloud::Ces::V1beta::DeleteDeploymentRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_deployment_client_stub.call_rpc_count
    end
  end

  def test_list_toolsets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListToolsetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_toolsets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_toolsets, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListToolsetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_toolsets_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_toolsets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_toolsets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_toolsets ::Google::Cloud::Ces::V1beta::ListToolsetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_toolsets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_toolsets(::Google::Cloud::Ces::V1beta::ListToolsetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_toolsets_client_stub.call_rpc_count
    end
  end

  def test_get_toolset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Toolset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_toolset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_toolset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetToolsetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_toolset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_toolset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_toolset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_toolset ::Google::Cloud::Ces::V1beta::GetToolsetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_toolset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_toolset(::Google::Cloud::Ces::V1beta::GetToolsetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_toolset_client_stub.call_rpc_count
    end
  end

  def test_create_toolset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Toolset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    toolset_id = "hello world"
    toolset = {}

    create_toolset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_toolset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateToolsetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["toolset_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Toolset), request["toolset"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_toolset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_toolset({ parent: parent, toolset_id: toolset_id, toolset: toolset }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_toolset parent: parent, toolset_id: toolset_id, toolset: toolset do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_toolset ::Google::Cloud::Ces::V1beta::CreateToolsetRequest.new(parent: parent, toolset_id: toolset_id, toolset: toolset) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_toolset({ parent: parent, toolset_id: toolset_id, toolset: toolset }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_toolset(::Google::Cloud::Ces::V1beta::CreateToolsetRequest.new(parent: parent, toolset_id: toolset_id, toolset: toolset), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_toolset_client_stub.call_rpc_count
    end
  end

  def test_update_toolset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Toolset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    toolset = {}
    update_mask = {}

    update_toolset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_toolset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateToolsetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Toolset), request["toolset"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_toolset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_toolset({ toolset: toolset, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_toolset toolset: toolset, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_toolset ::Google::Cloud::Ces::V1beta::UpdateToolsetRequest.new(toolset: toolset, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_toolset({ toolset: toolset, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_toolset(::Google::Cloud::Ces::V1beta::UpdateToolsetRequest.new(toolset: toolset, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_toolset_client_stub.call_rpc_count
    end
  end

  def test_delete_toolset
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_toolset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_toolset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteToolsetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_toolset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_toolset({ name: name, force: force, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_toolset name: name, force: force, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_toolset ::Google::Cloud::Ces::V1beta::DeleteToolsetRequest.new(name: name, force: force, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_toolset({ name: name, force: force, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_toolset(::Google::Cloud::Ces::V1beta::DeleteToolsetRequest.new(name: name, force: force, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_toolset_client_stub.call_rpc_count
    end
  end

  def test_list_app_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListAppVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_app_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_app_versions, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListAppVersionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_app_versions_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_app_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_app_versions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_app_versions ::Google::Cloud::Ces::V1beta::ListAppVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_app_versions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_app_versions(::Google::Cloud::Ces::V1beta::ListAppVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_app_versions_client_stub.call_rpc_count
    end
  end

  def test_get_app_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::AppVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_app_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_app_version, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetAppVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_app_version_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_app_version({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_app_version name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_app_version ::Google::Cloud::Ces::V1beta::GetAppVersionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_app_version({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_app_version(::Google::Cloud::Ces::V1beta::GetAppVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_app_version_client_stub.call_rpc_count
    end
  end

  def test_create_app_version
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::AppVersion.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    app_version_id = "hello world"
    app_version = {}

    create_app_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_app_version, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateAppVersionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["app_version_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::AppVersion), request["app_version"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_app_version_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_app_version({ parent: parent, app_version_id: app_version_id, app_version: app_version }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_app_version parent: parent, app_version_id: app_version_id, app_version: app_version do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_app_version ::Google::Cloud::Ces::V1beta::CreateAppVersionRequest.new(parent: parent, app_version_id: app_version_id, app_version: app_version) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_app_version({ parent: parent, app_version_id: app_version_id, app_version: app_version }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_app_version(::Google::Cloud::Ces::V1beta::CreateAppVersionRequest.new(parent: parent, app_version_id: app_version_id, app_version: app_version), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_app_version_client_stub.call_rpc_count
    end
  end

  def test_delete_app_version
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_app_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_app_version, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_app_version_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_app_version({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_app_version name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_app_version ::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_app_version({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_app_version(::Google::Cloud::Ces::V1beta::DeleteAppVersionRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_app_version_client_stub.call_rpc_count
    end
  end

  def test_restore_app_version
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restore_app_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :restore_app_version, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, restore_app_version_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.restore_app_version({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.restore_app_version name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.restore_app_version ::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.restore_app_version({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.restore_app_version(::Google::Cloud::Ces::V1beta::RestoreAppVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, restore_app_version_client_stub.call_rpc_count
    end
  end

  def test_list_changelogs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListChangelogsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_changelogs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_changelogs, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListChangelogsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_changelogs_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_changelogs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_changelogs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_changelogs ::Google::Cloud::Ces::V1beta::ListChangelogsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_changelogs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_changelogs(::Google::Cloud::Ces::V1beta::ListChangelogsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_changelogs_client_stub.call_rpc_count
    end
  end

  def test_get_changelog
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Changelog.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_changelog_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_changelog, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetChangelogRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_changelog_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_changelog({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_changelog name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_changelog ::Google::Cloud::Ces::V1beta::GetChangelogRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_changelog({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_changelog(::Google::Cloud::Ces::V1beta::GetChangelogRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_changelog_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Ces::V1beta::AgentService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Ces::V1beta::AgentService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::AgentService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Ces::V1beta::AgentService::Operations, client.operations_client
  end
end
