# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/ces/v1beta/evaluation_service"

class ::Google::Cloud::Ces::V1beta::EvaluationService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_agent_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.agent_path project: "value0", location: "value1", app: "value2", agent: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/agents/value3", path
    end
  end

  def test_app_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.app_path project: "value0", location: "value1", app: "value2"
      assert_equal "projects/value0/locations/value1/apps/value2", path
    end
  end

  def test_app_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.app_version_path project: "value0", location: "value1", app: "value2", version: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/versions/value3", path
    end
  end

  def test_changelog_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.changelog_path project: "value0", location: "value1", app: "value2", changelog: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/changelogs/value3", path
    end
  end

  def test_conversation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.conversation_path project: "value0", location: "value1", app: "value2", conversation: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/conversations/value3", path
    end
  end

  def test_evaluation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.evaluation_path project: "value0", location: "value1", app: "value2", evaluation: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/evaluations/value3", path
    end
  end

  def test_evaluation_dataset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.evaluation_dataset_path project: "value0", location: "value1", app: "value2", evaluation_dataset: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/evaluationDatasets/value3", path
    end
  end

  def test_evaluation_expectation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.evaluation_expectation_path project: "value0", location: "value1", app: "value2", evaluation_expectation: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/evaluationExpectations/value3", path
    end
  end

  def test_evaluation_result_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.evaluation_result_path project: "value0", location: "value1", app: "value2", evaluation: "value3", evaluation_result: "value4"
      assert_equal "projects/value0/locations/value1/apps/value2/evaluations/value3/results/value4", path
    end
  end

  def test_evaluation_run_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.evaluation_run_path project: "value0", location: "value1", app: "value2", evaluation_run: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/evaluationRuns/value3", path
    end
  end

  def test_scheduled_evaluation_run_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.scheduled_evaluation_run_path project: "value0", location: "value1", app: "value2", scheduled_evaluation_run: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/scheduledEvaluationRuns/value3", path
    end
  end

  def test_tool_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.tool_path project: "value0", location: "value1", app: "value2", tool: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/tools/value3", path
    end
  end

  def test_toolset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.toolset_path project: "value0", location: "value1", app: "value2", toolset: "value3"
      assert_equal "projects/value0/locations/value1/apps/value2/toolsets/value3", path
    end
  end
end
