# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/ces/v1beta/evaluation_service_pb"
require "google/cloud/ces/v1beta/evaluation_service/rest"


class ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_run_evaluation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    app = "hello world"
    evaluations = ["hello world"]
    evaluation_dataset = "hello world"
    display_name = "hello world"
    app_version = "hello world"
    config = {}
    run_count = 42
    persona_run_configs = [{}]
    optimization_config = {}
    scheduled_evaluation_run = "hello world"
    golden_run_method = :GOLDEN_RUN_METHOD_UNSPECIFIED

    run_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_run_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_evaluation({ app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_evaluation app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_evaluation ::Google::Cloud::Ces::V1beta::RunEvaluationRequest.new(app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_evaluation({ app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_evaluation(::Google::Cloud::Ces::V1beta::RunEvaluationRequest.new(app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_evaluation_client_stub.call_count
      end
    end
  end

  def test_create_evaluation
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Evaluation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluation_id = "hello world"
    evaluation = {}

    create_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_create_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_evaluation({ parent: parent, evaluation_id: evaluation_id, evaluation: evaluation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_evaluation parent: parent, evaluation_id: evaluation_id, evaluation: evaluation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_evaluation ::Google::Cloud::Ces::V1beta::CreateEvaluationRequest.new(parent: parent, evaluation_id: evaluation_id, evaluation: evaluation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_evaluation({ parent: parent, evaluation_id: evaluation_id, evaluation: evaluation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_evaluation(::Google::Cloud::Ces::V1beta::CreateEvaluationRequest.new(parent: parent, evaluation_id: evaluation_id, evaluation: evaluation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_evaluation_client_stub.call_count
      end
    end
  end

  def test_generate_evaluation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    conversation = "hello world"
    source = :SOURCE_UNSPECIFIED

    generate_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_generate_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_evaluation({ conversation: conversation, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_evaluation conversation: conversation, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_evaluation ::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest.new(conversation: conversation, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_evaluation({ conversation: conversation, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_evaluation(::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest.new(conversation: conversation, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_evaluation_client_stub.call_count
      end
    end
  end

  def test_import_evaluations
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    conversation_list = {}
    parent = "hello world"
    import_options = {}

    import_evaluations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_import_evaluations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_evaluations_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_evaluations({ conversation_list: conversation_list, parent: parent, import_options: import_options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_evaluations conversation_list: conversation_list, parent: parent, import_options: import_options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_evaluations ::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest.new(conversation_list: conversation_list, parent: parent, import_options: import_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_evaluations({ conversation_list: conversation_list, parent: parent, import_options: import_options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_evaluations(::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest.new(conversation_list: conversation_list, parent: parent, import_options: import_options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_evaluations_client_stub.call_count
      end
    end
  end

  def test_create_evaluation_dataset
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationDataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluation_dataset_id = "hello world"
    evaluation_dataset = {}

    create_evaluation_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_create_evaluation_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_evaluation_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_evaluation_dataset({ parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_evaluation_dataset parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_evaluation_dataset ::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest.new(parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_evaluation_dataset({ parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_evaluation_dataset(::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest.new(parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_evaluation_dataset_client_stub.call_count
      end
    end
  end

  def test_update_evaluation
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Evaluation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    evaluation = {}
    update_mask = {}

    update_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_update_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_evaluation({ evaluation: evaluation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_evaluation evaluation: evaluation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_evaluation ::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest.new(evaluation: evaluation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_evaluation({ evaluation: evaluation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_evaluation(::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest.new(evaluation: evaluation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_evaluation_client_stub.call_count
      end
    end
  end

  def test_update_evaluation_dataset
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationDataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    evaluation_dataset = {}
    update_mask = {}

    update_evaluation_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_update_evaluation_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_evaluation_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_evaluation_dataset({ evaluation_dataset: evaluation_dataset, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_evaluation_dataset evaluation_dataset: evaluation_dataset, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_evaluation_dataset ::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest.new(evaluation_dataset: evaluation_dataset, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_evaluation_dataset({ evaluation_dataset: evaluation_dataset, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_evaluation_dataset(::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest.new(evaluation_dataset: evaluation_dataset, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_evaluation_dataset_client_stub.call_count
      end
    end
  end

  def test_delete_evaluation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_delete_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_evaluation({ name: name, force: force, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_evaluation name: name, force: force, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_evaluation ::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest.new(name: name, force: force, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_evaluation({ name: name, force: force, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_evaluation(::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest.new(name: name, force: force, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_evaluation_client_stub.call_count
      end
    end
  end

  def test_delete_evaluation_result
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_evaluation_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_delete_evaluation_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_evaluation_result_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_evaluation_result({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_evaluation_result name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_evaluation_result ::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_evaluation_result({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_evaluation_result(::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_evaluation_result_client_stub.call_count
      end
    end
  end

  def test_delete_evaluation_dataset
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_evaluation_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_delete_evaluation_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_evaluation_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_evaluation_dataset({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_evaluation_dataset name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_evaluation_dataset ::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_evaluation_dataset({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_evaluation_dataset(::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_evaluation_dataset_client_stub.call_count
      end
    end
  end

  def test_delete_evaluation_run
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_evaluation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_delete_evaluation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_evaluation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_evaluation_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_evaluation_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_evaluation_run ::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_evaluation_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_evaluation_run(::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_evaluation_run_client_stub.call_count
      end
    end
  end

  def test_get_evaluation
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::Evaluation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_get_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_evaluation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_evaluation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_evaluation ::Google::Cloud::Ces::V1beta::GetEvaluationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_evaluation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_evaluation(::Google::Cloud::Ces::V1beta::GetEvaluationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_evaluation_client_stub.call_count
      end
    end
  end

  def test_get_evaluation_result
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_get_evaluation_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_evaluation_result_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_evaluation_result({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_evaluation_result name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_evaluation_result ::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_evaluation_result({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_evaluation_result(::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_evaluation_result_client_stub.call_count
      end
    end
  end

  def test_get_evaluation_dataset
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationDataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_get_evaluation_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_evaluation_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_evaluation_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_evaluation_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_evaluation_dataset ::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_evaluation_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_evaluation_dataset(::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_evaluation_dataset_client_stub.call_count
      end
    end
  end

  def test_get_evaluation_run
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_get_evaluation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_evaluation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_evaluation_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_evaluation_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_evaluation_run ::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_evaluation_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_evaluation_run(::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_evaluation_run_client_stub.call_count
      end
    end
  end

  def test_list_evaluations
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListEvaluationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    last_ten_results = true

    list_evaluations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_list_evaluations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_evaluations_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_evaluations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_evaluations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_evaluations ::Google::Cloud::Ces::V1beta::ListEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_evaluations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_evaluations(::Google::Cloud::Ces::V1beta::ListEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_evaluations_client_stub.call_count
      end
    end
  end

  def test_list_evaluation_results
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListEvaluationResultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_results_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_list_evaluation_results_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_evaluation_results_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_evaluation_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_evaluation_results parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_evaluation_results ::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_evaluation_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_evaluation_results(::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_evaluation_results_client_stub.call_count
      end
    end
  end

  def test_list_evaluation_datasets
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_datasets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_list_evaluation_datasets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_evaluation_datasets_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_evaluation_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_evaluation_datasets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_evaluation_datasets ::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_evaluation_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_evaluation_datasets(::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_evaluation_datasets_client_stub.call_count
      end
    end
  end

  def test_list_evaluation_runs
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListEvaluationRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_list_evaluation_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_evaluation_runs_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_evaluation_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_evaluation_runs ::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_evaluation_runs(::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_evaluation_runs_client_stub.call_count
      end
    end
  end

  def test_list_evaluation_expectations
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_expectations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_list_evaluation_expectations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_evaluation_expectations_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_evaluation_expectations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_evaluation_expectations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_evaluation_expectations ::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_evaluation_expectations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_evaluation_expectations(::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_evaluation_expectations_client_stub.call_count
      end
    end
  end

  def test_get_evaluation_expectation
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationExpectation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_expectation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_get_evaluation_expectation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_evaluation_expectation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_evaluation_expectation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_evaluation_expectation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_evaluation_expectation ::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_evaluation_expectation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_evaluation_expectation(::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_evaluation_expectation_client_stub.call_count
      end
    end
  end

  def test_create_evaluation_expectation
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationExpectation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluation_expectation_id = "hello world"
    evaluation_expectation = {}

    create_evaluation_expectation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_create_evaluation_expectation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_evaluation_expectation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_evaluation_expectation({ parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_evaluation_expectation parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_evaluation_expectation ::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest.new(parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_evaluation_expectation({ parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_evaluation_expectation(::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest.new(parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_evaluation_expectation_client_stub.call_count
      end
    end
  end

  def test_update_evaluation_expectation
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::EvaluationExpectation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    evaluation_expectation = {}
    update_mask = {}

    update_evaluation_expectation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_update_evaluation_expectation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_evaluation_expectation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_evaluation_expectation({ evaluation_expectation: evaluation_expectation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_evaluation_expectation evaluation_expectation: evaluation_expectation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_evaluation_expectation ::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest.new(evaluation_expectation: evaluation_expectation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_evaluation_expectation({ evaluation_expectation: evaluation_expectation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_evaluation_expectation(::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest.new(evaluation_expectation: evaluation_expectation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_evaluation_expectation_client_stub.call_count
      end
    end
  end

  def test_delete_evaluation_expectation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_evaluation_expectation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_delete_evaluation_expectation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_evaluation_expectation_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_evaluation_expectation({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_evaluation_expectation name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_evaluation_expectation ::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_evaluation_expectation({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_evaluation_expectation(::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_evaluation_expectation_client_stub.call_count
      end
    end
  end

  def test_create_scheduled_evaluation_run
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    scheduled_evaluation_run_id = "hello world"
    scheduled_evaluation_run = {}

    create_scheduled_evaluation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_create_scheduled_evaluation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_scheduled_evaluation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_scheduled_evaluation_run({ parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_scheduled_evaluation_run parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest.new(parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_scheduled_evaluation_run({ parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest.new(parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_scheduled_evaluation_run_client_stub.call_count
      end
    end
  end

  def test_get_scheduled_evaluation_run
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_scheduled_evaluation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_get_scheduled_evaluation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_scheduled_evaluation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_scheduled_evaluation_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_scheduled_evaluation_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_scheduled_evaluation_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_scheduled_evaluation_run_client_stub.call_count
      end
    end
  end

  def test_list_scheduled_evaluation_runs
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_scheduled_evaluation_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_list_scheduled_evaluation_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_scheduled_evaluation_runs_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_scheduled_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_scheduled_evaluation_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_scheduled_evaluation_runs ::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_scheduled_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_scheduled_evaluation_runs(::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_scheduled_evaluation_runs_client_stub.call_count
      end
    end
  end

  def test_update_scheduled_evaluation_run
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scheduled_evaluation_run = {}
    update_mask = {}

    update_scheduled_evaluation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_update_scheduled_evaluation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_scheduled_evaluation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_scheduled_evaluation_run({ scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_scheduled_evaluation_run scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest.new(scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_scheduled_evaluation_run({ scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest.new(scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_scheduled_evaluation_run_client_stub.call_count
      end
    end
  end

  def test_delete_scheduled_evaluation_run
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_scheduled_evaluation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_delete_scheduled_evaluation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_scheduled_evaluation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_scheduled_evaluation_run({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_scheduled_evaluation_run name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_scheduled_evaluation_run({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_scheduled_evaluation_run_client_stub.call_count
      end
    end
  end

  def test_test_persona_voice
    # Create test objects.
    client_result = ::Google::Cloud::Ces::V1beta::TestPersonaVoiceResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    app = "hello world"
    persona_id = "hello world"
    text = "hello world"

    test_persona_voice_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::ServiceStub.stub :transcode_test_persona_voice_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_persona_voice_client_stub do
        # Create client
        client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_persona_voice({ app: app, persona_id: persona_id, text: text }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_persona_voice app: app, persona_id: persona_id, text: text do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_persona_voice ::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest.new(app: app, persona_id: persona_id, text: text) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_persona_voice({ app: app, persona_id: persona_id, text: text }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_persona_voice(::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest.new(app: app, persona_id: persona_id, text: text), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_persona_voice_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Ces::V1beta::EvaluationService::Rest::Client::Configuration, config
  end
end
