# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/ces/v1beta/evaluation_service_pb"
require "google/cloud/ces/v1beta/evaluation_service"

class ::Google::Cloud::Ces::V1beta::EvaluationService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_run_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    app = "hello world"
    evaluations = ["hello world"]
    evaluation_dataset = "hello world"
    display_name = "hello world"
    app_version = "hello world"
    config = {}
    run_count = 42
    persona_run_configs = [{}]
    optimization_config = {}
    scheduled_evaluation_run = "hello world"
    golden_run_method = :GOLDEN_RUN_METHOD_UNSPECIFIED

    run_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_evaluation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::RunEvaluationRequest, request
      assert_equal "hello world", request["app"]
      assert_equal ["hello world"], request["evaluations"]
      assert_equal "hello world", request["evaluation_dataset"]
      assert_equal "hello world", request["display_name"]
      assert_equal "hello world", request["app_version"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::EvaluationConfig), request["config"]
      assert_equal 42, request["run_count"]
      assert request.has_run_count?
      assert_kind_of ::Google::Cloud::Ces::V1beta::PersonaRunConfig, request["persona_run_configs"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::OptimizationConfig), request["optimization_config"]
      assert_equal "hello world", request["scheduled_evaluation_run"]
      assert_equal :GOLDEN_RUN_METHOD_UNSPECIFIED, request["golden_run_method"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_evaluation({ app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_evaluation app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_evaluation ::Google::Cloud::Ces::V1beta::RunEvaluationRequest.new(app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_evaluation({ app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_evaluation(::Google::Cloud::Ces::V1beta::RunEvaluationRequest.new(app: app, evaluations: evaluations, evaluation_dataset: evaluation_dataset, display_name: display_name, app_version: app_version, config: config, run_count: run_count, persona_run_configs: persona_run_configs, optimization_config: optimization_config, scheduled_evaluation_run: scheduled_evaluation_run, golden_run_method: golden_run_method), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_evaluation_client_stub.call_rpc_count
    end
  end

  def test_create_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Evaluation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluation_id = "hello world"
    evaluation = {}

    create_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_evaluation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateEvaluationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["evaluation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Evaluation), request["evaluation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_evaluation({ parent: parent, evaluation_id: evaluation_id, evaluation: evaluation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_evaluation parent: parent, evaluation_id: evaluation_id, evaluation: evaluation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_evaluation ::Google::Cloud::Ces::V1beta::CreateEvaluationRequest.new(parent: parent, evaluation_id: evaluation_id, evaluation: evaluation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_evaluation({ parent: parent, evaluation_id: evaluation_id, evaluation: evaluation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_evaluation(::Google::Cloud::Ces::V1beta::CreateEvaluationRequest.new(parent: parent, evaluation_id: evaluation_id, evaluation: evaluation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_evaluation_client_stub.call_rpc_count
    end
  end

  def test_generate_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversation = "hello world"
    source = :SOURCE_UNSPECIFIED

    generate_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_evaluation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest, request
      assert_equal "hello world", request["conversation"]
      assert_equal :SOURCE_UNSPECIFIED, request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_evaluation({ conversation: conversation, source: source }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_evaluation conversation: conversation, source: source do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_evaluation ::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest.new(conversation: conversation, source: source) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_evaluation({ conversation: conversation, source: source }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_evaluation(::Google::Cloud::Ces::V1beta::GenerateEvaluationRequest.new(conversation: conversation, source: source), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_evaluation_client_stub.call_rpc_count
    end
  end

  def test_import_evaluations
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversation_list = {}
    parent = "hello world"
    import_options = {}

    import_evaluations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_evaluations, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest::ConversationList), request["conversation_list"]
      assert_equal :conversation_list, request.source
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest::ImportOptions), request["import_options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_evaluations_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_evaluations({ conversation_list: conversation_list, parent: parent, import_options: import_options }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_evaluations conversation_list: conversation_list, parent: parent, import_options: import_options do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_evaluations ::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest.new(conversation_list: conversation_list, parent: parent, import_options: import_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_evaluations({ conversation_list: conversation_list, parent: parent, import_options: import_options }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_evaluations(::Google::Cloud::Ces::V1beta::ImportEvaluationsRequest.new(conversation_list: conversation_list, parent: parent, import_options: import_options), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_evaluations_client_stub.call_rpc_count
    end
  end

  def test_create_evaluation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationDataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluation_dataset_id = "hello world"
    evaluation_dataset = {}

    create_evaluation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_evaluation_dataset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["evaluation_dataset_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::EvaluationDataset), request["evaluation_dataset"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_evaluation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_evaluation_dataset({ parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_evaluation_dataset parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_evaluation_dataset ::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest.new(parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_evaluation_dataset({ parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_evaluation_dataset(::Google::Cloud::Ces::V1beta::CreateEvaluationDatasetRequest.new(parent: parent, evaluation_dataset_id: evaluation_dataset_id, evaluation_dataset: evaluation_dataset), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_evaluation_dataset_client_stub.call_rpc_count
    end
  end

  def test_update_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Evaluation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    evaluation = {}
    update_mask = {}

    update_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_evaluation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::Evaluation), request["evaluation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_evaluation({ evaluation: evaluation, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_evaluation evaluation: evaluation, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_evaluation ::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest.new(evaluation: evaluation, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_evaluation({ evaluation: evaluation, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_evaluation(::Google::Cloud::Ces::V1beta::UpdateEvaluationRequest.new(evaluation: evaluation, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_evaluation_client_stub.call_rpc_count
    end
  end

  def test_update_evaluation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationDataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    evaluation_dataset = {}
    update_mask = {}

    update_evaluation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_evaluation_dataset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::EvaluationDataset), request["evaluation_dataset"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_evaluation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_evaluation_dataset({ evaluation_dataset: evaluation_dataset, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_evaluation_dataset evaluation_dataset: evaluation_dataset, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_evaluation_dataset ::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest.new(evaluation_dataset: evaluation_dataset, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_evaluation_dataset({ evaluation_dataset: evaluation_dataset, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_evaluation_dataset(::Google::Cloud::Ces::V1beta::UpdateEvaluationDatasetRequest.new(evaluation_dataset: evaluation_dataset, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_evaluation_dataset_client_stub.call_rpc_count
    end
  end

  def test_delete_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_evaluation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_evaluation({ name: name, force: force, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_evaluation name: name, force: force, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_evaluation ::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest.new(name: name, force: force, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_evaluation({ name: name, force: force, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_evaluation(::Google::Cloud::Ces::V1beta::DeleteEvaluationRequest.new(name: name, force: force, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_evaluation_client_stub.call_rpc_count
    end
  end

  def test_delete_evaluation_result
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_evaluation_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_evaluation_result, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_evaluation_result_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_evaluation_result({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_evaluation_result name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_evaluation_result ::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_evaluation_result({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_evaluation_result(::Google::Cloud::Ces::V1beta::DeleteEvaluationResultRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_evaluation_result_client_stub.call_rpc_count
    end
  end

  def test_delete_evaluation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_evaluation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_evaluation_dataset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_evaluation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_evaluation_dataset({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_evaluation_dataset name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_evaluation_dataset ::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_evaluation_dataset({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_evaluation_dataset(::Google::Cloud::Ces::V1beta::DeleteEvaluationDatasetRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_evaluation_dataset_client_stub.call_rpc_count
    end
  end

  def test_delete_evaluation_run
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_evaluation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_evaluation_run, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_evaluation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_evaluation_run({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_evaluation_run name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_evaluation_run ::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_evaluation_run({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_evaluation_run(::Google::Cloud::Ces::V1beta::DeleteEvaluationRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_evaluation_run_client_stub.call_rpc_count
    end
  end

  def test_get_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::Evaluation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_evaluation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetEvaluationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_evaluation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_evaluation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_evaluation ::Google::Cloud::Ces::V1beta::GetEvaluationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_evaluation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_evaluation(::Google::Cloud::Ces::V1beta::GetEvaluationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_evaluation_client_stub.call_rpc_count
    end
  end

  def test_get_evaluation_result
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationResult.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_evaluation_result, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_evaluation_result_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_evaluation_result({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_evaluation_result name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_evaluation_result ::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_evaluation_result({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_evaluation_result(::Google::Cloud::Ces::V1beta::GetEvaluationResultRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_evaluation_result_client_stub.call_rpc_count
    end
  end

  def test_get_evaluation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationDataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_evaluation_dataset, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_evaluation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_evaluation_dataset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_evaluation_dataset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_evaluation_dataset ::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_evaluation_dataset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_evaluation_dataset(::Google::Cloud::Ces::V1beta::GetEvaluationDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_evaluation_dataset_client_stub.call_rpc_count
    end
  end

  def test_get_evaluation_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_evaluation_run, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_evaluation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_evaluation_run({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_evaluation_run name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_evaluation_run ::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_evaluation_run({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_evaluation_run(::Google::Cloud::Ces::V1beta::GetEvaluationRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_evaluation_run_client_stub.call_rpc_count
    end
  end

  def test_list_evaluations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListEvaluationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    last_ten_results = true

    list_evaluations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_evaluations, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListEvaluationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal true, request["last_ten_results"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_evaluations_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_evaluations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_evaluations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_evaluations ::Google::Cloud::Ces::V1beta::ListEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_evaluations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_evaluations(::Google::Cloud::Ces::V1beta::ListEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, last_ten_results: last_ten_results), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_evaluations_client_stub.call_rpc_count
    end
  end

  def test_list_evaluation_results
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListEvaluationResultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_results_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_evaluation_results, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_evaluation_results_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_evaluation_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_evaluation_results parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_evaluation_results ::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_evaluation_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_evaluation_results(::Google::Cloud::Ces::V1beta::ListEvaluationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_evaluation_results_client_stub.call_rpc_count
    end
  end

  def test_list_evaluation_datasets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_datasets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_evaluation_datasets, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_evaluation_datasets_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_evaluation_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_evaluation_datasets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_evaluation_datasets ::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_evaluation_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_evaluation_datasets(::Google::Cloud::Ces::V1beta::ListEvaluationDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_evaluation_datasets_client_stub.call_rpc_count
    end
  end

  def test_list_evaluation_runs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListEvaluationRunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_runs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_evaluation_runs, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_evaluation_runs_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_evaluation_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_evaluation_runs ::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_evaluation_runs(::Google::Cloud::Ces::V1beta::ListEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_evaluation_runs_client_stub.call_rpc_count
    end
  end

  def test_list_evaluation_expectations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_evaluation_expectations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_evaluation_expectations, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_evaluation_expectations_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_evaluation_expectations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_evaluation_expectations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_evaluation_expectations ::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_evaluation_expectations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_evaluation_expectations(::Google::Cloud::Ces::V1beta::ListEvaluationExpectationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_evaluation_expectations_client_stub.call_rpc_count
    end
  end

  def test_get_evaluation_expectation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationExpectation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_expectation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_evaluation_expectation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_evaluation_expectation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_evaluation_expectation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_evaluation_expectation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_evaluation_expectation ::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_evaluation_expectation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_evaluation_expectation(::Google::Cloud::Ces::V1beta::GetEvaluationExpectationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_evaluation_expectation_client_stub.call_rpc_count
    end
  end

  def test_create_evaluation_expectation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationExpectation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluation_expectation_id = "hello world"
    evaluation_expectation = {}

    create_evaluation_expectation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_evaluation_expectation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["evaluation_expectation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::EvaluationExpectation), request["evaluation_expectation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_evaluation_expectation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_evaluation_expectation({ parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_evaluation_expectation parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_evaluation_expectation ::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest.new(parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_evaluation_expectation({ parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_evaluation_expectation(::Google::Cloud::Ces::V1beta::CreateEvaluationExpectationRequest.new(parent: parent, evaluation_expectation_id: evaluation_expectation_id, evaluation_expectation: evaluation_expectation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_evaluation_expectation_client_stub.call_rpc_count
    end
  end

  def test_update_evaluation_expectation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::EvaluationExpectation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    evaluation_expectation = {}
    update_mask = {}

    update_evaluation_expectation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_evaluation_expectation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::EvaluationExpectation), request["evaluation_expectation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_evaluation_expectation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_evaluation_expectation({ evaluation_expectation: evaluation_expectation, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_evaluation_expectation evaluation_expectation: evaluation_expectation, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_evaluation_expectation ::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest.new(evaluation_expectation: evaluation_expectation, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_evaluation_expectation({ evaluation_expectation: evaluation_expectation, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_evaluation_expectation(::Google::Cloud::Ces::V1beta::UpdateEvaluationExpectationRequest.new(evaluation_expectation: evaluation_expectation, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_evaluation_expectation_client_stub.call_rpc_count
    end
  end

  def test_delete_evaluation_expectation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_evaluation_expectation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_evaluation_expectation, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_evaluation_expectation_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_evaluation_expectation({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_evaluation_expectation name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_evaluation_expectation ::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_evaluation_expectation({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_evaluation_expectation(::Google::Cloud::Ces::V1beta::DeleteEvaluationExpectationRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_evaluation_expectation_client_stub.call_rpc_count
    end
  end

  def test_create_scheduled_evaluation_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    scheduled_evaluation_run_id = "hello world"
    scheduled_evaluation_run = {}

    create_scheduled_evaluation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_scheduled_evaluation_run, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["scheduled_evaluation_run_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun), request["scheduled_evaluation_run"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_scheduled_evaluation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_scheduled_evaluation_run({ parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_scheduled_evaluation_run parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest.new(parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_scheduled_evaluation_run({ parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::CreateScheduledEvaluationRunRequest.new(parent: parent, scheduled_evaluation_run_id: scheduled_evaluation_run_id, scheduled_evaluation_run: scheduled_evaluation_run), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_scheduled_evaluation_run_client_stub.call_rpc_count
    end
  end

  def test_get_scheduled_evaluation_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_scheduled_evaluation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_scheduled_evaluation_run, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_scheduled_evaluation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_scheduled_evaluation_run({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_scheduled_evaluation_run name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_scheduled_evaluation_run({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::GetScheduledEvaluationRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_scheduled_evaluation_run_client_stub.call_rpc_count
    end
  end

  def test_list_scheduled_evaluation_runs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_scheduled_evaluation_runs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_scheduled_evaluation_runs, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_scheduled_evaluation_runs_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_scheduled_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_scheduled_evaluation_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_scheduled_evaluation_runs ::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_scheduled_evaluation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_scheduled_evaluation_runs(::Google::Cloud::Ces::V1beta::ListScheduledEvaluationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_scheduled_evaluation_runs_client_stub.call_rpc_count
    end
  end

  def test_update_scheduled_evaluation_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    scheduled_evaluation_run = {}
    update_mask = {}

    update_scheduled_evaluation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_scheduled_evaluation_run, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::ScheduledEvaluationRun), request["scheduled_evaluation_run"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_scheduled_evaluation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_scheduled_evaluation_run({ scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_scheduled_evaluation_run scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest.new(scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_scheduled_evaluation_run({ scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::UpdateScheduledEvaluationRunRequest.new(scheduled_evaluation_run: scheduled_evaluation_run, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_scheduled_evaluation_run_client_stub.call_rpc_count
    end
  end

  def test_delete_scheduled_evaluation_run
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_scheduled_evaluation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_scheduled_evaluation_run, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_scheduled_evaluation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_scheduled_evaluation_run({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_scheduled_evaluation_run name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_scheduled_evaluation_run ::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_scheduled_evaluation_run({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_scheduled_evaluation_run(::Google::Cloud::Ces::V1beta::DeleteScheduledEvaluationRunRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_scheduled_evaluation_run_client_stub.call_rpc_count
    end
  end

  def test_test_persona_voice
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::TestPersonaVoiceResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    app = "hello world"
    persona_id = "hello world"
    text = "hello world"

    test_persona_voice_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_persona_voice, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest, request
      assert_equal "hello world", request["app"]
      assert_equal "hello world", request["persona_id"]
      assert_equal "hello world", request["text"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_persona_voice_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_persona_voice({ app: app, persona_id: persona_id, text: text }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_persona_voice app: app, persona_id: persona_id, text: text do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_persona_voice ::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest.new(app: app, persona_id: persona_id, text: text) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_persona_voice({ app: app, persona_id: persona_id, text: text }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_persona_voice(::Google::Cloud::Ces::V1beta::TestPersonaVoiceRequest.new(app: app, persona_id: persona_id, text: text), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_persona_voice_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Ces::V1beta::EvaluationService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Ces::V1beta::EvaluationService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::EvaluationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Ces::V1beta::EvaluationService::Operations, client.operations_client
  end
end
