# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/ces/v1beta/session_service_pb"
require "google/cloud/ces/v1beta/session_service"

class ::Google::Cloud::Ces::V1beta::SessionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_run_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::RunSessionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    config = {}
    inputs = [{}]

    run_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_session, name
      assert_kind_of ::Google::Cloud::Ces::V1beta::RunSessionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::SessionConfig), request["config"]
      assert_kind_of ::Google::Cloud::Ces::V1beta::SessionInput, request["inputs"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_session_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::SessionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_session({ config: config, inputs: inputs }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_session config: config, inputs: inputs do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_session ::Google::Cloud::Ces::V1beta::RunSessionRequest.new(config: config, inputs: inputs) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_session({ config: config, inputs: inputs }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_session(::Google::Cloud::Ces::V1beta::RunSessionRequest.new(config: config, inputs: inputs), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_session_client_stub.call_rpc_count
    end
  end

  def test_bidi_run_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Ces::V1beta::BidiSessionServerMessage.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    config = {}

    bidi_run_session_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :bidi_run_session, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, bidi_run_session_client_stub do
      # Create client
      client = ::Google::Cloud::Ces::V1beta::SessionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { config: config }
      request_proto = ::Google::Cloud::Ces::V1beta::BidiSessionClientMessage.new config: config
      enum_input = [request_hash, request_proto].to_enum
      client.bidi_run_session enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Ces::V1beta::BidiSessionServerMessage, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { config: config }
      request_proto = ::Google::Cloud::Ces::V1beta::BidiSessionClientMessage.new config: config
      stream_input = Gapic::StreamInput.new
      client.bidi_run_session stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Ces::V1beta::BidiSessionServerMessage, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { config: config }
      request_proto = ::Google::Cloud::Ces::V1beta::BidiSessionClientMessage.new config: config
      enum_input = [request_hash, request_proto].to_enum
      client.bidi_run_session enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Ces::V1beta::BidiSessionServerMessage, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { config: config }
      request_proto = ::Google::Cloud::Ces::V1beta::BidiSessionClientMessage.new config: config
      stream_input = Gapic::StreamInput.new
      client.bidi_run_session stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Ces::V1beta::BidiSessionServerMessage, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, bidi_run_session_client_stub.call_rpc_count
      bidi_run_session_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Ces::V1beta::BidiSessionClientMessage, r
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Ces::V1beta::SessionConfig), r["config"]
          assert_equal :config, r.message_type
        end
      end
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::SessionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Ces::V1beta::SessionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Ces::V1beta::SessionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Ces::V1beta::SessionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
