create or replace package apps.graphite_sync_bank as 
  type bank_result_t is record (
    bank_id number,
    branch_id number,
    bank_acct_id number,
    intermediary_acct_id number,
    external_payee_id number
  );

  procedure process_bank_objects_from_json(
    bank_obj_json in pljson,
    bank_output in out bank_result_t,
    supplier_output in out graphite_sync_supplier.supplier_output_t,
    site_output in out graphite_sync_site.site_output_t,
    keys in graphite_sync.r_return_keys,
    return_json in out pljson
  );

end graphite_sync_bank;
/
show err
