create or replace package body apps.graphite_sync_converter as
   function convert_supplier_json (
      supplier_json in pljson,
      parser in graphite_sync_json_parser
   ) return ap_vendor_pub_pkg.r_vendor_rec_type is
      supplier_rec ap_vendor_pub_pkg.r_vendor_rec_type; 
      ext_payee_json pljson;
      ext_payee_parser graphite_sync_json_parser;
   begin
      supplier_rec.vendor_id                      := parser.get_number('VENDOR_ID');
      supplier_rec.segment1                       := parser.get_number('SEGMENT1');
      supplier_rec.vendor_name                    := parser.get_string('VENDOR_NAME', true);
      supplier_rec.vendor_name_alt                := parser.get_string('VENDOR_NAME_ALT', true);
      supplier_rec.summary_flag                   := parser.get_string('SUMMARY_FLAG');
      supplier_rec.enabled_flag                   := parser.get_string('ENABLED_FLAG');
      supplier_rec.segment2                       := parser.get_string('SEGMENT2');
      supplier_rec.segment3                       := parser.get_string('SEGMENT3');
      supplier_rec.segment4                       := parser.get_string('SEGMENT4');
      supplier_rec.segment5                       := parser.get_string('SEGMENT5');
      supplier_rec.employee_id                    := parser.get_number('EMPLOYEE_ID');
      supplier_rec.vendor_type_lookup_code        := parser.get_string('VENDOR_TYPE_LOOKUP_CODE');
      supplier_rec.customer_num                   := parser.get_string('CUSTOMER_NUM');
      supplier_rec.one_time_flag                  := parser.get_string('ONE_TIME_FLAG');
      supplier_rec.parent_vendor_id               := parser.get_number('PARENT_VENDOR_ID');
      supplier_rec.min_order_amount               := parser.get_number('MIN_ORDER_AMOUNT');
      supplier_rec.terms_id                       := parser.get_number('TERMS_ID', true);
      supplier_rec.set_of_books_id                := parser.get_number('SET_OF_BOOKS_ID');
      supplier_rec.always_take_disc_flag          := parser.get_string('ALWAYS_TAKE_DISC_FLAG');
      supplier_rec.pay_date_basis_lookup_code     := parser.get_string('PAY_DATE_BASIS_LOOKUP_CODE');
      supplier_rec.pay_group_lookup_code          := parser.get_string('PAY_GROUP_LOOKUP_CODE');
      supplier_rec.payment_priority               := parser.get_number('PAYMENT_PRIORITY');
      supplier_rec.invoice_currency_code          := parser.get_string('INVOICE_CURRENCY_CODE', true);
      supplier_rec.payment_currency_code          := parser.get_string('PAYMENT_CURRENCY_CODE', true);
      supplier_rec.invoice_amount_limit           := parser.get_number('INVOICE_AMOUNT_LIMIT');
      supplier_rec.hold_all_payments_flag         := parser.get_string('HOLD_ALL_PAYMENTS_FLAG');
      supplier_rec.hold_future_payments_flag      := parser.get_string('HOLD_FUTURE_PAYMENTS_FLAG');
      supplier_rec.hold_reason                    := parser.get_string('HOLD_REASON', true);
      supplier_rec.type_1099                      := parser.get_string('TYPE_1099');
      supplier_rec.withholding_status_lookup_code := parser.get_string('WITHHOLDING_STATUS_LOOKUP_CODE');
      supplier_rec.withholding_start_date         := parser.get_date('WITHHOLDING_START_DATE', true);
      supplier_rec.organization_type_lookup_code  := parser.get_string('ORGANIZATION_TYPE_LOOKUP_CODE');
      supplier_rec.start_date_active              := parser.get_date('START_DATE_ACTIVE', true);
      supplier_rec.end_date_active                := parser.get_date('END_DATE_ACTIVE', true);
      supplier_rec.minority_group_lookup_code     := parser.get_string('MINORITY_GROUP_LOOKUP_CODE');
      supplier_rec.women_owned_flag               := parser.get_string('WOMEN_OWNED_FLAG');
      supplier_rec.small_business_flag            := parser.get_string('SMALL_BUSINESS_FLAG');
      supplier_rec.hold_flag                      := parser.get_string('HOLD_FLAG');
      supplier_rec.purchasing_hold_reason         := parser.get_string('PURCHASING_HOLD_REASON');
      supplier_rec.hold_by                        := parser.get_number('HOLD_BY');
      supplier_rec.hold_date                      := parser.get_date('HOLD_DATE', true);
      supplier_rec.terms_date_basis               := parser.get_string('TERMS_DATE_BASIS');
      supplier_rec.inspection_required_flag       := parser.get_string('INSPECTION_REQUIRED_FLAG');
      supplier_rec.receipt_required_flag          := parser.get_string('RECEIPT_REQUIRED_FLAG');
      supplier_rec.qty_rcv_tolerance              := parser.get_number('QTY_RCV_TOLERANCE');
      supplier_rec.qty_rcv_exception_code         := parser.get_string('QTY_RCV_EXCEPTION_CODE');
      supplier_rec.enforce_ship_to_location_code  := parser.get_string('ENFORCE_SHIP_TO_LOCATION_CODE');
      supplier_rec.days_early_receipt_allowed     := parser.get_number('DAYS_EARLY_RECEIPT_ALLOWED');
      supplier_rec.days_late_receipt_allowed      := parser.get_number('DAYS_LATE_RECEIPT_ALLOWED');
      supplier_rec.receipt_days_exception_code    := parser.get_string('RECEIPT_DAYS_EXCEPTION_CODE');
      supplier_rec.receiving_routing_id           := parser.get_number('RECEIVING_ROUTING_ID');
      supplier_rec.allow_substitute_receipts_flag := parser.get_string('ALLOW_SUBSTITUTE_RECEIPTS_FLAG');
      supplier_rec.allow_unordered_receipts_flag  := parser.get_string('ALLOW_UNORDERED_RECEIPTS_FLAG');
      supplier_rec.hold_unmatched_invoices_flag   := parser.get_string('HOLD_UNMATCHED_INVOICES_FLAG');
      supplier_rec.tax_verification_date          := parser.get_date('TAX_VERIFICATION_DATE');
      supplier_rec.name_control                   := parser.get_string('NAME_CONTROL');
      supplier_rec.state_reportable_flag          := parser.get_string('STATE_REPORTABLE_FLAG');
      supplier_rec.federal_reportable_flag        := parser.get_string('FEDERAL_REPORTABLE_FLAG');
      supplier_rec.attribute_category             := parser.get_string('ATTRIBUTE_CATEGORY');
      supplier_rec.attribute1                     := parser.get_string('ATTRIBUTE1', true);
      supplier_rec.attribute2                     := parser.get_string('ATTRIBUTE2', true);
      supplier_rec.attribute3                     := parser.get_string('ATTRIBUTE3', true);
      supplier_rec.attribute4                     := parser.get_string('ATTRIBUTE4', true);
      supplier_rec.attribute5                     := parser.get_string('ATTRIBUTE5', true);
      supplier_rec.attribute6                     := parser.get_string('ATTRIBUTE6', true);
      supplier_rec.attribute7                     := parser.get_string('ATTRIBUTE7', true);
      supplier_rec.attribute8                     := parser.get_string('ATTRIBUTE8', true);
      supplier_rec.attribute9                     := parser.get_string('ATTRIBUTE9', true);
      supplier_rec.attribute10                    := parser.get_string('ATTRIBUTE10', true);
      supplier_rec.attribute11                    := parser.get_string('ATTRIBUTE11', true);
      supplier_rec.attribute12                    := parser.get_string('ATTRIBUTE12', true);
      supplier_rec.attribute13                    := parser.get_string('ATTRIBUTE13', true);
      supplier_rec.attribute14                    := parser.get_string('ATTRIBUTE14', true);
      supplier_rec.attribute15                    := parser.get_string('ATTRIBUTE15', true);
      supplier_rec.auto_calculate_interest_flag   := parser.get_string('AUTO_CALCULATE_INTEREST_FLAG');
      supplier_rec.validation_number              := parser.get_number('VALIDATION_NUMBER');
      supplier_rec.exclude_freight_from_discount  := parser.get_string('EXCLUDE_FREIGHT_FROM_DISCOUNT');
      supplier_rec.tax_reporting_name             := parser.get_string('TAX_REPORTING_NAME', true);
      supplier_rec.check_digits                   := parser.get_string('CHECK_DIGITS');
      supplier_rec.allow_awt_flag                 := parser.get_string('ALLOW_AWT_FLAG');
      supplier_rec.awt_group_id                   := parser.get_number('AWT_GROUP_ID');
      supplier_rec.awt_group_name                 := parser.get_string('AWT_GROUP_NAME');
      supplier_rec.pay_awt_group_id               := parser.get_number('PAY_AWT_GROUP_ID');
      supplier_rec.pay_awt_group_name             := parser.get_string('PAY_AWT_GROUP_NAME');
      supplier_rec.global_attribute1              := parser.get_string('GLOBAL_ATTRIBUTE1', true);
      supplier_rec.global_attribute2              := parser.get_string('GLOBAL_ATTRIBUTE2', true);
      supplier_rec.global_attribute3              := parser.get_string('GLOBAL_ATTRIBUTE3', true);
      supplier_rec.global_attribute4              := parser.get_string('GLOBAL_ATTRIBUTE4', true);
      supplier_rec.global_attribute5              := parser.get_string('GLOBAL_ATTRIBUTE5', true);
      supplier_rec.global_attribute6              := parser.get_string('GLOBAL_ATTRIBUTE6', true);
      supplier_rec.global_attribute7              := parser.get_string('GLOBAL_ATTRIBUTE7', true);
      supplier_rec.global_attribute8              := parser.get_string('GLOBAL_ATTRIBUTE8', true);
      supplier_rec.global_attribute9              := parser.get_string('GLOBAL_ATTRIBUTE9', true);
      supplier_rec.global_attribute10             := parser.get_string('GLOBAL_ATTRIBUTE10', true);
      supplier_rec.global_attribute11             := parser.get_string('GLOBAL_ATTRIBUTE11', true);
      supplier_rec.global_attribute12             := parser.get_string('GLOBAL_ATTRIBUTE12', true);
      supplier_rec.global_attribute13             := parser.get_string('GLOBAL_ATTRIBUTE13', true);
      supplier_rec.global_attribute14             := parser.get_string('GLOBAL_ATTRIBUTE14', true);
      supplier_rec.global_attribute15             := parser.get_string('GLOBAL_ATTRIBUTE15', true);
      supplier_rec.global_attribute16             := parser.get_string('GLOBAL_ATTRIBUTE16', true);
      supplier_rec.global_attribute17             := parser.get_string('GLOBAL_ATTRIBUTE17', true);
      supplier_rec.global_attribute18             := parser.get_string('GLOBAL_ATTRIBUTE18', true);
      supplier_rec.global_attribute19             := parser.get_string('GLOBAL_ATTRIBUTE19', true);
      supplier_rec.global_attribute20             := parser.get_string('GLOBAL_ATTRIBUTE20', true);
      supplier_rec.global_attribute_category      := parser.get_string('GLOBAL_ATTRIBUTE_CATEGORY');
      supplier_rec.bank_charge_bearer             := parser.get_string('BANK_CHARGE_BEARER');
      supplier_rec.match_option                   := parser.get_string('MATCH_OPTION');
      supplier_rec.create_debit_memo_flag         := parser.get_string('CREATE_DEBIT_MEMO_FLAG');
      supplier_rec.party_id                       := parser.get_number('PARTY_ID');
      supplier_rec.parent_party_id                := parser.get_number('PARENT_PARTY_ID', true);
      supplier_rec.jgzz_fiscal_code               := parser.get_string('JGZZ_FISCAL_CODE');
      supplier_rec.sic_code                       := parser.get_string('SIC_CODE');
      supplier_rec.tax_reference                  := parser.get_string('TAX_REFERENCE');
      supplier_rec.inventory_organization_id      := parser.get_number('INVENTORY_ORGANIZATION_ID');
      supplier_rec.terms_name                     := parser.get_string('TERMS_NAME');
      supplier_rec.default_terms_id               := parser.get_number('DEFAULT_TERMS_ID', true);
      supplier_rec.vendor_interface_id            := parser.get_number('VENDOR_INTERFACE_ID');
      supplier_rec.ni_number                      := parser.get_string('NI_NUMBER');
      supplier_rec.edi_payment_format             := parser.get_string('EDI_PAYMENT_FORMAT');
      supplier_rec.edi_transaction_handling       := parser.get_string('EDI_TRANSACTION_HANDLING');
      supplier_rec.edi_payment_method             := parser.get_string('EDI_PAYMENT_METHOD');
      supplier_rec.edi_remittance_method          := parser.get_string('EDI_REMITTANCE_METHOD');
      supplier_rec.edi_remittance_instruction     := parser.get_string('EDI_REMITTANCE_INSTRUCTION');
      supplier_rec.url                            := parser.get_string('URL');
      supplier_rec.supplier_notif_method          := parser.get_string('SUPPLIER_NOTIF_METHOD');
      supplier_rec.remittance_email               := parser.get_string('REMITTANCE_EMAIL', true);
      supplier_rec.ceo_name                       := parser.get_string('CEO_NAME', true);
      supplier_rec.ceo_title                      := parser.get_string('CEO_TITLE', true);
      supplier_rec.vat_code                       := parser.get_string('VAT_CODE');
      supplier_rec.auto_tax_calc_flag             := parser.get_string('AUTO_TAX_CALC_FLAG');
      supplier_rec.offset_tax_flag                := parser.get_string('OFFSET_TAX_FLAG');
      supplier_rec.vat_registration_num           := parser.get_string('VAT_REGISTRATION_NUM');

      ext_payee_json := parser.get_object(graphite_sync.external_payee_key);
      if ext_payee_json is not null then 
        supplier_rec.ext_payee_rec := convert_external_payee_json(external_payee_json => ext_payee_json);
      end if;

      return supplier_rec;
   end convert_supplier_json;

  function convert_bank_json(
    bank_json in pljson
  ) return iby_ext_bankacct_pub.extbank_rec_type is
    bank_rec iby_ext_bankacct_pub.extbank_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => bank_json);

    bank_rec.bank_name := parser.get_string('BANK_NAME');
    bank_rec.bank_number := parser.get_string('BANK_NUMBER');
    bank_rec.institution_type := parser.get_string('INSTITUTION_TYPE');
    bank_rec.country_code := parser.get_string('COUNTRY_CODE');
    bank_rec.bank_alt_name := parser.get_string('BANK_ALT_NAME');
    bank_rec.bank_short_name := parser.get_string('BANK_SHORT_NAME');
    bank_rec.description := parser.get_string('DESCRIPTION');
    bank_rec.tax_payer_id := parser.get_string('TAX_PAYER_ID');
    bank_rec.tax_registration_number := parser.get_string('TAX_REGISTRATION_NUMBER');
    bank_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY');
    bank_rec.attribute1 := parser.get_string('ATTRIBUTE1');
    bank_rec.attribute2 := parser.get_string('ATTRIBUTE2');
    bank_rec.attribute3 := parser.get_string('ATTRIBUTE3');
    bank_rec.attribute4 := parser.get_string('ATTRIBUTE4');
    bank_rec.attribute5 := parser.get_string('ATTRIBUTE5');
    bank_rec.attribute6 := parser.get_string('ATTRIBUTE6');
    bank_rec.attribute7 := parser.get_string('ATTRIBUTE7');
    bank_rec.attribute8 := parser.get_string('ATTRIBUTE8');
    bank_rec.attribute9 := parser.get_string('ATTRIBUTE9');
    bank_rec.attribute10 := parser.get_string('ATTRIBUTE10');
    bank_rec.attribute11 := parser.get_string('ATTRIBUTE11');
    bank_rec.attribute12 := parser.get_string('ATTRIBUTE12');
    bank_rec.attribute13 := parser.get_string('ATTRIBUTE13');
    bank_rec.attribute14 := parser.get_string('ATTRIBUTE14');
    bank_rec.attribute15 := parser.get_string('ATTRIBUTE15');
    bank_rec.attribute16 := parser.get_string('ATTRIBUTE16');
    bank_rec.attribute17 := parser.get_string('ATTRIBUTE17');
    bank_rec.attribute18 := parser.get_string('ATTRIBUTE18');
    bank_rec.attribute19 := parser.get_string('ATTRIBUTE19');
    bank_rec.attribute20 := parser.get_string('ATTRIBUTE20');
    bank_rec.attribute21 := parser.get_string('ATTRIBUTE21');
    bank_rec.attribute22 := parser.get_string('ATTRIBUTE22');
    bank_rec.attribute23 := parser.get_string('ATTRIBUTE23');
    bank_rec.attribute24 := parser.get_string('ATTRIBUTE24');
    bank_rec.object_version_number := parser.get_string('OBJECT_VERSION_NUMBER');

    return bank_rec;
  end convert_bank_json;

  function convert_bank_branch_json(
    bank_branch_json in pljson
  ) return iby_ext_bankacct_pub.extbankbranch_rec_type is
    bank_branch_rec iby_ext_bankacct_pub.extbankbranch_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => bank_branch_json);

    bank_branch_rec.branch_name := parser.get_string('BRANCH_NAME');
    bank_branch_rec.branch_number := parser.get_string('BRANCH_NUMBER');
    bank_branch_rec.branch_type := parser.get_string('BRANCH_TYPE');
    bank_branch_rec.alternate_branch_name := parser.get_string('ALTERNATE_BRANCH_NAME');
    bank_branch_rec.description := parser.get_string('DESCRIPTION');
    bank_branch_rec.bic := parser.get_string('BIC');
    bank_branch_rec.eft_number := parser.get_string('EFT_NUMBER');
    bank_branch_rec.rfc_identifier := parser.get_string('RFC_IDENTIFIER');
    bank_branch_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY');
    bank_branch_rec.attribute1 := parser.get_string('ATTRIBUTE1');
    bank_branch_rec.attribute2 := parser.get_string('ATTRIBUTE2');
    bank_branch_rec.attribute3 := parser.get_string('ATTRIBUTE3');
    bank_branch_rec.attribute4 := parser.get_string('ATTRIBUTE4');
    bank_branch_rec.attribute5 := parser.get_string('ATTRIBUTE5');
    bank_branch_rec.attribute6 := parser.get_string('ATTRIBUTE6');
    bank_branch_rec.attribute7 := parser.get_string('ATTRIBUTE7');
    bank_branch_rec.attribute8 := parser.get_string('ATTRIBUTE8');
    bank_branch_rec.attribute9 := parser.get_string('ATTRIBUTE9');
    bank_branch_rec.attribute10 := parser.get_string('ATTRIBUTE10');
    bank_branch_rec.attribute11 := parser.get_string('ATTRIBUTE11');
    bank_branch_rec.attribute12 := parser.get_string('ATTRIBUTE12');
    bank_branch_rec.attribute13 := parser.get_string('ATTRIBUTE13');
    bank_branch_rec.attribute14 := parser.get_string('ATTRIBUTE14');
    bank_branch_rec.attribute15 := parser.get_string('ATTRIBUTE15');
    bank_branch_rec.attribute16 := parser.get_string('ATTRIBUTE16');
    bank_branch_rec.attribute17 := parser.get_string('ATTRIBUTE17');
    bank_branch_rec.attribute18 := parser.get_string('ATTRIBUTE18');
    bank_branch_rec.attribute19 := parser.get_string('ATTRIBUTE19');
    bank_branch_rec.attribute20 := parser.get_string('ATTRIBUTE20');
    bank_branch_rec.attribute21 := parser.get_string('ATTRIBUTE21');
    bank_branch_rec.attribute22 := parser.get_string('ATTRIBUTE22');
    bank_branch_rec.attribute23 := parser.get_string('ATTRIBUTE23');
    bank_branch_rec.attribute24 := parser.get_string('ATTRIBUTE24');
    bank_branch_rec.bch_object_version_number := parser.get_string('BCH_OBJECT_VERSION_NUMBER');
    bank_branch_rec.typ_object_version_number := parser.get_string('TYP_OBJECT_VERSION_NUMBER');
    bank_branch_rec.rfc_object_version_number := parser.get_string('RFC_OBJECT_VERSION_NUMBER');
    bank_branch_rec.eft_object_version_number := parser.get_string('EFT_OBJECT_VERSION_NUMBER');

    return bank_branch_rec;
  end convert_bank_branch_json;

  function convert_bank_acct_json(
    bank_acct_json in pljson
  ) return iby_ext_bankacct_pub.extbankacct_rec_type is
    bank_acct_rec iby_ext_bankacct_pub.extbankacct_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => bank_acct_json);

    bank_acct_rec.bank_account_id := parser.get_string('BANK_ACCOUNT_ID');
    bank_acct_rec.country_code := parser.get_string('COUNTRY_CODE');
    bank_acct_rec.branch_id := parser.get_string('BRANCH_ID');
    bank_acct_rec.bank_id := parser.get_string('BANK_ID');
    bank_acct_rec.acct_owner_party_id := parser.get_string('ACCT_OWNER_PARTY_ID');
    bank_acct_rec.bank_account_name := parser.get_string('BANK_ACCOUNT_NAME');
    bank_acct_rec.bank_account_num := parser.get_string('BANK_ACCOUNT_NUM');
    bank_acct_rec.currency := parser.get_string('CURRENCY');
    bank_acct_rec.bank_account_num_hash1 := parser.get_string('BANK_ACCOUNT_NUM_HASH1');
    bank_acct_rec.bank_account_num_hash2 := parser.get_string('BANK_ACCOUNT_NUM_HASH2');
    bank_acct_rec.iban := parser.get_string('IBAN');
    bank_acct_rec.check_digits := parser.get_string('CHECK_DIGITS');
    bank_acct_rec.multi_currency_allowed_flag := parser.get_string('MULTI_CURRENCY_ALLOWED_FLAG');
    bank_acct_rec.alternate_acct_name := parser.get_string('ALTERNATE_ACCT_NAME');
    bank_acct_rec.short_acct_name := parser.get_string('SHORT_ACCT_NAME');
    bank_acct_rec.acct_type := parser.get_string('ACCT_TYPE');
    bank_acct_rec.acct_suffix := parser.get_string('ACCT_SUFFIX');
    bank_acct_rec.description := parser.get_string('DESCRIPTION');
    bank_acct_rec.agency_location_code := parser.get_string('AGENCY_LOCATION_CODE');
    bank_acct_rec.foreign_payment_use_flag := parser.get_string('FOREIGN_PAYMENT_USE_FLAG');
    bank_acct_rec.exchange_rate_agreement_num := parser.get_string('EXCHANGE_RATE_AGREEMENT_NUM');
    bank_acct_rec.exchange_rate_agreement_type := parser.get_string('EXCHANGE_RATE_AGREEMENT_TYPE');
    bank_acct_rec.exchange_rate := parser.get_string('EXCHANGE_RATE');
    bank_acct_rec.payment_factor_flag := parser.get_string('PAYMENT_FACTOR_FLAG');
    bank_acct_rec.status := parser.get_string('STATUS');
    bank_acct_rec.end_date := parser.get_date('END_DATE');
    bank_acct_rec.start_date := parser.get_date('START_DATE');
    bank_acct_rec.hedging_contract_reference := parser.get_string('HEDGING_CONTRACT_REFERENCE');
    bank_acct_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY');
    bank_acct_rec.attribute1 := parser.get_string('ATTRIBUTE1');
    bank_acct_rec.attribute2 := parser.get_string('ATTRIBUTE2');
    bank_acct_rec.attribute3 := parser.get_string('ATTRIBUTE3');
    bank_acct_rec.attribute4 := parser.get_string('ATTRIBUTE4');
    bank_acct_rec.attribute5 := parser.get_string('ATTRIBUTE5');
    bank_acct_rec.attribute6 := parser.get_string('ATTRIBUTE6');
    bank_acct_rec.attribute7 := parser.get_string('ATTRIBUTE7');
    bank_acct_rec.attribute8 := parser.get_string('ATTRIBUTE8');
    bank_acct_rec.attribute9 := parser.get_string('ATTRIBUTE9');
    bank_acct_rec.attribute10 := parser.get_string('ATTRIBUTE10');
    bank_acct_rec.attribute11 := parser.get_string('ATTRIBUTE11');
    bank_acct_rec.attribute12 := parser.get_string('ATTRIBUTE12');
    bank_acct_rec.attribute13 := parser.get_string('ATTRIBUTE13');
    bank_acct_rec.attribute14 := parser.get_string('ATTRIBUTE14');
    bank_acct_rec.attribute15 := parser.get_string('ATTRIBUTE15');
    bank_acct_rec.object_version_number := parser.get_string('OBJECT_VERSION_NUMBER');
    bank_acct_rec.secondary_account_reference := parser.get_string('SECONDARY_ACCOUNT_REFERENCE');
    bank_acct_rec.contact_name := parser.get_string('CONTACT_NAME');
    bank_acct_rec.contact_phone := parser.get_string('CONTACT_PHONE');
    bank_acct_rec.contact_email := parser.get_string('CONTACT_EMAIL');
    bank_acct_rec.contact_fax := parser.get_string('CONTACT_FAX');

    return bank_acct_rec;
  end convert_bank_acct_json;

  function convert_inter_bank_json(
    inter_bank_json in pljson
  ) return iby_ext_bankacct_pub.intermediaryacct_rec_type is
    inter_bank_rec iby_ext_bankacct_pub.intermediaryacct_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => inter_bank_json);

    inter_bank_rec.intermediary_acct_id := parser.get_string('INTERMEDIARY_ACCT_ID');
    inter_bank_rec.bank_account_id := parser.get_string('BANK_ACCOUNT_ID');
    inter_bank_rec.country_code := parser.get_string('COUNTRY_CODE');
    inter_bank_rec.bank_name := parser.get_string('BANK_NAME');
    inter_bank_rec.city := parser.get_string('CITY');
    inter_bank_rec.bank_code := parser.get_string('BANK_CODE');
    inter_bank_rec.branch_number := parser.get_string('BRANCH_NUMBER');
    inter_bank_rec.bic := parser.get_string('BIC');
    inter_bank_rec.account_number := parser.get_string('ACCOUNT_NUMBER');
    inter_bank_rec.check_digits := parser.get_string('CHECK_DIGITS');
    inter_bank_rec.iban := parser.get_string('IBAN');
    inter_bank_rec.comments := parser.get_string('COMMENTS');
    inter_bank_rec.object_version_number := parser.get_string('OBJECT_VERSION_NUMBER');

    return inter_bank_rec;
  end convert_inter_bank_json;

  function convert_contact_json(
    contact_json in pljson
  ) return ap_vendor_pub_pkg.r_vendor_contact_rec_type is
    contact_rec ap_vendor_pub_pkg.r_vendor_contact_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => contact_json);

    contact_rec.vendor_contact_id := parser.get_string('VENDOR_CONTACT_ID');
    contact_rec.vendor_site_id := parser.get_string('VENDOR_SITE_ID');
    contact_rec.vendor_id := parser.get_string('VENDOR_ID');
    contact_rec.per_party_id := parser.get_string('PER_PARTY_ID');
    contact_rec.relationship_id := parser.get_string('RELATIONSHIP_ID');
    contact_rec.rel_party_id := parser.get_string('REL_PARTY_ID');
    contact_rec.party_site_id := parser.get_string('PARTY_SITE_ID');
    contact_rec.org_contact_id := parser.get_string('ORG_CONTACT_ID');
    contact_rec.org_party_site_id := parser.get_string('ORG_PARTY_SITE_ID');
    contact_rec.person_first_name := parser.get_string('PERSON_FIRST_NAME');
    contact_rec.person_middle_name := parser.get_string('PERSON_MIDDLE_NAME');
    contact_rec.person_last_name := parser.get_string('PERSON_LAST_NAME');
    contact_rec.person_title := parser.get_string('PERSON_TITLE');
    contact_rec.organization_name_phonetic := parser.get_string('ORGANIZATION_NAME_PHONETIC');
    contact_rec.person_first_name_phonetic := parser.get_string('PERSON_FIRST_NAME_PHONETIC');
    contact_rec.person_last_name_phonetic := parser.get_string('PERSON_LAST_NAME_PHONETIC');
    contact_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY');
    contact_rec.attribute1 := parser.get_string('ATTRIBUTE1');
    contact_rec.attribute2 := parser.get_string('ATTRIBUTE2');
    contact_rec.attribute3 := parser.get_string('ATTRIBUTE3');
    contact_rec.attribute4 := parser.get_string('ATTRIBUTE4');
    contact_rec.attribute5 := parser.get_string('ATTRIBUTE5');
    contact_rec.attribute6 := parser.get_string('ATTRIBUTE6');
    contact_rec.attribute7 := parser.get_string('ATTRIBUTE7');
    contact_rec.attribute8 := parser.get_string('ATTRIBUTE8');
    contact_rec.attribute9 := parser.get_string('ATTRIBUTE9');
    contact_rec.attribute10 := parser.get_string('ATTRIBUTE10');
    contact_rec.attribute11 := parser.get_string('ATTRIBUTE11');
    contact_rec.attribute12 := parser.get_string('ATTRIBUTE12');
    contact_rec.attribute13 := parser.get_string('ATTRIBUTE13');
    contact_rec.attribute14 := parser.get_string('ATTRIBUTE14');
    contact_rec.attribute15 := parser.get_string('ATTRIBUTE15');
    contact_rec.inactive_date := parser.get_string('INACTIVE_DATE');
    contact_rec.party_number := parser.get_string('PARTY_NUMBER');
    contact_rec.department := parser.get_string('DEPARTMENT');
    contact_rec.mail_stop := parser.get_string('MAIL_STOP');
    contact_rec.area_code := parser.get_string('AREA_CODE');
    contact_rec.phone := parser.get_string('PHONE');
    contact_rec.alt_area_code := parser.get_string('ALT_AREA_CODE');
    contact_rec.alt_phone := parser.get_string('ALT_PHONE');
    contact_rec.fax_area_code := parser.get_string('FAX_AREA_CODE');
    contact_rec.fax_phone := parser.get_string('FAX_PHONE');
    contact_rec.email_address := parser.get_string('EMAIL_ADDRESS');
    contact_rec.url := parser.get_string('URL');
    contact_rec.vendor_contact_interface_id := parser.get_string('VENDOR_CONTACT_INTERFACE_ID');
    contact_rec.vendor_interface_id := parser.get_string('VENDOR_INTERFACE_ID');
    contact_rec.vendor_site_code := parser.get_string('VENDOR_SITE_CODE');
    contact_rec.org_id := parser.get_string('ORG_ID');
    contact_rec.operating_unit_name := parser.get_string('OPERATING_UNIT_NAME');
    contact_rec.prefix := parser.get_string('PREFIX');
    contact_rec.contact_name_phonetic := parser.get_string('CONTACT_NAME_PHONETIC');
    contact_rec.party_site_name := parser.get_string('PARTY_SITE_NAME');

    return contact_rec;
  end convert_contact_json;


  function convert_external_payee_json(
    external_payee_json in pljson
  ) return iby_disbursement_setup_pub.external_payee_rec_type is
    ex_payee_rec iby_disbursement_setup_pub.external_payee_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => external_payee_json);

    ex_payee_rec.default_pmt_method := parser.get_string('DEFAULT_PMT_METHOD');
    ex_payee_rec.ece_tp_loc_code := parser.get_string('ECE_TP_LOC_CODE');
    ex_payee_rec.bank_charge_bearer := parser.get_string('BANK_CHARGE_BEARER');
    ex_payee_rec.bank_instr1_code := parser.get_string('BANK_INSTR1_CODE');
    ex_payee_rec.bank_instr2_code := parser.get_string('BANK_INSTR2_CODE');
    ex_payee_rec.bank_instr_detail := parser.get_string('BANK_INSTR_DETAIL');
    ex_payee_rec.pay_reason_code := parser.get_string('PAY_REASON_CODE');
    ex_payee_rec.pay_reason_com := parser.get_string('PAY_REASON_COM');
    ex_payee_rec.inactive_date := parser.get_string('INACTIVE_DATE');
    ex_payee_rec.pay_message1 := parser.get_string('PAY_MESSAGE1');
    ex_payee_rec.pay_message2 := parser.get_string('PAY_MESSAGE2');
    ex_payee_rec.pay_message3 := parser.get_string('PAY_MESSAGE3');
    ex_payee_rec.delivery_channel := parser.get_string('DELIVERY_CHANNEL');
    ex_payee_rec.pmt_format := parser.get_string('PMT_FORMAT');
    ex_payee_rec.settlement_priority := parser.get_string('SETTLEMENT_PRIORITY');
    ex_payee_rec.remit_advice_delivery_method := parser.get_string('REMIT_ADVICE_DELIVERY_METHOD');
    ex_payee_rec.remit_advice_email := parser.get_string('REMIT_ADVICE_EMAIL');
    ex_payee_rec.edi_payment_format := parser.get_string('EDI_PAYMENT_FORMAT');
    ex_payee_rec.edi_transaction_handling := parser.get_string('EDI_TRANSACTION_HANDLING');
    ex_payee_rec.edi_payment_method := parser.get_string('EDI_PAYMENT_METHOD');
    ex_payee_rec.edi_remittance_method := parser.get_string('EDI_REMITTANCE_METHOD');
    ex_payee_rec.edi_remittance_instruction := parser.get_string('EDI_REMITTANCE_INSTRUCTION');
    ex_payee_rec.remit_advice_fax := parser.get_string('REMIT_ADVICE_FAX');

    return ex_payee_rec;
  end convert_external_payee_json;

  function convert_site_json(
    parser in graphite_sync_json_parser
  ) return ap_vendor_pub_pkg.r_vendor_site_rec_type is
    site_rec ap_vendor_pub_pkg.r_vendor_site_rec_type;
    ex_payee_json pljson;
  begin
    site_rec.area_code := parser.get_string('AREA_CODE', true);
    site_rec.phone := parser.get_string('PHONE', true);
    site_rec.customer_num := parser.get_string('CUSTOMER_NUM');
    site_rec.ship_to_location_id := parser.get_number('SHIP_TO_LOCATION_ID');
    site_rec.bill_to_location_id := parser.get_number('BILL_TO_LOCATION_ID');
    site_rec.ship_via_lookup_code := parser.get_string('SHIP_VIA_LOOKUP_CODE');
    site_rec.freight_terms_lookup_code := parser.get_string('FREIGHT_TERMS_LOOKUP_CODE');
    site_rec.fob_lookup_code := parser.get_string('FOB_LOOKUP_CODE');
    site_rec.inactive_date := parser.get_date('INACTIVE_DATE', true);
    site_rec.fax := parser.get_string('FAX');
    site_rec.fax_area_code := parser.get_string('FAX_AREA_CODE');
    site_rec.telex := parser.get_string('TELEX');
    site_rec.terms_date_basis := parser.get_string('TERMS_DATE_BASIS');
    site_rec.distribution_set_id := parser.get_number('DISTRIBUTION_SET_ID');
    site_rec.accts_pay_code_combination_id := parser.get_number('ACCTS_PAY_CODE_COMBINATION_ID');
    site_rec.prepay_code_combination_id := parser.get_number('PREPAY_CODE_COMBINATION_ID');
    site_rec.pay_group_lookup_code := parser.get_string('PAY_GROUP_LOOKUP_CODE');
    site_rec.payment_priority := parser.get_string('PAYMENT_PRIORITY');
    site_rec.terms_id := parser.get_number('TERMS_ID', true);
    site_rec.invoice_amount_limit := parser.get_string('INVOICE_AMOUNT_LIMIT');
    site_rec.pay_date_basis_lookup_code := parser.get_string('PAY_DATE_BASIS_LOOKUP_CODE');
    site_rec.always_take_disc_flag := parser.get_string('ALWAYS_TAKE_DISC_FLAG', true);
    site_rec.invoice_currency_code := parser.get_string('INVOICE_CURRENCY_CODE');
    site_rec.payment_currency_code := parser.get_string('PAYMENT_CURRENCY_CODE');
    site_rec.vendor_site_id := parser.get_number('VENDOR_SITE_ID');
    site_rec.vendor_id := parser.get_number('VENDOR_ID');
    site_rec.vendor_site_code := parser.get_string('VENDOR_SITE_CODE');
    site_rec.vendor_site_code_alt := parser.get_string('VENDOR_SITE_CODE_ALT');
    site_rec.purchasing_site_flag := parser.get_string('PURCHASING_SITE_FLAG', true);
    site_rec.rfq_only_site_flag := parser.get_string('RFQ_ONLY_SITE_FLAG', true);
    site_rec.pay_site_flag := parser.get_string('PAY_SITE_FLAG', true);
    site_rec.attention_ar_flag := parser.get_string('ATTENTION_AR_FLAG', true);
    site_rec.hold_all_payments_flag := parser.get_string('HOLD_ALL_PAYMENTS_FLAG', true);
    site_rec.hold_future_payments_flag := parser.get_string('HOLD_FUTURE_PAYMENTS_FLAG', true);
    site_rec.hold_reason := parser.get_string('HOLD_REASON', true);
    site_rec.hold_unmatched_invoices_flag := parser.get_string('HOLD_UNMATCHED_INVOICES_FLAG', true);
    site_rec.tax_reporting_site_flag := parser.get_string('TAX_REPORTING_SITE_FLAG', true);
    site_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY', true);
    site_rec.attribute1 := parser.get_string('ATTRIBUTE1', true);
    site_rec.attribute2 := parser.get_string('ATTRIBUTE2', true);
    site_rec.attribute3 := parser.get_string('ATTRIBUTE3', true);
    site_rec.attribute4 := parser.get_string('ATTRIBUTE4', true);
    site_rec.attribute5 := parser.get_string('ATTRIBUTE5', true);
    site_rec.attribute6 := parser.get_string('ATTRIBUTE6', true);
    site_rec.attribute7 := parser.get_string('ATTRIBUTE7', true);
    site_rec.attribute8 := parser.get_string('ATTRIBUTE8', true);
    site_rec.attribute9 := parser.get_string('ATTRIBUTE9', true);
    site_rec.attribute10 := parser.get_string('ATTRIBUTE10', true);
    site_rec.attribute11 := parser.get_string('ATTRIBUTE11', true);
    site_rec.attribute12 := parser.get_string('ATTRIBUTE12', true);
    site_rec.attribute13 := parser.get_string('ATTRIBUTE13', true);
    site_rec.attribute14 := parser.get_string('ATTRIBUTE14', true);
    site_rec.attribute15 := parser.get_string('ATTRIBUTE15', true);
    site_rec.validation_number := parser.get_string('VALIDATION_NUMBER');
    site_rec.exclude_freight_from_discount := parser.get_string('EXCLUDE_FREIGHT_FROM_DISCOUNT');
    site_rec.bank_charge_bearer := parser.get_string('BANK_CHARGE_BEARER');
    site_rec.org_id := parser.get_number('ORG_ID');
    site_rec.check_digits := parser.get_string('CHECK_DIGITS');
    site_rec.allow_awt_flag := parser.get_string('ALLOW_AWT_FLAG', true);
    site_rec.awt_group_id := parser.get_number('AWT_GROUP_ID');
    site_rec.pay_awt_group_id := parser.get_number('PAY_AWT_GROUP_ID');
    site_rec.default_pay_site_id := parser.get_number('DEFAULT_PAY_SITE_ID');
    site_rec.pay_on_code := parser.get_string('PAY_ON_CODE');
    site_rec.pay_on_receipt_summary_code := parser.get_string('PAY_ON_RECEIPT_SUMMARY_CODE');
    site_rec.global_attribute_category := parser.get_string('GLOBAL_ATTRIBUTE_CATEGORY');
    site_rec.global_attribute1 := parser.get_string('GLOBAL_ATTRIBUTE1', true);
    site_rec.global_attribute2 := parser.get_string('GLOBAL_ATTRIBUTE2', true);
    site_rec.global_attribute3 := parser.get_string('GLOBAL_ATTRIBUTE3', true);
    site_rec.global_attribute4 := parser.get_string('GLOBAL_ATTRIBUTE4', true);
    site_rec.global_attribute5 := parser.get_string('GLOBAL_ATTRIBUTE5', true);
    site_rec.global_attribute6 := parser.get_string('GLOBAL_ATTRIBUTE6', true);
    site_rec.global_attribute7 := parser.get_string('GLOBAL_ATTRIBUTE7', true);
    site_rec.global_attribute8 := parser.get_string('GLOBAL_ATTRIBUTE8', true);
    site_rec.global_attribute9 := parser.get_string('GLOBAL_ATTRIBUTE9', true);
    site_rec.global_attribute10 := parser.get_string('GLOBAL_ATTRIBUTE10', true);
    site_rec.global_attribute11 := parser.get_string('GLOBAL_ATTRIBUTE11', true);
    site_rec.global_attribute12 := parser.get_string('GLOBAL_ATTRIBUTE12', true);
    site_rec.global_attribute13 := parser.get_string('GLOBAL_ATTRIBUTE13', true);
    site_rec.global_attribute14 := parser.get_string('GLOBAL_ATTRIBUTE14', true);
    site_rec.global_attribute15 := parser.get_string('GLOBAL_ATTRIBUTE15', true);
    site_rec.global_attribute16 := parser.get_string('GLOBAL_ATTRIBUTE16', true);
    site_rec.global_attribute17 := parser.get_string('GLOBAL_ATTRIBUTE17', true);
    site_rec.global_attribute18 := parser.get_string('GLOBAL_ATTRIBUTE18', true);
    site_rec.global_attribute19 := parser.get_string('GLOBAL_ATTRIBUTE19', true);
    site_rec.global_attribute20 := parser.get_string('GLOBAL_ATTRIBUTE20', true);
    site_rec.tp_header_id := parser.get_number('TP_HEADER_ID');
    site_rec.ece_tp_location_code := parser.get_string('ECE_TP_LOCATION_CODE');
    site_rec.pcard_site_flag := parser.get_string('PCARD_SITE_FLAG');
    site_rec.match_option := parser.get_string('MATCH_OPTION');
    site_rec.country_of_origin_code := parser.get_string('COUNTRY_OF_ORIGIN_CODE');
    site_rec.future_dated_payment_ccid := parser.get_string('FUTURE_DATED_PAYMENT_CCID');
    site_rec.create_debit_memo_flag := parser.get_string('CREATE_DEBIT_MEMO_FLAG');
    site_rec.supplier_notif_method := parser.get_string('SUPPLIER_NOTIF_METHOD');
    site_rec.email_address := parser.get_string('EMAIL_ADDRESS', true);
    site_rec.primary_pay_site_flag := parser.get_string('PRIMARY_PAY_SITE_FLAG');
    site_rec.shipping_control := parser.get_string('SHIPPING_CONTROL');
    site_rec.selling_company_identifier := parser.get_string('SELLING_COMPANY_IDENTIFIER');
    site_rec.gapless_inv_num_flag := parser.get_string('GAPLESS_INV_NUM_FLAG');
    site_rec.location_id := parser.get_number('LOCATION_ID');
    site_rec.party_site_id := parser.get_number('PARTY_SITE_ID');
    site_rec.org_name := parser.get_string('ORG_NAME');
    site_rec.duns_number := parser.get_string('DUNS_NUMBER', true);
    site_rec.address_style := parser.get_string('ADDRESS_STYLE');
    site_rec.language := parser.get_string('LANGUAGE');
    site_rec.province := parser.get_string('PROVINCE');
    site_rec.country := parser.get_string('COUNTRY');
    site_rec.address_line1 := parser.get_string('ADDRESS_LINE1');
    site_rec.address_line2 := parser.get_string('ADDRESS_LINE2', true);
    site_rec.address_line3 := parser.get_string('ADDRESS_LINE3', true);
    site_rec.address_line4 := parser.get_string('ADDRESS_LINE4', true);
    site_rec.address_lines_alt := parser.get_string('ADDRESS_LINES_ALT', true);
    site_rec.county := parser.get_string('COUNTY', true);
    site_rec.city := parser.get_string('CITY', true);
    site_rec.state := parser.get_string('STATE', true);
    site_rec.zip := parser.get_string('ZIP', true);
    site_rec.terms_name := parser.get_string('TERMS_NAME');
    site_rec.default_terms_id := parser.get_number('DEFAULT_TERMS_ID', true);
    site_rec.awt_group_name := parser.get_string('AWT_GROUP_NAME');
    site_rec.pay_awt_group_name := parser.get_string('PAY_AWT_GROUP_NAME');
    site_rec.distribution_set_name := parser.get_string('DISTRIBUTION_SET_NAME');
    site_rec.ship_to_location_code := parser.get_string('SHIP_TO_LOCATION_CODE');
    site_rec.bill_to_location_code := parser.get_string('BILL_TO_LOCATION_CODE');
    site_rec.default_dist_set_id := parser.get_number('DEFAULT_DIST_SET_ID');
    site_rec.default_ship_to_loc_id := parser.get_number('DEFAULT_SHIP_TO_LOC_ID');
    site_rec.default_bill_to_loc_id := parser.get_number('DEFAULT_BILL_TO_LOC_ID');
    site_rec.tolerance_id := parser.get_number('TOLERANCE_ID');
    site_rec.tolerance_name := parser.get_string('TOLERANCE_NAME');
    site_rec.vendor_interface_id := parser.get_number('VENDOR_INTERFACE_ID');
    site_rec.vendor_site_interface_id := parser.get_number('VENDOR_SITE_INTERFACE_ID');
    site_rec.retainage_rate := parser.get_string('RETAINAGE_RATE');
    site_rec.services_tolerance_id := parser.get_number('SERVICES_TOLERANCE_ID');
    site_rec.services_tolerance_name := parser.get_string('SERVICES_TOLERANCE_NAME');
    site_rec.shipping_location_id := parser.get_number('SHIPPING_LOCATION_ID');
    site_rec.vat_code := parser.get_string('VAT_CODE');
    site_rec.vat_registration_num := parser.get_string('VAT_REGISTRATION_NUM');
    site_rec.remittance_email := parser.get_string('REMITTANCE_EMAIL');
    site_rec.edi_id_number := parser.get_number('EDI_ID_NUMBER');
    site_rec.edi_payment_format := parser.get_string('EDI_PAYMENT_FORMAT');
    site_rec.edi_transaction_handling := parser.get_string('EDI_TRANSACTION_HANDLING');
    site_rec.edi_payment_method := parser.get_string('EDI_PAYMENT_METHOD');
    site_rec.edi_remittance_method := parser.get_string('EDI_REMITTANCE_METHOD');
    site_rec.edi_remittance_instruction := parser.get_string('EDI_REMITTANCE_INSTRUCTION');
    site_rec.party_site_name := parser.get_string('PARTY_SITE_NAME');
    site_rec.offset_tax_flag := parser.get_string('OFFSET_TAX_FLAG');
    site_rec.auto_tax_calc_flag := parser.get_string('AUTO_TAX_CALC_FLAG');
    site_rec.remit_advice_delivery_method := parser.get_string('REMIT_ADVICE_DELIVERY_METHOD');
    site_rec.remit_advice_fax := parser.get_string('REMIT_ADVICE_FAX');
    site_rec.cage_code := parser.get_string('CAGE_CODE');
    site_rec.legal_business_name := parser.get_string('LEGAL_BUSINESS_NAME');
    site_rec.doing_bus_as_name := parser.get_string('DOING_BUS_AS_NAME');
    site_rec.division_name := parser.get_string('DIVISION_NAME');
    site_rec.small_business_code := parser.get_string('SMALL_BUSINESS_CODE');
    site_rec.ccr_comments := parser.get_string('CCR_COMMENTS');
    site_rec.debarment_start_date := parser.get_date('DEBARMENT_START_DATE');
    site_rec.debarment_end_date := parser.get_date('DEBARMENT_END_DATE');
    site_rec.ap_tax_rounding_rule := parser.get_string('AP_TAX_ROUNDING_RULE');
    site_rec.amount_includes_tax_flag := parser.get_string('AMOUNT_INCLUDES_TAX_FLAG');

    
    ex_payee_json := parser.get_object(graphite_sync.external_payee_key);
    if ex_payee_json is not null then 
      site_rec.ext_payee_rec := convert_external_payee_json(external_payee_json => ex_payee_json);
    end if;

    return site_rec;
  end convert_site_json;


  function convert_address_json (
    address_json in pljson
  ) return hz_location_v2pub.location_rec_type is
    address_rec hz_location_v2pub.location_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => address_json);
    address_rec.location_id := parser.get_number('LOCATION_ID');
    address_rec.orig_system_reference := parser.get_string('ORIG_SYSTEM_REFERENCE');
    address_rec.orig_system := parser.get_string('ORIG_SYSTEM');
    address_rec.validated_flag := parser.get_string('VALIDATED_FLAG');
    address_rec.address_lines_phonetic := parser.get_string('ADDRESS_LINES_PHONETIC');
    address_rec.po_box_number := parser.get_string('PO_BOX_NUMBER');
    address_rec.location_directions := parser.get_string('LOCATION_DIRECTIONS');
    address_rec.address_effective_date := parser.get_string('ADDRESS_EFFECTIVE_DATE');
    address_rec.address_expiration_date := parser.get_string('ADDRESS_EXPIRATION_DATE');
    address_rec.clli_code := parser.get_string('CLLI_CODE');
    address_rec.language := parser.get_string('LANGUAGE');
    address_rec.short_description := parser.get_string('SHORT_DESCRIPTION');
    address_rec.description := parser.get_string('DESCRIPTION');
    address_rec.geometry_status_code := parser.get_string('GEOMETRY_STATUS_CODE');
    address_rec.loc_hierarchy_id := parser.get_number('LOC_HIERARCHY_ID');
    address_rec.sales_tax_geocode := parser.get_string('SALES_TAX_GEOCODE');
    address_rec.sales_tax_inside_city_limits := parser.get_string('SALES_TAX_INSIDE_CITY_LIMITS');
    address_rec.fa_location_id := parser.get_number('FA_LOCATION_ID');
    address_rec.content_source_type := parser.get_string('CONTENT_SOURCE_TYPE');
    address_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY');
    address_rec.attribute1 := parser.get_string('ATTRIBUTE1');
    address_rec.attribute2 := parser.get_string('ATTRIBUTE2');
    address_rec.attribute3 := parser.get_string('ATTRIBUTE3');
    address_rec.attribute4 := parser.get_string('ATTRIBUTE4');
    address_rec.attribute5 := parser.get_string('ATTRIBUTE5');
    address_rec.attribute6 := parser.get_string('ATTRIBUTE6');
    address_rec.attribute7 := parser.get_string('ATTRIBUTE7');
    address_rec.attribute8 := parser.get_string('ATTRIBUTE8');
    address_rec.attribute9 := parser.get_string('ATTRIBUTE9');
    address_rec.attribute10 := parser.get_string('ATTRIBUTE10');
    address_rec.attribute11 := parser.get_string('ATTRIBUTE11');
    address_rec.attribute12 := parser.get_string('ATTRIBUTE12');
    address_rec.attribute13 := parser.get_string('ATTRIBUTE13');
    address_rec.attribute14 := parser.get_string('ATTRIBUTE14');
    address_rec.attribute15 := parser.get_string('ATTRIBUTE15');
    address_rec.attribute16 := parser.get_string('ATTRIBUTE16');
    address_rec.attribute17 := parser.get_string('ATTRIBUTE17');
    address_rec.attribute18 := parser.get_string('ATTRIBUTE18');
    address_rec.attribute19 := parser.get_string('ATTRIBUTE19');
    address_rec.attribute20 := parser.get_string('ATTRIBUTE20');
    address_rec.timezone_id := parser.get_number('TIMEZONE_ID');
    address_rec.actual_content_source := parser.get_string('ACTUAL_CONTENT_SOURCE');
    address_rec.delivery_point_code := parser.get_string('DELIVERY_POINT_CODE');

    return address_rec;
  end;

  function convert_party_site_json(
    party_site_json pljson
  ) return hz_party_site_v2pub.party_site_rec_type is
    party_site_rec hz_party_site_v2pub.party_site_rec_type;
    parser graphite_sync_json_parser;
  begin
    parser := graphite_sync_json_parser(json_data => party_site_json);
    party_site_rec.party_site_id := parser.get_number('PARTY_SITE_ID');
    party_site_rec.party_id := parser.get_number('PARTY_ID');
    party_site_rec.location_id := parser.get_number('LOCATION_ID');
    party_site_rec.party_site_number := parser.get_string('PARTY_SITE_NUMBER');
    party_site_rec.orig_system_reference := parser.get_string('ORIG_SYSTEM_REFERENCE');
    party_site_rec.orig_system := parser.get_string('ORIG_SYSTEM');
    party_site_rec.mailstop := parser.get_string('MAILSTOP');
    party_site_rec.identifying_address_flag := parser.get_string('IDENTIFYING_ADDRESS_FLAG');
    party_site_rec.status := parser.get_string('STATUS');
    party_site_rec.party_site_name := parser.get_string('PARTY_SITE_NAME');
    party_site_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY');
    party_site_rec.attribute1 := parser.get_string('ATTRIBUTE1');
    party_site_rec.attribute2 := parser.get_string('ATTRIBUTE2');
    party_site_rec.attribute3 := parser.get_string('ATTRIBUTE3');
    party_site_rec.attribute4 := parser.get_string('ATTRIBUTE4');
    party_site_rec.attribute5 := parser.get_string('ATTRIBUTE5');
    party_site_rec.attribute6 := parser.get_string('ATTRIBUTE6');
    party_site_rec.attribute7 := parser.get_string('ATTRIBUTE7');
    party_site_rec.attribute8 := parser.get_string('ATTRIBUTE8');
    party_site_rec.attribute9 := parser.get_string('ATTRIBUTE9');
    party_site_rec.attribute10 := parser.get_string('ATTRIBUTE10');
    party_site_rec.attribute11 := parser.get_string('ATTRIBUTE11');
    party_site_rec.attribute12 := parser.get_string('ATTRIBUTE12');
    party_site_rec.attribute13 := parser.get_string('ATTRIBUTE13');
    party_site_rec.attribute14 := parser.get_string('ATTRIBUTE14');
    party_site_rec.attribute15 := parser.get_string('ATTRIBUTE15');
    party_site_rec.attribute16 := parser.get_string('ATTRIBUTE16');
    party_site_rec.attribute17 := parser.get_string('ATTRIBUTE17');
    party_site_rec.attribute18 := parser.get_string('ATTRIBUTE18');
    party_site_rec.attribute19 := parser.get_string('ATTRIBUTE19');
    party_site_rec.attribute20 := parser.get_string('ATTRIBUTE20');
    party_site_rec.language := parser.get_string('LANGUAGE');
    party_site_rec.addressee := parser.get_string('ADDRESSEE');
    party_site_rec.created_by_module := parser.get_string('CREATED_BY_MODULE');
    party_site_rec.application_id := parser.get_number('APPLICATION_ID');
    party_site_rec.global_location_number := parser.get_string('GLOBAL_LOCATION_NUMBER');
    party_site_rec.duns_number_c := parser.get_string('DUNS_NUMBER_C');
    return party_site_rec;
  end convert_party_site_json;

  function convert_organization_json(
    org_json in pljson,
    party_id in number
  ) return hz_party_v2pub.organization_rec_type is
    parser graphite_sync_json_parser;
    org_rec   hz_party_v2pub.organization_rec_type;
    party_rec hz_party_v2pub.party_rec_type;
  begin
    parser := graphite_sync_json_parser(json_data => org_json);

    org_rec.organization_name := parser.get_string('ORGANIZATION_NAME');
    org_rec.duns_number_c := parser.get_number('DUNS_NUMBER_C');
    org_rec.enquiry_duns := parser.get_number('ENQUIRY_DUNS');
    org_rec.ceo_name := parser.get_string('CEO_NAME');
    org_rec.ceo_title := parser.get_string('CEO_TITLE');
    org_rec.principal_name := parser.get_string('PRINCIPAL_NAME');
    org_rec.principal_title := parser.get_string('PRINCIPAL_TITLE');
    org_rec.legal_status := parser.get_string('LEGAL_STATUS');
    org_rec.control_yr := parser.get_string('CONTROL_YR');
    org_rec.employees_total := parser.get_string('EMPLOYEES_TOTAL');
    org_rec.hq_branch_ind := parser.get_string('HQ_BRANCH_IND');
    org_rec.branch_flag := parser.get_string('BRANCH_FLAG');
    org_rec.oob_ind := parser.get_string('OOB_IND');
    org_rec.line_of_business := parser.get_string('LINE_OF_BUSINESS');
    org_rec.cong_dist_code := parser.get_string('CONG_DIST_CODE');
    org_rec.sic_code := parser.get_string('SIC_CODE');
    org_rec.import_ind := parser.get_string('IMPORT_IND');
    org_rec.export_ind := parser.get_string('EXPORT_IND');
    org_rec.labor_surplus_ind := parser.get_string('LABOR_SURPLUS_IND');
    org_rec.debarment_ind := parser.get_string('DEBARMENT_IND');
    org_rec.minority_owned_ind := parser.get_string('MINORITY_OWNED_IND');
    org_rec.minority_owned_type := parser.get_string('MINORITY_OWNED_TYPE');
    org_rec.woman_owned_ind := parser.get_string('WOMAN_OWNED_IND');
    org_rec.disadv_8a_ind := parser.get_string('DISADV_8A_IND');
    org_rec.small_bus_ind := parser.get_string('SMALL_BUS_IND');
    org_rec.rent_own_ind := parser.get_string('RENT_OWN_IND');
    org_rec.debarments_count := parser.get_string('DEBARMENTS_COUNT');
    org_rec.debarments_date := parser.get_string('DEBARMENTS_DATE');
    org_rec.failure_score := parser.get_string('FAILURE_SCORE');
    org_rec.failure_score_natnl_percentile := parser.get_string('FAILURE_SCORE_NATNL_PERCENTILE');
    org_rec.failure_score_override_code := parser.get_string('FAILURE_SCORE_OVERRIDE_CODE');
    org_rec.failure_score_commentary := parser.get_string('FAILURE_SCORE_COMMENTARY');
    org_rec.global_failure_score := parser.get_string('GLOBAL_FAILURE_SCORE');
    org_rec.db_rating := parser.get_string('DB_RATING');
    org_rec.credit_score := parser.get_string('CREDIT_SCORE');
    org_rec.credit_score_commentary := parser.get_string('CREDIT_SCORE_COMMENTARY');
    org_rec.paydex_score := parser.get_string('PAYDEX_SCORE');
    org_rec.paydex_three_months_ago := parser.get_string('PAYDEX_THREE_MONTHS_AGO');
    org_rec.paydex_norm := parser.get_string('PAYDEX_NORM');
    org_rec.best_time_contact_begin := parser.get_string('BEST_TIME_CONTACT_BEGIN');
    org_rec.best_time_contact_end := parser.get_string('BEST_TIME_CONTACT_END');
    org_rec.organization_name_phonetic := parser.get_string('ORGANIZATION_NAME_PHONETIC');
    org_rec.tax_reference := parser.get_string('TAX_REFERENCE');
    org_rec.gsa_indicator_flag := parser.get_string('GSA_INDICATOR_FLAG');
    org_rec.jgzz_fiscal_code := parser.get_string('JGZZ_FISCAL_CODE');
    org_rec.analysis_fy := parser.get_string('ANALYSIS_FY');
    org_rec.fiscal_yearend_month := parser.get_string('FISCAL_YEAREND_MONTH');
    org_rec.curr_fy_potential_revenue := parser.get_string('CURR_FY_POTENTIAL_REVENUE');
    org_rec.next_fy_potential_revenue := parser.get_string('NEXT_FY_POTENTIAL_REVENUE');
    org_rec.year_established := parser.get_string('YEAR_ESTABLISHED');
    org_rec.mission_statement := parser.get_string('MISSION_STATEMENT');
    org_rec.organization_type := parser.get_string('ORGANIZATION_TYPE');
    org_rec.business_scope := parser.get_string('BUSINESS_SCOPE');
    org_rec.corporation_class := parser.get_string('CORPORATION_CLASS');
    org_rec.known_as := parser.get_string('KNOWN_AS');
    org_rec.known_as2 := parser.get_string('KNOWN_AS2');
    org_rec.known_as3 := parser.get_string('KNOWN_AS3');
    org_rec.known_as4 := parser.get_string('KNOWN_AS4');
    org_rec.known_as5 := parser.get_string('KNOWN_AS5');
    org_rec.local_bus_iden_type := parser.get_string('LOCAL_BUS_IDEN_TYPE');
    org_rec.local_bus_identifier := parser.get_string('LOCAL_BUS_IDENTIFIER');
    org_rec.pref_functional_currency := parser.get_string('PREF_FUNCTIONAL_CURRENCY');
    org_rec.registration_type := parser.get_string('REGISTRATION_TYPE');
    org_rec.total_employees_text := parser.get_string('TOTAL_EMPLOYEES_TEXT');
    org_rec.total_employees_ind := parser.get_string('TOTAL_EMPLOYEES_IND');
    org_rec.total_emp_est_ind := parser.get_string('TOTAL_EMP_EST_IND');
    org_rec.total_emp_min_ind := parser.get_string('TOTAL_EMP_MIN_IND');
    org_rec.parent_sub_ind := parser.get_string('PARENT_SUB_IND');
    org_rec.incorp_year := parser.get_string('INCORP_YEAR');
    org_rec.sic_code_type := parser.get_string('SIC_CODE_TYPE');
    org_rec.public_private_ownership_flag := parser.get_string('PUBLIC_PRIVATE_OWNERSHIP_FLAG');
    org_rec.internal_flag := parser.get_string('INTERNAL_FLAG');
    org_rec.local_activity_code_type := parser.get_string('LOCAL_ACTIVITY_CODE_TYPE');
    org_rec.local_activity_code := parser.get_string('LOCAL_ACTIVITY_CODE');
    org_rec.emp_at_primary_adr := parser.get_string('EMP_AT_PRIMARY_ADR');
    org_rec.emp_at_primary_adr_text := parser.get_string('EMP_AT_PRIMARY_ADR_TEXT');
    org_rec.emp_at_primary_adr_est_ind := parser.get_string('EMP_AT_PRIMARY_ADR_EST_IND');
    org_rec.emp_at_primary_adr_min_ind := parser.get_string('EMP_AT_PRIMARY_ADR_MIN_IND');
    org_rec.high_credit := parser.get_string('HIGH_CREDIT');
    org_rec.avg_high_credit := parser.get_string('AVG_HIGH_CREDIT');
    org_rec.total_payments := parser.get_string('TOTAL_PAYMENTS');
    org_rec.credit_score_class := parser.get_string('CREDIT_SCORE_CLASS');
    org_rec.credit_score_natl_percentile := parser.get_string('CREDIT_SCORE_NATL_PERCENTILE');
    org_rec.credit_score_incd_default := parser.get_string('CREDIT_SCORE_INCD_DEFAULT');
    org_rec.credit_score_age := parser.get_string('CREDIT_SCORE_AGE');
    org_rec.credit_score_date := parser.get_string('CREDIT_SCORE_DATE');
    org_rec.credit_score_commentary2 := parser.get_string('CREDIT_SCORE_COMMENTARY2');
    org_rec.credit_score_commentary3 := parser.get_string('CREDIT_SCORE_COMMENTARY3');
    org_rec.credit_score_commentary4 := parser.get_string('CREDIT_SCORE_COMMENTARY4');
    org_rec.credit_score_commentary5 := parser.get_string('CREDIT_SCORE_COMMENTARY5');
    org_rec.credit_score_commentary6 := parser.get_string('CREDIT_SCORE_COMMENTARY6');
    org_rec.credit_score_commentary7 := parser.get_string('CREDIT_SCORE_COMMENTARY7');
    org_rec.credit_score_commentary8 := parser.get_string('CREDIT_SCORE_COMMENTARY8');
    org_rec.credit_score_commentary9 := parser.get_string('CREDIT_SCORE_COMMENTARY9');
    org_rec.credit_score_commentary10 := parser.get_string('CREDIT_SCORE_COMMENTARY10');
    org_rec.failure_score_class := parser.get_string('FAILURE_SCORE_CLASS');
    org_rec.failure_score_incd_default := parser.get_string('FAILURE_SCORE_INCD_DEFAULT');
    org_rec.failure_score_age := parser.get_string('FAILURE_SCORE_AGE');
    org_rec.failure_score_date := parser.get_string('FAILURE_SCORE_DATE');
    org_rec.failure_score_commentary2 := parser.get_string('FAILURE_SCORE_COMMENTARY2');
    org_rec.failure_score_commentary3 := parser.get_string('FAILURE_SCORE_COMMENTARY3');
    org_rec.failure_score_commentary4 := parser.get_string('FAILURE_SCORE_COMMENTARY4');
    org_rec.failure_score_commentary5 := parser.get_string('FAILURE_SCORE_COMMENTARY5');
    org_rec.failure_score_commentary6 := parser.get_string('FAILURE_SCORE_COMMENTARY6');
    org_rec.failure_score_commentary7 := parser.get_string('FAILURE_SCORE_COMMENTARY7');
    org_rec.failure_score_commentary8 := parser.get_string('FAILURE_SCORE_COMMENTARY8');
    org_rec.failure_score_commentary9 := parser.get_string('FAILURE_SCORE_COMMENTARY9');
    org_rec.failure_score_commentary10 := parser.get_string('FAILURE_SCORE_COMMENTARY10');
    org_rec.maximum_credit_recommendation := parser.get_string('MAXIMUM_CREDIT_RECOMMENDATION');
    org_rec.maximum_credit_currency_code := parser.get_string('MAXIMUM_CREDIT_CURRENCY_CODE');
    org_rec.displayed_duns_party_id := parser.get_string('DISPLAYED_DUNS_PARTY_ID');
    org_rec.content_source_type := parser.get_string('CONTENT_SOURCE_TYPE');
    org_rec.content_source_number := parser.get_string('CONTENT_SOURCE_NUMBER');
    org_rec.attribute_category := parser.get_string('ATTRIBUTE_CATEGORY');
    org_rec.attribute1 := parser.get_string('ATTRIBUTE1');
    org_rec.attribute2 := parser.get_string('ATTRIBUTE2');
    org_rec.attribute3 := parser.get_string('ATTRIBUTE3');
    org_rec.attribute4 := parser.get_string('ATTRIBUTE4');
    org_rec.attribute5 := parser.get_string('ATTRIBUTE5');
    org_rec.attribute6 := parser.get_string('ATTRIBUTE6');
    org_rec.attribute7 := parser.get_string('ATTRIBUTE7');
    org_rec.attribute8 := parser.get_string('ATTRIBUTE8');
    org_rec.attribute9 := parser.get_string('ATTRIBUTE9');
    org_rec.attribute10 := parser.get_string('ATTRIBUTE10');
    org_rec.attribute11 := parser.get_string('ATTRIBUTE11');
    org_rec.attribute12 := parser.get_string('ATTRIBUTE12');
    org_rec.attribute13 := parser.get_string('ATTRIBUTE13');
    org_rec.attribute14 := parser.get_string('ATTRIBUTE14');
    org_rec.attribute15 := parser.get_string('ATTRIBUTE15');
    org_rec.attribute16 := parser.get_string('ATTRIBUTE16');
    org_rec.attribute17 := parser.get_string('ATTRIBUTE17');
    org_rec.attribute18 := parser.get_string('ATTRIBUTE18');
    org_rec.attribute19 := parser.get_string('ATTRIBUTE19');
    org_rec.attribute20 := parser.get_string('ATTRIBUTE20');
    org_rec.created_by_module := parser.get_string('CREATED_BY_MODULE');
    org_rec.application_id := parser.get_string('APPLICATION_ID');
    org_rec.do_not_confuse_with := parser.get_string('DO_NOT_CONFUSE_WITH');
    org_rec.actual_content_source := parser.get_string('ACTUAL_CONTENT_SOURCE');
    org_rec.home_country := parser.get_string('HOME_COUNTRY');

    party_rec.party_id := party_id;
    org_rec.party_rec := party_rec;

    return org_rec;
  end;
end graphite_sync_converter;
/
show err;
