create or replace package body apps.graphite_sync_json_utils as
  procedure raise_wrong_type (
    got    in varchar2,
    wanted in varchar2,
    key    in varchar2
  ) is
  begin
    raise_application_error(
                           -20001,
                           'Key "'
                           || key
                           || '": Wanted '
                           || wanted
                           || ' but got '
                           || got
    );
  end;

  procedure set_to_null_value (
    val in out varchar2
  ) is
  begin
    if val is null then
      val := fnd_api.g_null_char;
    end if;
  end set_to_null_value;

  procedure set_to_null_value(
    val in out date
  ) is
  begin
    if val is null then
      val := fnd_api.g_null_date;
    end if;
  end set_to_null_value;

  procedure set_to_null_value(
    val in out number
  ) is
  begin
    if val is null then
      val := fnd_api.g_null_num;
    end if;
  end set_to_null_value;

  function is_null_value_placeholder(
    val in varchar2
  ) return boolean is
  begin
    if val = null_char_placeholder then
      return true;
    end if;
    return false;
  end is_null_value_placeholder;

end graphite_sync_json_utils;
/
show err
