create or replace package apps.graphite_sync_site as
  address_key constant varchar2(7) := 'address';
  address_book_instance_id_key constant varchar2(5) := 'ab_id';
  party_site_key constant varchar2(10) := 'party_site';
  site_second_pass_key constant varchar2(11) := 'second_pass';

  type site_output_t is record (
    vendor_site_id number,
    party_site_id number,
    location_id number
  );

  type site_output_table_t is table of site_output_t;

  procedure process_post_site_batch(
    site_output_table in out site_output_table_t,
    post_site_batch_json in out pljson,
    vendor_id in number
  );

  procedure process_site_from_json(
    site_json in out pljson,
    site_output_obj in out nocopy pljson,
    address_book_output_obj in out nocopy pljson,
    vendor_id in number,
    keys in graphite_sync.r_return_keys,
    ignore_missing in boolean,
    supplier_party_id in number,
    site_output out site_output_t
  );

end graphite_sync_site;
/
show err
