PROMPT -----------------------------------;
PROMPT -- Compiling objects for PL/JSON --;
PROMPT -----------------------------------;

ALTER SESSION SET PLSQL_OPTIMIZE_LEVEL = 3;
ALTER SESSION SET plsql_code_type = 'NATIVE';
ALTER SESSION SET CURRENT_SCHEMA=graphite_hermes;

@@src/pljson/uninstall.sql

@@src/pljson/src/pljson_element.type.decl.sql
@@src/pljson/src/pljson_list.type.decl.sql
@@src/pljson/src/pljson.type.decl.sql
@@src/pljson/src/pljson_string.type.sql
@@src/pljson/src/pljson_number.type.sql
@@src/pljson/src/pljson_bool.type.sql
@@src/pljson/src/pljson_null.type.sql
@@src/pljson/src/pljson_ext.decl.sql
@@src/pljson/src/pljson_parser.decl.sql
@@src/pljson/src/pljson_parser.impl.sql
@@src/pljson/src/pljson_printer.package.sql
@@src/pljson/src/pljson_ext.impl.sql
@@src/pljson/src/pljson_element.type.impl.sql
@@src/pljson/src/pljson_list.type.impl.sql
@@src/pljson/src/pljson.type.impl.sql

PROMPT ------------------------------------------;
PROMPT -- Adding optional packages for PL/JSON --;
PROMPT ------------------------------------------;
@@src/pljson/src/addons/pljson_dyn.package.sql --dynamic sql execute
@@src/pljson/src/addons/pljson_ml.package.sql  --jsonml (xml to json)
@@src/pljson/src/addons/pljson_xml.package.sql --json to xml copied from http://www.json.org/java/org/json/XML.java
@@src/pljson/src/addons/pljson_util_pkg.package.sql --dynamic sql from http://ora-00001.blogspot.com/2010/02/ref-cursor-to-json.html
@@src/pljson/src/addons/pljson_helper.package.sql   --set operations on JSON and JSON_LIST
@@src/pljson/src/addons/pljson_object_cache.decl.sql    -- object cache
@@src/pljson/src/addons/pljson_object_cache.impl.sql    -- object cache
@@src/pljson/src/addons/pljson_table_impl.type.decl.sql -- dynamic table from json document
@@src/pljson/src/addons/pljson_table_impl.type.impl.sql -- dynamic table from json document

ALTER SESSION SET CURRENT_SCHEMA=sys;

PROMPT ------------------------------------------;
PROMPT ---- Adding APPS Grants and Synonyms -----;
PROMPT ------------------------------------------;
grant execute on graphite_hermes.pljson to apps;
grant execute on graphite_hermes.pljson_dyn to apps;
grant execute on graphite_hermes.pljson_helper to apps;
grant execute on graphite_hermes.pljson_ml to apps;
grant execute on graphite_hermes.pljson_object_cache to apps;
grant execute on graphite_hermes.pljson_parser to apps;
grant execute on graphite_hermes.pljson_printer to apps;
grant execute on graphite_hermes.pljson_util_pkg to apps;
grant execute on graphite_hermes.pljson_xml to apps;
grant execute on graphite_hermes.pljson_xml to apps;
grant execute on graphite_hermes.pljson_bool to apps;
grant execute on graphite_hermes.pljson_element to apps;
grant execute on graphite_hermes.pljson_element_array to apps;
grant execute on graphite_hermes.pljson_list to apps;
grant execute on graphite_hermes.pljson_narray to apps;
grant execute on graphite_hermes.pljson_null to apps;
grant execute on graphite_hermes.pljson_number to apps;
grant execute on graphite_hermes.pljson_path to apps;
grant execute on graphite_hermes.pljson_path_segment to apps;
grant execute on graphite_hermes.pljson_string to apps;
grant execute on graphite_hermes.pljson_table_impl to apps;
grant execute on graphite_hermes.pljson_varray to apps;
grant execute on graphite_hermes.pljson_vtab to apps;

create or replace synonym apps.pljson for graphite_hermes.pljson;
create or replace synonym apps.pljson_dyn for graphite_hermes.pljson_dyn;
create or replace synonym apps.pljson_helper for graphite_hermes.pljson_helper;
create or replace synonym apps.pljson_ml for graphite_hermes.pljson_ml;
create or replace synonym apps.pljson_object_cache for graphite_hermes.pljson_object_cache;
create or replace synonym apps.pljson_parser for graphite_hermes.pljson_parser;
create or replace synonym apps.pljson_printer for graphite_hermes.pljson_printer;
create or replace synonym apps.pljson_util_pkg for graphite_hermes.pljson_util_pkg;
create or replace synonym apps.pljson_xml for graphite_hermes.pljson_xml;
create or replace synonym apps.pljson_bool for graphite_hermes.pljson_bool;
create or replace synonym apps.pljson_element for graphite_hermes.pljson_element;
create or replace synonym apps.pljson_element_array for graphite_hermes.pljson_element_array;
create or replace synonym apps.pljson_list for graphite_hermes.pljson_list;
create or replace synonym apps.pljson_narray for graphite_hermes.pljson_narray;
create or replace synonym apps.pljson_null for graphite_hermes.pljson_null;
create or replace synonym apps.pljson_number for graphite_hermes.pljson_number;
create or replace synonym apps.pljson_path for graphite_hermes.pljson_path;
create or replace synonym apps.pljson_path_segment for graphite_hermes.pljson_path_segment;
create or replace synonym apps.pljson_string for graphite_hermes.pljson_string;
create or replace synonym apps.pljson_table_impl for graphite_hermes.pljson_table_impl;
create or replace synonym apps.pljson_varray for graphite_hermes.pljson_varray;
create or replace synonym apps.pljson_vtab for graphite_hermes.pljson_vtab;

PROMPT ------------------------------------------;
PROMPT --- Adding hermes package dependencies ---;
PROMPT ------------------------------------------;

-- this order matters
--@@src/hermes/src/graphite_sync_logs_tbl.sql
--@@src/hermes/src/graphite_sync_logs_seq.sql
--@@src/hermes/src/graphite_sync_logs_trigger.sql
--@@src/hermes/src/graphite_sync_logger_type.sql
--@@src/hermes/src/graphite_sync_logs_proc.sql
--@@src/hermes/src/graphite_sync_logger_type_body.sql

--grant select on graphite_hermes.graphite_log_id_seq to apps;
--grant select on graphite_hermes.graphite_transaction_id_seq to apps;
--grant execute on graphite_hermes.graphite_sync_write_log to apps;
--grant execute on graphite_hermes.graphite_sync_logger to apps;
--grant insert on graphite_hermes.graphite_sync_logs to apps;
--grant select on graphite_hermes.graphite_sync_logs to apps;
--create or replace synonym apps.graphite_sync_logger for graphite_hermes.graphite_sync_logger;
--create or replace synonym apps.graphite_sync_logs for graphite_hermes.graphite_sync_logs;
--create or replace synonym apps.graphite_log_id_seq for graphite_hermes.graphite_log_id_seq;
--create or replace synonym apps.graphite_transaction_id_seq for graphite_hermes.graphite_transaction_id_seq;
--create or replace synonym apps.graphite_sync_write_log for graphite_hermes.graphite_sync_write_log;

PROMPT ------------------------------------------;
PROMPT --------- Adding hermes package ----------;
PROMPT ------------------------------------------;
@@src/hermes/src/pkgs/graphite_sync.decl.sql
@@src/hermes/src/pkgs/graphite_sync_converter.decl.sql
@@src/hermes/src/pkgs/graphite_sync_supplier.decl.sql
@@src/hermes/src/pkgs/graphite_sync_site.decl.sql
@@src/hermes/src/pkgs/graphite_sync_bank.decl.sql
@@src/hermes/src/pkgs/graphite_sync_contact.decl.sql
@@src/hermes/src/pkgs/graphite_sync_json_utils.decl.sql
@@src/hermes/src/pkgs/graphite_sync_json_parser.decl.sql

@@src/hermes/src/pkgs/graphite_sync.impl.sql
@@src/hermes/src/pkgs/graphite_sync_converter.impl.sql
@@src/hermes/src/pkgs/graphite_sync_supplier.impl.sql
@@src/hermes/src/pkgs/graphite_sync_site.impl.sql
@@src/hermes/src/pkgs/graphite_sync_bank.impl.sql
@@src/hermes/src/pkgs/graphite_sync_contact.impl.sql
@@src/hermes/src/pkgs/graphite_sync_json_utils.impl.sql
@@src/hermes/src/pkgs/graphite_sync_json_parser.impl.sql

grant execute on apps.graphite_sync to graphite_hermes;
create or replace synonym graphite_hermes.graphite_sync for apps.graphite_sync;

--alter user graphite_hermes default tablespace apps_ts_tx_data;
--alter user graphite_hermes quota unlimited on apps_ts_tx_data;
/
show err
