create or replace package apps.graphite_sync as
  instance_id_key constant varchar2(3) := '_id';
  organization_key constant varchar2(12) := 'organization';
  external_payee_key constant varchar2(14) := 'external_payee';

  type r_return_keys is record
                        (
                          supplier_group_key        varchar2(50),
                          site_group_key            varchar2(50),
                          address_book_group_key    varchar2(50),
                          bank_group_key            varchar2(50),
                          vendor_id_key             varchar2(50),
                          party_id_key              varchar2(50),
                          segment1_key              varchar2(50),
                          vendor_site_id_key        varchar2(50),
                          party_site_id_key         varchar2(50),
                          location_id_key           varchar2(50),
                          vendor_contact_id_key     varchar2(50),
                          per_party_id_key          varchar2(50),
                          rel_party_id_key          varchar2(50),
                          rel_id_key                varchar2(50),
                          org_contact_id_key        varchar2(50),
                          contact_party_site_id_key varchar2(50),
                          bank_id_key               varchar2(50),
                          branch_id_key             varchar2(50),
                          bank_account_id_key       varchar2(50),
                          intermediary_bank_id_key  varchar2(50),
                          ext_payment_assign_id_key varchar2(50)
                        );

  type api_result_t is record (
    status varchar2(1),
    msg_count number,
    msg_data varchar2(4000)
  );

  type vendor_elements_json_t is record (
    supplier pljson,
    connection_metadata pljson,
    connection_metadata_keys pljson,
    site_arr pljson_list,
    post_site_batch pljson,
    contact_arr pljson_list,
    ignore_missing boolean
  );

  api_error_status exception;
  pragma exception_init(api_error_status, -20002);

  procedure raise_if_error_status(
    name in varchar2,
    result in out nocopy api_result_t
  );

  procedure syncronize(
    user_id in number,
    resp_id in number,
    app_id in number,
    in_clob in clob,
    out_clob in out clob,
    log_level in number
  );
end;
/
show err
