create or replace package body apps.graphite_sync_contact as

  procedure set_existing_contact_ids(
    contact_rec in out ap_vendor_pub_pkg.r_vendor_contact_rec_type
  ) is
    begin
      SELECT
        asco.vendor_contact_id,
        asco.per_party_id,
        asco.relationship_id,
        asco.rel_party_id,
        asco.org_contact_id,
        asco.party_site_id
      INTO
        contact_rec.vendor_contact_id,
        contact_rec.per_party_id,
        contact_rec.relationship_id,
        contact_rec.rel_party_id,
        contact_rec.org_contact_id,
        contact_rec.party_site_id
      FROM
         hz_relationships hr
        ,ap_suppliers asu
        ,ap_supplier_sites_all assa
        ,ap_supplier_contacts asco
        ,hz_org_contacts hoc
        ,hz_parties hpc
        ,hz_parties hpr
        ,hz_contact_points hpcp
      WHERE hoc.party_relationship_id = hr.relationship_id
        AND hr.subject_id = asu.party_id
        AND hr.relationship_code = 'CONTACT'
        AND hr.object_table_name = 'HZ_PARTIES'
        AND asu.vendor_id = assa.vendor_id
        AND hr.object_id = hpc.party_id
        AND hr.party_id = hpr.party_id
        AND asco.relationship_id  = hoc.party_relationship_id
        AND assa.party_site_id = asco.org_party_site_id
        AND hpr.party_type='PARTY_RELATIONSHIP'
        AND hpr.party_id = hpcp.owner_table_id
        AND hpcp.owner_table_name = 'HZ_PARTIES'
        AND asu.vendor_id = contact_rec.vendor_id
        AND assa.vendor_site_id = contact_rec.vendor_site_id
        AND hpr.email_address = contact_rec.email_address
        AND rownum = 1;

      exception
        when no_data_found then
          return;

    end set_existing_contact_ids;


  procedure set_null_contact_values(
    contact_rec in out ap_vendor_pub_pkg.r_vendor_contact_rec_type
  ) is
    begin
      graphite_sync_json_utils.set_to_null_value(contact_rec.person_first_name);
      graphite_sync_json_utils.set_to_null_value(contact_rec.person_middle_name);
      graphite_sync_json_utils.set_to_null_value(contact_rec.person_last_name);
      graphite_sync_json_utils.set_to_null_value(contact_rec.person_title);
      graphite_sync_json_utils.set_to_null_value(contact_rec.organization_name_phonetic);
      graphite_sync_json_utils.set_to_null_value(contact_rec.person_first_name_phonetic);
      graphite_sync_json_utils.set_to_null_value(contact_rec.person_last_name_phonetic);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute_category);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute1);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute2);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute3);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute4);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute5);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute6);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute7);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute8);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute9);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute10);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute11);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute12);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute13);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute14);
      graphite_sync_json_utils.set_to_null_value(contact_rec.attribute15);
      graphite_sync_json_utils.set_to_null_value(contact_rec.inactive_date);
      graphite_sync_json_utils.set_to_null_value(contact_rec.department);
      graphite_sync_json_utils.set_to_null_value(contact_rec.mail_stop);
      graphite_sync_json_utils.set_to_null_value(contact_rec.area_code);
      graphite_sync_json_utils.set_to_null_value(contact_rec.phone);
      graphite_sync_json_utils.set_to_null_value(contact_rec.alt_area_code);
      graphite_sync_json_utils.set_to_null_value(contact_rec.alt_phone);
      graphite_sync_json_utils.set_to_null_value(contact_rec.fax_area_code);
      graphite_sync_json_utils.set_to_null_value(contact_rec.fax_phone);
      graphite_sync_json_utils.set_to_null_value(contact_rec.email_address);
      graphite_sync_json_utils.set_to_null_value(contact_rec.url);
      graphite_sync_json_utils.set_to_null_value(contact_rec.prefix);
      graphite_sync_json_utils.set_to_null_value(contact_rec.contact_name_phonetic);
    end set_null_contact_values;

  procedure create_contact(
    contact_rec in ap_vendor_pub_pkg.r_vendor_contact_rec_type,
    contact_output out contact_output_t,
    result out nocopy graphite_sync.api_result_t
  ) is
    begin
      ap_vendor_pub_pkg.create_vendor_contact(
        p_api_version => 1.0,
        p_init_msg_list => fnd_api.g_true,
        p_commit => fnd_api.g_false,
        p_validation_level => fnd_api.g_valid_level_full,
        x_return_status => result.status,
        x_msg_count => result.msg_count,
        x_msg_data => result.msg_data,
        p_vendor_contact_rec => contact_rec,
        x_vendor_contact_id => contact_output.vendor_contact_id,
        x_per_party_id => contact_output.per_party_id,
        x_rel_party_id => contact_output.rel_party_id,
        x_rel_id => contact_output.relationship_id,
        x_org_contact_id => contact_output.org_contact_id,
        x_party_site_id => contact_output.party_site_id
      );

      graphite_sync.raise_if_error_status(name => 'create_contact', result => result);

  end create_contact;

  procedure update_contact(
    contact_rec in ap_vendor_pub_pkg.r_vendor_contact_rec_type,
    contact_output out contact_output_t,
    result out nocopy graphite_sync.api_result_t
  ) is
    begin
      ap_vendor_pub_pkg.update_vendor_contact_public(
        p_api_version => 1.0,
        p_init_msg_list => fnd_api.g_true,
        p_commit => fnd_api.g_false,
        p_validation_level => fnd_api.g_valid_level_full,
        p_vendor_contact_rec => contact_rec,
        x_return_status => result.status,
        x_msg_count => result.msg_count,
        x_msg_data => result.msg_data
      );

      graphite_sync.raise_if_error_status(name => 'update_contact', result => result);

      contact_output.vendor_contact_id := contact_rec.vendor_contact_id;
      contact_output.per_party_id := contact_rec.per_party_id;
      contact_output.rel_party_id := contact_rec.rel_party_id;
      contact_output.relationship_id := contact_rec.relationship_id;
      contact_output.org_contact_id := contact_rec.org_contact_id;
      contact_output.party_site_id := contact_rec.party_site_id;
  end update_contact;

  function is_update(
    contact_rec in ap_vendor_pub_pkg.r_vendor_contact_rec_type
  ) return boolean is
    begin
      return contact_rec.vendor_contact_id is not null;
  end is_update;

  procedure process_contact_from_json(
    contact_json in pljson,
    supplier_output in out graphite_sync_supplier.supplier_output_t,
    site_output in out graphite_sync_site.site_output_t,
    contact_output out contact_output_t
  ) is
    contact_rec ap_vendor_pub_pkg.r_vendor_contact_rec_type;
    result graphite_sync.api_result_t;
    parser graphite_sync_json_parser;
  begin
    contact_rec := graphite_sync_converter.convert_contact_json(contact_json);
    contact_rec.vendor_id := supplier_output.vendor_id;
    contact_rec.vendor_site_id := site_output.vendor_site_id;

    set_existing_contact_ids(contact_rec);

    if is_update(contact_rec) then
      set_null_contact_values(contact_rec);
      update_contact(contact_rec, contact_output, result);
    else
      create_contact(contact_rec, contact_output, result);
    end if;

  end process_contact_from_json;

end graphite_sync_contact;
/
show err
