create or replace package apps.graphite_sync_converter as
   function convert_supplier_json (
      supplier_json in pljson,
      parser in graphite_sync_json_parser
   ) return ap_vendor_pub_pkg.r_vendor_rec_type;

   function convert_bank_json (
      bank_json in pljson
   ) return iby_ext_bankacct_pub.extbank_rec_type;

   function convert_bank_branch_json (
      bank_branch_json in pljson
   ) return iby_ext_bankacct_pub.extbankbranch_rec_type;

   function convert_bank_acct_json (
      bank_acct_json in pljson
   ) return iby_ext_bankacct_pub.extbankacct_rec_type;

   function convert_inter_bank_json (
      inter_bank_json in pljson
   ) return iby_ext_bankacct_pub.intermediaryacct_rec_type;

   function convert_contact_json (
      contact_json in pljson
   ) return ap_vendor_pub_pkg.r_vendor_contact_rec_type;

   function convert_external_payee_json (
      external_payee_json in pljson
   ) return iby_disbursement_setup_pub.external_payee_rec_type;

   function convert_site_json (
      parser in graphite_sync_json_parser
   ) return ap_vendor_pub_pkg.r_vendor_site_rec_type;

   function convert_address_json (
      address_json in pljson
   ) return hz_location_v2pub.location_rec_type;

   function convert_party_site_json (
      party_site_json in pljson
   ) return hz_party_site_v2pub.party_site_rec_type;

   function convert_organization_json (
      org_json in pljson,
      party_id in number
    ) return hz_party_v2pub.organization_rec_type;

end graphite_sync_converter;
/
show err;
