/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.datastore.samples;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.DatastoreHelper;
import com.google.cloud.hadoop.io.datastore.DatastoreEntity;
import com.google.cloud.hadoop.io.datastore.DatastoreHadoopInputFormat;
import com.google.cloud.hadoop.io.datastore.DatastoreHadoopOutputFormat;
import com.google.cloud.hadoop.io.datastore.DatastoreKey;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;

public class WordCount {
    static final String OUTPUT_KIND_NAME = "mapred.datastore.samples.output.kind";

    public static void main(String[] args) throws Exception {
        GenericOptionsParser parser = new GenericOptionsParser(args);
        args = parser.getRemainingArgs();
        Preconditions.checkElementIndex((int)3, (int)args.length, (String)"Usage: hadoop jar datastore_wordcount.jar [datasetId] [inputKindName] [outputKindName] [jobName].  Please enter all parameters");
        String datasetId = args[0];
        String inputKindName = args[1];
        String outputKindName = args[2];
        String jobName = args[3];
        JobConf conf = new JobConf(parser.getConfiguration(), WordCount.class);
        conf.set(OUTPUT_KIND_NAME, outputKindName);
        Job job = new Job((Configuration)conf, jobName);
        job.setJarByClass(WordCount.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(Map.class);
        job.setReducerClass(Reduce.class);
        job.setInputFormatClass(DatastoreHadoopInputFormat.class);
        job.setOutputFormatClass(DatastoreHadoopOutputFormat.class);
        DatastoreV1.Query.Builder q = DatastoreV1.Query.newBuilder();
        DatastoreV1.KindExpression.Builder kind = DatastoreV1.KindExpression.newBuilder();
        kind.setName(inputKindName);
        q.addKind(kind);
        String query = TextFormat.printToString((MessageOrBuilder)q);
        DatastoreHadoopInputFormat.setInput((Job)job, (String)query, (String)datasetId);
        String numEntitiesInBatch = "100";
        DatastoreHadoopOutputFormat.setOutputSpecs((Job)job, (String)datasetId, (String)numEntitiesInBatch);
        job.waitForCompletion(true);
    }

    public static class Reduce
    extends Reducer<Text, IntWritable, DatastoreKey, DatastoreEntity> {
        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            if (!key.toString().isEmpty()) {
                DatastoreV1.Key.PathElement.Builder p = DatastoreV1.Key.PathElement.newBuilder();
                p.setKind(context.getConfiguration().get(WordCount.OUTPUT_KIND_NAME));
                p.setName(key.toString());
                DatastoreV1.Key.Builder k = DatastoreV1.Key.newBuilder();
                k.addPathElement(p);
                DatastoreV1.Entity.Builder e = DatastoreV1.Entity.newBuilder();
                e.addProperty(DatastoreHelper.makeProperty((String)"count", (DatastoreV1.Value.Builder)DatastoreHelper.makeValue((long)sum)));
                e.addProperty(DatastoreHelper.makeProperty((String)"word", (DatastoreV1.Value.Builder)DatastoreHelper.makeValue((String)key.toString())));
                e.setKey(k);
                context.write((Object)new DatastoreKey(), (Object)new DatastoreEntity(e.build()));
            }
        }
    }

    public static class Map
    extends Mapper<DatastoreKey, DatastoreEntity, Text, IntWritable> {
        public void map(DatastoreKey key, DatastoreEntity value, Mapper.Context context) throws IOException, InterruptedException {
            for (DatastoreV1.Property prop : value.get().getPropertyList()) {
                String[] tokenizer;
                if (!prop.getName().equals("line")) continue;
                String line = prop.getValue().getStringValue();
                for (String token : tokenizer = line.split(" ")) {
                    Text word = new Text();
                    word.set(token.replaceAll("[^A-Za-z]", "").toLowerCase());
                    context.write((Object)word, (Object)new IntWritable(1));
                }
            }
        }
    }
}

