/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.datastore.samples;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.DatastoreException;
import com.google.api.services.datastore.client.DatastoreHelper;
import com.google.cloud.hadoop.io.datastore.DatastoreHadoopHelper;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class WordCountSetUp {
    public static void main(String[] args) throws Exception {
        Preconditions.checkElementIndex((int)3, (int)args.length, (String)"Usage: hadoop jar datastore_wordcountsetup.jar [datasetId] [inputKindName] [outputKindName] [fileName].  Please enter all parameters");
        String datasetId = args[0];
        String inputKindName = args[1];
        String outputKindName = args[2];
        String fileName = args[3];
        Datastore ds = null;
        try {
            DatastoreHadoopHelper helper = new DatastoreHadoopHelper(new Configuration());
            ds = helper.createDatastore(datasetId);
        }
        catch (IOException exception) {
            System.err.println("I/O error connecting to the datastore: " + exception.getMessage());
            System.exit(1);
        }
        WordCountSetUp.deleteAllOfKind(inputKindName, ds);
        WordCountSetUp.deleteAllOfKind(outputKindName, ds);
        WordCountSetUp.checkDeleted(inputKindName, ds);
        WordCountSetUp.checkDeleted(outputKindName, ds);
        WordCountSetUp.populateDatastoreFromFile(inputKindName, fileName, ds);
    }

    public static void deleteAllOfKind(String kind, Datastore ds) {
        DatastoreV1.Query.Builder q = DatastoreV1.Query.newBuilder();
        DatastoreV1.KindExpression.Builder kindBuilder = DatastoreV1.KindExpression.newBuilder();
        kindBuilder.setName(kind);
        q.addKind(kindBuilder);
        DatastoreV1.RunQueryRequest request = DatastoreV1.RunQueryRequest.newBuilder().setQuery(q).build();
        DatastoreV1.RunQueryResponse response = null;
        try {
            response = ds.runQuery(request);
        }
        catch (DatastoreException e) {
            System.out.println("WARNING: can't erase root!" + e.getMessage());
        }
        List result = null;
        while (response != null) {
            result = response.getBatch().getEntityResultList();
            DatastoreV1.CommitRequest.Builder bwRequest = DatastoreV1.CommitRequest.newBuilder();
            for (int i = 0; i < result.size(); ++i) {
                DatastoreV1.Mutation.Builder mutation = DatastoreV1.Mutation.newBuilder();
                mutation.addDelete(((DatastoreV1.EntityResult)result.get(i)).getEntity().getKey());
                try {
                    ds.commit(bwRequest.setMutation(mutation).setMode(DatastoreV1.CommitRequest.Mode.NON_TRANSACTIONAL).build());
                    continue;
                }
                catch (DatastoreException e) {
                    System.out.println(e.getMessage() + Arrays.toString(e.getStackTrace()));
                }
            }
            if (response.getBatch().getMoreResults() == DatastoreV1.QueryResultBatch.MoreResultsType.NOT_FINISHED) {
                ByteString endCursor = response.getBatch().getEndCursor();
                q.setStartCursor(endCursor);
                try {
                    response = ds.runQuery(request);
                }
                catch (DatastoreException e) {
                    System.out.println("Datastore Error:" + e.getMessage());
                }
                continue;
            }
            response = null;
        }
    }

    public static void checkDeleted(String kind, Datastore ds) throws InterruptedException {
        int count = 0;
        while (count > 1) {
            DatastoreV1.Query.Builder q = DatastoreV1.Query.newBuilder();
            DatastoreV1.KindExpression.Builder kindBuilder = DatastoreV1.KindExpression.newBuilder();
            kindBuilder.setName(kind);
            q.addKind(kindBuilder);
            DatastoreV1.RunQueryRequest request = DatastoreV1.RunQueryRequest.newBuilder().setQuery(q).build();
            DatastoreV1.RunQueryResponse response = null;
            try {
                response = ds.runQuery(request);
            }
            catch (DatastoreException e) {
                System.out.println("DatastoreError" + e.getMessage());
            }
            List result = response.getBatch().getEntityResultList();
            count = result.size();
            System.out.println("Waiting for Datastore to update! Records:" + count);
            Thread.sleep(10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateDatastoreFromFile(String kind, String fileName, Datastore ds) throws IOException {
        FileInputStream fstream = new FileInputStream(fileName);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        DatastoreV1.CommitRequest.Builder request = DatastoreV1.CommitRequest.newBuilder();
        DatastoreV1.Mutation.Builder mutation = DatastoreV1.Mutation.newBuilder();
        try {
            String line = "";
            int count = 0;
            while ((line = br.readLine()) != null) {
                DatastoreV1.Entity.Builder e = DatastoreV1.Entity.newBuilder().setKey(DatastoreHelper.makeKey((Object[])new Object[]{kind, count + 1}));
                int length = 450;
                if (line.length() < 450) {
                    length = line.length();
                }
                if (length <= 0) continue;
                e.addProperty(DatastoreHelper.makeProperty((String)"line", (DatastoreV1.Value.Builder)DatastoreHelper.makeValue((String)line.substring(0, length))));
                mutation.addInsert(e);
                ++count;
            }
        }
        finally {
            br.close();
        }
        try {
            ds.commit(request.setMutation(mutation).setMode(DatastoreV1.CommitRequest.Mode.NON_TRANSACTIONAL).build());
        }
        catch (DatastoreException e) {
            System.out.println("WARNING: can't add new entity!" + e.getMessage());
        }
    }
}

