/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.datastore.samples;

import com.google.api.services.datastore.DatastoreV1;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryOutputFormat;
import com.google.cloud.hadoop.io.datastore.DatastoreEntity;
import com.google.cloud.hadoop.io.datastore.DatastoreHadoopInputFormat;
import com.google.cloud.hadoop.io.datastore.DatastoreKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;

public class DatastoreToBigQuery {
    public static void main(String[] args) throws Exception {
        GenericOptionsParser parser = new GenericOptionsParser(args);
        args = parser.getRemainingArgs();
        Preconditions.checkElementIndex((int)5, (int)args.length, (String)"Usage: hadoop jar datastoretobigquery_wordcount.jar [datasetId] [projectId]  [outputDatasetId] [outputTableId] [inputKindName] [jobName].  Please enter all parameters");
        String datastoreDatasetId = args[0];
        String projectId = args[1];
        String outputDatasetId = args[2];
        String outputTableId = args[3];
        String inputKindName = args[4];
        String jobName = args[5];
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputDatasetId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)outputTableId) ? 1 : 0) != 0);
        String fields = "[{'name': 'Word','type': 'STRING'},{'name': 'Number','type': 'INTEGER'}]";
        JobConf conf = new JobConf(parser.getConfiguration(), DatastoreToBigQuery.class);
        BigQueryConfiguration.configureBigQueryOutput((Configuration)conf, (String)projectId, (String)outputDatasetId, (String)outputTableId, (String)fields);
        Job job = new Job((Configuration)conf, jobName);
        job.setJarByClass(DatastoreToBigQuery.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(Map.class);
        job.setReducerClass(Reduce.class);
        job.setInputFormatClass(DatastoreHadoopInputFormat.class);
        job.setOutputFormatClass(BigQueryOutputFormat.class);
        DatastoreV1.Query.Builder q = DatastoreV1.Query.newBuilder();
        DatastoreV1.KindExpression.Builder kind = DatastoreV1.KindExpression.newBuilder();
        kind.setName(inputKindName);
        q.addKind(kind);
        String query = TextFormat.printToString((MessageOrBuilder)q);
        DatastoreHadoopInputFormat.setInput((Job)job, (String)query, (String)datastoreDatasetId);
        job.waitForCompletion(true);
    }

    public static class Reduce
    extends Reducer<Text, IntWritable, Text, JsonObject> {
        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            if (!key.toString().isEmpty()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("Word", key.toString());
                jsonObject.addProperty("Number", (Number)sum);
                context.write((Object)new Text("ignored"), (Object)jsonObject);
            }
        }
    }

    public static class Map
    extends Mapper<DatastoreKey, DatastoreEntity, Text, IntWritable> {
        public void map(DatastoreKey key, DatastoreEntity value, Mapper.Context context) throws IOException, InterruptedException {
            for (DatastoreV1.Property prop : value.get().getPropertyList()) {
                String[] tokenizer;
                if (!prop.getName().equals("line")) continue;
                String line = prop.getValue().getStringValue();
                for (String token : tokenizer = line.split(" ")) {
                    Text word = new Text();
                    word.set(token.replaceAll("[^A-Za-z]", "").toLowerCase());
                    context.write((Object)word, (Object)new IntWritable(1));
                }
            }
        }
    }
}

