# Copyright 2014 Google Inc. All Rights Reserved.D
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Downloads and installs the relevant gcs-connector-<version>.jar.
# Also configures it for use with hadoop.

set -e

if (( ${INSTALL_GCS_CONNECTOR} )) ; then

  if [[ -r "${HADOOP_INSTALL_DIR}/libexec/hadoop-config.sh" ]]; then
    . "${HADOOP_INSTALL_DIR}/libexec/hadoop-config.sh"
  fi
  if [[ -n "${HADOOP_COMMON_LIB_JARS_DIR}" ]] && \
      [[ -n "${HADOOP_PREFIX}" ]]; then
    LIB_JARS_DIR="${HADOOP_PREFIX}/${HADOOP_COMMON_LIB_JARS_DIR}"
  else
    LIB_JARS_DIR="${HADOOP_INSTALL_DIR}/lib"
  fi

  # Grab the connector jarfile, add it to installation /lib directory.
  JARNAME=$(grep -o '[^/]*\.jar' <<< ${GCS_CONNECTOR_JAR})
  LOCAL_JAR="${LIB_JARS_DIR}/${JARNAME}"
  if [[ $GCS_CONNECTOR_JAR == gs://* ]]; then
    gsutil cp "${GCS_CONNECTOR_JAR}" "${LOCAL_JAR}"
  else
    wget "${GCS_CONNECTOR_JAR}" -O ${LOCAL_JAR}
  fi

  echo "export HADOOP_CLASSPATH=\$HADOOP_CLASSPATH:${LOCAL_JAR}" \
      >> ${HADOOP_CONF_DIR}/hadoop-env.sh

  bdconfig merge_configurations \
      --configuration_file ${HADOOP_CONF_DIR}/core-site.xml \
      --source_configuration_file gcs-core-template.xml \
      --resolve_environment_variables \
      --create_if_absent \
      --noclobber

  # Test installation
  FS_CMD="sudo -u hadoop ${HADOOP_INSTALL_DIR}/bin/hadoop fs"
  if ! ${FS_CMD} -test -d gs://${CONFIGBUCKET}; then
    if ! gsutil ls -b gs://${CONFIGBUCKET}; then
      echo "Error: Could not access GCS on VM $(hostname)" >&2
    else
      cat << '      EOF' | sed 's/^\s*//' >&2
      Error: There was a problem accessing your configuration bucket using the GCS
      connector. Check configuration files. Also make sure have the GCS JSON API
      enabled as described at https://developers.google.com/storage/docs/json_api/.
      EOF
    fi
    exit 1
  fi
fi
