#!/usr/bin/env bash
#
# Copyright 2013 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

###############################################################################
# Sets up datastore for WordCount job to verify CloudDatastore setup.
# Note this clears and repopulates Kinds within the given dataset.
################################################################################

# Usage: ./test-datastore-clear.sh [datasetId] [hadoopNameNode] [optional: path to local jar to run]
# Set variables from args.
DATASET_ID=$1
HADOOP_NAME_NODE=$2
NUMBER_OF_ARGS=${#@}
if (( $NUMBER_OF_ARGS >= 3 )); then
  PATH_TO_JAR=$3
else
  PATH_TO_JAR="datastore_wordcountsetup.jar";
fi

# Push local jar to Google Compute Engine instance.
gcutil --project="$DATASET_ID" push "$HADOOP_NAME_NODE" $PATH_TO_JAR datastore_wordcountsetup.jar

# SSH into Google Compute Engine instance and run sample.
gcutil --project "$DATASET_ID" ssh "$HADOOP_NAME_NODE" << EOF
# Set Hadoop environment variables
chmod 666 datastore_wordcountsetup.jar
sudo su hadoop
rm /home/hadoop/hadoop-install/datastore_wordcountsetup.jar
cp datastore_wordcountsetup.jar /home/hadoop/hadoop-install/datastore_wordcountsetup.jar
cd /home/hadoop/hadoop-install
. libexec/hadoop-config.sh
# Set the hadoop command and the path to the hadoop examples jar
HADOOP_CMD="\${HADOOP_PREFIX}/bin/hadoop --config \$HADOOP_CONF_DIR"
# REPLACE parameters in line below.
COUNT_CMD="\$HADOOP_CMD jar /home/hadoop/hadoop-install/datastore_wordcountsetup.jar $DATASET_ID hadoopSampleWordCountLine hadoopSampleWordCountCount LICENSE.txt"
echo \$COUNT_CMD
eval \$COUNT_CMD
EOF

