# Copyright 2014 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Installs the OpenJDK Java7 JRE using apt-get.

# Strip the debian mirrors to force only using the GCS mirrors. Not ideal for
# production usage due to stripping security.debian.org, but reduces external
# load for non-critical use cases.

if [[ -x $(which java) ]]; then
  echo "Java already installed."
elif [[ -x $(which apt-get) ]]; then
  if (( ${STRIP_EXTERNAL_MIRRORS} )); then
    echo 'Stripping external apt-get mirrors...'
    sed -i "s/.*security.debian.org.*//" /etc/apt/sources.list
    sed -i "s/.*http.debian.net.*//" /etc/apt/sources.list
  else
    echo 'Using default apt-get mirror list for java installation...'
  fi

  UPDATE_SUCCEEDED=0
  for ((i = 1; i <= 3; i++)); do
    if apt-get -y -qq update; then
      UPDATE_SUCCEEDED=1
      break
    else
      echo "apt-get update attempt $i failed! Trying again..." >2
    fi
  done

  if ! (( ${UPDATE_SUCCEEDED} )); then
    echo "Final attempt to apt-get update..."
    # Let any final error propagate all the way out to any error traps.
    apt-get -y -qq update
  fi

  apt-get -y -qq install openjdk-7-jre-headless
elif [[ -x $(which yum) ]]; then
  yum -y -q install java-1.7.0-openjdk
else
  echo 'Cannot find package manager to install java. Exiting' >2
  exit 1
fi
