/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.samples;

import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryOutputFormat;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordCount {
    protected static final Logger LOG = LoggerFactory.getLogger(WordCount.class);
    public static final String WORDCOUNT_WORD_KEY = "mapred.bq.samples.wordcount.word.key";
    public static final String WORDCOUNT_WORD_KEY_DEFAULT = "word";

    private static boolean isStringNullOrEmpty(String toTest) {
        return toTest == null || "".equals(toTest);
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser parser = new GenericOptionsParser(args);
        if ((args = parser.getRemainingArgs()).length != 4) {
            System.out.println("Usage: hadoop jar bigquery_wordcount.jar [projectId] [fullyQualifiedInputTableId] [fieldName] [fullyQualifiedOutputTableId]");
            String indent = "    ";
            System.out.println(new StringBuilder(170 + String.valueOf(indent).length()).append(indent).append("projectId - Project under which to issue the BigQuery operations. ").append("Also serves as the default project for table IDs which don't explicitly specify a ").append("project for the table.").toString());
            System.out.println(new StringBuilder(98 + String.valueOf(indent).length()).append(indent).append("fullyQualifiedInputTableId - Input table ID of the form ").append("<optional projectId>:<datasetId>.<tableId>").toString());
            System.out.println(new StringBuilder(164 + String.valueOf(indent).length()).append(indent).append("fieldName - Name of the field to count in the input table, e.g. 'word' in ").append("publicdata:samples.shakespeare or 'repository_name' in ").append("publicdata:samples.github_timeline.").toString());
            System.out.println(new StringBuilder(100 + String.valueOf(indent).length()).append(indent).append("fullyQualifiedOutputTableId - Output table ID of the form ").append("<optional projectId>:<datasetId>.<tableId>").toString());
            System.exit(1);
        }
        String projectId = args[0];
        String fullyQualifiedInputTableId = args[1];
        String fieldName = args[2];
        String fullyQualifiedOutputTableId = args[3];
        String outputTableSchema = "[{'name': 'Word','type': 'STRING'},{'name': 'Count','type': 'INTEGER'}]";
        String jobName = "wordcount";
        JobConf conf = new JobConf(parser.getConfiguration(), WordCount.class);
        conf.set("mapred.bq.project.id", projectId);
        if (WordCount.isStringNullOrEmpty(conf.get("mapred.bq.gcs.bucket"))) {
            LOG.warn("Missing config for '{}'; trying to default to fs.gs.system.bucket.", (Object)"mapred.bq.gcs.bucket");
            String systemBucket = conf.get("fs.gs.system.bucket");
            if (WordCount.isStringNullOrEmpty(systemBucket)) {
                LOG.error("Also missing fs.gs.system.bucket; value must be specified.");
                System.exit(1);
            } else {
                LOG.info("Setting '{}' to '{}'", (Object)"mapred.bq.gcs.bucket", (Object)systemBucket);
                conf.set("mapred.bq.gcs.bucket", systemBucket);
            }
        } else {
            LOG.info("Using export bucket '{}' as specified in '{}'", (Object)conf.get("mapred.bq.gcs.bucket"), (Object)"mapred.bq.gcs.bucket");
        }
        BigQueryConfiguration.configureBigQueryInput((Configuration)conf, (String)fullyQualifiedInputTableId);
        BigQueryConfiguration.configureBigQueryOutput((Configuration)conf, (String)fullyQualifiedOutputTableId, (String)outputTableSchema);
        LOG.info("Setting '{}' to '{}'", (Object)WORDCOUNT_WORD_KEY, (Object)fieldName);
        conf.set(WORDCOUNT_WORD_KEY, fieldName);
        Job job = new Job((Configuration)conf, jobName);
        job.setJarByClass(WordCount.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(Map.class);
        job.setReducerClass(Reduce.class);
        job.setInputFormatClass(GsonBigQueryInputFormat.class);
        job.setOutputFormatClass(BigQueryOutputFormat.class);
        job.waitForCompletion(true);
        GsonBigQueryInputFormat.cleanupJob((JobContext)job);
    }

    public static class Reduce
    extends Reducer<Text, LongWritable, Text, JsonObject> {
        private static final Text dummyText = new Text("ignored");

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Word", key.toString());
            long count = 0L;
            for (LongWritable val : values) {
                count += val.get();
            }
            jsonObject.addProperty("Count", (Number)count);
            context.write((Object)dummyText, (Object)jsonObject);
        }
    }

    public static class Map
    extends Mapper<LongWritable, JsonObject, Text, LongWritable> {
        private static final LongWritable oneWritable = new LongWritable(1L);
        private Text word = new Text();
        private String wordKey;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.wordKey = context.getConfiguration().get(WordCount.WORDCOUNT_WORD_KEY, WordCount.WORDCOUNT_WORD_KEY_DEFAULT);
        }

        public void map(LongWritable key, JsonObject value, Mapper.Context context) throws IOException, InterruptedException {
            JsonElement countElement = value.get(this.wordKey);
            if (countElement != null) {
                String wordInRecord = countElement.getAsString();
                this.word.set(wordInRecord);
                context.write((Object)this.word, (Object)oneWritable);
            }
        }
    }
}

